/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity;

import com.sap.engine.interfaces.resourcecontext.ResourceContext;
import com.sap.engine.interfaces.resourcecontext.ResourceContextException;
import com.sap.engine.interfaces.resourcecontext.ResourceContextFactory;
import com.sap.engine.lib.util.base.LinearItem;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.entity.Container;
import com.sap.engine.services.ejb.entity.ContainerException;
import com.sap.engine.services.ejb.entity.Context;
import com.sap.engine.services.ejb.entity.ContextFP;
import com.sap.engine.services.ejb.entity.SynchronizationList;
import java.rmi.RemoteException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.transaction.Transaction;

public class ContainerFP
extends Container {
    private static final String SET_ENTITY_CONTEXT = "setEntityContext(javax.ejb.EntityContext)";
    private ResourceContextFactory resourceContextFactory = null;
    private ResourceContext restrictedResourceContext = null;

    public void init(Environment _env, String _applicationName, DeploymentDescriptor _descriptor, ClassLoader _loader) throws ContainerInitializationException {
        super.init(_env, _applicationName, _descriptor, _loader);
        this.resourceContextFactory = this.env.getResourceContextFactory();
        String componentName = "ejbContexts/" + this.applicationName + "/" + this.descriptor.getJndiName();
        this.restrictedResourceContext = this.resourceContextFactory.createRestrictedContext(this.applicationName, componentName);
    }

    public ResourceContextFactory getResourceContextFactory() {
        return this.resourceContextFactory;
    }

    public void afterRemove(Context c, Throwable error) throws ContainerException {
        if (c.isActive() || c.isPassive() || c.isRemoved()) {
            c.unlock();
        }
        if (c.inGlobalTransaction()) {
            Transaction t = (Transaction)c.transaction;
            SynchronizationList list = this.env.getSynchronizationList(t);
            list.removeElement((LinearItem)((Object)c));
        }
        this.unregister(c, error);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Context createContext() throws ContainerException {
        EntityBean bean = null;
        try {
            bean = (EntityBean)this.beanClass.newInstance();
        }
        catch (IllegalAccessException iaex) {
            throw new ContainerException("ejb_0030", new Object[]{this.beanClass.getName(), this.beanName}, iaex);
        }
        catch (InstantiationException iex) {
            throw new ContainerException("ejb_0030", new Object[]{this.beanClass.getName(), this.beanName}, iex);
        }
        ContextFP ctx = new ContextFP(this, bean);
        try {
            this.restrictedResourceContext.enterMethod(SET_ENTITY_CONTEXT);
            try {
                try {
                    bean.setEntityContext((EntityContext)ctx);
                }
                catch (Exception e) {
                    throw new ContainerException("ejb_0031", new Object[]{this.beanClass.getName(), this.beanName}, e);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.restrictedResourceContext.exitMethod(SET_ENTITY_CONTEXT, true);
                throw throwable;
            }
            this.restrictedResourceContext.exitMethod(SET_ENTITY_CONTEXT, true);
        }
        catch (ResourceContextException rce) {
            this.logInfo(rce);
        }
        ctx.status = (byte)5;
        return ctx;
    }

    public ResourceContext getRestrictedResourceContext() {
        return this.restrictedResourceContext;
    }
}

