/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.csiv2.EJBIORGeneratorInterface;
import com.sap.engine.interfaces.csiv2.IORDescriptor;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.userstore.UserStore;
import com.sap.engine.interfaces.security.userstore.UserStoreFactory;
import com.sap.engine.interfaces.security.userstore.context.GroupContext;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.util.base.LinearItem;
import com.sap.engine.services.connector.jca.ResourceSetContextObject;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.ejb.ContainerBoot;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.RunAsPrivilegedAction;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.entity.ContainerException;
import com.sap.engine.services.ejb.entity.Context;
import com.sap.engine.services.ejb.entity.EntityHome;
import com.sap.engine.services.ejb.entity.EntityLocalHome;
import com.sap.engine.services.ejb.entity.SynchronizationList;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseNoSuchObjectException;
import com.sap.engine.services.ejb.exceptions.EntityExceptionConstants;
import com.sap.engine.services.ejb.runtime.ContainerRuntime;
import com.sap.engine.services.ejb.util.EJBHashtable;
import com.sap.engine.services.ejb.util.EJBHashtableItem;
import com.sap.engine.services.ejb.util.MonitoringInfo;
import com.sap.engine.services.ejb.util.NoConnectionResourceSetImpl;
import com.sap.engine.services.ejb.util.ObjectToStringHashing;
import com.sap.engine.services.ejb.util.pool.ContainerPool;
import com.sap.engine.services.ejb.util.pool.PoolUser;
import com.sap.engine.services.ejb.util.pool.StackException;
import com.sap.tc.logging.Location;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class Container
extends PortableRemoteObject
implements PoolUser,
ContainerRuntime,
ContainerBoot,
EntityExceptionConstants {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$entity$Container == null ? (class$com$sap$engine$services$ejb$entity$Container = Container.class$("com.sap.engine.services.ejb.entity.Container")) : class$com$sap$engine$services$ejb$entity$Container));
    private static final String SYSTEM_METHODS = "System_methods_not_allowed_to_use_resources";
    private static final String _EJBHOME_ = "EJBHome";
    private static final String _EJBLOCALHOME_ = "EJBLocalHome";
    private boolean reentrant;
    private boolean containerPersistence;
    protected Class beanClass = null;
    protected String beanName = null;
    private Subject runAsSubject = null;
    protected String applicationName = null;
    private ResourceSet noConnectionResourceSet = null;
    private EJBIORGeneratorInterface iorGenerator = null;
    private SecurityContext myApplicationSecContext = null;
    private SimpleProfileInterface iiopSimpleProfile = null;
    private MonitoringInfo monitoringInfo = null;
    protected boolean remoteView;
    protected boolean localView;
    protected Environment env = null;
    protected ContainerPool pool = null;
    protected ClassLoader loader = null;
    protected EJBHashtable activeTable = null;
    protected EntityDescriptor descriptor = null;
    public EntityHome remoteHome = null;
    public EntityLocalHome localHome = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$entity$Container;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$util$pool$PoolUser;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$Environment;
    static /* synthetic */ Class class$java$util$Properties;

    public void init(Environment _env, String _applicationName, DeploymentDescriptor _descriptor, ClassLoader _loader) throws ContainerInitializationException {
        Constructor<?> constr;
        this.env = _env;
        this.applicationName = _applicationName;
        this.descriptor = (EntityDescriptor)_descriptor;
        this.beanName = this.descriptor.getEjbName();
        this.loader = _loader;
        String policyConfiguration = this.applicationName + "*" + this.descriptor.getEJBJarDescriptor().getJarName();
        this.myApplicationSecContext = this.env.getSecurityContext().getPolicyConfigurationContext(policyConfiguration);
        this.initSecurityRunAs(this.descriptor);
        this.initIIOPSimpleProfile(this.descriptor);
        this.remoteView = this.descriptor.hasRemoteInterfaces();
        this.localView = this.descriptor.hasLocalInterfaces();
        this.reentrant = this.descriptor.isReentrant();
        this.containerPersistence = this.descriptor.getPersistenceType() == 1;
        this.monitoringInfo = new MonitoringInfo(0);
        String ejbHomeName = this.descriptor.getEjbHomeImpl();
        String ejbLocalHomeName = this.descriptor.getEjbLocalHomeImpl();
        if (ejbHomeName == null && ejbLocalHomeName == null) {
            throw new ContainerInitializationException("ejb_0017", new Object[]{this.beanName});
        }
        String componentName = "ejbContexts/" + this.applicationName + "/" + this.descriptor.getJndiName();
        this.noConnectionResourceSet = new NoConnectionResourceSetImpl(this.applicationName, componentName, SYSTEM_METHODS);
        if (ejbHomeName != null) {
            try {
                Class<?> ejbHomeClass = this.loader.loadClass(ejbHomeName);
                constr = ejbHomeClass.getConstructor(class$com$sap$engine$services$ejb$entity$Container == null ? (class$com$sap$engine$services$ejb$entity$Container = Container.class$("com.sap.engine.services.ejb.entity.Container")) : class$com$sap$engine$services$ejb$entity$Container);
                this.remoteHome = (EntityHome)constr.newInstance(this);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContainerInitializationException("ejb_0018", new Object[]{ejbHomeName}, ncdfe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContainerInitializationException("ejb_0018", new Object[]{ejbHomeName}, cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new ContainerInitializationException("ejb_0019", new Object[]{ejbHomeName}, nsme);
            }
            catch (InstantiationException inste) {
                throw new ContainerInitializationException("ejb_0020", new Object[]{ejbHomeName}, inste);
            }
            catch (IllegalAccessException illAccEx) {
                throw new ContainerInitializationException("ejb_0021", new Object[]{ejbHomeName}, illAccEx);
            }
            catch (InvocationTargetException ite) {
                Throwable toThrow = ite.getTargetException();
                if (toThrow == null) {
                    toThrow = ite;
                }
                throw new ContainerInitializationException("ejb_0022", new Object[]{ejbHomeName}, toThrow);
            }
        }
        if (ejbLocalHomeName != null) {
            try {
                Class<?> ejbLocalHomeClass = this.loader.loadClass(ejbLocalHomeName);
                constr = ejbLocalHomeClass.getConstructor(class$com$sap$engine$services$ejb$entity$Container == null ? (class$com$sap$engine$services$ejb$entity$Container = Container.class$("com.sap.engine.services.ejb.entity.Container")) : class$com$sap$engine$services$ejb$entity$Container);
                this.localHome = (EntityLocalHome)constr.newInstance(this);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContainerInitializationException("ejb_0018", new Object[]{ejbLocalHomeName}, ncdfe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContainerInitializationException("ejb_0018", new Object[]{ejbLocalHomeName}, cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new ContainerInitializationException("ejb_0019", new Object[]{ejbLocalHomeName}, nsme);
            }
            catch (InstantiationException inste) {
                throw new ContainerInitializationException("ejb_0020", new Object[]{ejbLocalHomeName}, inste);
            }
            catch (IllegalAccessException illAccEx) {
                throw new ContainerInitializationException("ejb_0021", new Object[]{ejbLocalHomeName}, illAccEx);
            }
            catch (InvocationTargetException ite) {
                Throwable toThrow = ite.getTargetException();
                if (toThrow == null) {
                    toThrow = ite;
                }
                throw new ContainerInitializationException("ejb_0022", new Object[]{ejbLocalHomeName}, toThrow);
            }
        }
        try {
            this.beanClass = this.loader.loadClass(this.descriptor.getRuntimeClassName());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ContainerInitializationException("ejb_0023", new Object[]{this.beanName}, cnfe);
        }
        String poolClassName = null;
        Properties beanProps = this.descriptor.getBeanProperties();
        try {
            poolClassName = beanProps.getProperty("PoolClass", "com.sap.engine.services.ejb.util.pool.ContainerPoolImpl");
        }
        catch (Exception ex) {
            this.logInfo(ex);
            poolClassName = "com.sap.engine.services.ejb.util.pool.ContainerPoolImpl";
        }
        try {
            Class<?> poolClass = Class.forName(poolClassName);
            Constructor<?> c = poolClass.getConstructor(class$com$sap$engine$services$ejb$util$pool$PoolUser == null ? (class$com$sap$engine$services$ejb$util$pool$PoolUser = Container.class$("com.sap.engine.services.ejb.util.pool.PoolUser")) : class$com$sap$engine$services$ejb$util$pool$PoolUser, class$com$sap$engine$services$ejb$Environment == null ? (class$com$sap$engine$services$ejb$Environment = Container.class$("com.sap.engine.services.ejb.Environment")) : class$com$sap$engine$services$ejb$Environment, class$java$util$Properties == null ? (class$java$util$Properties = Container.class$("java.util.Properties")) : class$java$util$Properties);
            this.pool = (ContainerPool)c.newInstance(this, this.env, beanProps);
        }
        catch (Exception ex) {
            Throwable t = ex;
            if (ex instanceof InvocationTargetException && ((InvocationTargetException)ex).getTargetException() != null) {
                t = ((InvocationTargetException)ex).getTargetException();
            }
            throw new ContainerInitializationException("ejb_0024", new Object[]{this.beanName}, t);
        }
        catch (NoClassDefFoundError ncdfer) {
            throw new ContainerInitializationException("ejb_0025", new Object[]{poolClassName, this.beanName}, ncdfer);
        }
        this.activeTable = this.descriptor.getContainerSize() != 0 ? new EJBHashtable(this.descriptor.getContainerSize()) : new EJBHashtable();
    }

    public void initPools() throws ContainerInitializationException {
        try {
            this.pool.init();
        }
        catch (StackException sex) {
            throw new ContainerInitializationException("ejb_0026", new Object[]{this.beanName}, sex.getTarget());
        }
    }

    public EJBHome getEJBHome() {
        return (EJBHome)this.remoteHome;
    }

    public EJBLocalHome getEJBLocalHome() {
        return (EJBLocalHome)this.localHome;
    }

    public void destroy() {
        this.pool.destroy();
        this.pool = null;
        EJBHashtableItem[] activeContexts = this.activeTable.getAllContexts();
        int i = 0;
        while (i < activeContexts.length) {
            ((Context)activeContexts[i]).destroyEntity();
            ++i;
        }
        this.activeTable = null;
        if (this.remoteHome != null) {
            this.remoteHome.unexportEntityHome();
            this.remoteHome = null;
        }
        this.localHome = null;
        this.beanClass = null;
        this.loader = null;
        this.descriptor = null;
    }

    private void initIIOPSimpleProfile(DeploymentDescriptor descriptor) {
        IORDescriptor[] iorDescriptors = descriptor.getIORDescriptors();
        if (iorDescriptors != null) {
            this.iorGenerator = this.env.getIORGenerator();
            this.iiopSimpleProfile = this.iorGenerator.generateSecurityTaggedComponent(iorDescriptors);
        }
    }

    public void addIIOPSimpleProfile(PortableRemoteObject pro) throws ContainerInitializationException {
        this.iorGenerator.addTaggedComponent(pro, this.iiopSimpleProfile);
    }

    private void initSecurityRunAs(DeploymentDescriptor descriptor) throws ContainerInitializationException {
        SecurityIdentity secIdentity = descriptor.getSecurityIdentity();
        if (secIdentity == null || secIdentity.isCallerIdentity()) {
            return;
        }
        RunAsIdentity runAsIdentity = secIdentity.getRunAsIdentity();
        UserStoreFactory userStoreFactory = this.myApplicationSecContext.getUserStoreContext();
        UserStore userStore = userStoreFactory.getActiveUserStore();
        UserContext userCtx = userStore.getUserContext();
        String userName = runAsIdentity.getUserName();
        if (userName == null) {
            String runAsRoleName = runAsIdentity.getSecurityRoleName();
            SecurityRole runAsRole = this.getSecurityRoleContext().getSecurityRole(runAsRoleName);
            String[] userNames = runAsRole.getUsers();
            if (userNames != null && userNames.length != 0) {
                userName = userNames[0];
            } else {
                String[] groupNames = runAsRole.getGroups();
                if (groupNames != null) {
                    GroupContext groupCtx = userStore.getGroupContext();
                    int i = 0;
                    while (i < groupNames.length) {
                        Iterator groupUsers = groupCtx.getGroupInfo(groupNames[i]).getUsersInGroup();
                        if (groupUsers != null && groupUsers.hasNext()) {
                            userName = (String)groupUsers.next();
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (userName == null) {
                throw new ContainerInitializationException("ejb_0027", new Object[]{runAsRoleName});
            }
        }
        UserInfo user = userCtx.getUserInfo(userName);
        this.runAsSubject = new Subject();
        RunAsPrivilegedAction runAsAction = new RunAsPrivilegedAction(userCtx, user, this.runAsSubject);
        AccessController.doPrivileged(runAsAction);
    }

    protected SecurityRoleContext getSecurityRoleContext() {
        return this.myApplicationSecContext.getAuthorizationContext().getSecurityRoleContext();
    }

    public com.sap.engine.lib.security.SecurityContext getSecurityContext() {
        ThreadContext currentThread = this.env.getThreadSystem().getThreadContext();
        int secId = this.env.getSecurityContextObjectId();
        return (com.sap.engine.lib.security.SecurityContext)((Object)currentThread.getContextObject(secId));
    }

    public Subject getRunAsSubject() {
        return this.runAsSubject;
    }

    public ResourceContext getResourceContext() {
        return this.myApplicationSecContext.getAuthorizationContext().getSecurityResourceContext();
    }

    public TransactionManager getTransactionManager() {
        return this.env.getTransactionManager();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    public boolean isCMP() {
        return this.containerPersistence;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public EntityDescriptor getDescriptor() {
        return this.descriptor;
    }

    public EJBLocalObject createEJBLocalObject(Object key) {
        return this.localHome.createEJBLocalObject(key);
    }

    public EJBObject createEJBObject(Object key) throws RemoteException {
        return this.remoteHome.createEJBObject(key);
    }

    public Context getActive(Object pk, Object t) throws ContainerException {
        Context ctx = null;
        ctx = t == null ? (Context)this.activeTable.get(pk, (Object)Thread.currentThread()) : (Context)this.activeTable.get(pk, t);
        if (ctx == null) {
            ctx = this.createActive(this.getPooled(), pk, t);
        } else {
            if (ctx.isRemoved()) {
                throw new ContainerException("ejb_0015", new BaseNoSuchObjectException("ejb_0028", new Object[]{ObjectToStringHashing.getCompoundHashNoError((Object)pk)}));
            }
            ctx.lock();
        }
        return ctx;
    }

    public Context createActive(Object pk, Object t) throws ContainerException {
        return this.createActive(this.getPooled(), pk, t);
    }

    public Context createActive(Context c, Object pk, Object t) throws ContainerException {
        boolean local;
        boolean bl = local = t == null;
        if (local) {
            t = Thread.currentThread();
        }
        c.identify(pk, t, !local);
        c.lock();
        this.activeTable.put((EJBHashtableItem)c);
        if (!local) {
            this.addToTransaction(c, (Transaction)t);
        }
        return c;
    }

    public void afterRemove(Context c, Throwable error) throws ContainerException {
        if (c.isActive() || c.isPassive() || c.isRemoved()) {
            c.unlock();
        }
        boolean success = !c.isDiscarded() && error == null;
        int flag = success ? 0x4000000 : 0x20000000;
        try {
            c.delist(flag);
        }
        catch (SystemException se) {
            c.discard();
        }
        if (c.inGlobalTransaction()) {
            Transaction t = (Transaction)c.transaction;
            SynchronizationList list = this.env.getSynchronizationList(t);
            list.removeElement((LinearItem)((Object)c));
        }
        this.unregister(c, error);
    }

    public void releaseActive(Context c, Throwable error) throws ContainerException {
        if (c.isActive() || c.isPassive() || c.isRemoved()) {
            c.unlock();
        }
        if (!c.inGlobalTransaction()) {
            this.unregister(c, error);
        }
    }

    protected void unregister(Context c, Throwable error) throws ContainerException {
        this.activeTable.remove((EJBHashtableItem)c);
        c.cleanup();
        this.releasePooled(c, error);
    }

    public Context getPooled() throws ContainerException {
        Context c = null;
        try {
            c = (Context)this.pool.pop();
        }
        catch (StackException ese) {
            throw new BaseEJBException("ejb_0029", new Object[]{this.beanName}, ese.getTarget());
        }
        return c;
    }

    public void releasePooled(Context c, Throwable error) throws ContainerException {
        if (c.isRemoved()) {
            c.status = (byte)5;
        }
        if (!c.isPassive()) {
            return;
        }
        if (error == null) {
            this.pool.push((Object)c);
        } else {
            c.discard();
        }
    }

    protected Context createContext() throws ContainerException {
        EntityBean bean = null;
        ResourceSet rsOut = null;
        try {
            bean = (EntityBean)this.beanClass.newInstance();
        }
        catch (IllegalAccessException iaex) {
            throw new ContainerException("ejb_0030", new Object[]{this.beanClass.getName(), this.beanName}, iaex);
        }
        catch (InstantiationException iex) {
            throw new ContainerException("ejb_0030", new Object[]{this.beanClass.getName(), this.beanName}, iex);
        }
        Context ctx = new Context(this, bean);
        try {
            try {
                rsOut = ResourceSetContextObject.replaceCurrentResourceSet(this.noConnectionResourceSet);
                bean.setEntityContext((EntityContext)ctx);
            }
            catch (Exception e) {
                throw new ContainerException("ejb_0031", new Object[]{this.beanClass.getName(), this.beanName}, e);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
            throw throwable;
        }
        ResourceSetContextObject.replaceCurrentResourceSet(rsOut);
        ctx.status = (byte)5;
        return ctx;
    }

    private void addToTransaction(Context ctx, Transaction t) {
        SynchronizationList list = this.env.getSynchronizationList(t);
        list.addLastItem((LinearItem)((Object)ctx));
    }

    public void logInfo(Throwable t) {
        LOCATION.traceThrowableT(300, null, t);
    }

    public void logError(Throwable t) {
        LOCATION.traceThrowableT(500, null, t);
    }

    public ResourceSet getNoConnectionResourceSet() {
        return this.noConnectionResourceSet;
    }

    public String getCurrentUser() {
        Principal p = this.getSecurityContext().getPrincipal();
        if (p == null) {
            return "UNKNOWN";
        }
        return p.getName();
    }

    public MonitoringInfo getMonitoringInfo() {
        return this.monitoringInfo;
    }

    public void destroyObject(Object obj) {
        ((Context)obj).unsetContext();
    }

    public Object createObject() {
        return this.createContext();
    }

    public int getSessionProperty(int property) {
        return -1;
    }

    public int getPoolProperty(int property) {
        switch (property) {
            case 1: {
                return this.pool.size();
            }
            case 2: {
                return this.pool.getMaxSize();
            }
            case 3: {
                return this.pool.getInitialCapacity();
            }
            case 4: {
                return this.pool.getResizeStep();
            }
            case 5: {
                return this.pool.used();
            }
        }
        LOCATION.errorT(EJBResourceAccessor.category, "ejb_0033", new Object[]{new Integer(property)});
        return -1;
    }

    public int getCreationsNumber() {
        return this.monitoringInfo.getCreations();
    }

    public int getRemovalsNumber() {
        return this.monitoringInfo.getRemovals();
    }

    public int getPassivationsNumber() {
        return this.monitoringInfo.getPassivations();
    }

    public int getActivationsNumber() {
        return this.monitoringInfo.getActivations();
    }

    public int getLoadsNumber() {
        return this.monitoringInfo.getLoads();
    }

    public int getStoresNumber() {
        return this.monitoringInfo.getStores();
    }

    public int getType() {
        if (this.isCMP()) {
            return 3;
        }
        return 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

