/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.lib.xml.StandardDOMWriterNoSpace;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLGeneratorException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLGenerator {
    protected static AccessControls findSecDescriptor(AccessControls[] secDescriptors, String method_intf, Method method) {
        if (secDescriptors == null) {
            return null;
        }
        int i = 0;
        while (i < secDescriptors.length) {
            if (secDescriptors[i].getMethod().isRelevant(method_intf, method)) {
                return secDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    protected static boolean checkExcluded(MethodEntry[] uncalableMethods, String method_intf, String ejbName, Method method) {
        int j = 0;
        while (j < uncalableMethods.length) {
            if (uncalableMethods[j].isCompatible(method, method_intf, ejbName)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    protected static String getSecurityForStandardMethods(AccessControls[] allSecDescriptors, MethodEntry[] uncallables, String method_intf, String ejbName, Method method) {
        AccessControls methodSecDescriptor = XMLGenerator.findSecDescriptor(allSecDescriptors, method_intf, method);
        if (uncallables != null && XMLGenerator.checkExcluded(uncallables, method_intf, ejbName, method)) {
            return "excluded";
        }
        if (methodSecDescriptor != null) {
            return methodSecDescriptor.getUnchecked() ? "unchecked" : "checked";
        }
        return "unchecked";
    }

    public static ControlDescriptor findTxDescriptor(ControlDescriptor[] txDescriptors, String method_intf, Method method) {
        if (txDescriptors == null) {
            return null;
        }
        int i = 0;
        while (i < txDescriptors.length) {
            if (txDescriptors[i].getMethodEntry().isRelevant(method_intf, method)) {
                return txDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    protected static void load(Document mainDocument, Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = mainDocument.createElement(tagName);
        Text textNode = mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
    }

    protected static void writeToFile(Document mainDocument, String fileName, String ejbName) throws DeploymentException {
        try {
            new StandardDOMWriterNoSpace().write(mainDocument, fileName, "");
        }
        catch (IOException ioe) {
            throw new EJBXMLGeneratorException("ejb_2333", new String[]{fileName, ejbName}, ioe);
        }
    }

    protected static Class loadClass(ClassLoader loader, String className, String exceptionId, String ejbName) throws DeploymentException {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new EJBXMLGeneratorException(exceptionId, new String[]{ejbName}, e);
        }
    }

    protected static boolean definedMethod(Class superClass, String methodName, Class[] methodParamTypes) {
        try {
            superClass.getDeclaredMethod(methodName, methodParamTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

