/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.UpdateSecurityContext;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.IORDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.xml.ParseUtils;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDescriptorException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.engine.services.ejb.util.AdminUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InqmyEjbParser
extends ParseUtils {
    private static final String XML_NAME = "ejb-j2ee-engine.xml";
    public static final String TRANSACTION_READ_COMMITTED = "Committed";
    public static final String TRANSACTION_READ_UNCOMMITTED = "Uncommitted";
    public static final String TRANSACTION_REPEATABLE_READ = "Repeatable";
    public static final String TRANSACTION_SERIALIZABLE = "Serializable";
    private EJBJarDescriptor ejbJar;
    private Vector warnings;

    public void parseXml(EJBJarDescriptor _ejbJar, BufferedInputStream xmlStream, boolean atDeploy, SecurityContext jarSecCtx, boolean atUpdate, UpdateSecurityContext updateSecCtx, Vector _warnings) throws DeploymentException {
        Document document = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser parser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            if (!atDeploy && !atUpdate) {
                try {
                    parser.setBackwardsCompatibilityMode(true);
                }
                catch (SAXException sax) {
                    throw new EJBXMLParserException("ejb_2246", (Throwable)sax);
                }
            }
            parser.setValidation(true);
            document = parser.parse((InputStream)xmlStream);
            xmlStream.close();
        }
        catch (IOException ioe) {
            throw new EJBXMLParserException("ejb_2200", new Object[]{XML_NAME, _ejbJar.getJarName()}, ioe);
        }
        catch (SAXException sax) {
            throw new EJBXMLParserException("ejb_2200", new Object[]{XML_NAME, _ejbJar.getJarName()}, sax);
        }
        this.ejbJar = _ejbJar;
        this.warnings = _warnings;
        Node inqmyJar = document.getElementsByTagName("ejb-j2ee-engine").item(0);
        NodeList inqmyJarList = inqmyJar.getChildNodes();
        int i = 0;
        while (i < inqmyJarList.getLength()) {
            if (inqmyJarList.item(i).getNodeType() == 1) {
                Element el = (Element)inqmyJarList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    this.ejbJar.setInqmyDescription(this.getElementText(el));
                } else if (tag.equals("enterprise-beans")) {
                    this.processBeans(el);
                } else if (tag.equals("transaction-descriptor")) {
                    this.processTransactions(el);
                } else if (tag.equals("security-permission")) {
                    this.processSecurityRoles(el, atDeploy, jarSecCtx, atUpdate, updateSecCtx);
                }
            }
            ++i;
        }
    }

    protected String getXMLFileName() {
        return XML_NAME;
    }

    protected String getEJBJarFileName() {
        return this.ejbJar.getJarName();
    }

    protected Vector getWarnings() {
        return this.warnings;
    }

    protected ClassLoader getClassLoader() {
        return null;
    }

    private void processBeans(Element beans) throws DeploymentException {
        NodeList beansList = beans.getChildNodes();
        int i = 0;
        while (i < beansList.getLength()) {
            Element el;
            String tag;
            if (beansList.item(i).getNodeType() == 1 && (tag = (el = (Element)beansList.item(i)).getNodeName()).equals("enterprise-bean")) {
                NodeList entList = el.getChildNodes();
                String ejbName = null;
                DeploymentDescriptor dDescr = null;
                Properties bProps = new Properties();
                Vector<IORDescriptor> iors = new Vector<IORDescriptor>();
                Vector<ComponentReference> componentRefs = new Vector<ComponentReference>();
                int j = 0;
                while (j < entList.getLength()) {
                    if (entList.item(j).getNodeType() == 1) {
                        Element nextEl = (Element)entList.item(j);
                        String nextTag = nextEl.getNodeName();
                        if (nextTag.equals("ejb-name")) {
                            ejbName = this.getElementText(nextEl);
                            dDescr = this.findDescriptor(ejbName);
                        } else if (nextTag.equals("jndi-name")) {
                            dDescr.setJndiName(this.getElementText(nextEl));
                        } else if (nextTag.equals("session-props")) {
                            this.processSessionProps(nextEl, (SessionDescriptor)dDescr, bProps);
                        } else if (nextTag.equals("entity-props")) {
                            this.processEntityProps(nextEl, (EntityDescriptor)dDescr, bProps);
                        } else if (nextTag.equals("message-props")) {
                            this.processMessageDrivenProps(nextEl, dDescr, bProps);
                        } else if (nextTag.equals("container-size")) {
                            int contSize = Integer.parseInt(this.getElementText(nextEl));
                            if (contSize < 0) {
                                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": The value of element container-size is negative: " + contSize + ". It will be ignored!");
                            } else {
                                dDescr.setContainerSize(contSize);
                            }
                        } else if (nextTag.equals("resource-ref")) {
                            Element nonTxSupport;
                            String resName = this.getElementText(this.getFirstElementByName(nextEl, "res-ref-name"));
                            ResourceReference[] allReferences = dDescr.getResourceReferences();
                            if (allReferences == null) {
                                throw new EJBXMLParserException("ejb_2261", new Object[]{ejbName});
                            }
                            ResourceReference resRef = null;
                            int r = 0;
                            while (r < allReferences.length) {
                                if (allReferences[r].getResourceName().equals(resName)) {
                                    resRef = allReferences[r];
                                    break;
                                }
                                ++r;
                            }
                            if (resRef == null) {
                                throw new EJBXMLParserException("ejb_2262", new Object[]{resName});
                            }
                            Element resLink = this.getFirstElementByName(nextEl, "res-link");
                            if (resLink != null) {
                                resRef.setResourceLink(this.getElementText(resLink));
                            }
                            if ((nonTxSupport = this.getFirstElementByName(nextEl, "non-transactional")) != null) {
                                resRef.setTransactional(false);
                            }
                        } else if (nextTag.equals("ejb-ref")) {
                            String refName = this.getElementText(this.getFirstElementByName(nextEl, "ejb-ref-name"));
                            EJBeanReference[] allEjbReferences = dDescr.getEJBeanReferences();
                            EJBeanLocalReference[] allEjbLocalReferences = dDescr.getEJBeanLocalReferences();
                            if (allEjbReferences != null || allEjbLocalReferences != null) {
                                EJBeanReference ejbRef = null;
                                if (allEjbReferences != null) {
                                    int r = 0;
                                    while (r < allEjbReferences.length) {
                                        if (allEjbReferences[r].getReferenceName().equals(refName)) {
                                            ejbRef = allEjbReferences[r];
                                            String value = this.getElementText(this.getFirstElementByName(nextEl, "jndi-name"));
                                            if (value.equals("")) break;
                                            ejbRef.setReferenceJndiLink(value);
                                            break;
                                        }
                                        ++r;
                                    }
                                }
                                EJBeanLocalReference ejbLocalRef = null;
                                if (allEjbLocalReferences != null && ejbRef == null) {
                                    int r = 0;
                                    while (r < allEjbLocalReferences.length) {
                                        if (allEjbLocalReferences[r].getReferenceName().equals(refName)) {
                                            ejbLocalRef = allEjbLocalReferences[r];
                                            String value = this.getElementText(this.getFirstElementByName(nextEl, "jndi-name"));
                                            if (value.equals("")) break;
                                            ejbLocalRef.setReferenceJndiLink(value);
                                            break;
                                        }
                                        ++r;
                                    }
                                }
                                if (ejbRef == null && ejbLocalRef == null) {
                                    throw new EJBXMLParserException("ejb_2263", new Object[]{refName});
                                }
                            }
                        } else if (nextTag.equals("ejb-local-ref")) {
                            String refName = this.getElementText(this.getFirstElementByName(nextEl, "ejb-ref-name"));
                            EJBeanLocalReference[] allEjbLocalReferences = dDescr.getEJBeanLocalReferences();
                            if (allEjbLocalReferences != null) {
                                EJBeanLocalReference ejbLocalRef = null;
                                int r = 0;
                                while (r < allEjbLocalReferences.length) {
                                    if (allEjbLocalReferences[r].getReferenceName().equals(refName)) {
                                        ejbLocalRef = allEjbLocalReferences[r];
                                        String value = this.getElementText(this.getFirstElementByName(nextEl, "jndi-name"));
                                        if (value.equals("")) break;
                                        ejbLocalRef.setReferenceJndiLink(value);
                                        break;
                                    }
                                    ++r;
                                }
                                if (ejbLocalRef == null) {
                                    throw new EJBXMLParserException("ejb_2264", new Object[]{refName});
                                }
                            }
                        } else if (nextTag.equals("resource-env-ref")) {
                            String resEnvName = this.getElementText(this.getFirstElementByName(nextEl, "resource-env-ref-name"));
                            ResourceEnvReference[] allEnvReferences = dDescr.getResourceEnvReferences();
                            if (allEnvReferences != null) {
                                ResourceEnvReference resEnvRef = null;
                                int r = 0;
                                while (r < allEnvReferences.length) {
                                    if (allEnvReferences[r].getName().equals(resEnvName)) {
                                        resEnvRef = allEnvReferences[r];
                                        break;
                                    }
                                    ++r;
                                }
                                if (resEnvRef == null) {
                                    throw new EJBXMLParserException("ejb_2265", new Object[]{resEnvName});
                                }
                                String jndi_name = this.getElementText(this.getFirstElementByName(nextEl, "jndi-name"));
                                resEnvRef.setJndiName(jndi_name);
                            }
                        } else if (nextTag.equals("server-component-ref")) {
                            String name = this.getElementText(this.getFirstElementByName(nextEl, "name"));
                            if (name != null && !name.equals("")) {
                                ComponentReference compRef = new ComponentReference();
                                compRef.setName(name);
                                String type = this.getElementText(this.getFirstElementByName(nextEl, "type"));
                                if (type != null && type.equalsIgnoreCase("Interface")) {
                                    compRef.setType(1);
                                } else {
                                    compRef.setType(0);
                                }
                                String jndi_name = this.getElementText(this.getFirstElementByName(nextEl, "jndi-name"));
                                compRef.setJndiName(jndi_name);
                                Element descriptionEl = this.getFirstElementByName(nextEl, "description");
                                if (descriptionEl != null) {
                                    String description = this.getElementText(descriptionEl);
                                    compRef.setDescription(description);
                                }
                                componentRefs.add(compRef);
                            }
                        } else if (nextTag.equals("run-as-identity-map")) {
                            String userName = this.getElementText(this.getFirstElementByName(nextEl, "user-name"));
                            SecurityIdentity secId = dDescr.getSecurityIdentity();
                            if (secId == null) {
                                throw new EJBXMLParserException("ejb_2266", new Object[]{ejbName});
                            }
                            RunAsIdentity runAs = secId.getRunAsIdentity();
                            if (runAs == null) {
                                throw new EJBXMLParserException("ejb_2266", new Object[]{ejbName});
                            }
                            runAs.setUserName(userName);
                        } else if (nextTag.equals("ior-security-config")) {
                            IORDescriptor ior = new IORDescriptor();
                            Element child = this.getFirstElementByName(nextEl, "transport-config");
                            if (child != null) {
                                ior.setIntegrity(this.getElementText(this.getFirstElementByName(child, "integrity")));
                                ior.setConfidentiality(this.getElementText(this.getFirstElementByName(child, "confidentiality")));
                                ior.setEstablishTrustInTarget(this.getElementText(this.getFirstElementByName(child, "establish-trust-in-target")));
                                ior.setEstablishTrustInClient(this.getElementText(this.getFirstElementByName(child, "establish-trust-in-client")));
                            }
                            if ((child = this.getFirstElementByName(nextEl, "as-context")) != null) {
                                ior.setAuthenticationMethod(this.getElementText(this.getFirstElementByName(child, "auth-method")));
                                ior.setRealmName(this.getElementText(this.getFirstElementByName(child, "realm")));
                                if (this.getElementText(this.getFirstElementByName(child, "required")).equals("true")) {
                                    ior.setAuthMethodRequired(true);
                                } else {
                                    ior.setAuthMethodRequired(false);
                                }
                            }
                            if ((child = this.getFirstElementByName(nextEl, "sas-context")) != null) {
                                ior.setCallerPropagation(this.getElementText(this.getFirstElementByName(child, "caller-propagation")));
                            }
                            iors.add(ior);
                        }
                    }
                    ++j;
                }
                if (dDescr != null) {
                    dDescr.setBeanProperties(bProps);
                    if (iors.size() > 0) {
                        dDescr.setIORDescriptors(iors.toArray(new IORDescriptor[iors.size()]));
                    }
                    if (componentRefs.size() > 0) {
                        dDescr.setServerComponentReferences(componentRefs.toArray(new ComponentReference[componentRefs.size()]));
                    }
                }
            }
            ++i;
        }
    }

    private void processSessionProps(Element element, SessionDescriptor des, Properties props) {
        NodeList list = element.getChildNodes();
        boolean usePassivation = false;
        boolean keepsOpenResources = false;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element child = (Element)list.item(i);
                String tag = child.getNodeName();
                if (tag.equals("session-timeout")) {
                    int sessionTimeout = Integer.parseInt(this.getElementText(child));
                    if (sessionTimeout < 0) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": The value of element session-timeout is negative: " + sessionTimeout + ". It will be ignored!");
                    } else {
                        des.setSessionTimeout(sessionTimeout);
                    }
                } else if (tag.equals("passivation")) {
                    usePassivation = true;
                    Element el = this.getFirstElementByName(child, "passive-timeout");
                    int passiveTimeout = Integer.parseInt(this.getElementText(el));
                    if (passiveTimeout < 0) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": The value of element passive-timeout is negative: " + passiveTimeout + ". It will be ignored!");
                    } else {
                        des.setStatefulTimeout(passiveTimeout);
                    }
                    el = this.getFirstElementByName(child, "lrulimit");
                    int lruLimit = Integer.parseInt(this.getElementText(el));
                    if (lruLimit < 0) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": The value of element lrulimit is negative: " + lruLimit + ". It will be ignored!");
                    } else {
                        des.setLruLimit(lruLimit);
                    }
                } else if (tag.equals("keeps-open-resources")) {
                    keepsOpenResources = true;
                } else if (tag.equals("property")) {
                    String name = this.getElementText(this.getFirstElementByName(child, "property-name"));
                    String value = this.getElementText(this.getFirstElementByName(child, "property-value"));
                    if (name != null && value != null && name.equals("stateful-failover") && value.equalsIgnoreCase("true")) {
                        des.setStatefulFailover(true);
                    } else {
                        props.setProperty(name, value);
                    }
                }
            }
            ++i;
        }
        des.setUsePassivation(usePassivation);
        des.setKeepsOpenResources(keepsOpenResources);
    }

    private void processEntityProps(Element element, EntityDescriptor des, Properties props) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element child = (Element)list.item(i);
                String tag = child.getNodeName();
                if (tag.equals("unknown-pk-interval") && des instanceof CMPEntityDescriptor) {
                    int unknownPKInterval = Integer.parseInt(this.getElementText(child));
                    if (unknownPKInterval < 0) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": The value of element unknown-pk-interval is negative: " + unknownPKInterval + ". It will be ignored!");
                    } else {
                        ((CMPEntityDescriptor)des).setUnknownPKInterval(unknownPKInterval);
                    }
                } else if (tag.equals("initial-cache-size") && des instanceof CMPEntityDescriptor) {
                    int cacheSize = Integer.parseInt(this.getElementText(child));
                    if (cacheSize < 0) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": The value of element initial-cache-size is negative: " + cacheSize + ". It will be ignored!");
                    } else {
                        ((CMPEntityDescriptor)des).setCacheSize(cacheSize);
                    }
                } else if (tag.equals("property")) {
                    props.setProperty(this.getElementText(this.getFirstElementByName(child, "property-name")), this.getElementText(this.getFirstElementByName(child, "property-value")));
                }
            }
            ++i;
        }
    }

    private void processMessageDrivenProps(Element element, DeploymentDescriptor descr, Properties props) {
        MessageDrivenDescriptor mdbDescr = (MessageDrivenDescriptor)descr;
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element child = (Element)list.item(i);
                String tag = child.getNodeName();
                if (tag.equals("destination-name")) {
                    props.setProperty("DestinationName", this.getElementText(child));
                } else if (tag.equals("connection-factory-name")) {
                    props.setProperty("ConnectionFactoryName", this.getElementText(child));
                } else if (tag.equals("property")) {
                    String name = this.getElementText(this.getFirstElementByName(child, "property-name"));
                    String value = this.getElementText(this.getFirstElementByName(child, "property-value"));
                    if (name == null || value == null) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": property tag is not correct - name or value is not specified.");
                    } else if (name.equals("sap-xi-listener-type")) {
                        mdbDescr.setMessagingType(value);
                    } else if (name.equals("sap-xi-ra-name")) {
                        mdbDescr.setResourceAdapterName(value);
                    } else {
                        props.setProperty(name, value);
                    }
                }
            }
            ++i;
        }
    }

    private void processTransactions(Element transactions) throws DeploymentException {
        NodeList transactionList = transactions.getElementsByTagName("isolation-level");
        int j = 0;
        while (j < transactionList.getLength()) {
            if (transactionList.item(j).getNodeType() == 1) {
                NodeList isolationList = transactionList.item(j).getChildNodes();
                HashSet controlDescriptors = new HashSet();
                HashSet<DeploymentDescriptor> wholeBeanDescriptors = new HashSet<DeploymentDescriptor>();
                int i = 0;
                while (i < isolationList.getLength()) {
                    if (isolationList.item(i).getNodeType() == 1) {
                        Element el = (Element)isolationList.item(i);
                        String tag = el.getNodeName();
                        if (tag.equals("method")) {
                            controlDescriptors.addAll(this.findCtrlDescriptors(el));
                        } else if (tag.equals("ejb-name")) {
                            String ejbName = this.getElementText(el);
                            wholeBeanDescriptors.add(this.findDescriptor(ejbName));
                        } else if (tag.equals("isolation-attribute")) {
                            String isoLevel = this.getElementText(el);
                            if (isoLevel.equals(TRANSACTION_REPEATABLE_READ)) {
                                Iterator wholeBeanDescriptorsIterator = wholeBeanDescriptors.iterator();
                                while (wholeBeanDescriptorsIterator.hasNext()) {
                                    ((DeploymentDescriptor)wholeBeanDescriptorsIterator.next()).setUncommittedIsolationLevel();
                                }
                                Iterator controlDescriptorsIterator = controlDescriptors.iterator();
                                while (controlDescriptorsIterator.hasNext()) {
                                    ((ControlDescriptor)controlDescriptorsIterator.next()).setUncommittedIsolationLevel();
                                }
                            } else if (!isoLevel.equals(TRANSACTION_READ_COMMITTED)) {
                                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Isolation level attribute " + isoLevel + " is ignored. TRANSACTION_READ_COMMITTED isolation level is the default one.");
                            }
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private void processSecurityRoles(Element securityPerm, boolean atDeploy, SecurityContext jarSecCtx, boolean atUpdate, UpdateSecurityContext updateSecCtx) {
        NodeList securityRoleMapList = securityPerm.getElementsByTagName("security-role-map");
        if (atDeploy) {
            SecurityRoleContext securityRoleContext = jarSecCtx.getAuthorizationContext().getSecurityRoleContext();
            int j = 0;
            while (j < securityRoleMapList.getLength()) {
                Element mapELement = (Element)securityRoleMapList.item(j);
                Element secRoleElement = (Element)mapELement.getElementsByTagName("role-name").item(0);
                String roleName = this.getElementText(secRoleElement);
                SecurityRole securityRole = securityRoleContext.getSecurityRole(roleName);
                if (securityRole == null) {
                    this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Security role with name: " + roleName + " defined in ejb-j2ee-engine.xml but not defined in ejb-jar.xml or application.xml!");
                } else {
                    NodeList userList = mapELement.getElementsByTagName("user-name");
                    int k = 0;
                    while (k < userList.getLength()) {
                        securityRole.addUser(this.getElementText((Element)userList.item(k)));
                        ++k;
                    }
                    NodeList groupList = mapELement.getElementsByTagName("group-name");
                    int k2 = 0;
                    while (k2 < groupList.getLength()) {
                        securityRole.addGroup(this.getElementText((Element)groupList.item(k2)));
                        ++k2;
                    }
                    Element serverSecRoleElement = (Element)mapELement.getElementsByTagName("server-role-name").item(0);
                    if (serverSecRoleElement != null) {
                        String serverRoleName = this.getElementText(serverSecRoleElement);
                        securityRoleContext.removeSecurityRole(roleName);
                        securityRoleContext.addSecurityRoleReference(roleName, "SAP-J2EE-Engine", serverRoleName);
                    }
                }
                ++j;
            }
        } else if (atUpdate) {
            updateSecCtx.setDefaultTargetRoleMappings(securityRoleMapList);
        }
    }

    private Vector findCtrlDescriptors(Element mEl) throws DeploymentException {
        int i;
        Vector<ControlDescriptor> filtered;
        NodeList methodList = mEl.getChildNodes();
        String ejbName = null;
        String methodIntf = null;
        String methodName = null;
        Vector<String> methodParams = new Vector<String>();
        boolean hasMethodParams = false;
        int i2 = 0;
        while (i2 < methodList.getLength()) {
            if (methodList.item(i2).getNodeType() == 1) {
                Element el = (Element)methodList.item(i2);
                String tag = el.getNodeName();
                if (tag.equals("ejb-name")) {
                    ejbName = this.getElementText(el);
                } else if (tag.equals("method-intf")) {
                    methodIntf = this.getElementText(el);
                } else if (tag.equals("method-name")) {
                    methodName = this.getElementText(el).trim();
                } else if (tag.equals("method-params")) {
                    hasMethodParams = true;
                    NodeList paramList = el.getChildNodes();
                    int j = 0;
                    while (j < paramList.getLength()) {
                        Element pel;
                        if (paramList.item(j).getNodeType() == 1 && (pel = (Element)paramList.item(j)).getNodeName().equals("method-param")) {
                            methodParams.add(this.getElementText(pel));
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        ControlDescriptor[] allControls = this.findDescriptor(ejbName).getTransactionDescriptors();
        if (allControls == null) {
            return new Vector();
        }
        if (methodName.equals("*")) {
            if (methodIntf != null) {
                filtered = new Vector<ControlDescriptor>();
                int i3 = 0;
                while (i3 < allControls.length) {
                    if (allControls[i3].getMethodEntry().getMethodInterface().equals(methodIntf)) {
                        filtered.add(allControls[i3]);
                    }
                    ++i3;
                }
                return filtered;
            }
            Vector<ControlDescriptor> result = new Vector<ControlDescriptor>();
            int i4 = 0;
            while (i4 < allControls.length) {
                result.add(allControls[i4]);
                ++i4;
            }
            return result;
        }
        if (!hasMethodParams) {
            filtered = new Vector();
            if (methodIntf != null) {
                int i5 = 0;
                while (i5 < allControls.length) {
                    MethodEntry mEntry = allControls[i5].getMethodEntry();
                    if (mEntry.getMethodInterface().equals(methodIntf) && mEntry.getMethodName().equals(methodName)) {
                        filtered.add(allControls[i5]);
                    }
                    ++i5;
                }
                if (filtered.size() == 0) {
                    throw new EJBXMLParserException("ejb_2227", new Object[]{methodName, methodIntf, ejbName});
                }
            } else {
                int i6 = 0;
                while (i6 < allControls.length) {
                    MethodEntry mEntry = allControls[i6].getMethodEntry();
                    if (mEntry.getMethodName().equals(methodName)) {
                        filtered.add(allControls[i6]);
                    }
                    ++i6;
                }
                if (filtered.size() == 0) {
                    throw new EJBXMLParserException("ejb_2228", new Object[]{methodName, ejbName});
                }
            }
            return filtered;
        }
        filtered = new Vector();
        if (methodIntf != null) {
            i = 0;
            while (i < allControls.length) {
                MethodEntry mEntry = allControls[i].getMethodEntry();
                if (mEntry.getMethodInterface().equals(methodIntf) && mEntry.getMethodName().equals(methodName)) {
                    filtered.add(allControls[i]);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < allControls.length) {
                MethodEntry mEntry = allControls[i].getMethodEntry();
                if (mEntry.getMethodName().equals(methodName)) {
                    filtered.add(allControls[i]);
                }
                ++i;
            }
        }
        Vector<ControlDescriptor> secondFiltered = new Vector<ControlDescriptor>();
        String[] params = methodParams.toArray(new String[methodParams.size()]);
        Enumeration e = filtered.elements();
        while (e.hasMoreElements()) {
            ControlDescriptor accCtrl = (ControlDescriptor)e.nextElement();
            String[] mParams = accCtrl.getMethodEntry().getParameters();
            if (params.length != mParams.length) continue;
            boolean equals = true;
            int j = 0;
            while (j < params.length) {
                if (!params[j].equals(AdminUtils.convertClassName((String)mParams[j]))) {
                    equals = false;
                }
                ++j;
            }
            if (!equals) continue;
            secondFiltered.add(accCtrl);
        }
        if (secondFiltered.size() == 0) {
            String param = "";
            int i7 = 0;
            while (i7 < params.length) {
                param = param + ", " + params[i7];
                ++i7;
            }
            EJBXMLParserException toThrow = null;
            toThrow = param.length() == 0 ? new EJBXMLParserException("ejb_2223", new Object[]{methodName, param, XML_NAME}) : new EJBXMLParserException("ejb_2223", new Object[]{methodName, param.substring(2), XML_NAME});
            throw toThrow;
        }
        return secondFiltered;
    }

    private DeploymentDescriptor findDescriptor(String name) throws DeploymentException {
        DeploymentDescriptor[] descriptors = this.ejbJar.getDDescriptors();
        if (descriptors == null) {
            throw new EJBDescriptorException("ejb_2267", new Object[]{this.ejbJar.getJarName()});
        }
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getEjbName().equals(name)) {
                return descriptors[i];
            }
            ++i;
        }
        throw new EJBXMLParserException("ejb_2260", new Object[]{name});
    }
}

