/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.UpdateSecurityContext;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.xml.CMPParser;
import com.sap.engine.services.ejb.deploy.xml.MethodsExtractor;
import com.sap.engine.services.ejb.deploy.xml.ParseUtils;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.engine.services.ejb.util.AdminUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EJBJarParser
extends ParseUtils {
    private static final char SEP_CHAR = File.separatorChar;
    private static final char BACK_SLASH = '\\';
    private int xmlType = 2;
    private CMPParser cmpParser;
    private Vector warnings;
    private ClassLoader loader;
    private Document document;
    private String appName;
    private String ejbJarName;

    public EJBJarDescriptor parseXml(BufferedInputStream _xmlStream, Vector _warnings, ClassLoader _loader, String _appName, String _ejbJarName, boolean _atDeploy, SecurityContext _jarSecurityCtx, boolean _atUpdate, UpdateSecurityContext _updateSecurityCtx) throws DeploymentException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser domParser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            if (!_atDeploy && !_atUpdate) {
                try {
                    domParser.setBackwardsCompatibilityMode(true);
                }
                catch (SAXException sax) {
                    throw new EJBXMLParserException("ejb_2246", (Throwable)sax);
                }
            }
            domParser.setValidation(true);
            this.document = domParser.parse((InputStream)_xmlStream);
            _xmlStream.close();
        }
        catch (IOException ioe) {
            throw new EJBXMLParserException("ejb_2200", new Object[]{"ejb-jar.xml", _ejbJarName}, ioe);
        }
        catch (SAXException sax) {
            throw new EJBXMLParserException("ejb_2200", new Object[]{"ejb-jar.xml", _ejbJarName}, sax);
        }
        this.warnings = _warnings;
        this.loader = _loader;
        this.appName = _appName;
        this.ejbJarName = _ejbJarName;
        this.cmpParser = new CMPParser(this.ejbJarName, this.loader, this.warnings);
        return this.parseXml(_atDeploy, _jarSecurityCtx, _atUpdate, _updateSecurityCtx);
    }

    protected String getXMLFileName() {
        return "ejb-jar.xml";
    }

    protected String getEJBJarFileName() {
        return this.ejbJarName;
    }

    protected Vector getWarnings() {
        return this.warnings;
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    private EJBJarDescriptor parseXml(boolean atDeploy, SecurityContext jarSecurityCtx, boolean atUpdate, UpdateSecurityContext updateSecurityCtx) throws DeploymentException {
        EJBJarDescriptor result = new EJBJarDescriptor();
        DocumentType dt = this.document.getDoctype();
        if (dt == null) {
            throw new EJBXMLParserException("ejb_2201");
        }
        this.initXMLType(dt.getSystemId());
        Node ejbjar = this.document.getElementsByTagName("ejb-jar").item(0);
        NodeList ejbjarList = ejbjar.getChildNodes();
        Hashtable notLinkedSecRoleRefs = new Hashtable();
        int i = 0;
        while (i < ejbjarList.getLength()) {
            if (ejbjarList.item(i).getNodeType() == 1) {
                Element el = (Element)ejbjarList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getElementText(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getElementText(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("enterprise-beans")) {
                    result.setDescriptors(this.processBeans(el, notLinkedSecRoleRefs));
                } else if (tag.equals("relationships")) {
                    this.cmpParser.processRelationships(el, result);
                } else if (tag.equals("assembly-descriptor")) {
                    this.processAssemblyDescriptor(el, result, atDeploy, jarSecurityCtx, atUpdate, updateSecurityCtx, notLinkedSecRoleRefs);
                } else if (tag.equals("ejb-client-jar")) {
                    result.setClientJarName(this.processString(this.getElementText(el)));
                }
            }
            ++i;
        }
        if (!notLinkedSecRoleRefs.isEmpty()) {
            Enumeration enumeration = notLinkedSecRoleRefs.keys();
            while (enumeration.hasMoreElements()) {
                String roleName = (String)enumeration.nextElement();
                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Neither role-link is specified for security-role-ref " + roleName + ", nor a security-role with this name is defined. EJBContainer cannot choose an appropriate security role.");
            }
        }
        if (result.getAbstractSchema().getRelDescriptors() == null) {
            result.getAbstractSchema().setRelDescriptors(new RelationDescriptor[0]);
        }
        this.cmpParser.parseFields(result);
        this.cmpParser.parseFinders(result);
        return result;
    }

    private void initXMLType(String dtd) throws EJBXMLParserException {
        if (dtd == null) {
            this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": System identifier must be specified in the DOCTYPE declaration of an ejb-jar deployment descriptor. See: EJB 1.1 spec, page 244; EJB 2.0 spec, page 461. The beans will be deployed as 2.x beans.");
            this.xmlType = 2;
        } else if (dtd.indexOf("ejb-jar_1_1.dtd") != -1) {
            this.xmlType = 1;
        } else if (dtd.indexOf("ejb-jar_2_0.dtd") != -1) {
            this.xmlType = 2;
        } else {
            throw new EJBXMLParserException("ejb_2202", new Object[]{dtd});
        }
    }

    private DeploymentDescriptor[] processBeans(Element beansEl, Hashtable notLinkedSecRoleRefs) throws DeploymentException {
        NodeList beansList = beansEl.getChildNodes();
        Vector<DeploymentDescriptor> result = new Vector<DeploymentDescriptor>();
        int i = 0;
        while (i < beansList.getLength()) {
            if (beansList.item(i).getNodeType() == 1) {
                Element el = (Element)beansList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("session")) {
                    result.add(this.processSession(el, notLinkedSecRoleRefs));
                } else if (tag.equals("entity")) {
                    result.add(this.processEntity(el, notLinkedSecRoleRefs));
                } else if (tag.equals("message-driven")) {
                    result.add(this.processMessageDriven(el));
                }
            }
            ++i;
        }
        return result.toArray(new DeploymentDescriptor[result.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DeploymentDescriptor processEntity(Element entityEl, Hashtable notLinkedSecRoleRefs) throws DeploymentException {
        EntityDescriptor result = null;
        Element persistence = this.getFirstElementByName(entityEl, "persistence-type");
        String value = this.getElementText(persistence);
        if (value.equals("Bean")) {
            result = new EntityDescriptor();
            result.setPersistenceType(0);
        } else {
            if (!value.equals("Container")) throw new EJBXMLParserException("ejb_2203", new Object[]{value, "Bean", "Container"});
            result = new CMPEntityDescriptor();
            result.setPersistenceType(1);
            if (this.xmlType == 1) {
                ((CMPEntityDescriptor)result).setCmpVersion(this.xmlType);
            }
        }
        NodeList entityList = entityEl.getChildNodes();
        String ejbName = null;
        Vector<PersistentField> cmpFields = new Vector<PersistentField>();
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<EJBeanLocalReference> ejbLocalRefs = new Vector<EJBeanLocalReference>();
        Hashtable<String, SecurityRoleReference> securityRoleRefs = new Hashtable<String, SecurityRoleReference>();
        Vector<ResourceReference> resourceRefs = new Vector<ResourceReference>();
        Vector<ResourceEnvReference> resourceEnvRefs = new Vector<ResourceEnvReference>();
        Vector<FinderDescriptor> queries = new Vector<FinderDescriptor>();
        int i = 0;
        while (i < entityList.getLength()) {
            if (entityList.item(i).getNodeType() == 1) {
                Element el = (Element)entityList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getElementText(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getElementText(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("ejb-name")) {
                    ejbName = this.getElementText(el);
                    result.setBeanName(ejbName, this.appName);
                } else if (tag.equals("home")) {
                    result.setRemoteHomeInterface(this.getElementText(el));
                } else if (tag.equals("remote")) {
                    result.setRemoteInterface(this.getElementText(el));
                } else if (tag.equals("local-home")) {
                    result.setLocalHomeInterface(this.getElementText(el));
                } else if (tag.equals("local")) {
                    result.setLocalInterface(this.getElementText(el));
                } else if (tag.equals("ejb-class")) {
                    result.setClassName(this.getElementText(el));
                } else if (tag.equals("prim-key-class")) {
                    result.setPrimaryKeyClass(this.getElementText(el));
                } else if (tag.equals("reentrant")) {
                    result.setReentrant(this.getElementText(el).equals("True"));
                } else if (tag.equals("cmp-version")) {
                    String strCmpVersion = this.getElementText(el);
                    if (strCmpVersion.equals("2.x")) {
                        ((CMPEntityDescriptor)result).setCmpVersion(2);
                    } else {
                        if (!strCmpVersion.equals("1.x")) throw new EJBXMLParserException("ejb_2204", new Object[]{strCmpVersion, "1.x", "2.x"});
                        ((CMPEntityDescriptor)result).setCmpVersion(1);
                    }
                } else if (tag.equals("abstract-schema-name") && result.getPersistenceType() == 1) {
                    ((CMPEntityDescriptor)result).setAbstractSchemaName(this.getElementText(el));
                } else if (tag.equals("cmp-field")) {
                    cmpFields.add(this.cmpParser.processCMPField(el));
                } else if (tag.equals("primkey-field")) {
                    ((CMPEntityDescriptor)result).setPKFieldName(this.getElementText(el));
                } else if (tag.equals("env-entry")) {
                    envEntries.add(this.processEnvEntry(el));
                } else if (tag.equals("ejb-ref")) {
                    ejbRefs.add(this.processEjbRef(el));
                } else if (tag.equals("ejb-local-ref")) {
                    ejbLocalRefs.add(this.processEjbLocalRef(el));
                } else if (tag.equals("security-role-ref")) {
                    SecurityRoleReference roleRef = this.processSecurityRoleRef(el, notLinkedSecRoleRefs);
                    securityRoleRefs.put(roleRef.getRoleName(), roleRef);
                } else if (tag.equals("security-identity")) {
                    result.setSecurityIdentity(this.processSecurityIdentity(el));
                } else if (tag.equals("resource-ref")) {
                    resourceRefs.add(this.processResourceRef(el));
                } else if (tag.equals("resource-env-ref")) {
                    resourceEnvRefs.add(this.processResourceEnvRef(el));
                } else if (tag.equals("query")) {
                    queries.add(this.cmpParser.processQuery(el, ejbName));
                }
            }
            ++i;
        }
        result.setEnvironmentEntries(envEntries.toArray(new EnvironmentEntry[envEntries.size()]));
        result.setEJBeanReferences(ejbRefs.toArray(new EJBeanReference[ejbRefs.size()]));
        result.setEJBeanLocalReferences(ejbLocalRefs.toArray(new EJBeanLocalReference[ejbLocalRefs.size()]));
        result.setRoleReferences(securityRoleRefs);
        result.setResourceReferences(resourceRefs.toArray(new ResourceReference[resourceRefs.size()]));
        result.setResourceEnvReferences(resourceEnvRefs.toArray(new ResourceEnvReference[resourceEnvRefs.size()]));
        if (!(result instanceof CMPEntityDescriptor)) return result;
        ((CMPEntityDescriptor)result).setCmpFields(cmpFields.toArray(new PersistentField[cmpFields.size()]));
        ((CMPEntityDescriptor)result).setFinderDescriptors(queries.toArray(new FinderDescriptor[queries.size()]));
        return result;
    }

    private SecurityIdentity processSecurityIdentity(Element el) {
        SecurityIdentity securityIdentity = new SecurityIdentity();
        NodeList secIdentityList = el.getChildNodes();
        int j = 0;
        while (j < secIdentityList.getLength()) {
            if (secIdentityList.item(j).getNodeType() == 1) {
                Element nextEl = (Element)secIdentityList.item(j);
                String nextTag = nextEl.getNodeName();
                if (nextTag.equals("description")) {
                    securityIdentity.setDescription(this.getElementText(nextEl));
                } else if (nextTag.equals("use-caller-identity")) {
                    securityIdentity.setCallerIdentity(true);
                } else if (nextTag.equals("run-as")) {
                    NodeList runAsList = nextEl.getChildNodes();
                    RunAsIdentity runAsIdentity = new RunAsIdentity();
                    securityIdentity.setCallerIdentity(false);
                    Element runEl = null;
                    int r = 0;
                    while (r < runAsList.getLength()) {
                        if (runAsList.item(r).getNodeType() == 1) {
                            runEl = (Element)runAsList.item(r);
                            if (runEl.getNodeName().equals("role-name")) {
                                runAsIdentity.setSecurityRoleName(this.getElementText(runEl));
                            } else if (runEl.getNodeName().equals("description")) {
                                runAsIdentity.setDescription(this.getElementText(runEl));
                            }
                        }
                        ++r;
                    }
                    securityIdentity.setRunAsIdentity(runAsIdentity);
                }
            }
            ++j;
        }
        return securityIdentity;
    }

    private EnvironmentEntry processEnvEntry(Element envEl) throws DeploymentException {
        EnvironmentEntry result = new EnvironmentEntry();
        NodeList list = envEl.getChildNodes();
        String entryType = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                String entryValueStr;
                Element el = (Element)list.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setEntryDescription(this.getElementText(el));
                } else if (tag.equals("env-entry-name")) {
                    result.setEntryName(this.getElementText(el));
                } else if (tag.equals("env-entry-type")) {
                    entryType = this.getElementText(el);
                    result.setEntryType(entryType);
                } else if (tag.equals("env-entry-value") && !(entryValueStr = this.getElementText(el)).equals("")) {
                    Object entryValue;
                    if (entryType.equals("java.lang.Double")) {
                        entryValue = new Double(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Byte")) {
                        entryValue = new Byte(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Short")) {
                        entryValue = new Short(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Integer")) {
                        entryValue = new Integer(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Long")) {
                        entryValue = new Long(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Boolean")) {
                        entryValue = new Boolean(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Float")) {
                        entryValue = new Float(entryValueStr);
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.Character")) {
                        entryValue = new Character(entryValueStr.charAt(0));
                        result.setEntryValue(entryValue);
                    } else if (entryType.equals("java.lang.String")) {
                        entryValue = entryValueStr;
                        result.setEntryValue(entryValue);
                    } else {
                        throw new EJBXMLParserException("ejb_2205", new Object[]{entryType});
                    }
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EJBeanReference processEjbRef(Element elmnt) throws DeploymentException {
        NodeList refsList = elmnt.getChildNodes();
        EJBeanReference ejbRef = new EJBeanReference();
        int k = 0;
        while (k < refsList.getLength()) {
            if (refsList.item(k).getNodeType() == 1) {
                Element nextEl = (Element)refsList.item(k);
                String nextElTag = nextEl.getNodeName();
                String value = null;
                if (nextElTag.equals("description")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setReferenceDescription(value);
                    }
                } else if (nextElTag.equals("ejb-ref-name")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setReferenceName(value);
                    }
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getElementText(nextEl);
                    if (value.equals("Entity")) {
                        ejbRef.setType(1);
                    } else {
                        if (!value.equals("Session")) throw new EJBXMLParserException("ejb_2206", new Object[]{value, "Entity", "Session"});
                        ejbRef.setType(0);
                    }
                } else if (nextElTag.equals("home")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setHomeInterfaceName(value);
                    }
                } else if (nextElTag.equals("remote")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbRef.setRemoteInterfaceName(value);
                    }
                } else if (nextElTag.equals("ejb-link") && !(value = this.getElementText(nextEl)).equals("")) {
                    ejbRef.setReferenceEjbLink(value);
                }
            }
            ++k;
        }
        return ejbRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EJBeanLocalReference processEjbLocalRef(Element elmnt) throws DeploymentException {
        NodeList refsList = elmnt.getChildNodes();
        EJBeanLocalReference ejbLocalRef = new EJBeanLocalReference();
        int k = 0;
        while (k < refsList.getLength()) {
            if (refsList.item(k).getNodeType() == 1) {
                Element nextEl = (Element)refsList.item(k);
                String nextElTag = nextEl.getNodeName();
                String value = null;
                if (nextElTag.equals("description")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setReferenceDescription(value);
                    }
                } else if (nextElTag.equals("ejb-ref-name")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setReferenceName(value);
                    }
                } else if (nextElTag.equals("ejb-ref-type")) {
                    value = this.getElementText(nextEl);
                    if (value.equals("Entity")) {
                        ejbLocalRef.setType(1);
                    } else {
                        if (!value.equals("Session")) throw new EJBXMLParserException("ejb_2206", new Object[]{value, "Entity", "Session"});
                        ejbLocalRef.setType(0);
                    }
                } else if (nextElTag.equals("local-home")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setLocalHomeInterfaceName(value);
                    }
                } else if (nextElTag.equals("local")) {
                    value = this.getElementText(nextEl);
                    if (!value.equals("")) {
                        ejbLocalRef.setLocalInterfaceName(value);
                    }
                } else if (nextElTag.equals("ejb-link") && !(value = this.getElementText(nextEl)).equals("")) {
                    ejbLocalRef.setReferenceEjbLink(value);
                }
            }
            ++k;
        }
        return ejbLocalRef;
    }

    private SecurityRoleReference processSecurityRoleRef(Element elmnt, Hashtable notLinkedSecRoleRefs) {
        NodeList secList = elmnt.getChildNodes();
        SecurityRoleReference reference = new SecurityRoleReference();
        String roleName = null;
        boolean roleLinkSpecified = false;
        int k = 0;
        while (k < secList.getLength()) {
            if (secList.item(k).getNodeType() == 1) {
                String roleLink;
                Element nextEl = (Element)secList.item(k);
                String nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    String description = this.getElementText(nextEl);
                    if (!description.equals("")) {
                        reference.setDescription(description);
                    }
                } else if (nextElTag.equals("role-name")) {
                    roleName = this.getElementText(nextEl);
                    if (!roleName.equals("")) {
                        reference.setRoleName(roleName);
                    }
                } else if (nextElTag.equals("role-link") && !(roleLink = this.getElementText(nextEl)).equals("")) {
                    roleLinkSpecified = true;
                    reference.setSecurityRoleName(roleLink);
                }
            }
            ++k;
        }
        if (!roleLinkSpecified) {
            notLinkedSecRoleRefs.put(roleName, reference);
        }
        return reference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResourceReference processResourceRef(Element elmnt) throws DeploymentException {
        NodeList resList = elmnt.getChildNodes();
        ResourceReference resRef = new ResourceReference();
        int k = 0;
        while (k < resList.getLength()) {
            if (resList.item(k).getNodeType() == 1) {
                Element nextEl = (Element)resList.item(k);
                String nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    String description = this.getElementText(nextEl);
                    if (!description.equals("")) {
                        resRef.setResourceDescription(description);
                    }
                } else if (nextElTag.equals("res-ref-name")) {
                    String name = this.getElementText(nextEl);
                    if (!name.equals("")) {
                        resRef.setResourceName(name);
                    }
                } else if (nextElTag.equals("res-type")) {
                    String type = this.getElementText(nextEl);
                    if (!type.equals("")) {
                        resRef.setResourceType(type);
                    }
                } else if (nextElTag.equals("res-auth")) {
                    String authStr = this.getElementText(nextEl);
                    if (authStr.equals("Application")) {
                        resRef.setResourceAuthorization(3);
                    } else {
                        if (!authStr.equals("Container")) throw new EJBXMLParserException("ejb_2207", new Object[]{authStr, "Application", "Container"});
                        resRef.setResourceAuthorization(2);
                    }
                } else if (nextElTag.equals("res-sharing-scope")) {
                    String resShType = this.getElementText(nextEl);
                    if (resShType.equals("Shareable")) {
                        resRef.setResourceSharingScope(0);
                    } else {
                        if (!resShType.equals("Unshareable")) throw new EJBXMLParserException("ejb_2208", new Object[]{resShType, "Shareable", "Unshareable"});
                        resRef.setResourceSharingScope(1);
                    }
                }
            }
            ++k;
        }
        return resRef;
    }

    private ResourceEnvReference processResourceEnvRef(Element elmnt) {
        NodeList resList = elmnt.getChildNodes();
        ResourceEnvReference resRef = new ResourceEnvReference();
        int k = 0;
        while (k < resList.getLength()) {
            if (resList.item(k).getNodeType() == 1) {
                String type;
                Element nextEl = (Element)resList.item(k);
                String nextElTag = nextEl.getNodeName();
                if (nextElTag.equals("description")) {
                    String description = this.getElementText(nextEl);
                    if (!description.equals("")) {
                        resRef.setDescription(description);
                    }
                } else if (nextElTag.equals("resource-env-ref-name")) {
                    String name = this.getElementText(nextEl);
                    if (!name.equals("")) {
                        resRef.setName(name);
                    }
                } else if (nextElTag.equals("resource-env-ref-type") && !(type = this.getElementText(nextEl)).equals("")) {
                    resRef.setType(type);
                }
            }
            ++k;
        }
        return resRef;
    }

    private String processString(String str) {
        int index = str.indexOf(92);
        if (index == -1) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        while (index != -1) {
            sb.setCharAt(index, SEP_CHAR);
            index = str.indexOf(92, index + 1);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DeploymentDescriptor processMessageDriven(Element messageEl) throws DeploymentException {
        MessageDrivenDescriptor result = new MessageDrivenDescriptor();
        NodeList messageList = messageEl.getChildNodes();
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<EJBeanLocalReference> ejbLocalRefs = new Vector<EJBeanLocalReference>();
        Vector<ResourceReference> resourceRefs = new Vector<ResourceReference>();
        Vector<ResourceEnvReference> resourceEnvRefs = new Vector<ResourceEnvReference>();
        String beanName = null;
        int i = 0;
        while (i < messageList.getLength()) {
            if (messageList.item(i).getNodeType() == 1) {
                Element el = (Element)messageList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getElementText(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getElementText(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("ejb-name")) {
                    beanName = this.getElementText(el);
                    result.setBeanName(beanName, this.appName);
                } else if (tag.equals("ejb-class")) {
                    result.setClassName(this.getElementText(el));
                } else if (tag.equals("transaction-type")) {
                    String transType = this.getElementText(el);
                    if (transType.equals("Bean")) {
                        result.setTransactionType(0);
                    } else {
                        if (!transType.equals("Container")) throw new EJBXMLParserException("ejb_2213", new Object[]{beanName, transType, "Bean", "Container"});
                        result.setTransactionType(1);
                    }
                } else if (tag.equals("message-selector")) {
                    result.setMessageSelector(this.getElementText(el));
                } else if (tag.equals("acknowledge-mode")) {
                    String acknowledgeType = this.getElementText(el);
                    if (!acknowledgeType.equals("Auto-acknowledge") && !acknowledgeType.equals("Dups-ok-acknowledge")) {
                        throw new EJBXMLParserException("ejb_2214", new Object[]{beanName, acknowledgeType, "Auto-acknowledge", "Dups-ok-acknowledge"});
                    }
                    result.setAcknowledgeMode(acknowledgeType);
                    if (result.getTransactionType() == 1) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Message-driven bean: " + beanName + ": acknowledge-mode element is used only if transaction-type is 'Bean'. For 'Container' transaction-type acknowledgment is handled automatically as a part of the transaction commit. EJB 2.0 spec, Chapter 15.4.8.");
                    }
                } else if (tag.equals("message-driven-destination")) {
                    NodeList destType = el.getElementsByTagName("destination-type");
                    int nl = 0;
                    while (nl < destType.getLength()) {
                        if (destType.item(nl).getNodeType() == 1) {
                            String destTypeStr = this.getElementText((Element)destType.item(nl));
                            if (!destTypeStr.equals("javax.jms.Queue") && !destTypeStr.equals("javax.jms.Topic")) {
                                throw new EJBXMLParserException("ejb_2215", new Object[]{beanName, destTypeStr, "javax.jms.Queue", "javax.jms.Topic"});
                            }
                            result.setDestinationType(destTypeStr);
                            break;
                        }
                        ++nl;
                    }
                    destType = el.getElementsByTagName("subscription-durability");
                    if (destType.getLength() > 0 && result.getDestinationType().equals("javax.jms.Queue")) {
                        throw new EJBXMLParserException("ejb_2216", new Object[]{beanName});
                    }
                    int nl2 = 0;
                    while (nl2 < destType.getLength()) {
                        if (destType.item(nl2).getNodeType() == 1) {
                            String durable = this.getElementText((Element)destType.item(nl2));
                            if (!durable.equals("Durable") && !durable.equals("NonDurable")) {
                                throw new EJBXMLParserException("ejb_2217", new Object[]{beanName, durable, "Durable", "NonDurable"});
                            }
                            result.setSubscriptionDurability(durable);
                            break;
                        }
                        ++nl2;
                    }
                } else if (tag.equals("env-entry")) {
                    envEntries.add(this.processEnvEntry(el));
                } else if (tag.equals("ejb-ref")) {
                    ejbRefs.add(this.processEjbRef(el));
                } else if (tag.equals("ejb-local-ref")) {
                    ejbLocalRefs.add(this.processEjbLocalRef(el));
                } else if (tag.equals("security-identity")) {
                    SecurityIdentity secIdentity = this.processSecurityIdentity(el);
                    if (secIdentity.isCallerIdentity()) {
                        this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Run-as security identity is not specified for the Message Driven Bean " + result.getDisplayName());
                    }
                    result.setSecurityIdentity(secIdentity);
                } else if (tag.equals("resource-ref")) {
                    resourceRefs.add(this.processResourceRef(el));
                } else if (tag.equals("resource-env-ref")) {
                    resourceEnvRefs.add(this.processResourceEnvRef(el));
                }
            }
            ++i;
        }
        result.setEnvironmentEntries(envEntries.toArray(new EnvironmentEntry[envEntries.size()]));
        result.setEJBeanReferences(ejbRefs.toArray(new EJBeanReference[ejbRefs.size()]));
        result.setEJBeanLocalReferences(ejbLocalRefs.toArray(new EJBeanLocalReference[ejbLocalRefs.size()]));
        result.setResourceReferences(resourceRefs.toArray(new ResourceReference[resourceRefs.size()]));
        result.setResourceEnvReferences(resourceEnvRefs.toArray(new ResourceEnvReference[resourceEnvRefs.size()]));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DeploymentDescriptor processSession(Element sessionEl, Hashtable notLinkedSecRoleRefs) throws DeploymentException {
        SessionDescriptor result = new SessionDescriptor();
        NodeList sessionList = sessionEl.getChildNodes();
        Vector<EnvironmentEntry> envEntries = new Vector<EnvironmentEntry>();
        Vector<EJBeanReference> ejbRefs = new Vector<EJBeanReference>();
        Vector<EJBeanLocalReference> ejbLocalRefs = new Vector<EJBeanLocalReference>();
        Hashtable<String, SecurityRoleReference> securityRoleRefs = new Hashtable<String, SecurityRoleReference>();
        Vector<ResourceReference> resourceRefs = new Vector<ResourceReference>();
        Vector<ResourceEnvReference> resourceEnvRefs = new Vector<ResourceEnvReference>();
        String beanName = null;
        int i = 0;
        while (i < sessionList.getLength()) {
            if (sessionList.item(i).getNodeType() == 1) {
                Element el = (Element)sessionList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getElementText(el));
                } else if (tag.equals("display-name")) {
                    result.setDisplayName(this.getElementText(el));
                } else if (tag.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getElementText(el)));
                } else if (tag.equals("ejb-name")) {
                    beanName = this.getElementText(el);
                    result.setBeanName(beanName, this.appName);
                } else if (tag.equals("home")) {
                    result.setRemoteHomeInterface(this.getElementText(el));
                } else if (tag.equals("remote")) {
                    result.setRemoteInterface(this.getElementText(el));
                } else if (tag.equals("local-home")) {
                    result.setLocalHomeInterface(this.getElementText(el));
                } else if (tag.equals("local")) {
                    result.setLocalInterface(this.getElementText(el));
                } else if (tag.equals("ejb-class")) {
                    result.setClassName(this.getElementText(el));
                } else if (tag.equals("session-type")) {
                    String sesType = this.getElementText(el);
                    if (sesType.equals("Stateful")) {
                        result.setSessionType(1);
                    } else {
                        if (!sesType.equals("Stateless")) throw new EJBXMLParserException("ejb_2218", new Object[]{beanName, sesType, "Stateful", "Stateless"});
                        result.setSessionType(0);
                    }
                } else if (tag.equals("transaction-type")) {
                    String transType = this.getElementText(el);
                    if (transType.equals("Bean")) {
                        result.setTransactionType(0);
                    } else {
                        if (!transType.equals("Container")) throw new EJBXMLParserException("ejb_2213", new Object[]{beanName, transType, "Bean", "Container"});
                        result.setTransactionType(1);
                    }
                } else if (tag.equals("env-entry")) {
                    envEntries.add(this.processEnvEntry(el));
                } else if (tag.equals("ejb-ref")) {
                    ejbRefs.add(this.processEjbRef(el));
                } else if (tag.equals("ejb-local-ref")) {
                    ejbLocalRefs.add(this.processEjbLocalRef(el));
                } else if (tag.equals("security-role-ref")) {
                    SecurityRoleReference roleRef = this.processSecurityRoleRef(el, notLinkedSecRoleRefs);
                    securityRoleRefs.put(roleRef.getRoleName(), roleRef);
                } else if (tag.equals("security-identity")) {
                    result.setSecurityIdentity(this.processSecurityIdentity(el));
                } else if (tag.equals("resource-ref")) {
                    resourceRefs.add(this.processResourceRef(el));
                } else if (tag.equals("resource-env-ref")) {
                    resourceEnvRefs.add(this.processResourceEnvRef(el));
                }
            }
            ++i;
        }
        result.setEnvironmentEntries(envEntries.toArray(new EnvironmentEntry[envEntries.size()]));
        result.setEJBeanReferences(ejbRefs.toArray(new EJBeanReference[ejbRefs.size()]));
        result.setEJBeanLocalReferences(ejbLocalRefs.toArray(new EJBeanLocalReference[ejbLocalRefs.size()]));
        result.setRoleReferences(securityRoleRefs);
        result.setResourceReferences(resourceRefs.toArray(new ResourceReference[resourceRefs.size()]));
        result.setResourceEnvReferences(resourceEnvRefs.toArray(new ResourceEnvReference[resourceEnvRefs.size()]));
        return result;
    }

    private void processAssemblyDescriptor(Element assemblyEl, EJBJarDescriptor result, boolean atDeploy, SecurityContext jarSecurityCtx, boolean atUpdate, UpdateSecurityContext updateSecurityCtx, Hashtable notLinkedSecRoleRefs) throws DeploymentException {
        NodeList secRolesList = assemblyEl.getElementsByTagName("security-role");
        if (atUpdate) {
            updateSecurityCtx.setDefaultTargetRoles(secRolesList);
        }
        int i = 0;
        while (i < secRolesList.getLength()) {
            Element el = (Element)secRolesList.item(i);
            Element roleName = this.getFirstElementByName(el, "role-name");
            String name = this.getElementText(roleName);
            SecurityRoleReference reference = (SecurityRoleReference)notLinkedSecRoleRefs.remove(name);
            if (reference != null) {
                reference.setSecurityRoleName(name);
            }
            if (atDeploy) {
                SecurityRoleContext secRoleCtx = jarSecurityCtx.getAuthorizationContext().getSecurityRoleContext();
                SecurityRole secRole = secRoleCtx.addSecurityRole(name);
                Element descrEl = this.getFirstElementByName(el, "description");
                if (descrEl != null) {
                    String descr = this.getElementText(descrEl);
                    secRole.setDescription(descr);
                }
            }
            ++i;
        }
        NodeList assemblyList = assemblyEl.getChildNodes();
        Vector accessControls = new Vector();
        Vector controlDescriptors = new Vector();
        Vector excludeListMethods = new Vector();
        int i2 = 0;
        while (i2 < assemblyList.getLength()) {
            if (assemblyList.item(i2).getNodeType() == 1) {
                Element el = (Element)assemblyList.item(i2);
                String tag = el.getNodeName();
                if (tag.equals("method-permission")) {
                    this.processMethodPermission(el, result, accessControls);
                } else if (tag.equals("container-transaction")) {
                    this.processContainerTransaction(el, result, controlDescriptors);
                } else if (tag.equals("exclude-list")) {
                    this.processExcludeList(el, result, excludeListMethods);
                }
            }
            ++i2;
        }
        result.distributeControlDescriptors(controlDescriptors.toArray(new ControlDescriptor[controlDescriptors.size()]));
        result.distributeAccessControls(accessControls.toArray(new AccessControls[accessControls.size()]));
        result.distributeExcludeList(excludeListMethods.toArray(new MethodEntry[excludeListMethods.size()]));
    }

    private void processMethodPermission(Element el, EJBJarDescriptor result, Vector accessControls) throws DeploymentException {
        String accDescr = null;
        NodeList descrList = el.getElementsByTagName("description");
        int y = 0;
        while (y < descrList.getLength()) {
            if (descrList.item(y).getNodeType() == 1) {
                accDescr = this.getElementText((Element)descrList.item(y));
                break;
            }
            ++y;
        }
        String[] secRoles = null;
        Vector<String> tempRoles = new Vector<String>();
        NodeList rolesList = el.getElementsByTagName("role-name");
        int j = 0;
        while (j < rolesList.getLength()) {
            if (rolesList.item(j).getNodeType() == 1) {
                tempRoles.add(this.getElementText((Element)rolesList.item(j)));
            }
            ++j;
        }
        secRoles = tempRoles.toArray(new String[tempRoles.size()]);
        boolean unchecked = false;
        NodeList uncheckedList = el.getElementsByTagName("unchecked");
        int u = 0;
        while (u < uncheckedList.getLength()) {
            if (uncheckedList.item(u).getNodeType() == 1) {
                unchecked = true;
            }
            ++u;
        }
        NodeList methodsList = el.getElementsByTagName("method");
        int j2 = 0;
        while (j2 < methodsList.getLength()) {
            if (methodsList.item(j2).getNodeType() != 1) {
                return;
            }
            MethodEntry[] methodEntries = this.getMethodXml((Element)methodsList.item(j2), result, false);
            int me = 0;
            while (me < methodEntries.length) {
                if (!methodEntries[me].getMethodName().equals("Entire EJB")) {
                    boolean accessControlFound = false;
                    int ac = 0;
                    while (ac < accessControls.size()) {
                        if (((AccessControls)accessControls.elementAt(ac)).isCompatible(methodEntries[me])) {
                            ((AccessControls)accessControls.elementAt(ac)).addSecurityRoles(secRoles);
                            accessControlFound = true;
                            break;
                        }
                        ++ac;
                    }
                    if (!accessControlFound) {
                        AccessControls accCtrl = null;
                        accCtrl = unchecked ? new AccessControls(accDescr, methodEntries[me]) : new AccessControls(accDescr, secRoles, methodEntries[me]);
                        accessControls.add(accCtrl);
                    }
                }
                ++me;
            }
            ++j2;
        }
    }

    private void processContainerTransaction(Element el, EJBJarDescriptor result, Vector controlDescriptors) throws DeploymentException {
        String description = null;
        Element descrEl = this.getFirstElementByName(el, "description");
        if (descrEl != null) {
            description = this.getElementText(descrEl);
        }
        String transAttr = null;
        NodeList transList = el.getElementsByTagName("trans-attribute");
        int y = 0;
        while (y < transList.getLength()) {
            if (transList.item(y).getNodeType() == 1) {
                transAttr = this.getElementText((Element)transList.item(y));
                break;
            }
            ++y;
        }
        NodeList methodsList = el.getElementsByTagName("method");
        int j = 0;
        while (j < methodsList.getLength()) {
            if (methodsList.item(j).getNodeType() == 1) {
                MethodEntry[] methodEntries = this.getMethodXml((Element)methodsList.item(j), result, true);
                int me = 0;
                while (me < methodEntries.length) {
                    if (!methodEntries[me].getMethodName().equals("Entire EJB")) {
                        ControlDescriptor ctrlDescr;
                        MethodEntry prevMethodEntry = null;
                        boolean attributeIsSet = false;
                        int k = 0;
                        while (k < controlDescriptors.size()) {
                            prevMethodEntry = ((ControlDescriptor)controlDescriptors.elementAt(k)).getMethodEntry();
                            if (prevMethodEntry.simpleEquals(methodEntries[me]) && prevMethodEntry.getEjbName().equals(methodEntries[me].getEjbName())) {
                                attributeIsSet = true;
                                break;
                            }
                            ++k;
                        }
                        if (attributeIsSet) {
                            if (prevMethodEntry.hasLowPriority(methodEntries[me])) {
                                controlDescriptors.removeElementAt(k);
                                ctrlDescr = new ControlDescriptor(description, methodEntries[me], transAttr);
                                controlDescriptors.add(ctrlDescr);
                            } else if (prevMethodEntry.hasEqualsPriority(methodEntries[me])) {
                                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Method " + prevMethodEntry.getMethodName() + " in " + prevMethodEntry.getEjbName() + " has more than one transaction attribute. The first one is considered as valid.");
                            }
                        } else {
                            ctrlDescr = new ControlDescriptor(description, methodEntries[me], transAttr);
                            controlDescriptors.add(ctrlDescr);
                        }
                    }
                    ++me;
                }
            }
            ++j;
        }
    }

    private void processExcludeList(Element el, EJBJarDescriptor result, Vector excludeListMethods) throws DeploymentException {
        NodeList descrList = el.getElementsByTagName("description");
        int y = 0;
        while (y < descrList.getLength()) {
            if (descrList.item(y).getNodeType() == 1) {
                result.setExcludeListDescription(this.getElementText((Element)descrList.item(y)));
                break;
            }
            ++y;
        }
        NodeList methodsList = el.getElementsByTagName("method");
        int j = 0;
        while (j < methodsList.getLength()) {
            if (methodsList.item(j).getNodeType() == 1) {
                MethodEntry[] methodEntries = this.getMethodXml((Element)methodsList.item(j), result, false);
                int me = 0;
                while (me < methodEntries.length) {
                    if (!methodEntries[me].getMethodName().equals("Entire EJB")) {
                        excludeListMethods.add(methodEntries[me]);
                    }
                    ++me;
                }
            }
            ++j;
        }
    }

    private MethodEntry[] getMethodXml(Element methodEl, EJBJarDescriptor jarDescriptor, boolean containerTxAttrib) throws DeploymentException {
        NodeList methodList = methodEl.getChildNodes();
        Vector<String> methodParams = new Vector<String>();
        String description = null;
        String ejbName = null;
        String methodIntf = null;
        String methodName = null;
        boolean hasMethodParams = false;
        int i = 0;
        while (i < methodList.getLength()) {
            if (methodList.item(i).getNodeType() == 1) {
                Element el = (Element)methodList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    description = this.getElementText(el);
                } else if (tag.equals("ejb-name")) {
                    ejbName = this.getElementText(el);
                } else if (tag.equals("method-intf")) {
                    methodIntf = this.getElementText(el);
                    if (this.xmlType == 2) {
                        if (!(methodIntf.equals("Remote") || methodIntf.equals("Home") || methodIntf.equals("Local") || methodIntf.equals("LocalHome"))) {
                            throw new EJBXMLParserException("ejb_2220", new Object[]{methodIntf, "Remote", "Home", "Local", "LocalHome"});
                        }
                    } else if (!methodIntf.equals("Remote") && !methodIntf.equals("Home")) {
                        throw new EJBXMLParserException("ejb_2219", new Object[]{methodIntf, "Remote", "Home"});
                    }
                } else if (tag.equals("method-name")) {
                    methodName = this.getElementText(el).trim();
                } else if (tag.equals("method-params")) {
                    hasMethodParams = true;
                    NodeList paramList = el.getChildNodes();
                    int j = 0;
                    while (j < paramList.getLength()) {
                        Element pel;
                        if (paramList.item(j).getNodeType() == 1 && (pel = (Element)paramList.item(j)).getNodeName().equals("method-param")) {
                            methodParams.add(this.getElementText(pel));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        DeploymentDescriptor[] descriptors = jarDescriptor.getDDescriptors();
        DeploymentDescriptor foundDescr = null;
        int i2 = 0;
        while (i2 < descriptors.length) {
            if (descriptors[i2].getEjbName().equals(ejbName)) {
                foundDescr = descriptors[i2];
                break;
            }
            ++i2;
        }
        if (foundDescr == null) {
            throw new EJBXMLParserException("ejb_2221", new Object[]{ejbName});
        }
        MethodEntry[] methodEnts = null;
        try {
            methodEnts = MethodsExtractor.getAllMethodsInBean(methodName, methodIntf, foundDescr, this.loader, description, containerTxAttrib);
        }
        catch (ClassNotFoundException cnfe) {
            throw new EJBXMLParserException("ejb_2222", new Object[]{ejbName}, cnfe);
        }
        if (methodName.equals("*")) {
            return methodEnts;
        }
        if (!hasMethodParams) {
            int i3 = 0;
            while (i3 < methodEnts.length) {
                methodEnts[i3].setPriority(2);
                ++i3;
            }
            return methodEnts;
        }
        Vector<MethodEntry> filteredMethods = new Vector<MethodEntry>();
        String[] params = methodParams.toArray(new String[methodParams.size()]);
        int i4 = 0;
        while (i4 < methodEnts.length) {
            String[] mParams;
            if (!methodEnts[i4].getMethodName().equals("Entire EJB") && params.length == (mParams = methodEnts[i4].getParameters()).length) {
                boolean equals = true;
                int j = 0;
                while (j < params.length) {
                    if (!params[j].equals(AdminUtils.convertClassName((String)mParams[j]))) {
                        equals = false;
                    }
                    ++j;
                }
                if (equals) {
                    methodEnts[i4].setPriority(3);
                    filteredMethods.add(methodEnts[i4]);
                }
            }
            ++i4;
        }
        if (filteredMethods.size() == 0) {
            String param = "";
            int i5 = 0;
            while (i5 < params.length) {
                param = param + ", " + params[i5];
                ++i5;
            }
            EJBXMLParserException toThrow = null;
            toThrow = param.length() == 0 ? new EJBXMLParserException("ejb_2223", new Object[]{methodName, param, "ejb-jar.xml"}) : new EJBXMLParserException("ejb_2223", new Object[]{methodName, param.substring(2), "ejb-jar.xml"});
            throw toThrow;
        }
        return filteredMethods.toArray(new MethodEntry[filteredMethods.size()]);
    }
}

