/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.deploy.xml.ParseUtils;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.tc.logging.Location;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMPParser
extends ParseUtils {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$deploy$xml$CMPParser == null ? (class$com$sap$engine$services$ejb$deploy$xml$CMPParser = CMPParser.class$("com.sap.engine.services.ejb.deploy.xml.CMPParser")) : class$com$sap$engine$services$ejb$deploy$xml$CMPParser));
    private String ejbJarName;
    private ClassLoader loader;
    private Vector warnings;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$deploy$xml$CMPParser;

    public CMPParser(String _ejbJarName, ClassLoader _loader, Vector _warnings) {
        this.ejbJarName = _ejbJarName;
        this.loader = _loader;
        this.warnings = _warnings;
    }

    protected String getXMLFileName() {
        return "ejb-jar.xml";
    }

    protected String getEJBJarFileName() {
        return this.ejbJarName;
    }

    protected Vector getWarnings() {
        return this.warnings;
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    private void fillCmpFieldInfo(PersistentField[] cmpFields, CMPEntityDescriptor descriptor, Class clazz, boolean pkFields) throws DeploymentException {
        if (descriptor.isUnknownPK() && pkFields) {
            if (cmpFields.length != 1) {
                throw new EJBXMLParserException("ejb_2345", new Object[]{descriptor.getEjbName()});
            }
            this.setUnknownPKType(cmpFields[0], descriptor.getEjbName());
            return;
        }
        boolean cmp11 = descriptor.getCmpVersion() == 1;
        int j = 0;
        while (j < cmpFields.length) {
            Class fieldClass = this.getFieldClass(cmp11, cmpFields[j], descriptor.getEjbName(), clazz);
            if (Mappings.getDefaultSqlTypeForJavaType(fieldClass) == 2004) {
                cmpFields[j].setDV(true);
                DependentValueDescriptor dvDescr = this.mappedToSetOfColumns(cmpFields[j]);
                if (dvDescr != null) {
                    cmpFields[j] = dvDescr;
                    cmpFields[j].setMultipleDV(true);
                }
            }
            cmpFields[j].setFieldType(fieldClass.getName());
            ++j;
        }
    }

    protected void parseFields(EJBJarDescriptor ejbjarDes) throws DeploymentException {
        CMPEntityDescriptor[] entityDescriptors = ejbjarDes.getAbstractSchema().getDescriptors();
        int i = 0;
        while (i < entityDescriptors.length) {
            CMPEntityDescriptor descriptor = entityDescriptors[i];
            String beanClassName = descriptor.getClassName();
            Class<?> beanClazz = null;
            try {
                beanClazz = this.loader.loadClass(beanClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new EJBXMLParserException("ejb_2229", new Object[]{descriptor.getEjbName(), beanClassName}, cnfe);
            }
            this.parseCMPFields(descriptor, beanClazz);
            RelationField[] cmrFields = descriptor.getCmrFields();
            if (cmrFields != null) {
                int j = 0;
                while (j < cmrFields.length) {
                    String fieldName = cmrFields[j].getFieldName();
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        String returnType = beanClazz.getMethod(getMethodName, new Class[0]).getReturnType().getName();
                        if (cmrFields[j].getFieldType() != null && !cmrFields[j].getFieldType().equals(returnType)) {
                            this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": You had defined cmr-field-type of field " + cmrFields[j].getFieldName() + " to be " + cmrFields[j].getFieldType() + ". But accessor methods use type " + returnType + ". Type of the accessor methods is accepted as the proper one.");
                        }
                        cmrFields[j].setFieldType(returnType);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new EJBXMLParserException("ejb_2234", new Object[]{descriptor.getEjbName(), fieldName}, nsme);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void parseFinders(EJBJarDescriptor ejbjarDes) throws DeploymentException {
        CMPEntityDescriptor[] descriptors = ejbjarDes.getAbstractSchema().getDescriptors();
        if (descriptors == null) {
            return;
        }
        int i = 0;
        while (i < descriptors.length) {
            CMPEntityDescriptor descriptor = descriptors[i];
            String beanClassName = descriptor.getClassName();
            String remoteHomeClassName = descriptor.getRemoteHomeInterface();
            String localHomeClassName = descriptor.getLocalHomeInterface();
            Class<?> beanClass = null;
            Class<?> remHomeClass = null;
            Class<?> locHomeClass = null;
            try {
                beanClass = this.loader.loadClass(beanClassName);
                if (remoteHomeClassName != null) {
                    remHomeClass = this.loader.loadClass(remoteHomeClassName);
                }
                if (localHomeClassName != null) {
                    locHomeClass = this.loader.loadClass(localHomeClassName);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new EJBXMLParserException("ejb_2235", new Object[]{descriptor.getEjbName()}, cnfe);
            }
            FinderDescriptor[] methods = descriptor.getFinderDescriptors();
            if (methods != null) {
                int j = 0;
                while (j < methods.length) {
                    FinderDescriptor fDescr = methods[j];
                    String methodName = fDescr.getMethodName();
                    String[] params = fDescr.getParamsTypes();
                    Class[] paramsClass = this.getParamClasses(params, descriptor.getEjbName(), methodName);
                    if (methodName.startsWith("ejbSelect")) {
                        this.parseSelectMethod(fDescr, methodName, paramsClass, beanClass, descriptor.getEjbName());
                    } else if (methodName.startsWith("find")) {
                        this.parseFindMethod(fDescr, methodName, paramsClass, remHomeClass, locHomeClass);
                    } else {
                        throw new EJBXMLParserException("ejb_2239", new Object[]{methodName, "ejbSelect", "find"});
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private RelationField processCmrField(Element cmr) {
        RelationField field = new RelationField();
        Element tempEl = this.getFirstElementByName(cmr, "description");
        if (tempEl != null) {
            field.setDescription(this.getElementText(tempEl));
        }
        tempEl = this.getFirstElementByName(cmr, "cmr-field-name");
        field.setFieldName(this.getElementText(tempEl));
        tempEl = this.getFirstElementByName(cmr, "cmr-field-type");
        String cmrFieldType = null;
        if (tempEl != null) {
            cmrFieldType = this.getElementText(tempEl);
            if (!cmrFieldType.equals("java.util.Collection") && !cmrFieldType.equals("java.util.Set")) {
                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": You specified incorrect cmr-field-type, cmr-field " + field.getFieldName() + ". Only java.util.Set or java.util.Collection are acceptable. Type of cmr-field accessor methods will be accepted as the proper one.");
            } else {
                field.setFieldType(cmrFieldType);
            }
        }
        return field;
    }

    private OneSideRelationDescriptor processEjbRelationRole(Element role) {
        Element roleSourceEl;
        OneSideRelationDescriptor side = new OneSideRelationDescriptor();
        Element tempEl = this.getFirstElementByName(role, "description");
        if (tempEl != null) {
            side.setRoleDescription(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(role, "ejb-relationship-role-name")) != null) {
            side.setRoleName(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(role, "cascade-delete")) != null) {
            side.setCascade(true);
        }
        if ((tempEl = this.getFirstElementByName(roleSourceEl = this.getFirstElementByName(role, "relationship-role-source"), "description")) != null) {
            side.setRoleSourceDescription(this.getElementText(tempEl));
        }
        return side;
    }

    protected PersistentField processCMPField(Element cmpEl) {
        PersistentField result = new PersistentField();
        NodeList list = cmpEl.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getElementText(el));
                } else if (tag.equals("field-name")) {
                    result.setFieldName(this.getElementText(el));
                }
            }
            ++i;
        }
        return result;
    }

    protected void processRelationships(Element relEl, EJBJarDescriptor ejbjarDes) throws DeploymentException {
        Element tempEl = this.getFirstElementByName(relEl, "description");
        if (tempEl != null) {
            ejbjarDes.setRelationshipsDescription(this.getElementText(tempEl));
        }
        NodeList nl = relEl.getElementsByTagName("ejb-relation");
        RelationDescriptor[] relDescr = new RelationDescriptor[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            Element el = (Element)nl.item(i);
            relDescr[i] = this.processEjbRelation(el, ejbjarDes, i);
            ++i;
        }
        ejbjarDes.getAbstractSchema().setRelDescriptors(relDescr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RelationDescriptor processEjbRelation(Element ejbRel, EJBJarDescriptor ejbjarDes, int relId) throws DeploymentException {
        RelationField field;
        RelationDescriptor relDescr = new RelationDescriptor();
        Element tempEl = this.getFirstElementByName(ejbRel, "description");
        if (tempEl != null) {
            relDescr.setRelationDescription(this.getElementText(tempEl));
        }
        if ((tempEl = this.getFirstElementByName(ejbRel, "ejb-relation-name")) != null) {
            relDescr.setRelationName(this.getElementText(tempEl));
        }
        NodeList roles = ejbRel.getElementsByTagName("ejb-relationship-role");
        Element role1 = (Element)roles.item(0);
        Element role2 = (Element)roles.item(1);
        OneSideRelationDescriptor side1 = this.processEjbRelationRole(role1);
        OneSideRelationDescriptor side2 = this.processEjbRelationRole(role2);
        relDescr.setSide1(side1);
        relDescr.setSide2(side2);
        tempEl = this.getFirstElementByName(role1, "multiplicity");
        String mult1 = this.getElementText(tempEl);
        tempEl = this.getFirstElementByName(role2, "multiplicity");
        String mult2 = this.getElementText(tempEl);
        if (mult1.equals("One")) {
            if (mult2.equals("One")) {
                side1.setMultiplicityType(1);
                side2.setMultiplicityType(1);
            } else {
                if (!mult2.equals("Many")) throw new EJBXMLParserException("ejb_2209", new Object[]{mult2, "One", "Many"});
                side1.setMultiplicityType(2);
                side2.setMultiplicityType(3);
            }
        } else {
            if (!mult1.equals("Many")) throw new EJBXMLParserException("ejb_2209", new Object[]{mult1, "One", "Many"});
            if (mult2.equals("One")) {
                side1.setMultiplicityType(3);
                side2.setMultiplicityType(2);
            } else {
                if (!mult2.equals("Many")) throw new EJBXMLParserException("ejb_2209", new Object[]{mult2, "One", "Many"});
                side1.setMultiplicityType(4);
                side2.setMultiplicityType(4);
            }
        }
        Element roleSourceEl = this.getFirstElementByName(role1, "relationship-role-source");
        tempEl = this.getFirstElementByName(roleSourceEl, "ejb-name");
        String ejbName1 = this.getElementText(tempEl);
        CMPEntityDescriptor descr1 = ejbjarDes.getAbstractSchema().getDescriptor(ejbName1);
        if (descr1 == null) {
            throw new EJBXMLParserException("ejb_2210", new Object[]{ejbName1});
        }
        side1.setEjbId(descr1.getId());
        roleSourceEl = this.getFirstElementByName(role2, "relationship-role-source");
        tempEl = this.getFirstElementByName(roleSourceEl, "ejb-name");
        String ejbName2 = this.getElementText(tempEl);
        CMPEntityDescriptor descr2 = ejbjarDes.getAbstractSchema().getDescriptor(ejbName2);
        if (descr2 == null) {
            throw new EJBXMLParserException("ejb_2210", new Object[]{ejbName2});
        }
        side2.setEjbId(descr2.getId());
        NodeList cmr1 = role1.getElementsByTagName("cmr-field");
        NodeList cmr2 = role2.getElementsByTagName("cmr-field");
        int cmrCount = cmr1.getLength() + cmr2.getLength();
        if (cmrCount < 1 || cmrCount > 2) {
            throw new EJBXMLParserException("ejb_2211");
        }
        if (cmr1.getLength() == 1) {
            field = this.processCmrField((Element)cmr1.item(0));
            field.setRelationId(relId);
            side1.setCmrId(descr1.addCmrField(field));
        }
        if (cmr2.getLength() != 1) return relDescr;
        field = this.processCmrField((Element)cmr2.item(0));
        field.setRelationId(relId);
        side2.setCmrId(descr2.addCmrField(field));
        return relDescr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FinderDescriptor processQuery(Element queryEl, String ejbName) throws DeploymentException {
        FinderDescriptor result = new FinderDescriptor();
        Vector<String> params = new Vector<String>();
        NodeList queryList = queryEl.getChildNodes();
        int i = 0;
        while (i < queryList.getLength()) {
            if (queryList.item(i).getNodeType() == 1) {
                Element el = (Element)queryList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    result.setDescription(this.getElementText(el));
                } else if (tag.equals("query-method")) {
                    NodeList methodList = el.getChildNodes();
                    int j = 0;
                    while (j < methodList.getLength()) {
                        if (methodList.item(j).getNodeType() == 1) {
                            Element methodEl = (Element)methodList.item(j);
                            if (methodEl.getNodeName().equals("method-name")) {
                                String methodName = this.getElementText(methodEl);
                                if (methodName.equals("findByPrimaryKey")) {
                                    throw new EJBXMLParserException("ejb_2244", new Object[]{ejbName, this.ejbJarName});
                                }
                                result.setMethodName(methodName);
                            } else if (methodEl.getNodeName().equals("method-params")) {
                                NodeList paramsList = methodEl.getChildNodes();
                                int k = 0;
                                while (k < paramsList.getLength()) {
                                    Element paramEl;
                                    if (paramsList.item(k).getNodeType() == 1 && (paramEl = (Element)paramsList.item(k)).getNodeName().equals("method-param")) {
                                        params.add(this.getElementText(paramEl));
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                } else if (tag.equals("result-type-mapping")) {
                    String resultTypeMap = this.getElementText(el);
                    if (resultTypeMap.equals("Local")) {
                        result.setLocal();
                    } else {
                        if (!resultTypeMap.equals("Remote")) throw new EJBXMLParserException("ejb_2212", new Object[]{resultTypeMap, "Local", "Remote"});
                        result.setRemote();
                    }
                } else if (tag.equals("ejb-ql")) {
                    result.setQuery(this.getElementText(el));
                }
            }
            ++i;
        }
        result.setParamsTypes(params.toArray(new String[params.size()]));
        return result;
    }

    private Class getFieldClass(boolean cmp11, PersistentField cmpField, String ejbName, Class clazz) throws DeploymentException {
        String fieldName = cmpField.getFieldName();
        if (cmp11) {
            try {
                cmpField.setFieldClass(clazz.getField(fieldName).getType());
                return cmpField.getFieldClass();
            }
            catch (NoSuchFieldException nsfe) {
                String getMethodName = "ejb_get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    cmpField.setFieldClass(clazz.getMethod(getMethodName, new Class[0]).getReturnType());
                    return cmpField.getFieldClass();
                }
                catch (NoSuchMethodException nsme) {
                    throw new EJBXMLParserException("ejb_2241", new Object[]{ejbName, fieldName}, nsme);
                }
            }
        }
        String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            cmpField.setFieldClass(clazz.getMethod(getMethodName, new Class[0]).getReturnType());
            return cmpField.getFieldClass();
        }
        catch (NoSuchMethodException nsme) {
            throw new EJBXMLParserException("ejb_2241", new Object[]{ejbName, fieldName}, nsme);
        }
    }

    private DependentValueDescriptor mappedToSetOfColumns(PersistentField cmpField) throws DeploymentException {
        Class depValueClass = cmpField.getFieldClass();
        Field[] fields = depValueClass.getFields();
        if (fields.length == 0) {
            return null;
        }
        try {
            depValueClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            LOCATION.traceThrowableT(100, null, (Throwable)e);
            return null;
        }
        String[] subFieldNames = new String[fields.length];
        Class[] subFieldClasses = new Class[fields.length];
        String[] subFieldTypes = new String[fields.length];
        int p = 0;
        while (p < fields.length) {
            subFieldClasses[p] = fields[p].getType();
            if (Mappings.getDefaultSqlTypeForJavaType(subFieldClasses[p]) == 2004) {
                return null;
            }
            subFieldNames[p] = fields[p].getName();
            subFieldTypes[p] = subFieldClasses[p].getName();
            ++p;
        }
        DependentValueDescriptor depValueDscr = new DependentValueDescriptor();
        depValueDscr.setDescription(cmpField.getDescription());
        depValueDscr.setFieldName(cmpField.getFieldName());
        depValueDscr.setFieldClass(depValueClass);
        depValueDscr.setValueFieldNames(subFieldNames);
        depValueDscr.setValueFieldTypes(subFieldTypes);
        depValueDscr.setValueFieldClasses(subFieldClasses);
        return depValueDscr;
    }

    private void setCompoundPKCmpFields(CMPEntityDescriptor descriptor) throws DeploymentException {
        Class<?> pkClass = null;
        try {
            pkClass = this.loader.loadClass(descriptor.getPrimaryKeyClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new EJBXMLParserException("ejb_2230", new Object[]{descriptor.getEjbName(), descriptor.getPrimaryKeyClass()}, cnfe);
        }
        Vector<PersistentField> vPKCmpFields = new Vector<PersistentField>();
        Vector<PersistentField> vNotPKCmpFields = new Vector<PersistentField>();
        Field[] pkClassFiled = pkClass.getFields();
        PersistentField[] xmlCmpFields = descriptor.getCmpFields();
        int i = 0;
        while (i < xmlCmpFields.length) {
            PersistentField xmlCmpField = xmlCmpFields[i];
            boolean isPKField = false;
            int j = 0;
            while (j < pkClassFiled.length) {
                String pkClassFieldName = pkClassFiled[j].getName();
                if (pkClassFieldName.equals(xmlCmpField.getFieldName())) {
                    xmlCmpField.setCompoundPK();
                    vPKCmpFields.addElement(xmlCmpField);
                    isPKField = true;
                    break;
                }
                ++j;
            }
            if (!isPKField) {
                vNotPKCmpFields.addElement(xmlCmpField);
            }
            ++i;
        }
        if (pkClassFiled.length != vPKCmpFields.size()) {
            throw new EJBXMLParserException("ejb_2231", new Object[]{descriptor.getEjbName(), pkClass.getName()});
        }
        descriptor.setPKCmpFields(vPKCmpFields.toArray(new PersistentField[vPKCmpFields.size()]));
        descriptor.setCmpFields(vNotPKCmpFields.toArray(new PersistentField[vNotPKCmpFields.size()]));
    }

    private void createUnknownPKCmpField(CMPEntityDescriptor descriptor) throws DeploymentException {
        PersistentField[] notPKCmpFields = descriptor.getCmpFields();
        if (notPKCmpFields != null) {
            int k = 0;
            while (k < notPKCmpFields.length) {
                if (notPKCmpFields[k].getFieldName().equals("ejb_pk")) {
                    throw new EJBXMLParserException("ejb_2243", new String[]{"ejb_pk"});
                }
                ++k;
            }
        }
        PersistentField[] cmpFld = new PersistentField[]{new PersistentField()};
        cmpFld[0].setDescription("Deployer generates default PK if it is unknow; spec 10.8.3");
        cmpFld[0].setFieldName("ejb_pk");
        this.setUnknownPKType(cmpFld[0], descriptor.getEjbName());
        descriptor.setPKCmpFields(cmpFld);
    }

    private void setUnknownPKType(PersistentField cmp, String ejbName) throws DeploymentException {
        try {
            cmp.setFieldClass(Class.forName("java.lang.Long"));
        }
        catch (ClassNotFoundException cnfe) {
            throw new EJBXMLParserException("ejb_2232", new Object[]{ejbName, "java.lang.Long"}, cnfe);
        }
        cmp.setFieldType("java.lang.Long");
        cmp.setPK();
    }

    private void setSimplePKCmpField(CMPEntityDescriptor descriptor) throws DeploymentException {
        PersistentField[] xmlCmpFields = descriptor.getCmpFields();
        String pkFieldName = descriptor.getPKFieldName();
        int l = 0;
        while (l < xmlCmpFields.length) {
            if (xmlCmpFields[l].getFieldName().equals(pkFieldName)) {
                xmlCmpFields[l].setPK();
                descriptor.setPKCmpFields(new PersistentField[]{xmlCmpFields[l]});
                PersistentField[] newCmpfields = new PersistentField[xmlCmpFields.length - 1];
                System.arraycopy(xmlCmpFields, 0, newCmpfields, 0, l);
                System.arraycopy(xmlCmpFields, l + 1, newCmpfields, l, newCmpfields.length - l);
                descriptor.setCmpFields(newCmpfields);
                break;
            }
            ++l;
        }
        if (descriptor.getPKCmpFields() == null) {
            throw new EJBXMLParserException("ejb_2233", new Object[]{descriptor.getEjbName()});
        }
    }

    private void parseCMPFields(CMPEntityDescriptor descriptor, Class beanClazz) throws DeploymentException {
        boolean noPKCmpSpecifiedAndUnknownPK = false;
        if (descriptor.getPKFieldName() == null) {
            if (descriptor.isUnknownPK()) {
                this.createUnknownPKCmpField(descriptor);
                noPKCmpSpecifiedAndUnknownPK = true;
            } else {
                this.setCompoundPKCmpFields(descriptor);
            }
        } else {
            if (descriptor.isUnknownPK()) {
                throw new EJBXMLParserException("ejb_2245", new String[]{descriptor.getPKFieldName(), descriptor.getEjbName()});
            }
            this.setSimplePKCmpField(descriptor);
        }
        boolean arePkFields = true;
        PersistentField[] cmpFields = descriptor.getCmpFields();
        if (cmpFields != null) {
            this.fillCmpFieldInfo(cmpFields, descriptor, beanClazz, !arePkFields);
        }
        PersistentField[] pkCmpFields = descriptor.getPKCmpFields();
        if (!noPKCmpSpecifiedAndUnknownPK) {
            this.fillCmpFieldInfo(pkCmpFields, descriptor, beanClazz, arePkFields);
        }
    }

    private void parseSelectMethod(FinderDescriptor fDescr, String methodName, Class[] paramsClass, Class beanClass, String ejbName) throws DeploymentException {
        Method reflMethod = null;
        try {
            reflMethod = beanClass.getMethod(methodName, paramsClass);
        }
        catch (NoSuchMethodException nsme) {
            throw new EJBXMLParserException("ejb_2237", new Object[]{methodName, ejbName}, nsme);
        }
        fDescr.setSelect();
        fDescr.setReturnType(reflMethod.getReturnType().getName());
        this.setExceptionsInFinderDescr(fDescr, reflMethod);
    }

    private void parseFindMethod(FinderDescriptor fDescr, String methodName, Class[] paramsClass, Class remoteHomeClass, Class localHomeClass) throws DeploymentException {
        Method findMethod;
        block6: {
            findMethod = null;
            if (remoteHomeClass != null) {
                try {
                    findMethod = remoteHomeClass.getMethod(methodName, paramsClass);
                }
                catch (NoSuchMethodException nsme1) {
                    if (localHomeClass != null) break block6;
                    throw new EJBXMLParserException("ejb_2238", new Object[]{methodName, remoteHomeClass.getName(), "<no local home interface>"}, nsme1);
                }
            }
        }
        if (findMethod == null && localHomeClass != null) {
            try {
                findMethod = localHomeClass.getMethod(methodName, paramsClass);
            }
            catch (NoSuchMethodException nsme) {
                String remoteHomeName = remoteHomeClass == null ? "<no remote home interface>" : remoteHomeClass.getName();
                throw new EJBXMLParserException("ejb_2238", new Object[]{methodName, remoteHomeName, localHomeClass.getName()}, nsme);
            }
        }
        fDescr.setFinder();
        fDescr.setReturnType(findMethod.getReturnType().getName());
        this.setExceptionsInFinderDescr(fDescr, findMethod);
    }

    private void setExceptionsInFinderDescr(FinderDescriptor fDescr, Method reflIntfMethod) {
        Class<?>[] exceptionsClass = reflIntfMethod.getExceptionTypes();
        String[] exceptions = new String[exceptionsClass.length];
        int n = 0;
        while (n < exceptionsClass.length) {
            exceptions[n] = exceptionsClass[n].getName();
            ++n;
        }
        fDescr.setExceptions(exceptions);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

