/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.message;

import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.util.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MessageBeanCheck {
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public static void check(MessageDrivenDescriptor messDescr, Vector results, ClassLoader loader) {
        String ejbName = messDescr.getEjbName();
        Class<?> messageClass = null;
        try {
            messageClass = loader.loadClass(messDescr.getClassName());
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ". Can not load ejb-class " + messDescr.getClassName() + ".");
        }
        if (messageClass == null) {
            return;
        }
        String messageListenerName = "javax.jms.MessageListener";
        boolean connectorBased = false;
        if (messDescr.getMessagingType() != null && !messDescr.getMessagingType().equals("")) {
            connectorBased = true;
            messageListenerName = messDescr.getMessagingType();
        }
        Class<?> messageDrivenBeanClass = null;
        Class<?> messageListenerClass = null;
        Class<?> jmsMessageClass = null;
        try {
            messageDrivenBeanClass = loader.loadClass("javax.ejb.MessageDrivenBean");
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ". Class javax.ejb.MessageDrivenBean not found.");
            return;
        }
        try {
            messageListenerClass = loader.loadClass(messageListenerName);
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ". Class " + messageListenerName + " not found.");
            return;
        }
        if (!connectorBased) {
            try {
                jmsMessageClass = loader.loadClass("javax.jms.Message");
            }
            catch (ClassNotFoundException cnfe) {
                results.add("Bean " + ejbName + ". Class javax.jms.Message not found.");
                return;
            }
        }
        if (!Modifier.isPublic(messageClass.getModifiers())) {
            results.add("Bean " + ejbName + ". The message-driven bean class must be declared as public. EJB specification 15.7.2.");
        }
        if (Modifier.isFinal(messageClass.getModifiers())) {
            results.add("Bean " + ejbName + ". The message-driven bean class must not be declared as final. EJB specification 15.7.2.");
        }
        if (Modifier.isAbstract(messageClass.getModifiers())) {
            results.add("Bean " + ejbName + ". The message-driven bean class must not be declared as abstract. EJB specification 15.7.2.");
        }
        Constructor<?> constructor = null;
        try {
            constructor = messageClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean " + ejbName + ". Constructor with no arguments is not defined. EJB specification 15.7.2.");
        }
        catch (SecurityException se) {
            results.add("Bean " + ejbName + ". Can not access the constructor with no arguments. Reason: " + se.toString());
        }
        if (constructor != null && !Modifier.isPublic(constructor.getModifiers())) {
            results.add("Bean " + ejbName + ". The constructor must be declared as public. EJB specification 15.7.2.");
        }
        if (!messageDrivenBeanClass.isAssignableFrom(messageClass)) {
            results.add("Bean " + ejbName + ". The ejb-class must implement, directly or indirectly, the javax.ejb.MessageDrivenBean interface. EJB specification 15.7.2.");
        }
        if (!messageListenerClass.isAssignableFrom(messageClass)) {
            results.add("Bean " + ejbName + ". The ejb-class must implement, directly or indirectly, the " + messageListenerName + " interface.");
        }
        try {
            Method ejbCreateMethod = messageClass.getMethod("ejbCreate", new Class[0]);
            MessageBeanCheck.checkMethod(results, ejbCreateMethod, ejbName, "ejbCreate");
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean " + ejbName + ". ejbCreate() method is not defined. EJB specification 15.7.3.");
        }
        catch (SecurityException se) {
            results.add("Bean " + ejbName + ". Can not access ejbCreate() method. Reason: " + se.toString());
        }
        try {
            Method ejbRemoveMethod = messageClass.getMethod("ejbRemove", new Class[0]);
            MessageBeanCheck.checkMethod(results, ejbRemoveMethod, ejbName, "ejbRemove");
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean " + ejbName + ". ejbRemove() method is not defined. EJB specification 15.7.5.");
        }
        catch (SecurityException se) {
            results.add("Bean " + ejbName + ". Can not access ejbRemove() method. Reason: " + se.toString());
        }
        if (!connectorBased) {
            try {
                Method onMessageMethod = messageClass.getMethod("onMessage", jmsMessageClass);
                MessageBeanCheck.checkMethod(results, onMessageMethod, ejbName, "onMessage");
            }
            catch (NoSuchMethodException nsme) {
                results.add("Bean " + ejbName + ". onMessage(Message m) method is not defined. EJB specification 15.7.4.");
            }
            catch (SecurityException se) {
                results.add("Bean " + ejbName + ". Can not access onMessage method. Reason " + se.toString());
            }
        }
        if (ClassUtils.hasDeclaredMethod(messageClass, (String)"finalize", (Class[])new Class[0])) {
            results.add("Bean " + ejbName + ". finalize() method must not be declared. EJB specification 15.7.2.");
        }
    }

    public static void checkMethod(Vector results, Method method, String ejbName, String methodName) {
        if (!Modifier.isPublic(method.getModifiers())) {
            results.add("Message Driven Bean " + ejbName + ": " + methodName + " method must be declared as public. EJB specification 15.7.4.");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            results.add("Message Driven Bean " + ejbName + ": " + methodName + " method must not be declared as static. EJB specification 15.7.4.");
        }
        if (Modifier.isFinal(method.getModifiers())) {
            results.add("Message Driven Bean " + ejbName + ": " + methodName + " method must not be declared as final. EJB specification 15.7.4.");
        }
        if (!method.getReturnType().getName().equals("void")) {
            results.add("Message Driven Bean " + ejbName + ". Return type of " + methodName + " method must be void. EJB specification 15.7.4.");
        }
        if (MessageBeanCheck.hasApplicationException(method.getExceptionTypes())) {
            results.add("Message Driven Bean " + ejbName + ". Throws clause of " + methodName + " method must not define any application exceptions. EJB specification 15.7.4.");
        }
    }

    public static boolean hasApplicationException(Class[] exceptions) {
        int i = 0;
        while (i < exceptions.length) {
            if (!(class$java$lang$RuntimeException == null ? MessageBeanCheck.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(exceptions[i]) && !(class$java$rmi$RemoteException == null ? MessageBeanCheck.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exceptions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

