/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MultiplePKCheck {
    public static void check(CMPEntityDescriptor entDescr, Class pkClass, Vector results) {
        if (pkClass == null) {
            return;
        }
        String ejbName = entDescr.getEjbName();
        if (!Modifier.isPublic(pkClass.getModifiers())) {
            results.add("Bean " + ejbName + ": the primary key class must be public //see 10.8.2.");
        }
        try {
            if (!Modifier.isPublic(pkClass.getConstructor(new Class[0]).getModifiers())) {
                results.add("Bean " + ejbName + ": the primary key class must have a public constructor with no parameters //see 10.8.2.");
            }
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean " + ejbName + ": the primary key class must have a public constructor with no parameters //see 10.8.2.");
        }
        catch (SecurityException secEx) {
            results.add("Bean " + ejbName + ": can not access constructor(s) of pk-class " + pkClass.getName() + ". Reason: " + secEx.toString());
        }
        PersistentField[] cmpFields = entDescr.getPKCmpFields();
        MultiplePKCheck.checkAllPKClassFields(pkClass, cmpFields, ejbName, results);
    }

    private static void checkAllPKClassFields(Class pkClass, PersistentField[] cmpFields, String ejbName, Vector results) {
        Field[] pkFields = pkClass.getDeclaredFields();
        int i = 0;
        while (i < pkFields.length) {
            Field pkField = pkFields[i];
            String pkFieldName = pkField.getName();
            if (!Modifier.isPublic(pkField.getModifiers())) {
                results.add("Bean " + ejbName + ": field " + pkFieldName + " defined in " + pkClass.getName() + " is not public. All fields in the primary key class must be declared as public //see 10.8.2.");
            }
            boolean fnd = false;
            int m = 0;
            while (m < cmpFields.length) {
                if (cmpFields[m].getFieldName().equals(pkFieldName)) {
                    fnd = true;
                    break;
                }
                ++m;
            }
            if (!fnd) {
                results.add("Bean " + ejbName + ": field " + pkFieldName + " which is defined in pk-class " + pkClass.getName() + " is not cmp-field //see 10.8.2");
            }
            ++i;
        }
        Class superClass = pkClass.getSuperclass();
        if (superClass != null) {
            MultiplePKCheck.checkAllPKClassFields(superClass, cmpFields, ejbName, results);
        }
    }
}

