/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.RmiIiopUtils;
import java.lang.reflect.Method;
import java.util.Vector;

public class EntityPKCheck {
    public static void check(EntityDescriptor entDescr, Class pkclass, Vector results) {
        if (pkclass == null) {
            return;
        }
        Method[] pkclassMethods = pkclass.getMethods();
        boolean hashCode = false;
        boolean equals = false;
        if (!RmiIiopUtils.isValidRmiIIOPValueType(pkclass)) {
            results.add("Bean " + entDescr.getEjbName() + ": The primary key class " + pkclass.getName() + " is not a legal Value Type in RMI-IIOP.");
        }
        int i = 0;
        while (i < pkclassMethods.length) {
            Class<?>[] args2;
            Class<?>[] args1;
            Method method = pkclassMethods[i];
            Class<?> declaringClass = method.getDeclaringClass();
            if (method.getName().equals("hashCode") && !declaringClass.getName().equals("java.lang.Object") && (args1 = pkclassMethods[i].getParameterTypes()).length == 0) {
                hashCode = true;
                if (declaringClass != pkclass) {
                    results.add("Warning in bean " + entDescr.getEjbName() + ": The primary class " + pkclass.getName() + " does not override method hashCode().");
                }
            }
            if (method.getName().equals("equals") && !declaringClass.getName().equals("java.lang.Object") && (args2 = pkclassMethods[i].getParameterTypes()).length == 1 && args2[0].getName().equals("java.lang.Object")) {
                equals = true;
                if (declaringClass != pkclass) {
                    results.add("Warning in bean " + entDescr.getEjbName() + ": The primary class " + pkclass.getName() + " does not override method equals(java.lang.Object).");
                }
            }
            ++i;
        }
        if (!equals) {
            results.add("Bean " + entDescr.getEjbName() + ": The primary key class " + pkclass.getName() + " does not define method equals(java.lang.Object). The primary key class must provide suitable implementation of the equals(Object) method. EJB Specification 10.6.13.");
        }
        if (!hashCode) {
            results.add("Bean " + entDescr.getEjbName() + ": The primary key class " + pkclass.getName() + " does not define method hashCode(). The primary key class must provide suitable implementation of the hashCode() method. EJB Specification 10.6.13.");
        }
    }
}

