/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.util.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class CMRFieldChecker {
    protected static void check(RelationField cmrField, int i, ClassLoader loader, Vector results, String ejbName, Class entityClass, Class remoteClass) {
        String cmrFieldName = cmrField.getFieldName();
        String cmrFieldTypeName = cmrField.getFieldType();
        Class<?> cmrFieldType = null;
        try {
            cmrFieldType = loader.loadClass(cmrFieldTypeName);
        }
        catch (ClassNotFoundException cl) {
            results.add("Bean <" + ejbName + ">: type <" + cmrFieldTypeName + "> for cmr-field <" + cmrFieldName + "> is not found.");
        }
        if (Character.isUpperCase(cmrFieldName.charAt(0))) {
            results.add("Bean <" + ejbName + ">: cmr-field <" + cmrFieldName + "> starts with upper case.");
        }
        if (ClassUtils.hasField((Class)entityClass, (String)cmrFieldName)) {
            results.add("Bean <" + ejbName + ">: <" + cmrFieldName + "> field is defined in ejb-class, but it is also declared as a cmr-field.");
        }
        String getMethodName = "get" + Character.toUpperCase(cmrFieldName.charAt(0)) + cmrFieldName.substring(1);
        String setMethodName = "set" + Character.toUpperCase(cmrFieldName.charAt(0)) + cmrFieldName.substring(1);
        if (remoteClass != null) {
            if (ClassUtils.hasMethod((Class)remoteClass, (String)getMethodName, (Class[])new Class[0])) {
                results.add("Bean <" + ejbName + ">: " + getMethodName + "> for cmr-field <" + cmrFieldName + "> is defined in the remote interface. Accessor methods for cmr-fields should not be exposed in the remote interface of the bean //see 10.3.1.");
            }
            if (cmrFieldType != null && ClassUtils.hasMethod((Class)remoteClass, (String)setMethodName, (Class[])new Class[]{cmrFieldType})) {
                results.add("Bean <" + ejbName + ">: <" + setMethodName + "> for cmr-field <" + cmrFieldName + "> is defined in the remote interface. Accessor methods for cmr-fields should not be exposed in the remote interface of the bean //see 10.3.1.");
            }
        }
        Method getMethod = null;
        try {
            getMethod = entityClass.getMethod(getMethodName, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean <" + ejbName + ">: get method " + getMethodName + "() for cmr-field <" + cmrFieldName + "> is not declared in ejb-class.");
        }
        if (getMethod != null) {
            if (!Modifier.isAbstract(getMethod.getModifiers())) {
                results.add("Bean <" + ejbName + ">: method " + getMethodName + "() is not abstract.");
            }
            if (!Modifier.isPublic(getMethod.getModifiers()) && !Modifier.isProtected(getMethod.getModifiers())) {
                results.add("Bean <" + ejbName + ">: method " + getMethodName + "() is not public or protected.");
            }
            if (!getMethod.getReturnType().getName().equals(cmrFieldTypeName)) {
                results.add("Bean <" + ejbName + ">: the return type of method " + getMethodName + "() must be " + cmrFieldTypeName + ", but it is " + getMethod.getReturnType().getName() + ".");
            }
        }
        if (cmrFieldType != null) {
            Method setMethod = null;
            try {
                setMethod = entityClass.getMethod(setMethodName, cmrFieldType);
            }
            catch (NoSuchMethodException nsme) {
                results.add("Bean <" + ejbName + ">: set method " + setMethodName + "(" + cmrFieldType + ") for cmr-field <" + cmrFieldName + "> is not declared in ejb-class.");
            }
            if (setMethod != null) {
                if (!Modifier.isAbstract(setMethod.getModifiers())) {
                    results.add("Bean <" + ejbName + ">: method " + setMethodName + "(" + cmrFieldType + ") is not abstract.");
                }
                if (!Modifier.isPublic(setMethod.getModifiers()) && !Modifier.isProtected(setMethod.getModifiers())) {
                    results.add("Bean <" + ejbName + ">: method " + setMethodName + "(" + cmrFieldType + ") is not public or protected.");
                }
                if (!setMethod.getReturnType().getName().equals("void")) {
                    results.add("Bean <" + ejbName + ">: the return type of method " + setMethodName + "(" + cmrFieldType + ") must be void, but it is " + setMethod.getReturnType().getName() + ".");
                }
            }
        }
    }
}

