/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.verifier.RmiIiopUtils;
import com.sap.engine.services.ejb.util.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class CMPFieldChecker {
    protected static void check(PersistentField cmpField, int i, Vector results, String ejbName, Class entityClass, ClassLoader loader) {
        String cmpFieldName = cmpField.getFieldName();
        String cmpFieldTypeName = cmpField.getFieldType();
        Class<?> cmpFieldType = null;
        if (Character.isUpperCase(cmpFieldName.charAt(0))) {
            results.add("Bean <" + ejbName + ">: cmp-field <" + cmpFieldName + "> starts with upper case, it is not allowed.");
        }
        if (ClassUtils.hasField((Class)entityClass, (String)cmpFieldName)) {
            results.add("Bean <" + ejbName + ">: <" + cmpFieldName + "> field is defined in ejb-class, but it is also declared as a cmp-field.");
        }
        if (CMPFieldChecker.isPrimitiveType(cmpFieldTypeName)) {
            cmpFieldType = CMPFieldChecker.getClassForSimpleType(cmpFieldTypeName);
        } else {
            try {
                cmpFieldType = loader.loadClass(cmpFieldTypeName);
            }
            catch (ClassNotFoundException cl) {
                results.add("Bean <" + ejbName + ">: type <" + cmpFieldTypeName + "> for cmp-field <" + cmpFieldName + "> is not found.");
            }
        }
        String getMethodName = "get" + Character.toUpperCase(cmpFieldName.charAt(0)) + cmpFieldName.substring(1);
        String setMethodName = "set" + Character.toUpperCase(cmpFieldName.charAt(0)) + cmpFieldName.substring(1);
        Method getMethod = null;
        Method setMethod = null;
        try {
            getMethod = entityClass.getMethod(getMethodName, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean <" + ejbName + ">: get method for cmp-field <" + cmpFieldName + "> is not declared in ejb-class.");
        }
        if (getMethod != null) {
            Class<?> getMethodType = getMethod.getReturnType();
            if (!cmpFieldTypeName.equals(getMethodType.getName())) {
                results.add("Bean <" + ejbName + ">: the return type of <" + getMethodName + "> differs from the return type of the corresponding cmp-field.");
            }
            if (!Modifier.isAbstract(getMethod.getModifiers())) {
                results.add("Bean <" + ejbName + ">: method <" + getMethodName + "> is not abstract.");
            }
            if (!Modifier.isPublic(getMethod.getModifiers()) && !Modifier.isProtected(getMethod.getModifiers())) {
                results.add("Bean <" + ejbName + ">: method <" + getMethodName + "> is not public or protected.");
            }
            if (!RmiIiopUtils.isPersistentFieldTypeValid(getMethodType)) {
                results.add("Bean " + ejbName + ": return type of method " + getMethodName + " is not valid persistent field type.");
            }
        }
        try {
            if (cmpFieldType != null) {
                setMethod = entityClass.getMethod(setMethodName, cmpFieldType);
            }
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean <" + ejbName + ">: set method for cmp-field <" + cmpFieldName + "> is not declared in ejb-class.");
        }
        if (setMethod != null) {
            if (!Modifier.isAbstract(setMethod.getModifiers())) {
                results.add("Bean <" + ejbName + ">: method <" + setMethodName + "> is not abstract.");
            }
            if (!Modifier.isPublic(setMethod.getModifiers()) && !Modifier.isProtected(setMethod.getModifiers())) {
                results.add("Bean <" + ejbName + ">: method <" + setMethodName + "> is not public or protected.");
            }
            if (!setMethod.getReturnType().getName().equals("void")) {
                results.add("Bean <" + ejbName + ">: return type of method <" + getMethodName + "> must be void, but found <" + getMethod.getReturnType().getName() + ">.");
            }
        }
    }

    private static boolean isPrimitiveType(String fieldType) {
        return fieldType == null || fieldType.equals("int") || fieldType.equals("byte") || fieldType.equals("char") || fieldType.equals("short") || fieldType.equals("long") || fieldType.equals("double") || fieldType.equals("float") || fieldType.equals("boolean");
    }

    private static Class getClassForSimpleType(String type) {
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("double")) {
            return Double.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        return null;
    }
}

