/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier;

import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class BusinessMethodCheck {
    public static void check(String beanName, Method method, boolean remote, boolean beanMethod, Vector errors) {
        String warningInBean = "Warning in bean " + beanName + ": ";
        String errorInBean = "Error in bean " + beanName + ": ";
        Class[] exceptions = method.getExceptionTypes();
        boolean throwsRemoteExceptionOrSuperclass = CheckUtils.isValidRemoteException(exceptions);
        boolean throwsRemoteExceptionOrSubclass = CheckUtils.isRemoteExceptionOrSubclass(exceptions);
        int modifiers = method.getModifiers();
        if (beanMethod) {
            if (throwsRemoteExceptionOrSubclass) {
                errors.add(warningInBean + "Compatibility Note: Business method " + method.getName() + " throws java.rmi.RemoteException. EJB 1.0 allowed the business methods to throw the java.rmi.RemoteException to indicate a non-application exception. This practice was deprecated in EJB 1.1 - an EJB 1.1 or EJB 2.0 compliant enterprise bean should throw the javax.ejb.EJBException or another RuntimeException to indicate non-application exceptions to the Container.");
            }
            if (!Modifier.isPublic(modifiers)) {
                errors.add(errorInBean + "The business method " + method.getName() + " is not declared as public. Business methods must be declared as public. EJB Specification 7.10.4 and 10.6.8.");
            }
            if (Modifier.isStatic(modifiers)) {
                errors.add(errorInBean + "The business method " + method.getName() + " is declared as static. Business methods cannot be declared as static. EJB Specification 7.10.4 and 10.6.8.");
            }
            if (Modifier.isFinal(modifiers)) {
                errors.add(errorInBean + "The business method " + method.getName() + " is declared as final. Business methods cannot be declared as final. EJB Specification 7.10.4 and 10.6.8.");
            }
        }
        if (remote && !beanMethod && !throwsRemoteExceptionOrSuperclass) {
            errors.add(errorInBean + "The business method " + method.getName() + " does not throw java.rmi.RemoteException. Business methods of the remote interface must throw java.rmi.RemoteException.");
        }
        if (!remote && throwsRemoteExceptionOrSubclass) {
            errors.add(errorInBean + "The business method " + method.getName() + " in the local interface throws java.rmi.RemoteException or a subclass of it. The throws clause of any method in the local interface must not include the java.rmi.RemoteException.");
        }
    }
}

