/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.tools.sql.dbtypes.vendors;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.deploy.tools.sql.dbtypes.DBVendorMappings;
import java.util.Properties;

public class Oracle8iMappings
extends DBVendorMappings {
    private String VARCHAR_N = "256";
    private String VARBINARY_N = "256";
    private String DECIMAL_P = "10";
    private String DECIMAL_S = "2";

    public Oracle8iMappings(Properties props) {
        this.parseProps(props);
        this.types = new HashMapIntObject();
        this.types.put(12, "VARCHAR2(" + this.VARCHAR_N + ")");
        this.types.put(-3, "RAW(" + this.VARBINARY_N + ")");
        this.types.put(5, "NUMBER(5)");
        this.types.put(4, "NUMBER(10)");
        this.types.put(-5, "NUMBER(19)");
        if (this.DECIMAL_S.equals("0")) {
            this.types.put(3, "NUMERIC(" + this.DECIMAL_P + ")");
        } else {
            this.types.put(3, "NUMERIC(" + this.DECIMAL_P + "," + this.DECIMAL_S + ")");
        }
        this.types.put(8, "FLOAT");
        this.types.put(91, "DATE");
        this.types.put(92, "DATE");
        this.types.put(93, "DATE");
        this.types.put(2005, "NCLOB");
        this.types.put(2004, "BLOB");
        this.types.put(7, "REAL");
        this.types.put(-7, "NUMBER(5)");
    }

    public int getMaxTableNameLength() {
        return 30;
    }

    private void parseProps(Properties props) {
        if (props == null) {
            return;
        }
        String value = props.getProperty("VARCHAR_N");
        if (value != null) {
            try {
                int intValue = Integer.parseInt(value);
                this.VARCHAR_N = String.valueOf(3 * intValue);
            }
            catch (NumberFormatException nfe) {
                EJBResourceAccessor.location.pathT("Exception in Oracle8iMappings.parseProps() : " + nfe.toString());
            }
        }
        if ((value = props.getProperty("VARBINARY_N")) != null) {
            this.VARBINARY_N = value;
        }
        if ((value = props.getProperty("NUMERIC_P")) != null) {
            this.DECIMAL_P = value;
        }
        if ((value = props.getProperty("NUMERIC_S")) != null) {
            this.DECIMAL_S = value;
        }
    }
}

