/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.tools.sql;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.deploy.tools.sql.MultipleSetInfo;
import com.sap.engine.services.ejb.deploy.tools.sql.PreparedStatementInfo;
import com.sap.engine.services.ejb.deploy.tools.sql.RelationDescriptorWrapper;
import com.sap.engine.services.ejb.deploy.tools.sql.SetInfo;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGeneratorsHolder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class StatementGenerator {
    public static final String FOR_UPDATE = " for update ";
    private static final String QUOTE = "\\\"";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String WHERE = " where ";
    private static final String AND = " and ";
    private static final String COMMA = ", ";
    private static final String DOT = ".";
    private static final String EQUALS_PARAM_VALUE = " = ? ";
    private static final String NO_SETMETHOD_GENERATION = "NO_SETMETHOD_GENERATION";
    private static String lSeparator = System.getProperty("line.separator");
    private PersistentField[] pkCmpInfo = null;
    private PersistentField[] cmpInfo = null;
    private RelationDescriptor[] cmrInfo = null;
    private StringBuffer createTableSt = null;
    private AbstractSchema schema = null;
    private CMPEntityDescriptor dscr = null;
    private StatementGeneratorsHolder holder = null;
    private boolean isCompoundPK = false;
    private boolean isUnknownPK = false;

    StatementGenerator(CMPEntityDescriptor dscr, StatementGeneratorsHolder holder) {
        this.holder = holder;
        this.dscr = dscr;
        this.schema = holder.getAbstractSchema();
        this.pkCmpInfo = dscr.getPKCmpFields();
        this.cmpInfo = dscr.getCmpFields();
        this.cmrInfo = this.schema.getRelationDescriptors(dscr.getId());
        if (dscr.isUnknownPK()) {
            this.isUnknownPK = true;
        } else {
            this.isCompoundPK = this.pkCmpInfo[0].isCompoundPK();
        }
    }

    public CMPEntityDescriptor getDescriptor() {
        return this.dscr;
    }

    public AbstractSchema getAbstractSchema() {
        return this.schema;
    }

    public PersistentField[] getCmpInfo() {
        return this.cmpInfo;
    }

    public PersistentField[] getPKCmpInfo() {
        return this.pkCmpInfo;
    }

    public PreparedStatementInfo indirectSelectSt(RelationDescriptor relDscr) throws DeploymentException {
        OneSideRelationDescriptor refSide = relDscr.getFKSide();
        CMPEntityDescriptor refDscr = this.schema.getDescriptor(refSide.getEjbId());
        String[] refColumn = refSide.getFieldDBMap().getColumn();
        StringBuffer st = new StringBuffer(SELECT);
        this.selectAllColumns(refDscr, st);
        st.append(FROM);
        this.addQuotedName(refDscr.getTableName(), st);
        st.append(WHERE);
        SetInfo[] setInfo = new SetInfo[this.pkCmpInfo.length];
        int posInSt = 1;
        int i = 0;
        while (i < this.pkCmpInfo.length) {
            if (i > 0) {
                st.append(AND);
            }
            this.addFullColumnName(refDscr.getTableName(), refColumn[i], st);
            st.append(EQUALS_PARAM_VALUE);
            setInfo[i] = this.pkCmpInfo[i].getSetInfo(posInSt++);
            ++i;
        }
        PreparedStatementInfo result = new PreparedStatementInfo();
        if (refDscr.useSelectForUpdate()) {
            st.append(FOR_UPDATE);
        }
        result.setPreparedStatement(st.toString());
        result.setSetDescr(setInfo);
        return result;
    }

    public PreparedStatementInfo selectSt() throws DeploymentException {
        StringBuffer st = new StringBuffer(SELECT);
        this.selectAllColumns(this.dscr, st);
        st.append(FROM);
        this.addQuotedName(this.dscr.getTableName(), st);
        st.append(WHERE);
        SetInfo[] setInfo = new SetInfo[this.pkCmpInfo.length];
        int posInSt = 1;
        int i = 0;
        while (i < this.pkCmpInfo.length) {
            if (i > 0) {
                st.append(AND);
            }
            this.addQuotedName(this.pkCmpInfo[i].getFieldDBMap().getColumnName(), st);
            st.append(EQUALS_PARAM_VALUE);
            setInfo[i] = this.pkCmpInfo[i].getSetInfo(posInSt++);
            ++i;
        }
        if (this.dscr.useSelectForUpdate()) {
            st.append(FOR_UPDATE);
        }
        PreparedStatementInfo result = new PreparedStatementInfo();
        result.setPreparedStatement(st.toString());
        result.setSetDescr(setInfo);
        return result;
    }

    public PreparedStatementInfo selectStForFindByPK(boolean selectAllBeanFields) throws DeploymentException {
        StringBuffer st = new StringBuffer(SELECT);
        if (selectAllBeanFields) {
            this.selectAllColumns(this.dscr, st);
        } else {
            int i = 0;
            while (i < this.pkCmpInfo.length) {
                if (i > 0) {
                    st.append(COMMA);
                }
                this.addQuotedName(this.pkCmpInfo[i].getFieldDBMap().getColumnName(), st);
                ++i;
            }
        }
        st.append(FROM);
        this.addQuotedName(this.dscr.getTableName(), st);
        st.append(WHERE);
        SetInfo[] setInfo = new SetInfo[this.pkCmpInfo.length];
        int posInSt = 1;
        int i = 0;
        while (i < this.pkCmpInfo.length) {
            if (i > 0) {
                st.append(AND);
            }
            this.addQuotedName(this.pkCmpInfo[i].getFieldDBMap().getColumnName(), st);
            st.append(EQUALS_PARAM_VALUE);
            String fieldName = null;
            fieldName = this.isCompoundPK ? "param1." + this.pkCmpInfo[i].getFieldName() : (this.isUnknownPK ? "((java.lang.Long)param1)" : "param1");
            setInfo[i] = new SetInfo();
            setInfo[i].setFieldName(fieldName);
            setInfo[i].setSetObject(Mappings.getSetMethodForSelectStInFindMethod(this.pkCmpInfo[i].getFieldDBMap().getColumnType(), this.pkCmpInfo[i].getFieldClass(), posInSt++, "(" + fieldName + ")"));
            ++i;
        }
        if (selectAllBeanFields && this.dscr.useSelectForUpdate()) {
            st.append(FOR_UPDATE);
        }
        PreparedStatementInfo result = new PreparedStatementInfo();
        result.setPreparedStatement(st.toString());
        result.setSetDescr(setInfo);
        return result;
    }

    public PreparedStatementInfo insertSt() throws DeploymentException {
        Vector vSetInfo = new Vector();
        Vector vMultipleSetInfo = new Vector();
        Hashtable columnsInStatement = new Hashtable();
        this.addNonRepeatedCMRColumns(columnsInStatement);
        this.addNonRepeatedCMPColumns(this.cmpInfo, columnsInStatement);
        this.addNonRepeatedCMPColumns(this.pkCmpInfo, columnsInStatement);
        this.generateSetMethods(columnsInStatement, vMultipleSetInfo, vSetInfo);
        StringBuffer st = new StringBuffer();
        StringBuffer columnsToIns = new StringBuffer(" (");
        Enumeration addColumns = columnsInStatement.keys();
        boolean first = true;
        while (addColumns.hasMoreElements()) {
            String elementName = (String)addColumns.nextElement();
            String[] columnNames = this.getColumnNames(elementName, columnsInStatement);
            int i = 0;
            while (i < columnNames.length) {
                if (first) {
                    first = false;
                } else {
                    st.append(COMMA);
                    columnsToIns.append(COMMA);
                }
                st.append("?");
                this.addQuotedName(columnNames[i], columnsToIns);
                ++i;
            }
        }
        st.append(")");
        st.insert(0, ") values (");
        st.insert(0, columnsToIns.toString());
        st.insert(0, QUOTE);
        st.insert(0, this.dscr.getTableName().toUpperCase());
        st.insert(0, QUOTE);
        st.insert(0, "insert into ");
        PreparedStatementInfo result = new PreparedStatementInfo();
        result.setPreparedStatement(st.toString());
        result.setSetDescr(vSetInfo.toArray(new SetInfo[vSetInfo.size()]));
        result.setMultipleSetDescr(vMultipleSetInfo.toArray(new MultipleSetInfo[vMultipleSetInfo.size()]));
        return result;
    }

    private String[] getColumnNames(String elementName, Hashtable table) {
        Object objectInfo = table.get(elementName);
        if (objectInfo.equals(NO_SETMETHOD_GENERATION)) {
            return new String[0];
        }
        if (objectInfo instanceof RelationDescriptorWrapper) {
            return ((RelationDescriptorWrapper)objectInfo).getColumns();
        }
        return new String[]{elementName};
    }

    public String[] getDelFields() throws DeploymentException {
        Vector vFKField = new Vector();
        int i = 0;
        while (i < this.cmrInfo.length) {
            if (this.cmrInfo[i].getM2MMap() == null) {
                if (this.cmrInfo[i].recursiveRelation()) {
                    OneSideRelationDescriptor side1 = this.cmrInfo[i].getSide1();
                    this.selectDelFields(side1, vFKField);
                    OneSideRelationDescriptor side2 = this.cmrInfo[i].getSide2();
                    this.selectDelFields(side2, vFKField);
                } else {
                    OneSideRelationDescriptor side = this.cmrInfo[i].getMySideRelationDescriptor(this.dscr.getId());
                    this.selectDelFields(side, vFKField);
                }
            }
            ++i;
        }
        return vFKField.toArray(new String[vFKField.size()]);
    }

    private void selectDelFields(OneSideRelationDescriptor side, Vector vFKFields) {
        if (side.getFieldDBMap().getKey() == 1) {
            int cmrId = side.getCmrId();
            if (cmrId == -1) {
                vFKFields.addElement(side.getVirtualFieldName());
            } else {
                this.dscr = this.schema.getDescriptor(side.getEjbId());
                RelationField cmr = this.dscr.getRelationField(cmrId);
                vFKFields.addElement(cmr.getFieldName());
            }
            vFKFields.addElement(this.multiplicityToString(side.getMultiplicityType()));
        }
    }

    public String[] getInsertUpdateFields() throws DeploymentException {
        Vector vFKField = new Vector();
        int i = 0;
        while (i < this.cmrInfo.length) {
            if (this.cmrInfo[i].recursiveRelation()) {
                OneSideRelationDescriptor side1 = this.cmrInfo[i].getSide1();
                this.selectInsertUpdateFields(side1, vFKField);
                OneSideRelationDescriptor side2 = this.cmrInfo[i].getSide2();
                this.selectInsertUpdateFields(side2, vFKField);
            } else {
                OneSideRelationDescriptor mySide = this.cmrInfo[i].getMySideRelationDescriptor(this.dscr.getId());
                this.selectInsertUpdateFields(mySide, vFKField);
            }
            ++i;
        }
        return vFKField.toArray(new String[vFKField.size()]);
    }

    private void selectInsertUpdateFields(OneSideRelationDescriptor side, Vector vFKFields) {
        if (side.getFieldDBMap().getKey() == 2) {
            int cmrId = side.getCmrId();
            if (cmrId == -1) {
                vFKFields.addElement(side.getVirtualFieldName());
            } else {
                RelationField cmr = this.dscr.getRelationField(cmrId);
                vFKFields.addElement(cmr.getFieldName());
            }
            vFKFields.addElement(this.multiplicityToString(side.getMultiplicityType()));
        }
    }

    public PreparedStatementInfo updateSt() throws DeploymentException {
        Vector<SetInfo> vSetInfo = new Vector<SetInfo>();
        Vector vMultipleSetInfo = new Vector();
        Hashtable columnsInStatement = new Hashtable();
        this.addNonRepeatedCMRColumns(columnsInStatement);
        this.addNonRepeatedCMPColumns(this.cmpInfo, columnsInStatement);
        this.generateSetMethods(columnsInStatement, vMultipleSetInfo, vSetInfo);
        StringBuffer st = new StringBuffer("update ");
        this.addQuotedName(this.dscr.getTableName(), st);
        st.append(" set ");
        Enumeration addColumns = columnsInStatement.keys();
        boolean first = true;
        while (addColumns.hasMoreElements()) {
            String elementName = (String)addColumns.nextElement();
            String[] columnNames = this.getColumnNames(elementName, columnsInStatement);
            int i = 0;
            while (i < columnNames.length) {
                if (first) {
                    first = false;
                } else {
                    st.append(COMMA);
                }
                this.addQuotedName(columnNames[i], st);
                st.append(EQUALS_PARAM_VALUE);
                ++i;
            }
        }
        st.append(WHERE);
        int posInSt = columnsInStatement.size() + 1;
        int i = 0;
        while (i < this.pkCmpInfo.length) {
            if (i > 0) {
                st.append(AND);
            }
            this.addQuotedName(this.pkCmpInfo[i].getFieldDBMap().getColumnName(), st);
            st.append(EQUALS_PARAM_VALUE);
            SetInfo tempSet = this.pkCmpInfo[i].getSetInfo(posInSt++);
            vSetInfo.addElement(tempSet);
            ++i;
        }
        PreparedStatementInfo result = new PreparedStatementInfo();
        result.setPreparedStatement(st.toString());
        result.setSetDescr(vSetInfo.toArray(new SetInfo[vSetInfo.size()]));
        result.setMultipleSetDescr(vMultipleSetInfo.toArray(new MultipleSetInfo[vMultipleSetInfo.size()]));
        return result;
    }

    public PreparedStatementInfo deleteSt() throws DeploymentException {
        SetInfo[] setInfo = new SetInfo[this.pkCmpInfo.length];
        StringBuffer st = new StringBuffer("delete from ");
        this.addQuotedName(this.dscr.getTableName(), st);
        st.append(WHERE);
        int posInSt = 1;
        int i = 0;
        while (i < this.pkCmpInfo.length) {
            if (i > 0) {
                st.append(AND);
            }
            this.addQuotedName(this.pkCmpInfo[i].getFieldDBMap().getColumnName(), st);
            st.append(EQUALS_PARAM_VALUE);
            setInfo[i] = this.pkCmpInfo[i].getSetInfo(posInSt++);
            ++i;
        }
        PreparedStatementInfo result = new PreparedStatementInfo();
        result.setPreparedStatement(st.toString());
        result.setSetDescr(setInfo);
        return result;
    }

    public String getDropTableSt() {
        return "drop table \"" + this.dscr.getTableName().toUpperCase() + "\"";
    }

    public void createTableSt() throws DeploymentException {
        this.createTableSt = new StringBuffer("create table \"");
        this.createTableSt.append(this.dscr.getTableName().toUpperCase());
        this.createTableSt.append("\" (");
        StringBuffer pkFields = new StringBuffer();
        int i = 0;
        while (i < this.pkCmpInfo.length) {
            RPersistentFieldMap dbMap = this.pkCmpInfo[i].getFieldDBMap();
            if (this.pkCmpInfo[i].isDependentValue()) {
                String[] columns = ((RDependentValueMap)dbMap).getDvColumnName();
                int[] columnTypes = ((RDependentValueMap)dbMap).getDvColumnType();
                int j = 0;
                while (j < columns.length) {
                    if (pkFields.length() > 0) {
                        this.createTableSt.append(COMMA);
                        pkFields.append(COMMA);
                    }
                    this.createTableSt.append(lSeparator);
                    this.createTableSt.append("  \"");
                    this.createTableSt.append(columns[j].toUpperCase());
                    this.createTableSt.append("\" ");
                    this.createTableSt.append(this.holder.getDBVendorMappings().getDatabaseType(columnTypes[j]));
                    this.createTableSt.append(" not null");
                    pkFields.append("\"");
                    pkFields.append(columns[j].toUpperCase());
                    pkFields.append("\"");
                    ++j;
                }
            } else {
                if (pkFields.length() > 0) {
                    this.createTableSt.append(COMMA);
                    pkFields.append(COMMA);
                }
                this.createTableSt.append(lSeparator);
                this.createTableSt.append("  \"");
                this.createTableSt.append(dbMap.getColumnName().toUpperCase());
                this.createTableSt.append("\" ");
                this.createTableSt.append(this.holder.getDBVendorMappings().getDatabaseType(dbMap.getColumnType()));
                this.createTableSt.append(" not null");
                pkFields.append("\"");
                pkFields.append(dbMap.getColumnName().toUpperCase());
                pkFields.append("\"");
            }
            ++i;
        }
        this.createTableSt.append(COMMA);
        this.createTableSt.append(lSeparator);
        this.createTableSt.append("  primary key (");
        this.createTableSt.append(pkFields.toString());
        this.createTableSt.append(")");
        StringBuffer uColumns = new StringBuffer();
        int i2 = 0;
        while (i2 < this.cmpInfo.length) {
            RPersistentFieldMap dbMap = this.cmpInfo[i2].getFieldDBMap();
            if (this.cmpInfo[i2].isDependentValue()) {
                String[] columns = ((RDependentValueMap)dbMap).getDvColumnName();
                int[] columnTypes = ((RDependentValueMap)dbMap).getDvColumnType();
                int j = 0;
                while (j < columns.length) {
                    this.createTableSt.append(COMMA);
                    this.createTableSt.append(lSeparator);
                    this.createTableSt.append("  \"");
                    this.createTableSt.append(columns[j].toUpperCase());
                    this.createTableSt.append("\" ");
                    this.createTableSt.append(this.holder.getDBVendorMappings().getDatabaseType(columnTypes[j]));
                    if (dbMap.getKey() == 3) {
                        if (uColumns.length() > 0) {
                            uColumns.append(COMMA);
                        }
                        uColumns.append("\"");
                        uColumns.append(columns[j].toUpperCase());
                        uColumns.append("\"");
                    }
                    ++j;
                }
            } else {
                this.createTableSt.append(COMMA);
                this.createTableSt.append(lSeparator);
                this.createTableSt.append("  \"");
                this.createTableSt.append(dbMap.getColumnName().toUpperCase());
                this.createTableSt.append("\" ");
                this.createTableSt.append(this.holder.getDBVendorMappings().getDatabaseType(dbMap.getColumnType()));
                if (dbMap.getKey() == 3) {
                    if (uColumns.length() > 0) {
                        uColumns.append(COMMA);
                    }
                    uColumns.append("\"");
                    uColumns.append(dbMap.getColumnName().toUpperCase());
                    uColumns.append("\"");
                }
            }
            ++i2;
        }
        boolean fk = false;
        int i3 = 0;
        while (i3 < this.cmrInfo.length) {
            OneSideRelationDescriptor mySideRelDescr = this.cmrInfo[i3].getMySideRelationDescriptor(this.dscr.getId());
            if (mySideRelDescr.getFieldDBMap().getKey() != 1) {
                StringBuffer fkFields = new StringBuffer();
                StringBuffer refFKFields = new StringBuffer();
                OneSideRelationDescriptor refPKSideRelDescr = this.cmrInfo[i3].getRefSideRelationDescriptor(this.dscr.getId());
                PersistentField[] refPKCmp = this.schema.getDescriptor(refPKSideRelDescr.getEjbId()).getPKCmpFields();
                RRelationFieldMap cmrDBMap = mySideRelDescr.getFieldDBMap();
                String[] columns = cmrDBMap.getColumn();
                fk = cmrDBMap.getKey() == 2;
                int j = 0;
                while (j < columns.length) {
                    this.createTableSt.append(COMMA);
                    this.createTableSt.append(lSeparator);
                    this.createTableSt.append("  \"");
                    this.createTableSt.append(columns[j].toUpperCase());
                    this.createTableSt.append("\" ");
                    this.createTableSt.append(this.holder.getDBVendorMappings().getDatabaseType(refPKCmp[j].getFieldDBMap().getColumnType()));
                    if (fk) {
                        if (fkFields.length() > 0) {
                            fkFields.append(COMMA);
                            refFKFields.append(COMMA);
                        }
                        fkFields.append("\"");
                        fkFields.append(columns[j].toUpperCase());
                        fkFields.append("\"");
                        refFKFields.append("\"");
                        refFKFields.append(refPKCmp[j].getFieldDBMap().getColumnName().toUpperCase());
                        refFKFields.append("\"");
                    }
                    ++j;
                }
                if (fk) {
                    CMPEntityDescriptor refDscr = this.schema.getDescriptor(refPKSideRelDescr.getEjbId());
                    this.createTableSt.append(COMMA);
                    this.createTableSt.append(lSeparator);
                    this.createTableSt.append("  foreign key (");
                    this.createTableSt.append(fkFields.toString());
                    this.createTableSt.append(") references \"");
                    this.createTableSt.append(refDscr.getTableName().toUpperCase());
                    this.createTableSt.append("\" (");
                    this.createTableSt.append(refFKFields.toString());
                    this.createTableSt.append(")");
                    this.holder.tablesGraph[this.dscr.getId()][refDscr.getId()] = true;
                }
            }
            ++i3;
        }
        if (uColumns.length() > 0) {
            this.createTableSt.append(COMMA);
            this.createTableSt.append(lSeparator);
            this.createTableSt.append("  unique (");
            this.createTableSt.append(uColumns.toString());
            this.createTableSt.append(")");
        }
        this.createTableSt.append(lSeparator);
        this.createTableSt.append(")");
    }

    public boolean isUnknownPK() {
        return this.dscr.isUnknownPK();
    }

    public String getCreateTableSt() {
        return this.createTableSt.toString();
    }

    private String multiplicityToString(int multiplicity) {
        if (multiplicity == 1) {
            return "one_to_one";
        }
        if (multiplicity == 2) {
            return "one_to_many";
        }
        if (multiplicity == 3) {
            return "many_to_one";
        }
        if (multiplicity == 4) {
            return "many_to_many";
        }
        return null;
    }

    private MultipleSetInfo getMultipleSetInfoForRelation(int posInSt, OneSideRelationDescriptor relationDescr, PersistentField[] refPKCmp, String pkClass) throws DeploymentException {
        MultipleSetInfo tempMultipleSet = new MultipleSetInfo();
        String[] setMethod = this.getCompoundSetMethodForRelation(posInSt, relationDescr, refPKCmp, pkClass);
        String[] setNull = this.getCompoundSetNullForRelation(posInSt, refPKCmp);
        RelationField cmrField = this.dscr.getRelationField(relationDescr.getCmrId());
        String cmrFieldName = null;
        cmrFieldName = cmrField == null ? relationDescr.getVirtualFieldName() : cmrField.getFieldName();
        tempMultipleSet.setFieldName(cmrFieldName);
        tempMultipleSet.setSetNull(setNull);
        tempMultipleSet.setSetObject(setMethod);
        return tempMultipleSet;
    }

    private SetInfo getSetInfoForRelation(int posInSt, OneSideRelationDescriptor relationDescr, PersistentField refPKCmp) throws DeploymentException {
        SetInfo tempSet = new SetInfo();
        RelationField cmrField = this.dscr.getRelationField(relationDescr.getCmrId());
        String cmrFieldName = null;
        cmrFieldName = cmrField == null ? relationDescr.getVirtualFieldName() : cmrField.getFieldName();
        tempSet.setFieldName(cmrFieldName);
        tempSet.setSetObject(this.getSetMethodForRelation(posInSt, relationDescr, refPKCmp));
        tempSet.setSetNull(this.getSetNullForRelation(posInSt, refPKCmp));
        return tempSet;
    }

    private String getSetMethodForRelation(int posInSt, OneSideRelationDescriptor relationDescr, PersistentField refPKCmp) throws DeploymentException {
        RelationField cmrField = this.dscr.getRelationField(relationDescr.getCmrId());
        String cmrFieldName = null;
        cmrFieldName = cmrField == null ? relationDescr.getVirtualFieldName() : cmrField.getFieldName();
        int columnType = refPKCmp.getFieldDBMap().getColumnType();
        Class fieldClass = refPKCmp.getFieldClass();
        if (relationDescr.getMultiplicityType() == 3) {
            return Mappings.getSetMethod(columnType, fieldClass, posInSt, "((" + fieldClass.getName() + ") " + cmrFieldName + ".ref.getPrimaryKey())");
        }
        return Mappings.getSetMethod(columnType, fieldClass, posInSt, "((" + fieldClass.getName() + ") " + cmrFieldName + ".getPrimaryKey())");
    }

    private String getSetNullForRelation(int posInSt, PersistentField refPKCmp) {
        return Mappings.getSetNull(refPKCmp.getFieldDBMap().getColumnType(), posInSt);
    }

    private String[] getCompoundSetMethodForRelation(int posInSt, OneSideRelationDescriptor relationDescr, PersistentField[] refPKCmp, String pkClass) throws DeploymentException {
        String[] setMethod = new String[refPKCmp.length];
        RelationField cmrField = this.dscr.getRelationField(relationDescr.getCmrId());
        String cmrFieldName = null;
        cmrFieldName = cmrField == null ? relationDescr.getVirtualFieldName() : cmrField.getFieldName();
        int j = 0;
        while (j < refPKCmp.length) {
            int columnType = refPKCmp[j].getFieldDBMap().getColumnType();
            Class fieldClass = refPKCmp[j].getFieldClass();
            String fieldName = refPKCmp[j].getFieldName();
            setMethod[j] = relationDescr.getMultiplicityType() == 3 ? Mappings.getSetMethod(columnType, fieldClass, posInSt++, "((" + pkClass + ")" + cmrFieldName + ".ref.getPrimaryKey())." + fieldName) : Mappings.getSetMethod(columnType, fieldClass, posInSt++, "((" + pkClass + ")" + cmrFieldName + ".getPrimaryKey())." + fieldName);
            ++j;
        }
        return setMethod;
    }

    private String[] getCompoundSetNullForRelation(int posInSt, PersistentField[] refPKCmp) {
        String[] setMethod = new String[refPKCmp.length];
        int j = 0;
        while (j < refPKCmp.length) {
            int columnType = refPKCmp[j].getFieldDBMap().getColumnType();
            setMethod[j] = Mappings.getSetNull(columnType, posInSt++);
            ++j;
        }
        return setMethod;
    }

    private void addCmrColumnsToSelectSt(RelationDescriptor[] cmr, StringBuffer sBuff, String tableName, int ejbId) {
        int i = 0;
        while (i < cmr.length) {
            if (cmr[i].recursiveRelation()) {
                OneSideRelationDescriptor side1 = cmr[i].getSide1();
                this.selectCmrColumnsToSelectSt(side1, sBuff, tableName);
                OneSideRelationDescriptor side2 = cmr[i].getSide2();
                this.selectCmrColumnsToSelectSt(side2, sBuff, tableName);
            } else {
                OneSideRelationDescriptor mySideRelDescr = cmr[i].getMySideRelationDescriptor(ejbId);
                this.selectCmrColumnsToSelectSt(mySideRelDescr, sBuff, tableName);
            }
            ++i;
        }
    }

    private void selectCmrColumnsToSelectSt(OneSideRelationDescriptor side, StringBuffer sBuff, String tableName) {
        if (side.getFieldDBMap().getKey() == 1) {
            return;
        }
        String[] columns = side.getFieldDBMap().getColumn();
        int j = 0;
        while (j < columns.length) {
            sBuff.append(COMMA);
            this.addQuotedName(tableName, sBuff);
            sBuff.append(DOT);
            this.addQuotedName(columns[j], sBuff);
            ++j;
        }
    }

    private void addCmpColumnsToSelectSt(PersistentField[] cmp, StringBuffer sBuff, String tableName, boolean firstColumn) {
        int i = 0;
        while (i < cmp.length) {
            if (cmp[i].isDependentValue()) {
                this.addDvCmpColumnsToSelectSt((DependentValueDescriptor)cmp[i], sBuff, tableName, firstColumn);
            } else {
                this.addCmpColumnsToSelectSt(cmp[i], sBuff, tableName, firstColumn);
            }
            firstColumn = false;
            ++i;
        }
    }

    private void addCmpColumnsToSelectSt(PersistentField cmp, StringBuffer sBuff, String tableName, boolean firstColumn) {
        if (firstColumn) {
            firstColumn = false;
        } else {
            sBuff.append(COMMA);
        }
        this.addQuotedName(tableName, sBuff);
        sBuff.append(DOT);
        this.addQuotedName(cmp.getFieldDBMap().getColumnName(), sBuff);
    }

    private void addDvCmpColumnsToSelectSt(DependentValueDescriptor dvCmp, StringBuffer sBuff, String tableName, boolean firstColumn) {
        String[] columns = ((RDependentValueMap)dvCmp.getFieldDBMap()).getDvColumnName();
        int k = 0;
        while (k < columns.length) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                sBuff.append(COMMA);
            }
            this.addQuotedName(tableName, sBuff);
            sBuff.append(DOT);
            this.addQuotedName(columns[k], sBuff);
            ++k;
        }
    }

    private void selectAllColumns(CMPEntityDescriptor dscr, StringBuffer sBuff) {
        String tableName = dscr.getTableName();
        PersistentField[] refPk = dscr.getPKCmpFields();
        this.addCmpColumnsToSelectSt(refPk, sBuff, tableName, true);
        PersistentField[] refNotPk = dscr.getCmpFields();
        this.addCmpColumnsToSelectSt(refNotPk, sBuff, tableName, false);
        RelationDescriptor[] cmr = this.schema.getRelationDescriptors(dscr.getId());
        this.addCmrColumnsToSelectSt(cmr, sBuff, tableName, dscr.getId());
    }

    private void addQuotedName(String name, StringBuffer sBuff) {
        sBuff.append(QUOTE);
        sBuff.append(name.toUpperCase());
        sBuff.append(QUOTE);
    }

    private void addFullColumnName(String tableName, String columnName, StringBuffer sBuff) {
        this.addQuotedName(tableName, sBuff);
        sBuff.append(DOT);
        this.addQuotedName(columnName, sBuff);
    }

    private void addNonRepeatedCMRColumns(Hashtable columnsInStatement) {
        int i = 0;
        while (i < this.cmrInfo.length) {
            if (this.cmrInfo[i].recursiveRelation()) {
                OneSideRelationDescriptor side1 = this.cmrInfo[i].getSide1();
                OneSideRelationDescriptor side2 = this.cmrInfo[i].getSide2();
                this.selectNonRepeatedCMRColumns(side1, columnsInStatement, this.cmrInfo[i]);
                this.selectNonRepeatedCMRColumns(side2, columnsInStatement, this.cmrInfo[i]);
            } else {
                OneSideRelationDescriptor mySideRelDescr = this.cmrInfo[i].getMySideRelationDescriptor(this.dscr.getId());
                this.selectNonRepeatedCMRColumns(mySideRelDescr, columnsInStatement, this.cmrInfo[i]);
            }
            ++i;
        }
    }

    private void selectNonRepeatedCMRColumns(OneSideRelationDescriptor mySide, Hashtable columnsInStatement, RelationDescriptor cmrInfo) {
        if (mySide.getFieldDBMap().getKey() == 1) {
            return;
        }
        String[] columns = mySide.getFieldDBMap().getColumn();
        RelationDescriptorWrapper cmrInfoWrapper = new RelationDescriptorWrapper(columns, cmrInfo);
        columnsInStatement.put(columns[0], cmrInfoWrapper);
        int j = 1;
        while (j < columns.length) {
            columnsInStatement.put(columns[j], NO_SETMETHOD_GENERATION);
            ++j;
        }
    }

    private void addNonRepeatedCMPColumns(PersistentField[] _cmpInfo, Hashtable columnsInStatement) {
        int i = 0;
        while (i < _cmpInfo.length) {
            if (_cmpInfo[i].isDependentValue()) {
                DependentValueDescriptor dvCmpInfo = (DependentValueDescriptor)_cmpInfo[i];
                String[] columns = ((RDependentValueMap)dvCmpInfo.getFieldDBMap()).getDvColumnName();
                int j = 0;
                while (j < columns.length) {
                    DependentValueDescriptor prevValue = columnsInStatement.put(columns[j], dvCmpInfo);
                    this.connectCmrToCmp(dvCmpInfo, prevValue);
                    ++j;
                }
            } else {
                String columnName = _cmpInfo[i].getFieldDBMap().getColumnName();
                PersistentField prevValue = columnsInStatement.put(columnName, _cmpInfo[i]);
                this.connectCmrToCmp(_cmpInfo[i], prevValue);
            }
            ++i;
        }
    }

    private void connectCmrToCmp(PersistentField cmp, Object prevValue) {
        if (!cmp.isPK() && prevValue instanceof RelationDescriptorWrapper) {
            RelationDescriptor cmr = ((RelationDescriptorWrapper)prevValue).getCmrInfo();
            cmp.setCmrFieldInOneColumn(cmr);
            cmr.setCmpFieldInOneColumn(cmp);
        }
    }

    private void generateSetMethods(Hashtable columnsInStatment, Vector vMultipleSetInfo, Vector vSetInfo) throws DeploymentException {
        HashSet<DependentValueDescriptor> dvObjects = new HashSet<DependentValueDescriptor>();
        int posInSt = 1;
        Enumeration keys = columnsInStatment.keys();
        while (keys.hasMoreElements()) {
            String columnName = (String)keys.nextElement();
            Object objectInfo = columnsInStatment.get(columnName);
            if (objectInfo.equals(NO_SETMETHOD_GENERATION)) continue;
            if (objectInfo instanceof DependentValueDescriptor) {
                DependentValueDescriptor dvCmp = (DependentValueDescriptor)objectInfo;
                dvCmp.specifyMyPosition(columnName, posInSt++);
                dvObjects.add(dvCmp);
                continue;
            }
            if (objectInfo instanceof PersistentField) {
                PersistentField cmp = (PersistentField)objectInfo;
                SetInfo tempSetInfo = cmp.getSetInfo(posInSt++);
                vSetInfo.addElement(tempSetInfo);
                continue;
            }
            RelationDescriptorWrapper cmrWrapper = (RelationDescriptorWrapper)objectInfo;
            RelationDescriptor cmr = cmrWrapper.getCmrInfo();
            OneSideRelationDescriptor pkSide = cmr.getPKSide();
            OneSideRelationDescriptor fkSide = cmr.getFKSide();
            posInSt = this.generateCmrSetMethods(fkSide, pkSide, vSetInfo, vMultipleSetInfo, posInSt);
        }
        Iterator it = dvObjects.iterator();
        while (it.hasNext()) {
            MultipleSetInfo mInfo = ((DependentValueDescriptor)it.next()).getMultipleSetInfo();
            vMultipleSetInfo.addElement(mInfo);
        }
    }

    private int generateCmrSetMethods(OneSideRelationDescriptor mySide, OneSideRelationDescriptor refSide, Vector vSetInfo, Vector vMultipleSetInfo, int posInSt) throws DeploymentException {
        CMPEntityDescriptor refDescr = this.schema.getDescriptor(refSide.getEjbId());
        PersistentField[] refPKCmp = refDescr.getPKCmpFields();
        if (!refPKCmp[0].isCompoundPK()) {
            SetInfo tempSetInfo = this.getSetInfoForRelation(posInSt, mySide, refPKCmp[0]);
            vSetInfo.addElement(tempSetInfo);
        } else {
            MultipleSetInfo tempMultipleSet = this.getMultipleSetInfoForRelation(posInSt, mySide, refPKCmp, refDescr.getRealPrimaryKeyClass());
            vMultipleSetInfo.addElement(tempMultipleSet);
        }
        return posInSt + refPKCmp.length;
    }
}

