/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.orMappingVerifier;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import com.sap.engine.services.ejb.deploy.orMappingVerifier.CMPEntityVerifier;
import com.sap.engine.services.ejb.deploy.orMappingVerifier.M2MRelationVerifier;
import com.sap.engine.services.ejb.exceptions.deployment.ORMappingExceptionConstants;
import com.sap.engine.services.ejb.exceptions.deployment.ORMappingVerificationException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.types.CommonTypes;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class RelationVerifier
implements ORMappingExceptionConstants {
    private RelationVerifier() {
    }

    public static void check(AbstractSchema abstractSchema, RelationDescriptor rel, CatalogReader catalogReader, Hashtable tableToFKColumns, Vector warnings) throws DeploymentException {
        OneSideRelationDescriptor side1 = rel.getSide1();
        OneSideRelationDescriptor side2 = rel.getSide2();
        int multiplicity = side1.getMultiplicityType();
        switch (multiplicity) {
            case 1: {
                RelationVerifier.checkOneToOne(abstractSchema, side1, side2, catalogReader, tableToFKColumns, warnings);
                break;
            }
            case 2: {
                RelationVerifier.checkOneToMany(abstractSchema, side1, side2, catalogReader, tableToFKColumns, warnings);
                break;
            }
            case 3: {
                RelationVerifier.checkOneToMany(abstractSchema, side2, side1, catalogReader, tableToFKColumns, warnings);
                break;
            }
            case 4: {
                RelationVerifier.checkManyToMany(abstractSchema, rel.getM2MMap(), side1, side2, catalogReader);
            }
        }
    }

    private static void checkOneToOne(AbstractSchema schema, OneSideRelationDescriptor side1, OneSideRelationDescriptor side2, CatalogReader catalogReader, Hashtable tableToFKColumns, Vector warnings) throws DeploymentException {
        CMPEntityDescriptor descr1 = RelationVerifier.getDescriptor(schema, side1);
        RRelationFieldMap rMap1 = side1.getFieldDBMap();
        int key1 = rMap1.getKey();
        CMPEntityDescriptor descr2 = RelationVerifier.getDescriptor(schema, side2);
        RRelationFieldMap rMap2 = side2.getFieldDBMap();
        int key2 = rMap2.getKey();
        if (key1 == 1) {
            if (key2 != 0 && key2 != 2) {
                throw new ORMappingVerificationException("ejb_2010", new String[]{descr1.getEjbName(), descr2.getEjbName(), RelationVerifier.multiplicityToStr(side1.getMultiplicityType())});
            }
        } else if (key1 == 0 || key1 == 2) {
            if (key2 != 1) {
                throw new ORMappingVerificationException("ejb_2011", new String[]{descr1.getEjbName(), descr2.getEjbName(), RelationVerifier.multiplicityToStr(side1.getMultiplicityType())});
            }
        } else {
            throw new ORMappingVerificationException("ejb_2011", new String[]{descr1.getEjbName(), descr2.getEjbName(), RelationVerifier.multiplicityToStr(side1.getMultiplicityType())});
        }
        Table pkTable = null;
        Table fkTable = null;
        PersistentField[] pkFields = null;
        String[] fkColumns = null;
        if (key1 == 1) {
            pkTable = RelationVerifier.getMyTable(descr1, catalogReader);
            pkFields = descr1.getPKCmpFields();
            fkColumns = rMap2.getColumn();
            fkTable = RelationVerifier.getMyTable(descr2, catalogReader);
        } else {
            pkTable = RelationVerifier.getMyTable(descr2, catalogReader);
            pkFields = descr2.getPKCmpFields();
            fkTable = RelationVerifier.getMyTable(descr1, catalogReader);
            fkColumns = rMap1.getColumn();
        }
        if (pkFields.length != fkColumns.length) {
            if (key1 == 1) {
                Object[] excArgs = new String[]{descr1.getEjbName(), descr2.getEjbName(), descr2.getTableName(), descr1.getTableName(), String.valueOf(fkColumns.length), String.valueOf(pkFields.length)};
                throw new ORMappingVerificationException("ejb_2009", excArgs);
            }
            Object[] excArgs = new String[]{descr1.getEjbName(), descr2.getEjbName(), descr1.getTableName(), descr2.getTableName(), String.valueOf(fkColumns.length), String.valueOf(pkFields.length)};
            throw new ORMappingVerificationException("ejb_2009", excArgs);
        }
        RelationVerifier.checkColumnsInRelation(pkTable, pkFields, fkTable, fkColumns, descr2.getCmpFields(), tableToFKColumns, warnings);
    }

    private static void checkOneToMany(AbstractSchema schema, OneSideRelationDescriptor side1, OneSideRelationDescriptor side2, CatalogReader catalogReader, Hashtable tableToFKColumns, Vector warnings) throws DeploymentException {
        String[] fkColumns;
        CMPEntityDescriptor descr1 = RelationVerifier.getDescriptor(schema, side1);
        CMPEntityDescriptor descr2 = RelationVerifier.getDescriptor(schema, side2);
        RRelationFieldMap rMap1 = side1.getFieldDBMap();
        int key1 = rMap1.getKey();
        if (key1 != 1) {
            throw new ORMappingVerificationException("ejb_2011", new String[]{descr1.getEjbName(), descr2.getEjbName(), RelationVerifier.multiplicityToStr(side1.getMultiplicityType())});
        }
        RRelationFieldMap rMap2 = side2.getFieldDBMap();
        int key2 = rMap2.getKey();
        if (key2 != 0 && key2 != 2) {
            throw new ORMappingVerificationException("ejb_2010", new String[]{descr1.getEjbName(), descr2.getEjbName(), RelationVerifier.multiplicityToStr(side1.getMultiplicityType())});
        }
        PersistentField[] pkFields = descr1.getPKCmpFields();
        if (pkFields.length != (fkColumns = rMap2.getColumn()).length) {
            Object[] excArgs = new String[]{descr1.getEjbName(), descr2.getEjbName(), descr2.getTableName(), descr1.getTableName(), String.valueOf(fkColumns.length), String.valueOf(pkFields.length)};
            throw new ORMappingVerificationException("ejb_2009", excArgs);
        }
        Table table1 = RelationVerifier.getMyTable(descr1, catalogReader);
        Table table2 = RelationVerifier.getMyTable(descr2, catalogReader);
        RelationVerifier.checkColumnsInRelation(table1, pkFields, table2, fkColumns, descr2.getCmpFields(), tableToFKColumns, warnings);
    }

    private static void checkManyToMany(AbstractSchema schema, M2MRelationFieldMap m2mRelation, OneSideRelationDescriptor side1, OneSideRelationDescriptor side2, CatalogReader catalogReader) throws DeploymentException {
        CMPEntityDescriptor descr1 = RelationVerifier.getDescriptor(schema, side1);
        RRelationFieldMap rMap1 = side1.getFieldDBMap();
        int key1 = rMap1.getKey();
        CMPEntityDescriptor descr2 = RelationVerifier.getDescriptor(schema, side2);
        RRelationFieldMap rMap2 = side2.getFieldDBMap();
        int key2 = rMap2.getKey();
        if (key1 != 1 || key2 != 1) {
            throw new ORMappingVerificationException("ejb_2012", new String[]{descr1.getEjbName(), descr2.getEjbName()});
        }
        Table table1 = RelationVerifier.getMyTable(descr1, catalogReader);
        PersistentField[] pkFields1 = descr1.getPKCmpFields();
        Table table2 = RelationVerifier.getMyTable(descr2, catalogReader);
        PersistentField[] pkFields2 = descr2.getPKCmpFields();
        M2MRelationVerifier.check(m2mRelation, table1, pkFields1, table2, pkFields2, catalogReader);
    }

    private static void checkColumnsInRelation(Table pkTable, PersistentField[] pkColumns, Table fkTable, String[] fkColumns, PersistentField[] cmp2, Hashtable tableToFKColumns, Vector warnings) throws DeploymentException {
        int i = 0;
        while (i < pkColumns.length) {
            String MESSAGE;
            String pkColumnName = pkColumns[i].getFieldDBMap().getColumnName();
            Column column = pkTable.getColumn(pkColumnName.toUpperCase());
            if (!column.isPrimaryKey()) {
                throw new ORMappingVerificationException("ejb_2007", new String[]{pkColumnName, pkTable.getName()});
            }
            HashSet set = (HashSet)tableToFKColumns.get(fkTable.getName());
            if (set.contains(fkColumns[i])) {
                String MESSAGE2 = "Relationship between " + pkTable.getName() + " and " + fkTable.getName() + " uses (logical) foreign key " + fkColumns[i] + ", which has already been used by another relationship. The application itself should update both cmr-fields.";
                warnings.add(MESSAGE2);
            } else {
                set.add(fkColumns[i]);
            }
            Column refColumn = CMPEntityVerifier.getCatalogColumn(fkTable, fkColumns[i]);
            if (refColumn.isPrimaryKey()) {
                MESSAGE = "Primary key column " + fkColumns[i] + " in table " + fkTable.getName() + " is also (logical) foreign key, i.e. it is used by a relationship. The application should NOT update this relationship. It will cause update of the primary key field.";
                warnings.add(MESSAGE);
            }
            if (column.getJdbcType() != refColumn.getJdbcType()) {
                throw new ORMappingVerificationException("ejb_2018", new String[]{fkColumns[i], fkTable.getName(), CommonTypes.getJdbcTypeName((int)refColumn.getJdbcType()), pkColumnName, pkTable.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType())});
            }
            if (RelationVerifier.isFkCmpColumn(fkColumns[i], cmp2)) {
                MESSAGE = "Column " + fkColumns[i] + " is described as (logical) foreign key but it is used also as a column of a cmp-field. The application itself should update both cmp- and cmr- fields.";
                warnings.add(MESSAGE);
            }
            ++i;
        }
    }

    private static CMPEntityDescriptor getDescriptor(AbstractSchema schema, OneSideRelationDescriptor side) {
        return schema.getDescriptor(side.getEjbId());
    }

    private static Table getMyTable(CMPEntityDescriptor descr, CatalogReader catalogReader) throws DeploymentException {
        String tableName = descr.getTableName();
        return CMPEntityVerifier.getCatalogTable(catalogReader, tableName);
    }

    private static boolean isFkCmpColumn(String fkColumn, PersistentField[] cmp) {
        int i = 0;
        while (i < cmp.length) {
            if (cmp[i].isDependentValue()) {
                String[] cmpColumns = ((RDependentValueMap)cmp[i].getFieldDBMap()).getDvColumnName();
                int j = 0;
                while (j < cmpColumns.length) {
                    if (fkColumn.equals(cmpColumns[j])) {
                        return true;
                    }
                    ++j;
                }
            } else {
                String cmpColumn = cmp[i].getFieldDBMap().getColumnName();
                if (fkColumn.equals(cmpColumn)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static String multiplicityToStr(int multiplicity) {
        switch (multiplicity) {
            case 1: {
                return "ONE_TO_ONE";
            }
            case 2: {
                return "ONE_TO_MANY";
            }
            case 3: {
                return "MANY_TO_ONE";
            }
            case 4: {
                return "MANY_TO_MANY";
            }
        }
        return "UNDEFINED";
    }
}

