/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.orMappingVerifier;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.orMappingVerifier.CMPEntityVerifier;
import com.sap.engine.services.ejb.exceptions.deployment.ORMappingExceptionConstants;
import com.sap.engine.services.ejb.exceptions.deployment.ORMappingVerificationException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.types.CommonTypes;

public class M2MRelationVerifier
implements ORMappingExceptionConstants {
    private M2MRelationVerifier() {
    }

    public static void check(M2MRelationFieldMap m2mRelation, Table refTable1, PersistentField[] refFields1, Table refTable2, PersistentField[] refFields2, CatalogReader catalogReader) throws DeploymentException {
        String tableName = m2mRelation.getHelpTable();
        Table table = CMPEntityVerifier.getCatalogTable(catalogReader, tableName);
        String[] col1 = m2mRelation.getColumns1();
        if (col1.length != refFields1.length) {
            throw new ORMappingVerificationException("ejb_2008", new String[]{tableName, String.valueOf(col1.length), refTable1.getName(), String.valueOf(refFields1.length)});
        }
        M2MRelationVerifier.checkFKColumns(col1, table, refFields1, refTable1);
        String[] col2 = m2mRelation.getColumns2();
        if (col2.length != refFields2.length) {
            throw new ORMappingVerificationException("ejb_2008", new String[]{tableName, String.valueOf(col2.length), refTable2.getName(), String.valueOf(refFields2.length)});
        }
        M2MRelationVerifier.checkFKColumns(col2, table, refFields2, refTable2);
    }

    private static void checkFKColumns(String[] columnNames, Table table, PersistentField[] refFields, Table refTable) throws DeploymentException {
        int i = 0;
        while (i < columnNames.length) {
            Column column = CMPEntityVerifier.getCatalogColumn(table, columnNames[i]);
            Column refColumn = CMPEntityVerifier.getCatalogColumn(refTable, refFields[i].getFieldDBMap().getColumnName());
            if (column.getJdbcType() != refColumn.getJdbcType()) {
                throw new ORMappingVerificationException("ejb_2018", new String[]{columnNames[i], table.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType()), refColumn.getName(), refTable.getName(), CommonTypes.getJdbcTypeName((int)refColumn.getJdbcType())});
            }
            ++i;
        }
    }
}

