/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.orMappingVerifier;

import com.sap.dictionary.database.catalog.CatalogReaderAccess;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.orMappingVerifier.CMPEntityVerifier;
import com.sap.engine.services.ejb.deploy.orMappingVerifier.RelationVerifier;
import com.sap.sql.catalog.CatalogReader;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class AbstractSchemaVerifier {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$deploy$orMappingVerifier$AbstractSchemaVerifier == null ? (class$com$sap$engine$services$ejb$deploy$orMappingVerifier$AbstractSchemaVerifier = AbstractSchemaVerifier.class$("com.sap.engine.services.ejb.deploy.orMappingVerifier.AbstractSchemaVerifier")) : class$com$sap$engine$services$ejb$deploy$orMappingVerifier$AbstractSchemaVerifier));
    static /* synthetic */ Class class$com$sap$engine$services$ejb$deploy$orMappingVerifier$AbstractSchemaVerifier;

    public static void check(String applicationName, AbstractSchema abstractSchema, Environment env, Vector warnings) throws DeploymentException {
        DataBaseProperties dbProps = abstractSchema.getDBProperties();
        String dsName = dbProps.getDataSourceName();
        DataSource ds = null;
        try {
            ds = (DataSource)env.getNewNamingContext().lookup("ejbContainer/cmp/notx/" + applicationName + "/" + dsName);
        }
        catch (NamingException ne) {
            String MESSAGE = "The application " + applicationName + " contains CMP Entity Beans that intends to use dataSource " + dsName + ". Check of the Object-Relational mapping of the CMP Entity Beans will not be done because NamingException " + "has occurred when retrieving the dataSource.";
            LOCATION.traceThrowableT(300, MESSAGE, (Throwable)ne);
            warnings.add(MESSAGE);
            return;
        }
        CatalogReader catalogReader = null;
        Connection con = null;
        try {
            con = ds.getConnection();
            String conImplName = con.getClass().getName();
            if (conImplName != "com.sap.engine.services.dbpool.cci.CommonConnectionHandle") {
                warnings.add("ORMapping verification is skipped because the datasource used by the application is not OpenSQL. Use only OpenSQL datasource if you want the OR mapping verification to be done.");
                AbstractSchemaVerifier.close(catalogReader, con, warnings);
                return;
            }
            catalogReader = CatalogReaderAccess.getCatalogReader((Connection)con);
        }
        catch (SQLException se) {
            String MESSAGE = "The application " + applicationName + " contains CMP Entity Beans that intends to use dataSource " + dsName + ". Check of the Object-Relational mapping of the CMP Entity Beans will not be done because SQLException " + "has occurred when a connection is obtaned from the dataSource.";
            LOCATION.traceThrowableT(100, MESSAGE, (Throwable)se);
            warnings.add(MESSAGE);
            AbstractSchemaVerifier.close(catalogReader, con, warnings);
            return;
        }
        try {
            Hashtable tableToUsedFKColumns = new Hashtable();
            CMPEntityDescriptor[] cmpDescr = abstractSchema.getDescriptors();
            int i = 0;
            while (i < cmpDescr.length) {
                CMPEntityVerifier.check(cmpDescr[i], catalogReader, warnings);
                tableToUsedFKColumns.put(cmpDescr[i].getTableName().toUpperCase(), new HashSet());
                ++i;
            }
            RelationDescriptor[] relations = abstractSchema.getRelDescriptors();
            int i2 = 0;
            while (i2 < relations.length) {
                RelationVerifier.check(abstractSchema, relations[i2], catalogReader, tableToUsedFKColumns, warnings);
                ++i2;
            }
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            AbstractSchemaVerifier.close(catalogReader, con, warnings);
            throw throwable;
        }
        AbstractSchemaVerifier.close(catalogReader, con, warnings);
    }

    private static void close(CatalogReader catalogReader, Connection con, Vector warnings) {
        if (catalogReader != null) {
            CatalogReaderAccess.releaseCatalogReader((CatalogReader)catalogReader);
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sqlEx) {
                String MESSAGE = "SQLException has occurred when closing the database connection used by the CataologReader.";
                LOCATION.traceThrowableT(100, "SQLException has occurred when closing the database connection used by the CataologReader.", (Throwable)sqlEx);
                warnings.add("SQLException has occurred when closing the database connection used by the CataologReader.");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

