/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.enhancer;

import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.enhancer.EJBClassEnhancer;
import com.sap.engine.services.ejb.deploy.enhancer.FieldAccessChanger;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDescriptorException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class EntityEnhancer {
    static /* synthetic */ Class class$java$lang$Object;

    public static void generate(CMPEntityDescriptor dd, ClassLoader loader, ZipFile inJar, ZipOutputStream outJar) throws EJBDeploymentException {
        String ejbClassName = dd.getClassName();
        Class<?> ejbClass = null;
        try {
            ejbClass = loader.loadClass(ejbClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new EJBDeploymentException("ejb_2191", new Object[]{ejbClassName}, cnfe);
        }
        Class[] superClasses = EntityEnhancer.getSuperClasses(ejbClass);
        PersistentField[] cmpPersFields = dd.getCmpFields();
        PersistentField[] cmpPKPersFields = dd.getPKCmpFields();
        if (cmpPKPersFields == null) {
            throw new EJBDescriptorException("ejb_2190");
        }
        if (cmpPersFields == null) {
            cmpPersFields = new PersistentField[]{};
        }
        Field[] cmpFields = new Field[cmpPKPersFields.length + cmpPersFields.length];
        try {
            int i = 0;
            while (i < cmpFields.length) {
                cmpFields[i] = i < cmpPKPersFields.length ? ejbClass.getField(cmpPKPersFields[i].getFieldName()) : ejbClass.getField(cmpPersFields[i - cmpPKPersFields.length].getFieldName());
                ++i;
            }
        }
        catch (NoSuchFieldException nsfe) {
            throw new EJBDeploymentException("ejb_2192", new Object[]{dd.getEjbName()}, nsfe);
        }
        Hashtable<String, byte[]> fieldChBytes = new Hashtable<String, byte[]>();
        try {
            InputStream in;
            int j = 0;
            while (j < superClasses.length) {
                ZipEntry inEntry = inJar.getEntry(superClasses[j].getName().replace('.', '/') + ".class");
                Class[] supers = new Class[superClasses.length - j - 1];
                System.arraycopy(superClasses, j + 1, supers, 0, supers.length);
                if (inEntry == null) {
                    throw new EJBFileOperationException("ejb_2193", new Object[]{superClasses[j].getName(), ejbClassName});
                }
                in = new BufferedInputStream(inJar.getInputStream(inEntry));
                FieldAccessChanger ch = new FieldAccessChanger(in, cmpFields, supers);
                ((BufferedInputStream)in).close();
                if (ch.process()) {
                    fieldChBytes.put(superClasses[j].getName(), ch.getByteCode());
                }
                ++j;
            }
            Class topClass = superClasses.length > 1 ? superClasses[superClasses.length - 1] : null;
            byte[] chBytes = (byte[])fieldChBytes.remove(ejbClassName);
            in = null;
            if (chBytes == null) {
                ZipEntry entry = inJar.getEntry(ejbClassName.replace('.', '/') + ".class");
                if (entry == null) {
                    throw new EJBFileOperationException("ejb_2194", new Object[]{ejbClassName, inJar.getName()});
                }
                in = new BufferedInputStream(inJar.getInputStream(entry));
            } else {
                in = new ByteArrayInputStream(chBytes);
            }
            EJBClassEnhancer en = new EJBClassEnhancer(in, ejbClass, cmpFields, topClass);
            fieldChBytes.put(ejbClassName, en.enhance());
            in.close();
            int j2 = 1;
            while (j2 < superClasses.length) {
                chBytes = (byte[])fieldChBytes.remove(superClasses[j2].getName());
                if (chBytes == null) {
                    ZipEntry entry = inJar.getEntry(superClasses[j2].getName().replace('.', '/') + ".class");
                    if (entry == null) {
                        throw new EJBFileOperationException("ejb_2194", new Object[]{ejbClassName, inJar.getName()});
                    }
                    in = new BufferedInputStream(inJar.getInputStream(entry));
                } else {
                    in = new ByteArrayInputStream(chBytes);
                }
                en = new EJBClassEnhancer(in, superClasses[j2], cmpFields, topClass);
                fieldChBytes.put(superClasses[j2].getName(), en.enhance());
                in.close();
                ++j2;
            }
            Enumeration e = fieldChBytes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String entryName = key.replace('.', '/') + ".class";
                try {
                    outJar.putNextEntry(new ZipEntry(entryName));
                    outJar.write((byte[])fieldChBytes.get(key));
                    outJar.closeEntry();
                }
                catch (ZipException zipe) {
                    EJBResourceAccessor.location.pathT("Exception in EntityEnhancer.generate() : " + zipe.toString());
                }
            }
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2195", (Throwable)ioe);
        }
    }

    private static Class[] getSuperClasses(Class ejbClass) {
        Vector temp = new Vector();
        temp.add(ejbClass);
        Class superClass = ejbClass.getSuperclass();
        while (!superClass.equals(class$java$lang$Object == null ? EntityEnhancer.class$("java.lang.Object") : class$java$lang$Object)) {
            temp.addElement(superClass);
            superClass = superClass.getSuperclass();
        }
        Object[] result = new Class[temp.size()];
        temp.copyInto(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

