/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.ejbql;

import com.sap.ejbql.EJBQLParser;
import com.sap.ejbql.EJBQLParsingContext;
import com.sap.ejbql.SchemaManager;
import com.sap.ejbql.tree.Query;
import com.sap.ejbql.tree.TypeManager;
import com.sap.engine.interfaces.ejb.orMapping.SchemaORMapping;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.SchemaORMappingImpl;
import com.sap.engine.services.ejb.deploy.ejbql.SchemaManagerImpl;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.deploy.tools.sql.SetInfo;
import com.sap.engine.services.ejb.deploy.xml.ParseUtils;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.engine.services.ejb.util.AdminUtils;
import com.sap.sql.NativeSQLAccess;
import com.sap.sql.ejb.InputDescriptor;
import com.sap.sql.ejb.ResultDescriptor;
import com.sap.sql.ejb.SQLMapper;
import com.sap.sql.ejb.SQLMapperFactory;
import com.sap.sql.ejb.SQLMappingException;
import com.sap.sql.ejb.SQLMappingResult;
import com.sap.sql.types.CommonTypes;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class QLTranslator {
    private String applicationName = null;
    private EJBJarDescriptor jarDescr = null;
    private AbstractSchema schema = null;
    private ClassLoader loader = null;
    private EJBQLParsingContext qlParsingContext = null;
    private EJBQLParser qlParser = null;
    private SQLMapper sqlMapper = null;
    private DataSource ds = null;
    private Vector warnings = null;
    private int connectionVendorId = -1;
    private boolean connectionVendorIdIsSet = false;

    public QLTranslator(String _applicationName, EJBJarDescriptor _jarDescr, ClassLoader _loader, Vector _warnings) {
        this.applicationName = _applicationName;
        this.jarDescr = _jarDescr;
        this.loader = _loader;
        this.warnings = _warnings;
        this.schema = _jarDescr.getAbstractSchema();
    }

    public void translateQuery(CMPEntityDescriptor thisDescr, FinderDescriptor finderDescr) throws DeploymentException {
        SQLMappingResult finalSqlResult;
        if (finderDescr.getSQLStatement() != null || finderDescr.isFindByPK()) {
            return;
        }
        this.prepareQLContext(finderDescr);
        try {
            Query queryTree = this.qlParsingContext.getParseTree();
            boolean selectDistinct = finderDescr.getReturnType().equals("java.util.Set");
            boolean selectAllColumns = finderDescr.toLoadSelectedObjects();
            finalSqlResult = this.getSQLMapper(selectAllColumns).mapEjbQl(queryTree, selectDistinct);
            this.checkOpenSQLCompatibility(finderDescr, finalSqlResult);
            ResultDescriptor firstResultDescriptor = finalSqlResult.getResultDescriptors()[0];
            boolean allColumnsSelected = selectAllColumns && firstResultDescriptor.isObjectRepresentation() && !finalSqlResult.wasSelectPrimaryKeyFieldsForced();
            finderDescr.setToLoadSelectedObjects(allColumnsSelected);
            String sqlStatement = this.getSQLStatment(finalSqlResult);
            CMPEntityDescriptor selectedBean = this.checkResultType(thisDescr, finderDescr, firstResultDescriptor);
            if (allColumnsSelected) {
                if (selectedBean != null && selectedBean.useSelectForUpdate()) {
                    sqlStatement = sqlStatement + " for update ";
                    if (finderDescr.getLockMode() != null) {
                        finderDescr.setLockMode(null);
                        String message = "Method {" + finderDescr.getMethodName() + "} in CMP entity bean {" + thisDescr.getEjbName() + "} selects bean {" + selectedBean + "} that uses SELECT FOR UPDATE locking. It is not allowed to switch on <lock> attribute" + " of <load-selected-objects> in persistent.xml for such find/select methods. <lock> attribute will be ignored.";
                        this.warnings.add(message);
                    }
                } else if (finderDescr.getLockMode() != null) {
                    SQLMappingResult selectPK = this.getSQLMapper(false).mapEjbQl(queryTree, selectDistinct);
                    String selectPKStatement = this.getSQLStatment(selectPK);
                    finderDescr.setSelectPKStatment(selectPKStatement);
                }
            } else if (selectAllColumns) {
                finderDescr.setLockMode(null);
                this.warnings.add("For find/select method {" + finderDescr.getMethodName() + "} in CMP entity bean {" + thisDescr.getEjbName() + "} <load-selected-objects> tag exists in persistent.xml. Query {" + finderDescr.getQuery() + "} selects cmp-field or cannot be translated to SQL statement that selects all columns. That's why" + " <load-selected-objects> and its attribute <lock> will be ignored.");
            }
            finderDescr.setSQLStatement(sqlStatement);
        }
        catch (SQLMappingException sql) {
            throw new EJBDeploymentException("ejb_2422", new String[]{sql.getErrorLable()}, sql);
        }
        this.fillSetInfos(finderDescr, finalSqlResult, thisDescr.getEjbName());
    }

    public void translateAllQueries() throws DeploymentException {
        CMPEntityDescriptor[] cmpDescr = this.schema.getDescriptors();
        FinderDescriptor[] finderDescr = null;
        int i = 0;
        while (i < cmpDescr.length) {
            finderDescr = cmpDescr[i].getFinderDescriptors();
            int j = 0;
            while (j < finderDescr.length) {
                this.translateQuery(cmpDescr[i], finderDescr[j]);
                ++j;
            }
            ++i;
        }
    }

    private String getSQLStatment(SQLMappingResult sqlMap) throws SQLMappingException {
        String sqlSt = sqlMap.getStatementString();
        sqlSt = this.addEscapeChar(sqlSt, '\\');
        sqlSt = this.addEscapeChar(sqlSt, '\"');
        return sqlSt;
    }

    private void prepareQLContext(FinderDescriptor f) throws DeploymentException {
        this.initEJBQLParsingContext();
        this.qlParsingContext.setInputParams(f.getParamsTypes());
        this.qlParsingContext.setQueryString(f.getQuery());
        this.getQLParser(f.isQLVersion2_1()).parse(this.qlParsingContext);
        if (this.qlParsingContext.getNofErrors() != 0) {
            throw new EJBDeploymentException("ejb_2420", new String[]{f.getQuery(), this.qlParsingContext.getErrorMessages()});
        }
    }

    private void initEJBQLParsingContext() {
        if (this.qlParsingContext == null) {
            SchemaManagerImpl schemaManager = new SchemaManagerImpl(this.jarDescr);
            TypeManager typeManager = new TypeManager((SchemaManager)schemaManager);
            this.qlParsingContext = new EJBQLParsingContext(typeManager);
        }
    }

    private EJBQLParser getQLParser(boolean ql2_1) {
        if (this.qlParser == null) {
            this.qlParser = new EJBQLParser();
        }
        if (ql2_1) {
            this.qlParser.setEJB_2_1();
        } else {
            this.qlParser.setEJB_2_0();
        }
        return this.qlParser;
    }

    private SQLMapper getSQLMapper(boolean selectAllBeanFields) throws SQLMappingException {
        if (this.sqlMapper == null) {
            this.sqlMapper = SQLMapperFactory.createSQLMapper((SchemaORMapping)new SchemaORMappingImpl(this.schema));
        }
        if (selectAllBeanFields) {
            this.sqlMapper.setSelectAllBeanFields();
        } else {
            this.sqlMapper.setSelectPrimaryKeyFields();
        }
        return this.sqlMapper;
    }

    private void fillSetInfos(FinderDescriptor finderDescr, SQLMappingResult sqlResult, String ejbName) throws DeploymentException {
        InputDescriptor[] inputDescr = sqlResult.getInputDescriptors();
        finderDescr.setSetInfo(new SetInfo[inputDescr.length]);
        int i = 0;
        while (i < inputDescr.length) {
            int paramIndex = inputDescr[i].getInputParameter();
            int columnIndex = inputDescr[i].getPosition();
            if (inputDescr[i].isBean()) {
                CMPEntityDescriptor beanDescr = this.schema.getDescriptorByAbstractSchemaName(inputDescr[i].getEjbName());
                this.fillSetMethods(beanDescr, inputDescr[i].getEjbFieldName(), columnIndex, paramIndex, finderDescr);
            } else {
                Class fClass;
                String fieldType = finderDescr.getParamsTypes()[paramIndex - 1];
                String fieldName = "param" + paramIndex;
                int jdbcType = inputDescr[i].getJdbcType();
                try {
                    fClass = ParseUtils.getClassFromString(fieldType, this.loader);
                }
                catch (ClassNotFoundException de) {
                    EJBXMLParserException toThrow = new EJBXMLParserException("ejb_2236", new Object[]{ejbName, finderDescr.getMethodName(), fieldType}, de);
                    throw toThrow;
                }
                SetInfo info = new SetInfo();
                info.setFieldName(fieldName);
                info.setSetObject(Mappings.getSetMethodForSelectStInFindMethod(jdbcType, fClass, columnIndex, fieldName));
                if (!AdminUtils.isPrimitiveType((String)fieldType)) {
                    info.setSetNull(Mappings.getSetNull(jdbcType, columnIndex));
                }
                finderDescr.getSetInfo()[columnIndex - 1] = info;
            }
            ++i;
        }
    }

    private void fillSetMethods(CMPEntityDescriptor bDescr, String inputFieldName, int columnIndex, int paramIndex, FinderDescriptor fDescr) throws DeploymentException {
        PersistentField[] pkCmp = bDescr.getPKCmpFields();
        PersistentField persistentField = null;
        int i = 0;
        while (i < pkCmp.length) {
            if (inputFieldName.equals(pkCmp[i].getFieldName())) {
                persistentField = pkCmp[i];
                break;
            }
            ++i;
        }
        if (persistentField == null) {
            throw new EJBDeploymentException("ejb_2424", new String[]{fDescr.getMethodName(), inputFieldName});
        }
        String fieldName = "((" + bDescr.getRealPrimaryKeyClass() + ")param" + paramIndex + ".getPrimaryKey())";
        SetInfo tempSet = persistentField.getSetInfoForFindMethods(columnIndex, fieldName);
        tempSet.setFieldName(fieldName);
        fDescr.getSetInfo()[columnIndex - 1] = tempSet;
    }

    private String addEscapeChar(String sqlStatement, char ch) {
        int pos = 0;
        int index = sqlStatement.indexOf(ch, pos);
        if (index == -1) {
            return sqlStatement;
        }
        StringBuffer sBuffer = new StringBuffer();
        while (index != -1) {
            sBuffer.append(sqlStatement.substring(pos, index));
            sBuffer.append("\\" + ch);
            pos = index + 1;
            index = sqlStatement.indexOf(ch, pos);
        }
        if (pos <= sqlStatement.length()) {
            sBuffer.append(sqlStatement.substring(pos, sqlStatement.length()));
        }
        return sBuffer.toString();
    }

    /*
     * Loose catch block
     */
    private int getConnectionVendorId(String query) throws DeploymentException {
        block10: {
            if (!this.connectionVendorIdIsSet) {
                this.connectionVendorIdIsSet = true;
                DataSource ds = this.getDataSource(query);
                Connection conn = null;
                conn = ds.getConnection();
                this.connectionVendorId = NativeSQLAccess.getVendorID((Connection)conn);
                Object var6_4 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    break block10;
                }
                catch (SQLException sql) {
                    EJBResourceAccessor.location.infoT("Exception in QLTranslator.getConnectionVendorId() : " + sql.toString());
                }
                break block10;
                {
                    catch (SQLException sql) {
                        throw new EJBDeploymentException("ejb_2425", new String[]{this.schema.getDBProperties().getDataSourceName()}, sql);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException sql) {
                        EJBResourceAccessor.location.infoT("Exception in QLTranslator.getConnectionVendorId() : " + sql.toString());
                    }
                    throw throwable;
                }
            }
        }
        return this.connectionVendorId;
    }

    private DataSource getDataSource(String query) throws DeploymentException {
        if (this.ds == null) {
            String dsName = null;
            try {
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ((Hashtable)p).put("domain", "true");
                InitialContext naming = new InitialContext(p);
                dsName = this.schema.getDBProperties().getDataSourceName();
                this.ds = (DataSource)naming.lookup("ejbContainer/cmp/tx/" + this.applicationName + "/" + dsName);
            }
            catch (NamingException n) {
                throw new EJBDeploymentException("ejb_2426", new String[]{query, dsName}, n);
            }
        }
        return this.ds;
    }

    private CMPEntityDescriptor checkResultType(CMPEntityDescriptor thisDescr, FinderDescriptor finderDescr, ResultDescriptor firstResultDescriptor) throws DeploymentException {
        if (firstResultDescriptor.isObjectRepresentation()) {
            String selectedBeanName = firstResultDescriptor.getEjbName();
            finderDescr.setSelectedAbstractSchemaName(selectedBeanName);
            CMPEntityDescriptor selectedBeanDescr = this.getSelectedBeanDescr(selectedBeanName, thisDescr, finderDescr);
            if (finderDescr.isSelect()) {
                this.checkReturnTypeOfCmrSelectMethod(finderDescr, selectedBeanDescr);
            }
            return selectedBeanDescr;
        }
        if (!finderDescr.isSelect()) {
            throw new EJBDeploymentException("ejb_2427", new String[]{finderDescr.getQuery()});
        }
        if (firstResultDescriptor.isBean()) {
            String selectedBeanName = firstResultDescriptor.getEjbName();
            finderDescr.setSelectedAbstractSchemaName(selectedBeanName);
            String selectedFiledName = firstResultDescriptor.getEjbFieldName();
            PersistentField cmpField = this.getSelectedCmpField(finderDescr, thisDescr, selectedBeanName, selectedFiledName);
            finderDescr.setSelectedField(cmpField);
            this.checkReturnTypeOfCmpSelectMethod(finderDescr, cmpField.getFieldType());
        } else {
            int jdbcType = firstResultDescriptor.getJdbcType();
            Class aggFunctionClass = this.checkReturnTypeOfAggSelectMethod(finderDescr, jdbcType);
            finderDescr.setAggFunctionClass(aggFunctionClass);
        }
        return null;
    }

    private void checkReturnTypeOfCmrSelectMethod(FinderDescriptor finderDescr, CMPEntityDescriptor selectedBeanDescr) throws DeploymentException {
        String returnType = finderDescr.getReturnType();
        if (!returnType.equals("java.util.Collection") && !returnType.equals("java.util.Set")) {
            String returnedInterface = null;
            returnedInterface = finderDescr.isLocal() ? selectedBeanDescr.getLocalInterface() : selectedBeanDescr.getRemoteInterface();
            if (returnedInterface == null || !returnedInterface.equals(returnType)) {
                throw new EJBDeploymentException("ejb_2428", new String[]{finderDescr.getQuery(), returnedInterface, returnType});
            }
        }
    }

    private void checkReturnTypeOfCmpSelectMethod(FinderDescriptor finderDescr, String fieldType) throws DeploymentException {
        String returnType = finderDescr.getReturnType();
        if (!(returnType.equals("java.util.Collection") || returnType.equals("java.util.Set") || fieldType.equals(returnType))) {
            throw new EJBDeploymentException("ejb_2428", new String[]{finderDescr.getQuery(), fieldType, returnType});
        }
    }

    private Class checkReturnTypeOfAggSelectMethod(FinderDescriptor finderDescr, int jdbcType) throws DeploymentException {
        String returnType = finderDescr.getReturnType();
        Class defualtClass = CommonTypes.defaultMapping((int)jdbcType);
        if (!defualtClass.getName().equals(returnType)) {
            throw new EJBDeploymentException("ejb_2428", new String[]{finderDescr.getQuery(), defualtClass.getName(), returnType});
        }
        return defualtClass;
    }

    private PersistentField getSelectedCmpField(FinderDescriptor finderDescr, CMPEntityDescriptor thisDescr, String selectedBeanName, String selectedFiledName) throws DeploymentException {
        CMPEntityDescriptor selectedBeanDescr = this.getSelectedBeanDescr(selectedBeanName, thisDescr, finderDescr);
        PersistentField selectedCmp = this.findSelectedCmpField(selectedBeanDescr, selectedFiledName);
        String returnType = finderDescr.getReturnType();
        if (!(returnType.equals("java.util.Collection") || returnType.equals("java.util.Set") || selectedCmp.getFieldType().equals(returnType))) {
            throw new EJBDeploymentException("ejb_2428", new String[]{finderDescr.getQuery(), selectedCmp.getFieldType(), returnType});
        }
        return selectedCmp;
    }

    private PersistentField findSelectedCmpField(CMPEntityDescriptor selectedBeanDescr, String selectedFieldName) {
        PersistentField[] pkCmp = selectedBeanDescr.getPKCmpFields();
        int j = 0;
        while (j < pkCmp.length) {
            if (pkCmp[j].getFieldName().equals(selectedFieldName)) {
                return pkCmp[j];
            }
            ++j;
        }
        PersistentField[] notPKCmp = selectedBeanDescr.getCmpFields();
        int j2 = 0;
        while (j2 < notPKCmp.length) {
            if (notPKCmp[j2].getFieldName().equals(selectedFieldName)) {
                return notPKCmp[j2];
            }
            ++j2;
        }
        return null;
    }

    private CMPEntityDescriptor getSelectedBeanDescr(String selectedBeanName, CMPEntityDescriptor thisDescr, FinderDescriptor fDecsr) throws DeploymentException {
        if (fDecsr.isSelect()) {
            AbstractSchema schema = this.jarDescr.getAbstractSchema();
            return schema.getDescriptorByAbstractSchemaName(selectedBeanName);
        }
        if (!thisDescr.getAbstractSchemaName().equals(selectedBeanName)) {
            throw new EJBDeploymentException("ejb_2428", new String[]{fDecsr.getQuery(), selectedBeanName, thisDescr.getAbstractSchemaName()});
        }
        return thisDescr;
    }

    private void checkOpenSQLCompatibility(FinderDescriptor fDescr, SQLMappingResult sqlMapping) throws DeploymentException, SQLMappingException {
        if (sqlMapping.isStatementDatabaseDependent()) {
            fDescr.setIsStatementDBDependent(true);
            String warningMessage = "QL query: " + fDescr.getQuery() + " is database dependent. It may not work on some database systems.";
            if (sqlMapping.isDatabaseVendorRequired()) {
                int vendorId = this.schema.getDBProperties().getDBVendorId();
                if (vendorId == -1) {
                    vendorId = this.getConnectionVendorId(fDescr.getQuery());
                    if (vendorId != -1) {
                        sqlMapping.setDatabaseVendor(vendorId);
                    } else {
                        throw new EJBDeploymentException("ejb_2421", new String[]{fDescr.getQuery()});
                    }
                }
                warningMessage = warningMessage + " It intends to work on " + NativeSQLAccess.getVendorName((int)vendorId) + " database.";
            }
            this.warnings.add(warningMessage);
        }
    }
}

