/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors.orMapping;

import com.sap.engine.interfaces.ejb.orMapping.BeanORMapping;
import com.sap.engine.interfaces.ejb.orMapping.CMRInfo;
import com.sap.engine.interfaces.ejb.orMapping.SchemaORMapping;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.BeanORMappingImpl;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.DumpUtils;
import java.util.Hashtable;

public class SchemaORMappingImpl
implements SchemaORMapping {
    private AbstractSchema schema = null;
    private BeanORMapping[] beansORMapping = null;
    private Hashtable ejbBeanNameToItsORMapping = null;
    private Hashtable schemaBeanNameToItsORMapping = null;

    public SchemaORMappingImpl(AbstractSchema schema) {
        this.schema = schema;
    }

    public BeanORMapping[] getAllBeansORMapping() {
        this.init();
        return this.beansORMapping;
    }

    public BeanORMapping getBeanORMapping(String schemaBeanName) {
        this.init();
        return (BeanORMapping)this.schemaBeanNameToItsORMapping.get(schemaBeanName);
    }

    public BeanORMapping getBeanORMappingByEJBName(String ejbName) {
        this.init();
        return (BeanORMapping)this.ejbBeanNameToItsORMapping.get(ejbName);
    }

    public CMRInfo[] getRelations(String schemaBeanName) {
        return this.getBeanORMapping(schemaBeanName).getRelations();
    }

    public int getDBVendorId() {
        return this.schema.getDBProperties().getDBVendorId();
    }

    public String display() {
        StringBuffer strBuff = new StringBuffer("SchemaORMappingImpl");
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("    ********Beans****: ");
        strBuff.append(DumpUtils.arrayOfObjectsToString(this.getAllBeansORMapping()));
        strBuff.append(DumpUtils.lSeparator);
        return strBuff.toString();
    }

    public String toString() {
        StringBuffer strBuff = new StringBuffer("SchemaORMappingImpl, beans: ");
        BeanORMapping[] beans = this.getAllBeansORMapping();
        int i = 0;
        while (i < beans.length) {
            strBuff.append(beans[i].toString());
            strBuff.append(";  ");
            ++i;
        }
        return strBuff.toString();
    }

    private void init() {
        CMPEntityDescriptor[] descr = null;
        Object mapping = null;
        if (this.ejbBeanNameToItsORMapping == null) {
            this.ejbBeanNameToItsORMapping = new Hashtable();
            this.schemaBeanNameToItsORMapping = new Hashtable();
            descr = this.schema.getDescriptors();
            this.beansORMapping = new BeanORMappingImpl[descr.length];
            int i = 0;
            while (i < descr.length) {
                this.beansORMapping[i] = new BeanORMappingImpl(descr[i], this.schema);
                this.ejbBeanNameToItsORMapping.put(descr[i].getEjbName(), this.beansORMapping[i]);
                this.schemaBeanNameToItsORMapping.put(descr[i].getAbstractSchemaName(), this.beansORMapping[i]);
                ++i;
            }
        }
    }
}

