/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;

public class MessageDrivenDescriptor
extends DeploymentDescriptor {
    private int transactionType = -1;
    private String messageSelector = null;
    private String acknowledgeMode = null;
    private String subscriptionDurability = null;
    private String destinationType = null;
    private String messagingType;
    private String resourceAdapterName;

    public Object clone() {
        MessageDrivenDescriptor descr = (MessageDrivenDescriptor)super.clone();
        descr.transactionType = this.transactionType;
        descr.setMessageSelector(this.messageSelector == null ? null : new String(this.messageSelector));
        descr.setAcknowledgeMode(this.acknowledgeMode == null ? null : new String(this.acknowledgeMode));
        descr.setSubscriptionDurability(this.subscriptionDurability == null ? null : new String(this.subscriptionDurability));
        descr.setDestinationType(this.destinationType == null ? null : new String(this.destinationType));
        return descr;
    }

    public boolean equals(Object obj) {
        MessageDrivenDescriptor descr = null;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageDrivenDescriptor)) {
            return false;
        }
        if (!super.equals((DeploymentDescriptor)obj)) {
            return false;
        }
        descr = (MessageDrivenDescriptor)obj;
        if (this.transactionType != descr.getTransactionType()) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.messageSelector, descr.getMessageSelector())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.acknowledgeMode, descr.getAcknowledgeMode())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.subscriptionDurability, descr.getSubscriptionDurability())) {
            return false;
        }
        return EqualUtils.equalObjects(this.destinationType, descr.getDestinationType());
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String aMode) {
        this.acknowledgeMode = aMode;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String message_selector) {
        this.messageSelector = message_selector;
    }

    public String getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(String subscription_durability) {
        this.subscriptionDurability = subscription_durability;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destination_type) {
        this.destinationType = destination_type;
    }

    public void setTransactionType(int transactionType) {
        this.transactionType = transactionType;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionDescriptors(ControlDescriptor[] trans) {
        if (trans == null) {
            this.transactionDescriptors = null;
            return;
        }
        if (trans.length > 0 && this.transactionType == 0) {
            throw new BaseIllegalArgumentException("ejb_2182", new Object[]{this.getEjbName()});
        }
        int i = 0;
        while (i < trans.length) {
            if (trans[i].getTransactionAttribute() != 0 && trans[i].getTransactionAttribute() != 2) {
                throw new BaseIllegalArgumentException("ejb_2183", new Object[]{this.getEjbName(), trans[i].getTxName()});
            }
            ++i;
        }
        super.setTransactionDescriptors(trans);
    }

    public String getRuntimeClassName() {
        if (this.messagingType == null || this.messagingType.equals("")) {
            return this.runtimeClassName + this.useIndex[4] + "Extension";
        }
        return this.runtimeClassName + this.useIndex[4] + "JCAExtension";
    }

    public String getBootClassName() {
        if (this.messagingType == null || this.messagingType.equals("")) {
            return this.runtimeClassName + this.useIndex[4] + "Container";
        }
        return this.runtimeClassName + this.useIndex[4] + "JCAContainer";
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public void setMessagingType(String _messagingType) {
        this.messagingType = _messagingType;
    }

    public String getResourceAdapterName() {
        return this.resourceAdapterName;
    }

    public void setResourceAdapterName(String _resourceAdapterName) {
        this.resourceAdapterName = _resourceAdapterName;
    }
}

