/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;

public class EJBJarDescriptor
extends ArchiveDescriptor
implements Serializable {
    private String inqmyDescription = null;
    private AbstractSchema abstractSchema = new AbstractSchema();
    private DeploymentDescriptor[] descriptors = null;
    private String clientJarName = null;
    private String jarName = null;
    private String relationshipsDescription = null;
    private String excludeListDescription = null;
    private SecurityRoles[] securityRoles = null;
    private int jarIndex = 0;

    public void setJarName(String _jarName) {
        this.jarName = _jarName;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getInqmyDescription() {
        return this.inqmyDescription;
    }

    public void setInqmyDescription(String descr) {
        this.inqmyDescription = descr;
    }

    public String getExcludeListDescription() {
        return this.excludeListDescription;
    }

    public void setExcludeListDescription(String descr) {
        this.excludeListDescription = descr;
    }

    public SerializableFile getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String larIcon) {
        this.largeIcon = larIcon != null ? new SerializableFile(larIcon) : null;
    }

    public SerializableFile getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smIcon) {
        this.smallIcon = smIcon != null ? new SerializableFile(smIcon) : null;
    }

    public SecurityRoles[] getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRoles[] _securityRoles) {
        this.securityRoles = _securityRoles;
    }

    public Descriptor[] getDescriptors() {
        return this.descriptors;
    }

    public DeploymentDescriptor[] getDDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(DeploymentDescriptor[] descrs) {
        this.descriptors = descrs;
        if (descrs != null) {
            Vector<DeploymentDescriptor> cmpEntityDescrs = new Vector<DeploymentDescriptor>();
            int i = 0;
            while (i < this.descriptors.length) {
                this.descriptors[i].setEJBJarDescriptor(this);
                if (this.descriptors[i] instanceof CMPEntityDescriptor) {
                    cmpEntityDescrs.add(this.descriptors[i]);
                }
                ++i;
            }
            this.abstractSchema.setDescriptors(cmpEntityDescrs.toArray(new CMPEntityDescriptor[0]));
        }
    }

    public void loadFromFile(String s) {
    }

    public void loadFromDocument(Document s) {
    }

    public Document getAsDocument() {
        return null;
    }

    public String saveToFile(String fileName) {
        return null;
    }

    public void setDescriptors(Descriptor[] d) {
        DeploymentDescriptor[] tempDD;
        if (d != null) {
            tempDD = new DeploymentDescriptor[d.length];
            int i = 0;
            while (i < d.length) {
                tempDD[i] = d[i] != null ? (DeploymentDescriptor)d[i] : null;
                ++i;
            }
        } else {
            tempDD = null;
        }
        this.setDescriptors(tempDD);
    }

    public Descriptor getDescriptor(String ss) {
        if (this.descriptors != null) {
            int i = 0;
            while (i < this.descriptors.length) {
                if (this.descriptors[i].getEjbName().equals(ss)) {
                    return this.descriptors[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void distributeSecurityRoles(SecurityRoles[] sec_roles) {
        this.securityRoles = sec_roles;
        if (this.securityRoles == null) {
            return;
        }
        int i = 0;
        while (i < this.descriptors.length) {
            Hashtable roleRefs = this.descriptors[i].getRoleReferences();
            if (roleRefs == null) break;
            Enumeration enumeration = roleRefs.elements();
            block1: while (enumeration.hasMoreElements()) {
                SecurityRoleReference roleRef = (SecurityRoleReference)enumeration.nextElement();
                String roleName = null;
                roleName = roleRef.getRoleLink() == null ? roleRef.getRoleName() : roleRef.getRoleLink().getRoleName();
                int k = 0;
                while (k < this.securityRoles.length) {
                    if (this.securityRoles[k].getRoleName().equals(roleName)) {
                        roleRef.setRoleLink(this.securityRoles[k]);
                        continue block1;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void distributeCorrectControlDescriptors(ControlDescriptor[] ctrlDescriptors) {
        int i = 0;
        while (i < this.descriptors.length) {
            String tempEjbName = this.descriptors[i].getEjbName();
            Vector<ControlDescriptor> tempctrlDescr = new Vector<ControlDescriptor>();
            int c = 0;
            while (c < ctrlDescriptors.length) {
                if (ctrlDescriptors[c].getMethodEntry().getEjbName().equals(tempEjbName)) {
                    tempctrlDescr.add(ctrlDescriptors[c]);
                }
                ++c;
            }
            try {
                this.descriptors[i].setTransactionDescriptors(tempctrlDescr.toArray(new ControlDescriptor[0]));
            }
            catch (IllegalArgumentException iae) {
                this.descriptors[i].setTransactionDescriptors(new ControlDescriptor[0]);
            }
            ++i;
        }
    }

    public void distributeControlDescriptors(ControlDescriptor[] ctrlDescriptors) {
        int i = 0;
        while (i < this.descriptors.length) {
            String tempEjbName = this.descriptors[i].getEjbName();
            Vector<ControlDescriptor> tempctrlDescr = new Vector<ControlDescriptor>();
            int c = 0;
            while (c < ctrlDescriptors.length) {
                if (ctrlDescriptors[c].getMethodEntry().getEjbName().equals(tempEjbName)) {
                    tempctrlDescr.add(ctrlDescriptors[c]);
                }
                ++c;
            }
            this.descriptors[i].setTransactionDescriptors(tempctrlDescr.toArray(new ControlDescriptor[0]));
            ++i;
        }
    }

    public void distributeAccessControls(AccessControls[] accessControls) {
        int i = 0;
        while (i < this.descriptors.length) {
            String tempEjbName = this.descriptors[i].getEjbName();
            Vector<AccessControls> tempAccControls = new Vector<AccessControls>();
            int y = 0;
            while (y < accessControls.length) {
                if (accessControls[y].getMethod().getEjbName().equals(tempEjbName)) {
                    tempAccControls.add(accessControls[y]);
                }
                ++y;
            }
            Object[] accessArray = new AccessControls[tempAccControls.size()];
            tempAccControls.copyInto(accessArray);
            this.descriptors[i].setAccessControlEntries((AccessControls[])accessArray);
            ++i;
        }
    }

    public void distributeExcludeList(MethodEntry[] excludeList) {
        int i = 0;
        while (i < this.descriptors.length) {
            String tempEjbName = this.descriptors[i].getEjbName();
            Vector<MethodEntry> tempMethods = new Vector<MethodEntry>();
            int y = 0;
            while (y < excludeList.length) {
                if (excludeList[y].getEjbName().equals(tempEjbName)) {
                    tempMethods.add(excludeList[y]);
                }
                ++y;
            }
            Object[] result = new MethodEntry[tempMethods.size()];
            tempMethods.copyInto(result);
            this.descriptors[i].setUncalableMethods((MethodEntry[])result);
            ++i;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AbstractSchema getAbstractSchema() {
        return this.abstractSchema;
    }

    public void setAbstractSchema(AbstractSchema abstractSchema) {
        this.abstractSchema = abstractSchema;
    }

    public String getClientJarName() {
        if (this.clientJarName == null || this.clientJarName.equals("")) {
            this.clientJarName = "client" + this.jarName;
        }
        return this.clientJarName;
    }

    public void setClientJarName(String clientJarName) {
        this.clientJarName = clientJarName;
    }

    public String getRelationshipsDescription() {
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String relationshipsDescription) {
        this.relationshipsDescription = relationshipsDescription;
    }

    public int getJarIndex() {
        return this.jarIndex;
    }

    public void setJarIndex(int jar_index) {
        this.jarIndex = jar_index;
        this.abstractSchema.setIndex(this.jarIndex);
    }

    public boolean hasMDBs() {
        if (this.descriptors == null) {
            return false;
        }
        int i = 0;
        while (i < this.descriptors.length) {
            if (this.descriptors[i] instanceof MessageDrivenDescriptor) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object clone() {
        SecurityRoles[] tempSR;
        DeploymentDescriptor[] tempDD;
        EJBJarDescriptor ejbJD = new EJBJarDescriptor();
        ejbJD.setDescription(this.description == null ? null : new String(this.description));
        ejbJD.setDisplayName(this.displayName == null ? null : new String(this.displayName));
        if (this.smallIcon != null && this.smallIcon.getAbsoluteFilePath() != null) {
            ejbJD.setSmallIcon(this.smallIcon.getAbsoluteFilePath());
        } else {
            ejbJD.setSmallIcon((String)null);
        }
        if (this.largeIcon != null && this.largeIcon.getAbsoluteFilePath() != null) {
            ejbJD.setLargeIcon(this.largeIcon.getAbsoluteFilePath());
        } else {
            ejbJD.setLargeIcon((String)null);
        }
        ejbJD.setWebServiceRelated(this.webServiceRelated);
        ejbJD.setWebServiceObject(this.webServiceObject);
        ejbJD.setInqmyDescription(this.inqmyDescription == null ? null : new String(this.inqmyDescription));
        if (this.abstractSchema != null) {
            ejbJD.setAbstractSchema((AbstractSchema)this.abstractSchema.clone());
        } else {
            ejbJD.setAbstractSchema(null);
        }
        if (this.descriptors != null) {
            tempDD = new DeploymentDescriptor[this.descriptors.length];
            int i = 0;
            while (i < this.descriptors.length) {
                tempDD[i] = this.descriptors[i] != null ? (DeploymentDescriptor)this.descriptors[i].clone() : null;
                ++i;
            }
        } else {
            tempDD = null;
        }
        ejbJD.setDescriptors(tempDD);
        ejbJD.setClientJarName(this.clientJarName == null ? null : new String(this.clientJarName));
        ejbJD.setJarName(this.jarName == null ? null : new String(this.jarName));
        ejbJD.setRelationshipsDescription(this.relationshipsDescription == null ? null : new String(this.relationshipsDescription));
        ejbJD.setExcludeListDescription(this.excludeListDescription == null ? null : new String(this.excludeListDescription));
        if (this.securityRoles != null) {
            tempSR = new SecurityRoles[this.securityRoles.length];
            int i = 0;
            while (i < this.securityRoles.length) {
                tempSR[i] = this.securityRoles[i] != null ? (SecurityRoles)this.securityRoles[i].clone() : null;
                ++i;
            }
        } else {
            tempSR = null;
        }
        ejbJD.setSecurityRoles(tempSR);
        ejbJD.setLoaded(this.isLoaded());
        ejbJD.setJarIndex(this.jarIndex);
        return ejbJD;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EJBJarDescriptor)) {
            return false;
        }
        EJBJarDescriptor ejbJD = (EJBJarDescriptor)obj;
        if (!EqualUtils.equalObjects(this.inqmyDescription, ejbJD.getInqmyDescription())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.abstractSchema, ejbJD.getAbstractSchema())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.descriptors, ejbJD.getDDescriptors())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getClientJarName(), ejbJD.getClientJarName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.jarName, ejbJD.getJarName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.relationshipsDescription, ejbJD.getRelationshipsDescription())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.excludeListDescription, ejbJD.getExcludeListDescription())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.securityRoles, ejbJD.getSecurityRoles())) {
            return false;
        }
        if (this.jarIndex != ejbJD.getJarIndex()) {
            return false;
        }
        return this.isLoaded() == ejbJD.isLoaded();
    }

    public SecurityRoles getSecurityRole(String name) {
        if (name == null) {
            return null;
        }
        if (this.securityRoles == null) {
            return null;
        }
        int i = 0;
        while (i < this.securityRoles.length) {
            if (this.securityRoles[i].getName().equals(name)) {
                return this.securityRoles[i];
            }
            ++i;
        }
        return null;
    }
}

