/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.CloneUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.deploy.tools.sql.MultipleSetInfo;
import com.sap.engine.services.ejb.deploy.tools.sql.SetInfo;
import com.sap.engine.services.ejb.util.AdminUtils;

public class DependentValueDescriptor
extends PersistentField {
    private String[] valueFieldNames = null;
    private String[] valueFieldTypes = null;
    private int[] posInSt = null;
    private transient Class[] valueFieldClasses = null;

    public DependentValueDescriptor() {
        this.setDV(true);
        this.setMultipleDV(true);
    }

    public int[] getPosInSt() {
        return this.posInSt;
    }

    public void setPosInSt(int[] _posInSt) {
        this.posInSt = _posInSt;
    }

    public String[] getValueFieldNames() {
        return this.valueFieldNames;
    }

    public void setValueFieldNames(String[] valueFieldNames) {
        this.valueFieldNames = valueFieldNames;
    }

    public String[] getValueFieldTypes() {
        return this.valueFieldTypes;
    }

    public void setValueFieldTypes(String[] valueFieldTypes) {
        this.valueFieldTypes = valueFieldTypes;
    }

    public Class[] getValueFieldClasses() {
        return this.valueFieldClasses;
    }

    public void setValueFieldClasses(Class[] valueFieldClasses) {
        this.valueFieldClasses = valueFieldClasses;
    }

    public MultipleSetInfo getMultipleSetInfo() throws DeploymentException {
        String[] setMethods = this.getDVSetMethod(this.posInSt);
        String[] setNull = this.getDVSetNull(this.posInSt);
        SetInfo[] subfield = new SetInfo[setMethods.length];
        int k = 0;
        while (k < setMethods.length) {
            subfield[k] = new SetInfo();
            subfield[k].setFieldName(this.fieldName + "." + this.valueFieldNames[k]);
            subfield[k].setSetObject(setMethods[k]);
            if (!AdminUtils.isPrimitiveType((String)this.valueFieldTypes[k])) {
                subfield[k].setSetNull(setNull[k]);
            }
            ++k;
        }
        MultipleSetInfo tempMultipleSet = new MultipleSetInfo();
        tempMultipleSet.setFieldName(this.fieldName);
        tempMultipleSet.setSetNull(setNull);
        tempMultipleSet.setSetSubfields(subfield);
        return tempMultipleSet;
    }

    public void specifyMyPosition(String column, int pos) {
        String[] dvColumnName = ((RDependentValueMap)this.fieldDBMap).getDvColumnName();
        int i = 0;
        while (i < dvColumnName.length) {
            if (dvColumnName[i].equals(column)) {
                if (this.posInSt == null) {
                    this.posInSt = new int[dvColumnName.length];
                }
                this.posInSt[i] = pos;
                break;
            }
            ++i;
        }
    }

    public Object clone() {
        DependentValueDescriptor clonning = (DependentValueDescriptor)super.clone();
        clonning.setValueFieldNames(CloneUtils.cloneStringArray(this.valueFieldNames));
        clonning.setValueFieldTypes(CloneUtils.cloneStringArray(this.valueFieldTypes));
        if (this.posInSt == null) {
            clonning.setPosInSt(null);
        } else {
            int[] clonedPosInSt = new int[this.posInSt.length];
            System.arraycopy(this.posInSt, 0, clonedPosInSt, 0, this.posInSt.length);
            clonning.setPosInSt(clonedPosInSt);
        }
        return clonning;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DependentValueDescriptor)) {
            return false;
        }
        DependentValueDescriptor second = (DependentValueDescriptor)obj;
        if (!EqualUtils.equalUnOrderedArrays(this.valueFieldNames, second.getValueFieldNames())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.valueFieldTypes, second.getValueFieldTypes())) {
            return false;
        }
        return EqualUtils.equalOrderedArrays(this.posInSt, second.getPosInSt());
    }

    private String[] getDVSetMethod(int[] pos) throws DeploymentException {
        String[] dvColumnName = ((RDependentValueMap)this.fieldDBMap).getDvColumnName();
        int[] dvColumnType = ((RDependentValueMap)this.fieldDBMap).getDvColumnType();
        String[] setMethod = new String[dvColumnName.length];
        int i = 0;
        while (i < dvColumnName.length) {
            setMethod[i] = Mappings.getSetMethod(dvColumnType[i], this.valueFieldClasses[i], pos[i], this.fieldName + "." + this.valueFieldNames[i]);
            ++i;
        }
        return setMethod;
    }

    private String[] getDVSetNull(int[] pos) {
        String[] dvColumnName = ((RDependentValueMap)this.fieldDBMap).getDvColumnName();
        int[] dvColumnType = ((RDependentValueMap)this.fieldDBMap).getDvColumnType();
        String[] setMethod = new String[dvColumnName.length];
        int i = 0;
        while (i < dvColumnName.length) {
            setMethod[i] = Mappings.getSetNull(dvColumnType[i], pos[i]);
            ++i;
        }
        return setMethod;
    }
}

