/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;

public class ControlDescriptor
implements Serializable,
Cloneable {
    public static final int TX_NOT_SUPPORTED = 0;
    public static final int TX_NEVER = 1;
    public static final int TX_REQUIRED = 2;
    public static final int TX_SUPPORTS = 3;
    public static final int TX_REQUIRES_NEW = 4;
    public static final int TX_MANDATORY = 5;
    public static final int TX_EMPTY = -1;
    public static final int ISOLATION_LEVEL_EMPTY = -1;
    private int transactionAttribute = -1;
    private int isolationLevel = -1;
    private MethodEntry method = null;
    private String description = null;

    public ControlDescriptor(MethodEntry meth) {
        this.method = meth;
    }

    public ControlDescriptor(String description, MethodEntry method, String transAttr) {
        if (transAttr.equals("NotSupported")) {
            this.transactionAttribute = 0;
        } else if (transAttr.equals("Supports")) {
            this.transactionAttribute = 3;
        } else if (transAttr.equals("Required")) {
            this.transactionAttribute = 2;
        } else if (transAttr.equals("RequiresNew")) {
            this.transactionAttribute = 4;
        } else if (transAttr.equals("Mandatory")) {
            this.transactionAttribute = 5;
        } else if (transAttr.equals("Never")) {
            this.transactionAttribute = 1;
        } else {
            throw new BaseIllegalArgumentException("ejb_2173", new Object[]{transAttr});
        }
        if (description != null && !description.equals("")) {
            this.description = description;
        }
        this.method = method;
    }

    public Object clone() {
        ControlDescriptor descr = new ControlDescriptor(this.method == null ? null : (MethodEntry)this.method.clone());
        descr.setDescription(this.description == null ? null : new String(this.description));
        descr.isolationLevel = this.isolationLevel;
        descr.transactionAttribute = this.transactionAttribute;
        return descr;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ControlDescriptor)) {
            return false;
        }
        ControlDescriptor descr = (ControlDescriptor)obj;
        if (!EqualUtils.equalObjects(this.method, descr.getMethodEntry())) {
            return false;
        }
        if (this.transactionAttribute != descr.getTransactionAttribute()) {
            return false;
        }
        if (this.isolationLevel != descr.getIsolationLevel()) {
            return false;
        }
        return EqualUtils.equalObjects(this.description, descr.getDescription());
    }

    public boolean equalsForUpdate(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ControlDescriptor)) {
            return false;
        }
        ControlDescriptor descr = (ControlDescriptor)obj;
        if (!EqualUtils.equalObjects(this.method, descr.getMethodEntry())) {
            return false;
        }
        if (this.transactionAttribute != descr.getTransactionAttribute()) {
            return false;
        }
        return this.isolationLevel == descr.getIsolationLevel();
    }

    public void setTransactionAttribute(int transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public int getTransactionAttribute() {
        return this.transactionAttribute;
    }

    public String getTxName() {
        if (this.transactionAttribute == 0) {
            return "NotSupported";
        }
        if (this.transactionAttribute == 3) {
            return "Supports";
        }
        if (this.transactionAttribute == 2) {
            return "Required";
        }
        if (this.transactionAttribute == 4) {
            return "RequiresNew";
        }
        if (this.transactionAttribute == 5) {
            return "Mandatory";
        }
        if (this.transactionAttribute == 1) {
            return "Never";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIsolationLevel(String isoLevel) {
        if (isoLevel == null) throw new BaseIllegalArgumentException("ejb_2174", new Object[]{null});
        if (isoLevel.equals("")) {
            this.isolationLevel = -1;
            return;
        } else if (isoLevel.equals("Committed")) {
            this.isolationLevel = 2;
            return;
        } else if (isoLevel.equals("Uncommitted")) {
            this.isolationLevel = 1;
            return;
        } else if (isoLevel.equals("Repeatable")) {
            this.isolationLevel = 4;
            return;
        } else {
            if (!isoLevel.equals("Serializable")) throw new BaseIllegalArgumentException("ejb_2174", new Object[]{isoLevel});
            this.isolationLevel = 8;
        }
    }

    public void setUncommittedIsolationLevel() {
        this.isolationLevel = 1;
    }

    public String getIsolationLevelString() {
        if (this.isolationLevel == 1) {
            return "Uncommitted";
        }
        if (this.isolationLevel == 4) {
            return "Repeatable";
        }
        if (this.isolationLevel == 8) {
            return "Serializable";
        }
        if (this.isolationLevel == 2) {
            return "Committed";
        }
        if (this.isolationLevel == -1) {
            return "";
        }
        return "";
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MethodEntry getMethodEntry() {
        return this.method;
    }

    public void setMethodEntry(MethodEntry method) {
        this.method = method;
    }
}

