/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;

public class CMPEntityDescriptor
extends EntityDescriptor {
    public static final int CMP_2_VERSION = 2;
    public static final int CMP_1_VERSION = 1;
    public static final int DEFAULT_UNKNOWN_PK_INTERVAL = 100;
    private int id = -1;
    private boolean isReadOnly = false;
    private boolean selectForUpdate = false;
    private String jarIdentifier = null;
    private String abstractSchemaName;
    private int cmpVersion = 2;
    private PersistentField[] pkCmpFields = null;
    private PersistentField[] cmpFields = null;
    private RelationField[] cmrFields = null;
    private String tableName = null;
    private FinderDescriptor[] ejbFindSelectDescriptors = null;
    private MethodEntry[] abstractCreateMethods = null;
    private int unknownPKInterval = 100;
    private int cacheSize = 0;
    private transient String primaryKeyFieldName = null;

    public CMPEntityDescriptor(EntityDescriptor ed) {
        this.init((EntityDescriptor)ed.clone());
    }

    public CMPEntityDescriptor() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean useSelectForUpdate() {
        return this.selectForUpdate;
    }

    public void setSelectForUpdate(boolean useSelectForUpdate) {
        this.selectForUpdate = useSelectForUpdate;
    }

    public String getJarIdentifier() {
        return this.jarIdentifier;
    }

    public void setJarIdentifier(String jarIdentifier) {
        this.jarIdentifier = jarIdentifier;
    }

    public String getAbstractSchemaName() {
        if (this.abstractSchemaName == null) {
            if (this.cmpVersion == 1) {
                return this.getEjbName();
            }
            BaseRuntimeException toThrow = new BaseRuntimeException("ejb_2172", new Object[]{this.getEjbName()});
            toThrow.log();
            throw toThrow;
        }
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String absName) {
        this.abstractSchemaName = absName;
    }

    public int getCmpVersion() {
        return this.cmpVersion;
    }

    public void setCmpVersion(int cmpVersion) {
        this.cmpVersion = cmpVersion;
    }

    public PersistentField[] getCmpFields() {
        return this.cmpFields;
    }

    public void setCmpFields(PersistentField[] cmpFields) {
        this.cmpFields = cmpFields;
    }

    public boolean isUnknownPK() {
        return this.getPrimaryKeyClass().equals("java.lang.Object");
    }

    public String getRealPrimaryKeyClass() {
        if (this.isUnknownPK()) {
            return "java.lang.Long";
        }
        return this.getPrimaryKeyClass();
    }

    public void addCmpField(PersistentField cmpField) {
        PersistentField[] newFields = null;
        if (this.cmpFields == null) {
            this.cmpFields = new PersistentField[1];
            this.cmpFields[0] = cmpField;
        } else {
            newFields = new PersistentField[this.cmpFields.length + 1];
            System.arraycopy(this.cmpFields, 0, newFields, 0, this.cmpFields.length);
            newFields[this.cmpFields.length] = cmpField;
            this.cmpFields = newFields;
        }
    }

    public RelationField[] getCmrFields() {
        return this.cmrFields;
    }

    public void setCmrFields(RelationField[] cmrFields) {
        this.cmrFields = cmrFields;
    }

    public int addCmrField(RelationField cmrField) {
        if (this.cmrFields == null) {
            this.cmrFields = new RelationField[1];
            this.cmrFields[0] = cmrField;
            return 0;
        }
        RelationField[] newFields = new RelationField[this.cmrFields.length + 1];
        System.arraycopy(this.cmrFields, 0, newFields, 0, this.cmrFields.length);
        newFields[this.cmrFields.length] = cmrField;
        this.cmrFields = newFields;
        return this.cmrFields.length - 1;
    }

    public FinderDescriptor[] getFinderDescriptors() {
        return this.ejbFindSelectDescriptors;
    }

    public void setFinderDescriptors(FinderDescriptor[] finderDescriptors) {
        this.ejbFindSelectDescriptors = finderDescriptors;
    }

    public PersistentField[] getPKCmpFields() {
        return this.pkCmpFields;
    }

    public void setPKCmpFields(PersistentField[] pkField) {
        this.pkCmpFields = pkField;
    }

    public void setPKFieldName(String pkField) {
        this.primaryKeyFieldName = pkField;
    }

    public String getPKFieldName() {
        return this.primaryKeyFieldName;
    }

    public String toString() {
        return "CMPEntityDescriptor " + this.getEjbName();
    }

    public MethodEntry[] getAbstractCreateMethods() {
        return this.abstractCreateMethods;
    }

    public void setAbstractCreateMethods(MethodEntry[] crMethods) {
        this.abstractCreateMethods = crMethods;
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName + this.useIndex[4] + "PM";
    }

    public String getPersistentClassName() {
        return this.runtimeClassName + this.useIndex[4] + "Persistent";
    }

    public RelationField getRelationField(int cmrId) {
        if (this.cmrFields == null || cmrId < 0 || cmrId >= this.cmrFields.length) {
            return null;
        }
        return this.cmrFields[cmrId];
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    private void init(EntityDescriptor ed) {
        this.setClassName(ed.getClassName());
        this.setRemoteInterface(ed.getRemoteInterface());
        this.setRemoteHomeInterface(ed.getRemoteHomeInterface());
        this.setLocalHomeInterface(ed.getLocalHomeInterface());
        this.setLocalInterface(ed.getLocalInterface());
        this.setEjbHomeImpl(ed.getEjbHomeImpl());
        this.setEjbLocalHomeImpl(ed.getEjbLocalHomeImpl());
        this.setEjbObjectImpl(ed.getEjbObjectImpl());
        this.setEjbLocalObjectImpl(ed.getEjbLocalObjectImpl());
        this.setUseIndex(ed.getUseIndex());
        this.setTransactionDescriptors(ed.getTransactionDescriptors());
        this.setAccessControlEntries(ed.getAccessControlEntries());
        this.setBeanProperties(ed.getBeanProperties());
        this.setEnvironmentEntries(ed.getEnvironmentEntries());
        this.setResourceReferences(ed.getResourceReferences());
        this.setResourceEnvReferences(ed.getResourceEnvReferences());
        this.setEJBeanReferences(ed.getEJBeanReferences());
        this.setEJBeanLocalReferences(ed.getEJBeanLocalReferences());
        this.setUncalableMethods(ed.getUncalableMethods());
        this.setSecurityIdentity(ed.getSecurityIdentity());
        this.setRoleReferences(ed.getRoleReferences());
        this.setJndiName(ed.getJndiName());
        this.setDisplayName(ed.getDisplayName());
        this.setEjbName(ed.getEjbName());
        this.setDescription(ed.getDescription());
        this.setContainerSize(ed.getContainerSize());
        this.setContainerBoot(ed.getContainerBoot());
        this.setSmallIcon(ed.getSmallIcon().getAbsoluteFilePath());
        this.setLargeIcon(ed.getLargeIcon().getAbsoluteFilePath());
        this.setPersistenceType(ed.getPersistenceType());
        this.setReentrant(ed.isReentrant());
        this.setPrimaryKeyClass(ed.getPrimaryKeyClass());
    }

    public Object clone() {
        int i;
        PersistentField[] pFTemp;
        PersistentField[] origPFTemp;
        CMPEntityDescriptor clonned = (CMPEntityDescriptor)super.clone();
        clonned.setId(this.getId());
        clonned.setReadOnly(this.isReadOnly());
        clonned.setSelectForUpdate(this.useSelectForUpdate());
        clonned.setJarIdentifier(this.getJarIdentifier() == null ? null : new String(this.getJarIdentifier()));
        clonned.setAbstractSchemaName(this.abstractSchemaName == null ? null : new String(this.abstractSchemaName));
        clonned.setCmpVersion(this.getCmpVersion());
        clonned.setPKFieldName(this.primaryKeyFieldName);
        if (this.getPKCmpFields() != null) {
            origPFTemp = this.getPKCmpFields();
            pFTemp = new PersistentField[origPFTemp.length];
            i = 0;
            while (i < pFTemp.length) {
                pFTemp[i] = origPFTemp[i] != null ? (PersistentField)origPFTemp[i].clone() : null;
                ++i;
            }
            clonned.setPKCmpFields(pFTemp);
        } else {
            clonned.setPKCmpFields(null);
        }
        if (this.getCmpFields() != null) {
            origPFTemp = this.getCmpFields();
            pFTemp = new PersistentField[origPFTemp.length];
            i = 0;
            while (i < pFTemp.length) {
                pFTemp[i] = origPFTemp[i] != null ? (PersistentField)origPFTemp[i].clone() : null;
                ++i;
            }
            clonned.setCmpFields(pFTemp);
        } else {
            clonned.setCmpFields(null);
        }
        if (this.getCmrFields() != null) {
            RelationField[] origRFTemp = this.getCmrFields();
            RelationField[] rFTemp = new RelationField[origRFTemp.length];
            i = 0;
            while (i < rFTemp.length) {
                rFTemp[i] = origRFTemp[i] != null ? (RelationField)origRFTemp[i].clone() : null;
                ++i;
            }
            clonned.setCmrFields(rFTemp);
        } else {
            clonned.setCmrFields(null);
        }
        clonned.setTableName(this.tableName == null ? null : new String(this.tableName));
        if (this.getFinderDescriptors() != null) {
            FinderDescriptor[] origFDTemp = this.getFinderDescriptors();
            FinderDescriptor[] fDTemp = new FinderDescriptor[origFDTemp.length];
            i = 0;
            while (i < fDTemp.length) {
                fDTemp[i] = origFDTemp[i] != null ? (FinderDescriptor)origFDTemp[i].clone() : null;
                ++i;
            }
            clonned.setFinderDescriptors(fDTemp);
        } else {
            clonned.setFinderDescriptors(null);
        }
        if (this.getAbstractCreateMethods() != null) {
            MethodEntry[] origMeTemp = this.getAbstractCreateMethods();
            MethodEntry[] meTemp = new MethodEntry[origMeTemp.length];
            i = 0;
            while (i < meTemp.length) {
                meTemp[i] = origMeTemp[i] != null ? (MethodEntry)origMeTemp[i].clone() : null;
                ++i;
            }
            clonned.setAbstractCreateMethods(meTemp);
        } else {
            clonned.setAbstractCreateMethods(null);
        }
        clonned.setCacheSize(this.getCacheSize());
        clonned.setUnknownPKInterval(this.getUnknownPKInterval());
        return clonned;
    }

    public boolean equals(Object o) {
        CMPEntityDescriptor comparable;
        block19: {
            if (!super.equals(o)) {
                return false;
            }
            if (!(o instanceof CMPEntityDescriptor)) {
                return false;
            }
            comparable = (CMPEntityDescriptor)o;
            if (this.getId() != comparable.getId()) {
                return false;
            }
            if (this.isReadOnly() != comparable.isReadOnly()) {
                return false;
            }
            if (this.useSelectForUpdate() != comparable.useSelectForUpdate()) {
                return false;
            }
            if (!EqualUtils.equalObjects(this.getJarIdentifier(), comparable.getJarIdentifier())) {
                return false;
            }
            try {
                String schemaName = this.getAbstractSchemaName();
                String schemaName2 = null;
                try {
                    schemaName2 = comparable.getAbstractSchemaName();
                }
                catch (RuntimeException re3) {
                    return false;
                }
                if (!EqualUtils.equalObjects(schemaName, schemaName2)) {
                    return false;
                }
            }
            catch (RuntimeException re) {
                if (this.checkThrowsRuntime(comparable)) break block19;
                return false;
            }
        }
        if (this.getCmpVersion() != comparable.getCmpVersion()) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getPKCmpFields(), comparable.getPKCmpFields())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getCmpFields(), comparable.getCmpFields())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getCmrFields(), comparable.getCmrFields())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.tableName, comparable.getTableName())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getFinderDescriptors(), comparable.getFinderDescriptors())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getAbstractCreateMethods(), comparable.getAbstractCreateMethods())) {
            return false;
        }
        if (this.getCacheSize() != comparable.getCacheSize()) {
            return false;
        }
        return this.getUnknownPKInterval() == comparable.getUnknownPKInterval();
    }

    private boolean checkThrowsRuntime(CMPEntityDescriptor obj) {
        try {
            obj.getAbstractSchemaName();
            return false;
        }
        catch (RuntimeException ex) {
            return true;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getUnknownPKInterval() {
        return this.unknownPKInterval;
    }

    public void setUnknownPKInterval(int unknownPKInterval) {
        this.unknownPKInterval = unknownPKInterval;
    }
}

