/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.ear.common.CloneUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import java.io.Serializable;
import java.lang.reflect.Method;

public class AccessControls
implements Serializable,
Cloneable {
    private MethodEntry method = null;
    private String[] securityRoleNames = null;
    private boolean unchecked = false;
    private String description = null;
    private int pid = Integer.MIN_VALUE;

    public AccessControls() {
    }

    public AccessControls(String description, String[] roleNames, MethodEntry methodEntr) {
        this.description = description;
        this.method = methodEntr;
        this.securityRoleNames = roleNames;
        this.unchecked = false;
    }

    public AccessControls(String description, MethodEntry methodEntr) {
        this.description = description;
        this.method = methodEntr;
        this.unchecked = true;
    }

    public void addSecurityRoles(String[] newRoleNames) {
        if (this.securityRoleNames == null) {
            this.securityRoleNames = newRoleNames;
            return;
        }
        String[] temp = new String[newRoleNames.length + this.securityRoleNames.length];
        System.arraycopy(this.securityRoleNames, 0, temp, 0, this.securityRoleNames.length);
        System.arraycopy(newRoleNames, 0, temp, this.securityRoleNames.length, newRoleNames.length);
        this.securityRoleNames = temp;
    }

    public MethodEntry getMethod() {
        return this.method;
    }

    public void setMethod(MethodEntry me) {
        this.method = me;
    }

    public boolean getUnchecked() {
        return this.unchecked;
    }

    public void setUnchecked(boolean unchecked) {
        this.unchecked = unchecked;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getMethodName() {
        return this.method.getMethodName();
    }

    public String[] getParametersType() {
        return this.method.getParameters();
    }

    public String[] getSecurityRoleNames() {
        return this.securityRoleNames;
    }

    public void setSecurityRoleNames(String[] srn) {
        this.securityRoleNames = srn;
    }

    public boolean isCompatible(MethodEntry mEntry) {
        if (mEntry == null || this.method == null) {
            return false;
        }
        if (!mEntry.getEjbName().equals(this.method.getEjbName())) {
            return false;
        }
        return this.compare(mEntry.getMethodName(), mEntry.getMethodInterface(), mEntry.getParameters());
    }

    public boolean isCompatible(Method chMethod, String interfaceName) {
        if (chMethod == null || this.method == null) {
            return false;
        }
        Class<?>[] par2 = chMethod.getParameterTypes();
        String[] params = new String[par2.length];
        int i = 0;
        while (i < par2.length) {
            params[i] = par2[i].getName();
            ++i;
        }
        return this.compare(chMethod.getName(), interfaceName, params);
    }

    private boolean compare(String name, String intfName, String[] params) {
        String[] par1 = this.method.getParameters();
        if (intfName == null ? this.method.getMethodInterface() != null : !intfName.equals(this.method.getMethodInterface())) {
            return false;
        }
        if (name.equals(this.method.getMethodName())) {
            if (par1.length != params.length) {
                return false;
            }
            int i = 0;
            while (i < par1.length) {
                if (!params[i].equals(par1[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public Object clone() {
        AccessControls clonning = new AccessControls();
        clonning.setDescription(this.description == null ? null : new String(this.description));
        clonning.setMethod(this.method == null ? null : (MethodEntry)this.method.clone());
        clonning.setPid(this.pid);
        clonning.setSecurityRoleNames(CloneUtils.cloneStringArray(this.securityRoleNames));
        clonning.unchecked = this.unchecked;
        return clonning;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AccessControls)) {
            return false;
        }
        AccessControls second = (AccessControls)obj;
        if (!EqualUtils.equalObjects(this.method, second.getMethod())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.securityRoleNames, second.getSecurityRoleNames())) {
            return false;
        }
        if (this.unchecked != second.getUnchecked()) {
            return false;
        }
        return this.pid == second.getPid() && EqualUtils.equalObjects(this.description, second.getDescription());
    }

    public boolean equalsForUpdate(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AccessControls)) {
            return false;
        }
        AccessControls second = (AccessControls)obj;
        if (!EqualUtils.equalObjects(this.method, second.getMethod())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.securityRoleNames, second.getSecurityRoleNames())) {
            return false;
        }
        return this.unchecked == second.getUnchecked();
    }
}

