/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;
import java.util.Vector;

public class AbstractSchema
implements Serializable {
    public static final int ADMINISTRATIVE_LOCKING = 0;
    public static final int TABLE_LOCKING = 1;
    public static final int LOCAL_LOCKING = 2;
    public static final int OPTIMISTIC_ID = 0;
    public static final int PESSIMISTIC_ID = 1;
    public static final String OPTIMISTIC = "Optimistic";
    public static final String PESSIMISTIC = "Pessimistic";
    private static String lSeparator = System.getProperty("line.separator");
    private transient PersistenceManager pManager;
    private transient boolean switchOffVerification = false;
    private transient boolean createTablesAtDeploy = false;
    private int lockingType = 0;
    private DataBaseProperties dbProperties = null;
    private int lockStrategy = 1;
    private CMPEntityDescriptor[] descriptors = null;
    private RelationDescriptor[] relDescriptors = null;
    private int index = 0;

    public CMPEntityDescriptor getDescriptor(String ejbName) {
        if (this.descriptors != null && ejbName != null) {
            int i = 0;
            while (i < this.descriptors.length) {
                if (ejbName.equals(this.descriptors[i].getEjbName())) {
                    return this.descriptors[i];
                }
                ++i;
            }
        }
        return null;
    }

    public CMPEntityDescriptor getDescriptor(int id) {
        return id >= 0 && id < this.descriptors.length ? this.descriptors[id] : null;
    }

    public CMPEntityDescriptor getDescriptorByAbstractSchemaName(String abstractSchemaName) {
        if (this.descriptors != null && abstractSchemaName != null) {
            int i = 0;
            while (i < this.descriptors.length) {
                if (abstractSchemaName.equals(this.descriptors[i].getAbstractSchemaName())) {
                    return this.descriptors[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void setSwitchOffVerification(boolean verify) {
        this.switchOffVerification = verify;
    }

    public boolean isVerificationSwitchedOff() {
        return this.switchOffVerification;
    }

    public void setCreateTablesAtDeploy(boolean createTables) {
        this.createTablesAtDeploy = createTables;
    }

    public boolean haveToCreateTables() {
        return this.createTablesAtDeploy;
    }

    public void setLockingType(int locking) {
        this.lockingType = locking;
    }

    public int getLockingType() {
        return this.lockingType;
    }

    public void setPersistenceManager(PersistenceManager pManager) {
        this.pManager = pManager;
    }

    public PersistenceManager getPersistenceManager() {
        return this.pManager;
    }

    public String toString() {
        StringBuffer strBuff = new StringBuffer("AbstractSchema ");
        if (this.descriptors != null) {
            int i = 0;
            while (i < this.descriptors.length) {
                strBuff.append(lSeparator);
                strBuff.append(this.descriptors[i].toString());
                ++i;
            }
        }
        return strBuff.toString();
    }

    public void setDescriptors(CMPEntityDescriptor[] pod) {
        this.descriptors = pod;
        if (this.descriptors != null) {
            int i = 0;
            while (i < this.descriptors.length) {
                if (this.descriptors[i].getId() == -1) {
                    this.descriptors[i].setId(i);
                }
                ++i;
            }
        }
    }

    public DataBaseProperties getDBProperties() {
        return this.dbProperties;
    }

    public void setDBProperties(DataBaseProperties dbProperties) {
        this.dbProperties = dbProperties;
    }

    public CMPEntityDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setLockStrategy(String strategy) {
        if (strategy.equals(OPTIMISTIC)) {
            this.lockStrategy = 0;
        } else if (strategy.equals(PESSIMISTIC)) {
            this.lockStrategy = 1;
        } else {
            throw new BaseIllegalArgumentException("ejb_2171", new Object[]{strategy, OPTIMISTIC, PESSIMISTIC});
        }
    }

    public int getLockStrategy() {
        return this.lockStrategy;
    }

    public boolean isEmpty() {
        return this.descriptors == null || this.descriptors.length == 0;
    }

    public RelationDescriptor getRelationDescriptor(int _ejbId1, int _ejbId2, String _cmrName1, String _cmrName2) {
        OneSideRelationDescriptor side1 = null;
        OneSideRelationDescriptor side2 = null;
        RelationField cmr1 = null;
        RelationField cmr2 = null;
        int ejbId1 = -1;
        int ejbId2 = -1;
        int i = 0;
        while (i < this.relDescriptors.length) {
            side1 = this.relDescriptors[i].getSide1();
            side2 = this.relDescriptors[i].getSide2();
            ejbId1 = side1.getEjbId();
            ejbId2 = side2.getEjbId();
            cmr1 = this.getDescriptor(ejbId1).getRelationField(side1.getCmrId());
            cmr2 = this.getDescriptor(ejbId2).getRelationField(side2.getCmrId());
            if (ejbId1 == _ejbId1 && ejbId2 == _ejbId2 && this.equalRelations(cmr1, cmr2, _cmrName1, _cmrName2)) {
                return this.relDescriptors[i];
            }
            if (ejbId1 == _ejbId2 && ejbId2 == _ejbId1 && this.equalRelations(cmr2, cmr1, _cmrName1, _cmrName2)) {
                return this.relDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    public RelationDescriptor[] getM2MRelationDescriptors() {
        Vector<RelationDescriptor> vRelDscrForEJB = new Vector<RelationDescriptor>();
        int i = 0;
        while (i < this.relDescriptors.length) {
            if (this.relDescriptors[i].getM2MMap() != null) {
                vRelDscrForEJB.addElement(this.relDescriptors[i]);
            }
            ++i;
        }
        return vRelDscrForEJB.toArray(new RelationDescriptor[vRelDscrForEJB.size()]);
    }

    public RelationDescriptor[] getRelationDescriptors(int _ejbId) {
        if (this.relDescriptors == null) {
            return new RelationDescriptor[0];
        }
        Vector<RelationDescriptor> vRelDscrForEJB = new Vector<RelationDescriptor>();
        int ejbId1 = -1;
        int ejbId2 = -1;
        int i = 0;
        while (i < this.relDescriptors.length) {
            ejbId1 = this.relDescriptors[i].getSide1().getEjbId();
            ejbId2 = this.relDescriptors[i].getSide2().getEjbId();
            if (ejbId1 == _ejbId || ejbId2 == _ejbId) {
                vRelDscrForEJB.addElement(this.relDescriptors[i]);
            }
            ++i;
        }
        return vRelDscrForEJB.toArray(new RelationDescriptor[vRelDscrForEJB.size()]);
    }

    public RelationDescriptor[] getRelationsWithNotNullCmrField(int _ejbId) {
        Vector<RelationDescriptor> vRelDscrForEJB = new Vector<RelationDescriptor>();
        int ejbId1 = -1;
        int ejbId2 = -1;
        int i = 0;
        while (i < this.relDescriptors.length) {
            OneSideRelationDescriptor side1 = this.relDescriptors[i].getSide1();
            OneSideRelationDescriptor side2 = this.relDescriptors[i].getSide2();
            ejbId1 = side1.getEjbId();
            ejbId2 = side2.getEjbId();
            if (ejbId1 == _ejbId && side1.cmrId != -1 || ejbId2 == _ejbId && side2.cmrId != -1) {
                vRelDscrForEJB.addElement(this.relDescriptors[i]);
            }
            ++i;
        }
        return vRelDscrForEJB.toArray(new RelationDescriptor[vRelDscrForEJB.size()]);
    }

    public RelationDescriptor getRelDescriptor(int relationId) {
        if (relationId < 0 || this.relDescriptors == null || relationId > this.relDescriptors.length) {
            return null;
        }
        return this.relDescriptors[relationId];
    }

    public RelationDescriptor[] getRelDescriptors() {
        return this.relDescriptors;
    }

    public void setRelDescriptors(RelationDescriptor[] relDescriptors) {
        this.relDescriptors = relDescriptors;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int id) {
        this.index = id;
    }

    public boolean useSelectForUpdate() {
        int i = 0;
        while (i < this.descriptors.length) {
            if (this.descriptors[i].useSelectForUpdate()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object clone() {
        int i;
        AbstractSchema clonning = new AbstractSchema();
        clonning.setDBProperties(this.dbProperties != null ? (DataBaseProperties)this.dbProperties.clone() : null);
        clonning.lockStrategy = this.lockStrategy;
        if (this.descriptors != null) {
            CMPEntityDescriptor[] desc = new CMPEntityDescriptor[this.descriptors.length];
            i = 0;
            while (i < this.descriptors.length) {
                desc[i] = this.descriptors[i] == null ? null : (CMPEntityDescriptor)this.descriptors[i].clone();
                ++i;
            }
            clonning.setDescriptors(desc);
        } else {
            clonning.setDescriptors(null);
        }
        clonning.setIndex(this.index);
        if (this.relDescriptors != null) {
            RelationDescriptor[] rel = new RelationDescriptor[this.relDescriptors.length];
            i = 0;
            while (i < this.relDescriptors.length) {
                rel[i] = this.relDescriptors[i] == null ? null : (RelationDescriptor)this.relDescriptors[i].clone();
                ++i;
            }
            clonning.setRelDescriptors(rel);
        } else {
            clonning.setRelDescriptors(null);
        }
        clonning.switchOffVerification = this.switchOffVerification;
        clonning.createTablesAtDeploy = this.createTablesAtDeploy;
        clonning.lockingType = this.lockingType;
        return clonning;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractSchema)) {
            return false;
        }
        AbstractSchema second = (AbstractSchema)obj;
        if (this.index != second.getIndex() || this.lockStrategy != second.getLockStrategy()) {
            return false;
        }
        if (this.dbProperties != null ? !this.dbProperties.equals(second.getDBProperties()) : second.getDBProperties() != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.descriptors, second.getDescriptors())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.relDescriptors, second.getRelDescriptors())) {
            return false;
        }
        if (this.switchOffVerification != second.switchOffVerification) {
            return false;
        }
        if (this.createTablesAtDeploy != second.createTablesAtDeploy) {
            return false;
        }
        return this.lockingType == second.lockingType;
    }

    public boolean equalsForUpdate(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractSchema)) {
            return false;
        }
        AbstractSchema second = (AbstractSchema)obj;
        if (this.index != second.getIndex() || this.lockStrategy != second.getLockStrategy()) {
            return false;
        }
        if (this.dbProperties != null ? !this.dbProperties.equals(second.getDBProperties()) : second.getDBProperties() != null) {
            return false;
        }
        return EqualUtils.equalUnOrderedArrays(this.descriptors, second.getDescriptors());
    }

    private boolean equalRelations(RelationField cmr1, RelationField cmr2, String _cmrName1, String _cmrName2) {
        if (cmr1 != null && cmr2 == null) {
            return _cmrName1 != null && _cmrName1.equals(cmr1.getFieldName()) && _cmrName2 == null;
        }
        if (cmr1 == null && cmr2 != null) {
            return _cmrName2 != null && _cmrName2.equals(cmr2.getFieldName()) && _cmrName1 == null;
        }
        return _cmrName1 != null && _cmrName1.equals(cmr1.getFieldName()) && _cmrName2 != null && _cmrName2.equals(cmr2.getFieldName());
    }
}

