/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.admintool;

import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLGeneratorException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLPersistentGenerator {
    public static final String UTF8 = "UTF-8";
    public static final String dtd = " <!DOCTYPE persistent-ejb-map SYSTEM \".\\dtd\\persistent.dtd \" >";
    private Document mainDocument = null;

    public void generateXml(EJBJarDescriptor ejbjarDescriptor, String fileName) throws DeploymentException {
        this.generateDocument(ejbjarDescriptor);
        try {
            new StandardDOMWriter().write(this.mainDocument, fileName, dtd, UTF8);
        }
        catch (IOException ioe) {
            throw new EJBXMLGeneratorException("ejb_2313", (Throwable)ioe);
        }
    }

    public Document generateDocument(EJBJarDescriptor ejbjarDescriptor) throws DeploymentException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Thread.currentThread().setContextClassLoader(cl);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcfe) {
            throw new EJBXMLGeneratorException("ejb_2321", (Throwable)pcfe);
        }
        this.mainDocument = builder.newDocument();
        Element persMap = this.mainDocument.createElement("persistent-ejb-map");
        this.mainDocument.appendChild(persMap);
        AbstractSchema abstractSchema = ejbjarDescriptor.getAbstractSchema();
        if (abstractSchema.isVerificationSwitchedOff()) {
            Element switchOffVerify = this.mainDocument.createElement("switch-off-verification");
            persMap.appendChild(switchOffVerify);
        }
        if (abstractSchema.haveToCreateTables()) {
            Element createTablesEl = this.mainDocument.createElement("create-tables-at-deploy");
            persMap.appendChild(createTablesEl);
        }
        Element lockingEl = this.mainDocument.createElement("locking");
        int lockingTypeId = abstractSchema.getLockingType();
        String lockingType = this.getStringLockingType(lockingTypeId);
        lockingEl.setAttribute("type", lockingType);
        persMap.appendChild(lockingEl);
        DataBaseProperties dbProperties = abstractSchema.getDBProperties();
        Element dbPropertiesEl = this.generateDBProps(dbProperties);
        persMap.appendChild(dbPropertiesEl);
        Element entityBeans = this.mainDocument.createElement("entity-beans");
        persMap.appendChild(entityBeans);
        CMPEntityDescriptor[] entityDescriptors = abstractSchema.getDescriptors();
        int i = 0;
        while (i < entityDescriptors.length) {
            Element entityBeanMap = this.generateEntityBean(entityDescriptors[i]);
            entityBeans.appendChild(entityBeanMap);
            ++i;
        }
        Element relationships = this.mainDocument.createElement("relationships");
        persMap.appendChild(relationships);
        RelationDescriptor[] relations = abstractSchema.getRelDescriptors();
        if (relations != null) {
            int i2 = 0;
            while (i2 < relations.length) {
                Element tableRelation = this.generateTableRelation(relations[i2], abstractSchema);
                relationships.appendChild(tableRelation);
                ++i2;
            }
        }
        return this.mainDocument;
    }

    private String getStringLockingType(int type) {
        switch (type) {
            case 1: {
                return "Table";
            }
            case 2: {
                return "Local";
            }
        }
        return "Administrative";
    }

    private Element generateEntityBean(CMPEntityDescriptor entityDescriptor) {
        Element entityBeanMap = this.mainDocument.createElement("entity-bean");
        this.load(entityBeanMap, entityDescriptor.getEjbName(), "ejb-name");
        this.load(entityBeanMap, entityDescriptor.getTableName(), "table-name");
        PersistentField[] pkCmpFields = entityDescriptor.getPKCmpFields();
        int j = 0;
        while (j < pkCmpFields.length) {
            Element cmpFieldElement = this.generateCmpMap(pkCmpFields[j]);
            entityBeanMap.appendChild(cmpFieldElement);
            ++j;
        }
        PersistentField[] cmpFields = entityDescriptor.getCmpFields();
        int j2 = 0;
        while (j2 < cmpFields.length) {
            Element cmpFieldElement = this.generateCmpMap(cmpFields[j2]);
            entityBeanMap.appendChild(cmpFieldElement);
            ++j2;
        }
        FinderDescriptor[] finderDescriptors = entityDescriptor.getFinderDescriptors();
        if (finderDescriptors != null) {
            int j3 = 0;
            while (j3 < finderDescriptors.length) {
                String sqlCriteria = finderDescriptors[j3].getSQLStatement();
                if (entityDescriptor.getCmpVersion() != 2 || sqlCriteria != null && !sqlCriteria.equals("")) {
                    Element finderElement = this.mainDocument.createElement("finder-descriptor");
                    entityBeanMap.appendChild(finderElement);
                    this.load(finderElement, finderDescriptors[j3].getSQLStatement(), "criteria");
                    this.load(finderElement, finderDescriptors[j3].getMethodName(), "method-name");
                    Element paramsEl = this.mainDocument.createElement("method-params");
                    finderElement.appendChild(paramsEl);
                    String[] params = finderDescriptors[j3].getParamsTypes();
                    int p = 0;
                    while (p < params.length) {
                        this.load(paramsEl, params[p], "method-param");
                        ++p;
                    }
                    if (!finderDescriptors[j3].getStoringMode()) {
                        Element mode = this.mainDocument.createElement("switch-off-storing");
                        finderElement.appendChild(mode);
                    }
                    if (finderDescriptors[j3].toLoadSelectedObjects()) {
                        Element loadEl = this.mainDocument.createElement("load-selected-objects");
                        String lockMode = finderDescriptors[j3].getLockMode();
                        if (lockMode != null) {
                            loadEl.setAttribute("lock", lockMode);
                        }
                        finderElement.appendChild(loadEl);
                    }
                    if (!finderDescriptors[j3].getLazyLoading()) {
                        Element lazyLoadingEl = this.mainDocument.createElement("lazy-loading");
                        finderElement.appendChild(lazyLoadingEl);
                    }
                    if (finderDescriptors[j3].getFetchSize() != 0) {
                        this.load(finderElement, String.valueOf(finderDescriptors[j3].getFetchSize()), "fetch-size");
                    }
                    if (finderDescriptors[j3].isQLVersion2_1()) {
                        Element ql21 = this.mainDocument.createElement("ql-2.1-compatible");
                        finderElement.appendChild(ql21);
                    }
                }
                ++j3;
            }
        }
        if (entityDescriptor.isReadOnly()) {
            Element readOnlyElement = this.mainDocument.createElement("read-only");
            entityBeanMap.appendChild(readOnlyElement);
        }
        if (entityDescriptor.useSelectForUpdate()) {
            Element selectForUpdElement = this.mainDocument.createElement("select-for-update");
            entityBeanMap.appendChild(selectForUpdElement);
        }
        return entityBeanMap;
    }

    private Element generateCmpMap(PersistentField cmp) {
        Element cmpFieldElement = this.mainDocument.createElement("field-map");
        this.load(cmpFieldElement, cmp.getFieldName(), "field-name");
        RPersistentFieldMap fieldDBMap = cmp.getFieldDBMap();
        if (fieldDBMap instanceof RDependentValueMap) {
            RDependentValueMap dv = (RDependentValueMap)fieldDBMap;
            String[] subfields = ((DependentValueDescriptor)cmp).getValueFieldNames();
            int k = 0;
            while (k < dv.getDvColumnName().length) {
                Element cmpColumnElement = this.mainDocument.createElement("dv-column");
                this.load(cmpColumnElement, subfields[k], "subfield-name");
                cmpFieldElement.appendChild(cmpColumnElement);
                this.load(cmpColumnElement, dv.getDvColumnName()[k], "column-name");
                ++k;
            }
        } else {
            Element cmpColumnElement = this.mainDocument.createElement("column");
            cmpFieldElement.appendChild(cmpColumnElement);
            this.load(cmpColumnElement, fieldDBMap.getColumnName(), "column-name");
        }
        if (cmp.isMutable()) {
            Element mutableElement = this.mainDocument.createElement("mutable");
            cmpFieldElement.appendChild(mutableElement);
        }
        cmpFieldElement.setAttribute("key-type", this.intToStringKeyMap(fieldDBMap.getKey()));
        return cmpFieldElement;
    }

    private Element generateDBProps(DataBaseProperties dbProperties) {
        Element dbPropertiesEl = this.mainDocument.createElement("db-properties");
        this.load(dbPropertiesEl, dbProperties.getDataSourceName(), "data-source-name");
        if (dbProperties.getDBVendorId() != -1) {
            Element dbVendorEl = this.mainDocument.createElement("database-vendor");
            dbVendorEl.setAttribute("name", dbProperties.getDBVendorName());
            dbPropertiesEl.appendChild(dbVendorEl);
        }
        return dbPropertiesEl;
    }

    private Element generateTableRelation(RelationDescriptor relation, AbstractSchema schema) {
        boolean manyToMany;
        Element tableRelation = this.mainDocument.createElement("table-relation");
        M2MRelationFieldMap m2mMap = relation.getM2MMap();
        boolean bl = manyToMany = m2mMap != null;
        if (manyToMany) {
            this.load(tableRelation, m2mMap.getHelpTable(), "help-table");
        }
        Element tableRelationshipRole1 = this.mainDocument.createElement("table-relationship-role");
        tableRelation.appendChild(tableRelationshipRole1);
        OneSideRelationDescriptor side1 = relation.getSide1();
        CMPEntityDescriptor descr1 = schema.getDescriptor(side1.getEjbId());
        PersistentField[] pk1 = descr1.getPKCmpFields();
        OneSideRelationDescriptor side2 = relation.getSide2();
        CMPEntityDescriptor descr2 = schema.getDescriptor(side2.getEjbId());
        PersistentField[] pk2 = descr2.getPKCmpFields();
        this.createOneSideOfRelation(tableRelationshipRole1, side1, schema, pk2, manyToMany);
        Element tableRelationshipRole2 = this.mainDocument.createElement("table-relationship-role");
        tableRelation.appendChild(tableRelationshipRole2);
        this.createOneSideOfRelation(tableRelationshipRole2, side2, schema, pk1, manyToMany);
        if (manyToMany) {
            String[] foreignKeyColumns1 = m2mMap.getColumns1();
            this.createFkColumnElements(tableRelationshipRole1, foreignKeyColumns1, pk1);
            String[] foreignKeyColumns2 = m2mMap.getColumns2();
            this.createFkColumnElements(tableRelationshipRole2, foreignKeyColumns2, pk2);
        }
        return tableRelation;
    }

    private void createFkColumnElements(Element tableRelationshipRole1, String[] fkColumns, PersistentField[] refPkFields) {
        int i = 0;
        while (i < fkColumns.length) {
            Element fkColumnEl = this.mainDocument.createElement("fk-column");
            this.load(fkColumnEl, fkColumns[i], "column-name");
            this.load(fkColumnEl, refPkFields[i].getFieldName(), "pk-field-name");
            tableRelationshipRole1.appendChild(fkColumnEl);
            ++i;
        }
    }

    private Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String intToStringKeyMap(int i) {
        switch (i) {
            case 1: {
                return "PrimaryKey";
            }
            case 2: {
                return "ForeignKey";
            }
            case 3: {
                return "UniqueKey";
            }
        }
        return "NoKey";
    }

    private void createOneSideOfRelation(Element tableRelationshipRole, OneSideRelationDescriptor side, AbstractSchema schema, PersistentField[] refPkFields, boolean manyToMany) {
        String[] columns;
        CMPEntityDescriptor descr = schema.getDescriptor(side.getEjbId());
        this.load(tableRelationshipRole, descr.getEjbName(), "ejb-name");
        if (side.getCmrId() != -1) {
            this.load(tableRelationshipRole, descr.getRelationField(side.getCmrId()).getFieldName(), "cmr-field");
        }
        RRelationFieldMap sideMap = side.getFieldDBMap();
        tableRelationshipRole.setAttribute("key-type", this.intToStringKeyMap(sideMap.getKey()));
        if (!manyToMany && (columns = sideMap.getColumn()) != null) {
            this.createFkColumnElements(tableRelationshipRole, columns, refPkFields);
        }
    }
}

