/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.admintool;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class RMappingTool11 {
    private static final String STORAGE = "Storage";
    private static final String ENTITYEJB = "EntityEJB";
    private static final String RDBSTORAGEPROPS = "RDBStorageProps";
    private static final String TABLENAME = "TableName";
    private static final String KEY = "Key";
    private static final String COLUMN = "Column";
    private static final String FIELD = "Field";
    private static final String FIELDCOLUMNMAP = "FieldColumnMap";
    private static final String POOLNAME = "PoolName";
    private static final String RDBFINDERDSCR = "rdbFinderDescriptor";
    private static final String METHODNAME = "MethodName";
    private static final String METHODARG = "MethodArgument";
    private static final String NAME = "Name";
    private static final String CRITERIA = "Criteria";
    private CMPEntityDescriptor[] descriptors11 = null;
    private EJBJarDescriptor ejbJar = null;
    private String poolName = null;

    public void setEJBJarDscr(EJBJarDescriptor ejbJar) {
        if (!ejbJar.equals(this.ejbJar)) {
            this.descriptors11 = null;
            this.ejbJar = ejbJar;
        }
    }

    public void readXML(String xmlName) throws IOException, SAXException, DeploymentException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        StandardDOMParser parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
        Document doc = parser.parse(xmlName);
        this.scanDocument(doc);
    }

    public void readXML(InputStream xmlStream) throws IOException, SAXException, DeploymentException {
        this.readXML(xmlStream, null, null);
    }

    public void readXML(InputStream xmlStream, String dbVendor) throws IOException, SAXException, DeploymentException {
        this.readXML(xmlStream, dbVendor, null);
    }

    public void readXML(InputStream xmlStream, String dbVendor, String dsName) throws IOException, SAXException, DeploymentException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        StandardDOMParser parser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
        Document doc = parser.parse(xmlStream);
        this.scanDocument(doc);
        xmlStream.close();
        AbstractSchema schema = this.ejbJar.getAbstractSchema();
        schema.setSwitchOffVerification(true);
        DataBaseProperties dbProps = new DataBaseProperties();
        if (dsName == null) {
            dbProps.setDataSourceName(this.poolName);
        } else {
            dbProps.setDataSourceName(dsName);
        }
        if (dbVendor != null) {
            dbProps.setDBVendorName(dbVendor);
        }
        schema.setDBProperties(dbProps);
        schema.setCreateTablesAtDeploy(dbProps.getDBVendorId() != -1);
    }

    private void scanDocument(Document doc) throws DeploymentException {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName(ENTITYEJB);
        int i = 0;
        while (i < nl.getLength()) {
            Element ejb = (Element)nl.item(i);
            CMPEntityDescriptor dscr = this.getDescriptor(ejb.getAttribute(NAME));
            this.scanEntityEJB(ejb, dscr);
            ++i;
        }
    }

    private void scanEntityEJB(Element ejb, CMPEntityDescriptor dscr) throws DeploymentException {
        PersistentField[] pkCmp = dscr.getPKCmpFields();
        PersistentField[] cmp = dscr.getCmpFields();
        String keyStr = null;
        String fieldName = null;
        int pos = -1;
        NodeList storageList = ejb.getElementsByTagName(STORAGE);
        Element storage = (Element)storageList.item(0);
        NodeList rDBStoragePropsList = storage.getElementsByTagName(RDBSTORAGEPROPS);
        Element rDBStorageProps = (Element)rDBStoragePropsList.item(0);
        if (this.poolName == null) {
            this.poolName = rDBStorageProps.getAttribute(POOLNAME);
        }
        dscr.setTableName(rDBStorageProps.getAttribute(TABLENAME));
        NodeList columnList = rDBStorageProps.getElementsByTagName(FIELDCOLUMNMAP);
        RPersistentFieldMap fieldDBMap = null;
        int k = 0;
        while (k < columnList.getLength()) {
            Element column = (Element)columnList.item(k);
            fieldName = column.getAttribute(FIELD);
            pos = this.getPosInArray(cmp, fieldName);
            if (pos > -1) {
                fieldDBMap = new RPersistentFieldMap();
                fieldDBMap.setColumnName(column.getAttribute(COLUMN));
                if (cmp[pos].getFieldClass() != null) {
                    fieldDBMap.setColumnType(Mappings.getDefaultSqlTypeForJavaType(cmp[pos].getFieldClass()));
                }
                keyStr = column.getAttribute(KEY).trim();
                fieldDBMap.setKey(Integer.parseInt(keyStr));
                cmp[pos].setFieldDBMap(fieldDBMap);
            } else {
                pos = this.getPosInArray(pkCmp, fieldName);
                if (pos > -1) {
                    fieldDBMap = new RPersistentFieldMap();
                    fieldDBMap.setColumnName(column.getAttribute(COLUMN));
                    if (pkCmp[pos].getFieldClass() != null) {
                        fieldDBMap.setColumnType(Mappings.getDefaultSqlTypeForJavaType(pkCmp[pos].getFieldClass()));
                    }
                    keyStr = column.getAttribute(KEY).trim();
                    fieldDBMap.setKey(1);
                    pkCmp[pos].setFieldDBMap(fieldDBMap);
                }
            }
            ++k;
        }
        this.fillDBMap(pkCmp);
        this.fillDBMap(cmp);
        NodeList finderDescriptorList = rDBStorageProps.getElementsByTagName(RDBFINDERDSCR);
        FinderDescriptor[] finderDescriptor = new FinderDescriptor[finderDescriptorList.getLength()];
        Element findDscr = null;
        int k2 = 0;
        while (k2 < finderDescriptorList.getLength()) {
            findDscr = (Element)finderDescriptorList.item(k2);
            finderDescriptor[k2] = new FinderDescriptor();
            finderDescriptor[k2].setRemote();
            finderDescriptor[k2].setMethodName(findDscr.getAttribute(METHODNAME));
            NodeList nodeList = findDscr.getElementsByTagName(METHODARG);
            String[] paramsType = new String[nodeList.getLength()];
            int i = 0;
            while (i < paramsType.length) {
                paramsType[i] = this.getElementText((Element)nodeList.item(i));
                ++i;
            }
            finderDescriptor[k2].setParamsTypes(paramsType);
            String sqlCriteria = findDscr.getAttribute(CRITERIA);
            int index = sqlCriteria.indexOf(36);
            while (index > 0) {
                sqlCriteria = sqlCriteria.substring(0, index) + "?" + sqlCriteria.substring(index + 1);
                index = sqlCriteria.indexOf(36);
            }
            if (sqlCriteria.equals("")) {
                finderDescriptor[k2].setSQLStatement("select * from " + dscr.getTableName());
            } else if (sqlCriteria.toLowerCase().startsWith("select")) {
                finderDescriptor[k2].setSQLStatement(sqlCriteria);
            } else {
                finderDescriptor[k2].setSQLStatement("select * from " + dscr.getTableName() + " where " + sqlCriteria);
            }
            ++k2;
        }
        dscr.setFinderDescriptors(finderDescriptor);
    }

    private void fillDBMap(PersistentField[] cmp) {
        int k = 0;
        while (k < cmp.length) {
            if (cmp[k].getFieldDBMap() == null) {
                RPersistentFieldMap fieldDBMap = new RPersistentFieldMap();
                fieldDBMap.setColumnName(cmp[k].getFieldName());
                fieldDBMap.setKey(1);
                cmp[k].setFieldDBMap(fieldDBMap);
            }
            ++k;
        }
    }

    private CMPEntityDescriptor getDescriptor(String ejbName) throws DeploymentException {
        int i;
        DeploymentDescriptor[] descriptors = null;
        Vector<DeploymentDescriptor> vDscriprtors11 = null;
        if (this.descriptors11 == null) {
            descriptors = this.ejbJar.getDDescriptors();
            vDscriprtors11 = new Vector<DeploymentDescriptor>();
            i = 0;
            while (i < descriptors.length) {
                if (descriptors[i] instanceof CMPEntityDescriptor && ((CMPEntityDescriptor)descriptors[i]).getCmpVersion() == 1) {
                    vDscriprtors11.addElement(descriptors[i]);
                }
                ++i;
            }
            this.descriptors11 = vDscriprtors11.toArray(new CMPEntityDescriptor[vDscriprtors11.size()]);
        }
        i = 0;
        while (i < this.descriptors11.length) {
            if (ejbName.equals(this.descriptors11[i].getEjbName())) {
                return this.descriptors11[i];
            }
            ++i;
        }
        throw new EJBXMLParserException("ejb_2404", new String[]{this.ejbJar.getJarName(), ejbName});
    }

    private String getElementText(Element el) {
        NodeList nodeList = null;
        Node node = null;
        nodeList = el.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                StandardDOMParser.trimWhiteSpaces((Node)node);
                if (!Symbols.isWhitespace((String)((Text)node).getData())) {
                    return ((Text)node).getData();
                }
            }
            ++i;
        }
        return "";
    }

    private int getPosInArray(PersistentField[] cmp, String field) {
        int i = 0;
        while (i < cmp.length) {
            if (field.equals(cmp[i].getFieldName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

