/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.admintool;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.deploy.tools.sql.dbtypes.DBMapper;

public class RMappingTool {
    private static final String UNDERSCORE = "_";
    private AbstractSchema schema = null;
    private int maxTableNameLength = -1;

    public RMappingTool(AbstractSchema schema, String dsName, String dbVendor) throws DeploymentException {
        schema.setSwitchOffVerification(true);
        DataBaseProperties db = new DataBaseProperties();
        db.setDataSourceName(dsName);
        if (dbVendor != null) {
            db.setDBVendorName(dbVendor);
        }
        schema.setDBProperties(db);
        if (db.getDBVendorId() == -1) {
            schema.setCreateTablesAtDeploy(false);
            this.maxTableNameLength = 30;
        } else {
            this.maxTableNameLength = DBMapper.getDBVendorMappings(db.getDBVendorId(), null).getMaxTableNameLength();
            schema.setCreateTablesAtDeploy(true);
        }
        this.schema = schema;
    }

    public RMappingTool(AbstractSchema schema) throws DeploymentException {
        this(schema, "defaultDSName", null);
    }

    public void createSchemaMapping() throws DeploymentException {
        RelationDescriptor[] relDscr = null;
        if (this.schema == null || this.schema.isEmpty()) {
            return;
        }
        CMPEntityDescriptor[] descriptors = this.schema.getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            this.createRPersistentMap(descriptors[i]);
            ++i;
        }
        relDscr = this.schema.getRelDescriptors();
        this.createRelationMapping(this.schema.getRelDescriptors());
    }

    public void createRPersistentMap(CMPEntityDescriptor dscr) throws DeploymentException {
        dscr.setTableName(this.generateTableName(dscr.getEjbName(), dscr.getId()));
        this.createPersistentMapping(dscr.getCmpFields(), 0);
        this.createPersistentMapping(dscr.getPKCmpFields(), 1);
    }

    private void createPersistentMapping(PersistentField[] cmp, int fieldKeyType) throws DeploymentException {
        RPersistentFieldMap dbMap = null;
        int i = 0;
        while (i < cmp.length) {
            if (cmp[i] instanceof DependentValueDescriptor) {
                dbMap = new RDependentValueMap();
                ((RDependentValueMap)dbMap).setDvColumnName(this.addIndex(((DependentValueDescriptor)cmp[i]).getValueFieldNames()));
                Class[] sufFieldClasses = ((DependentValueDescriptor)cmp[i]).getValueFieldClasses();
                if (sufFieldClasses != null) {
                    int[] dvColumnType = new int[sufFieldClasses.length];
                    int j = 0;
                    while (j < sufFieldClasses.length) {
                        dvColumnType[j] = Mappings.getDefaultSqlTypeForJavaType(sufFieldClasses[j]);
                        ++j;
                    }
                    ((RDependentValueMap)dbMap).setDvColumnType(dvColumnType);
                }
            } else {
                dbMap = new RPersistentFieldMap();
                dbMap.setColumnName(cmp[i].getFieldName() + "_0");
                if (cmp[i].getFieldClass() != null) {
                    dbMap.setColumnType(Mappings.getDefaultSqlTypeForJavaType(cmp[i].getFieldClass()));
                }
            }
            dbMap.setKey(fieldKeyType);
            cmp[i].setFieldDBMap(dbMap);
            ++i;
        }
    }

    public void createRelationMapping(RelationDescriptor[] schemaRelations) {
        RRelationFieldMap dbMap1 = null;
        RRelationFieldMap dbMap2 = null;
        OneSideRelationDescriptor side1 = null;
        OneSideRelationDescriptor side2 = null;
        M2MRelationFieldMap m2m = null;
        Object refPKFields = null;
        String[] column = null;
        String ejbName1 = null;
        String ejbName2 = null;
        int m2mRelId = 0;
        if (schemaRelations == null) {
            return;
        }
        int i = 0;
        while (i < schemaRelations.length) {
            side1 = schemaRelations[i].getSide1();
            side2 = schemaRelations[i].getSide2();
            if (side1.getFieldDBMap() == null) {
                if (side1.getMultiplicityType() == 3) {
                    dbMap1 = this.generateFKSideMap(side2, 0, i);
                    dbMap2 = new RRelationFieldMap();
                    dbMap2.setKey(1);
                } else if (side1.getMultiplicityType() == 2) {
                    dbMap2 = this.generateFKSideMap(side1, 0, i);
                    dbMap1 = new RRelationFieldMap();
                    dbMap1.setKey(1);
                } else if (side1.getMultiplicityType() == 1) {
                    if (side1.getCmrId() == -1) {
                        dbMap2 = this.generateFKSideMap(side1, 0, i);
                        dbMap1 = new RRelationFieldMap();
                        dbMap1.setKey(1);
                    } else {
                        dbMap1 = this.generateFKSideMap(side2, 0, i);
                        dbMap2 = new RRelationFieldMap();
                        dbMap2.setKey(1);
                    }
                } else if (side1.getMultiplicityType() == 4) {
                    dbMap1 = new RRelationFieldMap();
                    dbMap1.setKey(1);
                    dbMap2 = new RRelationFieldMap();
                    dbMap2.setKey(1);
                    m2m = new M2MRelationFieldMap(m2mRelId++);
                    column = this.generateM2MFKColumnMap(side1, i);
                    m2m.setColumns1(column);
                    column = this.generateM2MFKColumnMap(side2, i);
                    m2m.setColumns2(column);
                    ejbName1 = this.schema.getDescriptor(side1.getEjbId()).getEjbName();
                    ejbName2 = this.schema.getDescriptor(side2.getEjbId()).getEjbName();
                    m2m.setHelpTable(ejbName1 + UNDERSCORE + ejbName2 + UNDERSCORE + i);
                    schemaRelations[i].setM2MMap(m2m);
                }
                side1.setFieldDBMap(dbMap1);
                side2.setFieldDBMap(dbMap2);
            }
            ++i;
        }
    }

    private String[] generateM2MFKColumnMap(OneSideRelationDescriptor refPKSide, int relationId) {
        RRelationFieldMap dbMap = new RRelationFieldMap();
        PersistentField[] refPKFields = this.schema.getDescriptor(refPKSide.getEjbId()).getPKCmpFields();
        String[] column = new String[refPKFields.length];
        int j = 0;
        while (j < column.length) {
            column[j] = refPKFields[j].getFieldDBMap().getColumnName() + UNDERSCORE + refPKSide.getEjbId() + UNDERSCORE + relationId;
            ++j;
        }
        return column;
    }

    private RRelationFieldMap generateFKSideMap(OneSideRelationDescriptor refPKSide, int fkType, int relationId) {
        RRelationFieldMap dbMap = new RRelationFieldMap();
        PersistentField[] refPKFields = this.schema.getDescriptor(refPKSide.getEjbId()).getPKCmpFields();
        String[] column = new String[refPKFields.length];
        int j = 0;
        while (j < column.length) {
            column[j] = refPKFields[j].getFieldDBMap().getColumnName() + UNDERSCORE + relationId;
            ++j;
        }
        dbMap.setKey(fkType);
        dbMap.setColumn(column);
        return dbMap;
    }

    private String generateTableName(String ejbName, int ejbId) {
        String tableName = ejbName + ejbId;
        if (tableName.length() > this.maxTableNameLength) {
            tableName = tableName.substring(tableName.length() - this.maxTableNameLength);
            while (this.isDigit(tableName.charAt(0))) {
                tableName = tableName.substring(1);
            }
        }
        return tableName;
    }

    private String[] addIndex(String[] oldArr) {
        String[] newArr = new String[oldArr.length];
        int i = 0;
        while (i < oldArr.length) {
            newArr[i] = oldArr[i] + UNDERSCORE + i;
            ++i;
        }
        return newArr;
    }

    private boolean isDigit(char ch) {
        return ch == '_' || ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9';
    }
}

