/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy;

import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.interfaces.cross.CrossGenerationData;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.UpdateSecurityContext;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.interfaces.security.resource.ResourceHandle;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.ejbql.QLTranslator;
import com.sap.engine.services.ejb.deploy.enhancer.EntityEnhancer;
import com.sap.engine.services.ejb.deploy.verifier.Verifier;
import com.sap.engine.services.ejb.deploy.xml.EJBJarParser;
import com.sap.engine.services.ejb.deploy.xml.InqmyEjbParser;
import com.sap.engine.services.ejb.deploy.xml.PersistentParser;
import com.sap.engine.services.ejb.deploy.xml.XMLEntityGenerator;
import com.sap.engine.services.ejb.deploy.xml.XMLMessageGenerator;
import com.sap.engine.services.ejb.deploy.xml.XMLPmGenerator;
import com.sap.engine.services.ejb.deploy.xml.XMLSessionGenerator;
import com.sap.engine.services.ejb.exceptions.deployment.EJBConfigurationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileGenerationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import com.sap.engine.services.ejb.util.AdminUtils;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class DeployAdmin {
    private static final String METHOD_GENERATE = "generate(...)";
    private static final String XML_EJB_JAR = "ejb-jar.xml";
    private static final String XML_PERSISTENT = "persistent.xml";
    private static final String XML_EJB_J2EE_ENGINE = "ejb-j2ee-engine.xml";
    private static final String COMPILER_PATH = "CompilerPath";
    public static final String GEN_JAR_PREFIX = "gen_";
    private static final char sepChar = File.separatorChar;
    private static final char pathSep = File.pathSeparatorChar;
    private static final String[] sesStatefulRemoteXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/session/stateful/objectimpl.xsl", "com/sap/engine/services/ejb/deploy/xsl/session/stateful/homeimpl.xsl"};
    private static final String[] sesStatefulLocalXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/session/stateful/localobjectimpl.xsl", "com/sap/engine/services/ejb/deploy/xsl/session/stateful/localhomeimpl.xsl"};
    private static final String[] sesStatelessRemoteXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/session/stateless/objectimpl.xsl", "com/sap/engine/services/ejb/deploy/xsl/session/stateless/homeimpl.xsl"};
    private static final String[] sesStatelessLocalXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/session/stateless/localobjectimpl.xsl", "com/sap/engine/services/ejb/deploy/xsl/session/stateless/localhomeimpl.xsl"};
    private static final String[] entityRemoteXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/entity/objectImpl.xsl", "com/sap/engine/services/ejb/deploy/xsl/entity/homeImpl.xsl"};
    private static final String[] entityLocalXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/entity/localObjectImpl.xsl", "com/sap/engine/services/ejb/deploy/xsl/entity/localHomeImpl.xsl"};
    private static final String[] pmXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/pm/beanpersistent.xsl", "com/sap/engine/services/ejb/deploy/xsl/pm/beanPM.xsl", "com/sap/engine/services/ejb/deploy/xsl/pm/RObeanpersistent.xsl", "com/sap/engine/services/ejb/deploy/xsl/pm/RObeanPM.xsl", "com/sap/engine/services/ejb/deploy/xsl/pm/beanpersistentM2M.xsl"};
    private static final String[] messageXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/message/messageExtension.xsl", "com/sap/engine/services/ejb/deploy/xsl/message/messageContainer.xsl"};
    private static final String[] JCAMessageXsls = new String[]{"com/sap/engine/services/ejb/deploy/xsl/message/messageExtensionJCA.xsl", "com/sap/engine/services/ejb/deploy/xsl/message/messageContainerJCA.xsl"};
    private Environment environment = null;
    private LoadContext loadContext = null;
    private ClassLoader ejbServiceLoader = null;
    private TransformerFactory factory = null;
    private Properties transformerProps = null;
    private HashSet crossClassPath = null;
    private HashSet mainClassPath = null;
    private Location ejbLocation = null;
    private int tempIndex = 0;

    public DeployAdmin(Environment _environment) {
        this.environment = _environment;
        this.loadContext = this.environment.getCoreContext().getLoadContext();
        this.ejbServiceLoader = this.loadContext.getClassLoader("service:ejb");
        this.transformerProps = new Properties();
        this.transformerProps.setProperty("omit-xml-declaration", "yes");
        this.transformerProps.setProperty("indent", "no");
        SystemMonitor monitor = this.environment.getSystemMonitor();
        this.mainClassPath = new HashSet();
        this.crossClassPath = new HashSet();
        String compilerPathProperty = this.environment.getServiceProperties().getProperty(COMPILER_PATH);
        if (compilerPathProperty != null) {
            this.mainClassPath.add(compilerPathProperty);
        }
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getService("iiop").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getService("p4").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getService("ejb").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getService("timeout").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getService("deploy").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getService("connector").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("ejblocking").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("ejbcomponent").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("ejbserialization").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("security").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("cross").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("webservices").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("container").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("transactionext").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("resourceset_api").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getInterface("resourcecontext_api").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getLibrary("ejb20").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getLibrary("jms").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getLibrary("mail").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getLibrary("opensql").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getLibrary("add_ejb").getJars());
        AdminUtils.addJarsForClasspath((HashSet)this.mainClassPath, (String[])monitor.getLibrary("j2eeca").getJars());
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "frame.jar");
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "iq-lib.jar");
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "util.jar");
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "exception.jar");
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "logging.jar");
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "jta.jar");
        this.mainClassPath.add("." + sepChar + "bin" + sepChar + "system" + sepChar + "jdbc20.jar");
        this.crossClassPath.addAll(this.mainClassPath);
        this.ejbLocation = EJBResourceAccessor.location;
    }

    public void generate(File[] jars, InputStream[] altDDStreams, ApplicationDescriptor applicationDescriptor, ClassLoader earLoader, String[] remSupp, Configuration securityConfig, Vector warnings) throws DeploymentException {
        String applicationName = applicationDescriptor.getName();
        String appRootDir = null;
        try {
            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_GENERATE}, ioe);
        }
        File appDir = new File(appRootDir);
        appDir.mkdirs();
        File applicationJars = new File(appDir, "applicationjars");
        applicationJars.mkdirs();
        File jarsDir = new File(appDir, "jars");
        jarsDir.mkdirs();
        EJBJarDescriptor[] ejbjarDescriptors = new EJBJarDescriptor[jars.length];
        SecurityContext securityContext = this.environment.getSecurityContext();
        SecurityContext[] jarSecurityContexts = new SecurityContext[jars.length];
        int j = 0;
        while (j < jars.length) {
            String jarName = jars[j].getName();
            Configuration jarSecurityConfig = null;
            try {
                jarSecurityConfig = securityConfig.createSubConfiguration(jarName);
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2128", new Object[]{METHOD_GENERATE, applicationName}, (Throwable)((Object)ce));
            }
            ModificationContext modificationContext = securityContext.getModificationContext();
            SecurityContext mySecContext = modificationContext.beginModifications(jarSecurityConfig);
            String policyConfigurationName = applicationName + "*" + jarName;
            SecurityContext oldPolicyConfigCtx = mySecContext.getPolicyConfigurationContext(policyConfigurationName);
            if (oldPolicyConfigCtx != null) {
                mySecContext.unregisterPolicyConfiguration(policyConfigurationName);
            }
            mySecContext.registerPolicyConfiguration(policyConfigurationName);
            jarSecurityContexts[j] = mySecContext.getPolicyConfigurationContext(policyConfigurationName);
            ejbjarDescriptors[j] = this.parseSingleJar(jars[j], altDDStreams[j], warnings, earLoader, applicationName, true, jarSecurityContexts[j], false, null);
            ejbjarDescriptors[j].setJarIndex(j);
            ++j;
        }
        applicationDescriptor.setEJBJarDescriptors(ejbjarDescriptors);
        Verifier.check(applicationDescriptor, earLoader, warnings);
        this.translateQL(applicationName, ejbjarDescriptors, earLoader, warnings);
        String[] appClassPaths = this.makeCompilerClassPaths(applicationName, earLoader, warnings);
        String appMainClassPath = appClassPaths[0];
        String appCrossClassPath = appClassPaths[1];
        this.loadContext.registerReference(((ReferencedLoader)earLoader).getName(), "library:add_ejb");
        this.loadContext.registerReference(((ReferencedLoader)earLoader).getName(), "service:ejb");
        int j2 = 0;
        while (j2 < jars.length) {
            this.deploySingleJar(ejbjarDescriptors[j2], jars[j2], earLoader, appMainClassPath, appCrossClassPath, appDir, remSupp, jarSecurityContexts[j2]);
            ++j2;
        }
    }

    public EJBJarDescriptor parseSingleJar(File jar, InputStream altDDStream, Vector warnings, ClassLoader earLoader, String appName, boolean atDeploy, SecurityContext jarSecurityCtx, boolean atUpdate, UpdateSecurityContext updateSecurityCtx) throws DeploymentException {
        EJBJarDescriptor result = null;
        ZipFile file = null;
        try {
            file = new ZipFile(jar);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2150", new Object[]{jar.getPath()}, ioe);
        }
        try {
            try {
                BufferedInputStream xmlStream = null;
                if (altDDStream != null) {
                    xmlStream = new BufferedInputStream(altDDStream);
                } else {
                    ZipEntry entry = file.getEntry("META-INF/ejb-jar.xml");
                    if (entry == null && (entry = file.getEntry("meta-inf/ejb-jar.xml")) == null && (entry = file.getEntry("META-INF/EJB-JAR.XML")) == null) {
                        throw new EJBFileOperationException("ejb_2151", new Object[]{jar.getPath()});
                    }
                    xmlStream = new BufferedInputStream(file.getInputStream(entry));
                }
                EJBJarParser ejbjarParser = new EJBJarParser();
                result = ejbjarParser.parseXml(xmlStream, warnings, earLoader, appName, jar.getName(), atDeploy, jarSecurityCtx, atUpdate, updateSecurityCtx);
                result.setJarName(jar.getName());
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_2152", new Object[]{XML_EJB_JAR, jar.getPath()}, ioe);
            }
            catch (IllegalArgumentException iae) {
                throw new EJBDeploymentException("ejb_2154", new Object[]{XML_EJB_JAR, jar.getPath()}, iae);
            }
            try {
                ZipEntry persistentEntry = file.getEntry("META-INF/persistent.xml");
                if (persistentEntry == null) {
                    persistentEntry = file.getEntry("meta-inf/persistent.xml");
                }
                if (persistentEntry != null) {
                    PersistentParser persistentParser = new PersistentParser();
                    persistentParser.parseXML(result, new BufferedInputStream(file.getInputStream(persistentEntry)), warnings, earLoader);
                } else if (!result.getAbstractSchema().isEmpty()) {
                    throw new EJBFileOperationException("ejb_2153", new Object[]{jar.getPath()});
                }
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_2152", new Object[]{XML_PERSISTENT, jar.getPath()}, ioe);
            }
            catch (IllegalArgumentException iae) {
                throw new EJBDeploymentException("ejb_2154", new Object[]{XML_PERSISTENT, jar.getPath()}, iae);
            }
            try {
                ZipEntry inqmyEjbEntry = file.getEntry("META-INF/ejb-j2ee-engine.xml");
                if (inqmyEjbEntry == null) {
                    inqmyEjbEntry = file.getEntry("meta-inf/ejb-j2ee-engine.xml");
                }
                if (inqmyEjbEntry != null) {
                    InqmyEjbParser inqmyEjbParser = new InqmyEjbParser();
                    inqmyEjbParser.parseXml(result, new BufferedInputStream(file.getInputStream(inqmyEjbEntry)), atDeploy, jarSecurityCtx, atUpdate, updateSecurityCtx, warnings);
                } else if (result.hasMDBs()) {
                    throw new EJBDeploymentException("ejb_2189", new Object[]{result.getJarName()});
                }
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_2152", new Object[]{XML_EJB_J2EE_ENGINE, jar.getPath()}, ioe);
            }
            catch (IllegalArgumentException iae) {
                throw new EJBDeploymentException("ejb_2154", new Object[]{XML_EJB_J2EE_ENGINE, jar.getPath()}, iae);
            }
            Object var15_21 = null;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            try {
                file.close();
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_9998", new Object[]{file.getName()}, ioe);
            }
            throw throwable;
        }
        try {
            file.close();
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_9998", new Object[]{file.getName()}, ioe);
        }
        DeploymentDescriptor[] descriptors = result.getDDescriptors();
        String jarIdentifier = appName + "*" + result.getJarName();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i] instanceof CMPEntityDescriptor) {
                ((CMPEntityDescriptor)descriptors[i]).setJarIdentifier(jarIdentifier);
            }
            ++i;
        }
        return result;
    }

    public void fixSingleJarOnStartup(EJBJarDescriptor jarDescr) {
        int jarIndex = jarDescr.getJarIndex() * 10;
        DeploymentDescriptor[] descriptors = jarDescr.getDDescriptors();
        Hashtable<String, Integer> usedFiles = new Hashtable<String, Integer>();
        int i = 0;
        while (i < descriptors.length) {
            String beanClassName;
            String locHomeClassName;
            String locClassName;
            String homeClassName;
            Integer index = null;
            int[] useIndex = new int[5];
            String remClassName = descriptors[i].getRemoteInterface();
            if (remClassName != null) {
                index = (Integer)usedFiles.get(remClassName);
                if (index == null) {
                    useIndex[0] = 0;
                    usedFiles.put(remClassName, new Integer(1));
                } else {
                    useIndex[0] = index;
                    usedFiles.put(remClassName, new Integer(useIndex[0] + 1));
                }
                useIndex[0] = useIndex[0] + jarIndex;
                descriptors[i].setEjbObjectImpl(remClassName + "ObjectImpl" + useIndex[0]);
            }
            if ((homeClassName = descriptors[i].getRemoteHomeInterface()) != null) {
                index = (Integer)usedFiles.get(homeClassName);
                if (index == null) {
                    useIndex[1] = 0;
                    usedFiles.put(homeClassName, new Integer(1));
                } else {
                    useIndex[1] = index;
                    usedFiles.put(homeClassName, new Integer(useIndex[1] + 1));
                }
                useIndex[1] = useIndex[1] + jarIndex;
                descriptors[i].setEjbHomeImpl(homeClassName + "Impl" + useIndex[1]);
            }
            if ((locClassName = descriptors[i].getLocalInterface()) != null) {
                index = (Integer)usedFiles.get(locClassName);
                if (index == null) {
                    useIndex[2] = 0;
                    usedFiles.put(locClassName, new Integer(1));
                } else {
                    useIndex[2] = index;
                    usedFiles.put(locClassName, new Integer(useIndex[2] + 1));
                }
                useIndex[2] = useIndex[2] + jarIndex;
                descriptors[i].setEjbLocalObjectImpl(locClassName + "LocalObjectImpl" + useIndex[2]);
            }
            if ((locHomeClassName = descriptors[i].getLocalHomeInterface()) != null) {
                index = (Integer)usedFiles.get(locHomeClassName);
                if (index == null) {
                    useIndex[3] = 0;
                    usedFiles.put(locHomeClassName, new Integer(1));
                } else {
                    useIndex[3] = index;
                    usedFiles.put(locHomeClassName, new Integer(useIndex[3] + 1));
                }
                useIndex[3] = useIndex[3] + jarIndex;
                descriptors[i].setEjbLocalHomeImpl(locHomeClassName + "Impl" + useIndex[3]);
            }
            if ((beanClassName = descriptors[i].getClassName()) != null) {
                index = (Integer)usedFiles.get(beanClassName);
                if (index == null) {
                    useIndex[4] = 0;
                    usedFiles.put(beanClassName, new Integer(1));
                } else {
                    useIndex[4] = index;
                    usedFiles.put(beanClassName, new Integer(useIndex[4] + 1));
                }
                useIndex[4] = useIndex[4] + jarIndex;
            }
            descriptors[i].setUseIndex(useIndex);
            ++i;
        }
    }

    protected void deploySingleJar(EJBJarDescriptor jarDescr, File jar, ClassLoader earLoader, String appMainClassPath, String appCrossClassPath, File appDir, String[] remSupp, SecurityContext jarSecurityContext) throws DeploymentException {
        File tempDir = new File(appDir, "temp" + sepChar + "temp" + System.currentTimeMillis());
        tempDir.mkdirs();
        DynamicClassLoader loader = new DynamicClassLoader(tempDir.getPath(), earLoader);
        appMainClassPath = appMainClassPath + tempDir.getPath() + pathSep;
        appCrossClassPath = appCrossClassPath + tempDir.getPath() + pathSep;
        DeploymentDescriptor[] descriptors = jarDescr.getDDescriptors();
        int jarIndex = jarDescr.getJarIndex() * 10;
        Hashtable<String, Integer> usedFiles = new Hashtable<String, Integer>();
        int i = 0;
        while (i < descriptors.length) {
            String beanClassName;
            String locHomeClassName;
            String locClassName;
            String homeClassName;
            Integer index = null;
            int[] useIndex = new int[5];
            String remClassName = descriptors[i].getRemoteInterface();
            if (remClassName != null) {
                index = (Integer)usedFiles.get(remClassName);
                if (index == null) {
                    useIndex[0] = 0;
                    usedFiles.put(remClassName, new Integer(1));
                } else {
                    useIndex[0] = index;
                    usedFiles.put(remClassName, new Integer(useIndex[0] + 1));
                }
                useIndex[0] = useIndex[0] + jarIndex;
                descriptors[i].setEjbObjectImpl(remClassName + "ObjectImpl" + useIndex[0]);
                int index0 = remClassName.lastIndexOf(".");
                if (index0 > -1) {
                    new File(tempDir, remClassName.substring(0, index0).replace('.', sepChar)).mkdirs();
                }
            }
            if ((homeClassName = descriptors[i].getRemoteHomeInterface()) != null) {
                index = (Integer)usedFiles.get(homeClassName);
                if (index == null) {
                    useIndex[1] = 0;
                    usedFiles.put(homeClassName, new Integer(1));
                } else {
                    useIndex[1] = index;
                    usedFiles.put(homeClassName, new Integer(useIndex[1] + 1));
                }
                useIndex[1] = useIndex[1] + jarIndex;
                descriptors[i].setEjbHomeImpl(homeClassName + "Impl" + useIndex[1]);
                int index0 = homeClassName.lastIndexOf(".");
                if (index0 > -1) {
                    new File(tempDir, homeClassName.substring(0, index0).replace('.', sepChar)).mkdirs();
                }
            }
            if ((locClassName = descriptors[i].getLocalInterface()) != null) {
                index = (Integer)usedFiles.get(locClassName);
                if (index == null) {
                    useIndex[2] = 0;
                    usedFiles.put(locClassName, new Integer(1));
                } else {
                    useIndex[2] = index;
                    usedFiles.put(locClassName, new Integer(useIndex[2] + 1));
                }
                useIndex[2] = useIndex[2] + jarIndex;
                descriptors[i].setEjbLocalObjectImpl(locClassName + "LocalObjectImpl" + useIndex[2]);
                int index0 = locClassName.lastIndexOf(".");
                if (index0 > -1) {
                    new File(tempDir, locClassName.substring(0, index0).replace('.', sepChar)).mkdirs();
                }
            }
            if ((locHomeClassName = descriptors[i].getLocalHomeInterface()) != null) {
                index = (Integer)usedFiles.get(locHomeClassName);
                if (index == null) {
                    useIndex[3] = 0;
                    usedFiles.put(locHomeClassName, new Integer(1));
                } else {
                    useIndex[3] = index;
                    usedFiles.put(locHomeClassName, new Integer(useIndex[3] + 1));
                }
                useIndex[3] = useIndex[3] + jarIndex;
                descriptors[i].setEjbLocalHomeImpl(locHomeClassName + "Impl" + useIndex[3]);
                int index0 = locHomeClassName.lastIndexOf(".");
                if (index0 > -1) {
                    new File(tempDir, locHomeClassName.substring(0, index0).replace('.', sepChar)).mkdirs();
                }
            }
            if ((beanClassName = descriptors[i].getClassName()) != null) {
                index = (Integer)usedFiles.get(beanClassName);
                if (index == null) {
                    useIndex[4] = 0;
                    usedFiles.put(beanClassName, new Integer(1));
                } else {
                    useIndex[4] = index;
                    usedFiles.put(beanClassName, new Integer(useIndex[4] + 1));
                }
                useIndex[4] = useIndex[4] + jarIndex;
                int index0 = beanClassName.lastIndexOf(".");
                if (index0 > -1) {
                    new File(tempDir, beanClassName.substring(0, index0).replace('.', sepChar)).mkdirs();
                }
            }
            descriptors[i].setUseIndex(useIndex);
            ++i;
        }
        Vector generatedJavaFiles = new Vector();
        Vector<EntityDescriptor> cmp11Descr = new Vector<EntityDescriptor>();
        int i2 = 0;
        while (i2 < descriptors.length) {
            this.ejbLocation.infoT("EJB: " + descriptors[i2].getEjbName());
            this.mapSecurity(descriptors[i2], jarSecurityContext, loader);
            String xmlFileName = tempDir.getPath() + sepChar + "temp" + i2 + ".xml";
            int[] useIndex = descriptors[i2].getUseIndex();
            boolean hasRemote = descriptors[i2].hasRemoteInterfaces();
            boolean hasLocal = descriptors[i2].hasLocalInterfaces();
            if (descriptors[i2] instanceof SessionDescriptor) {
                boolean isStateful;
                SessionDescriptor sesDescriptor = (SessionDescriptor)descriptors[i2];
                XMLSessionGenerator.generateXml(sesDescriptor, loader, xmlFileName, useIndex);
                boolean bl = isStateful = sesDescriptor.getSessionType() == 1;
                if (hasRemote) {
                    if (isStateful) {
                        this.processXSLT(new String[]{sesDescriptor.getEjbObjectImpl(), sesDescriptor.getEjbHomeImpl()}, xmlFileName, sesStatefulRemoteXsls, tempDir, generatedJavaFiles);
                    } else {
                        this.processXSLT(new String[]{sesDescriptor.getEjbObjectImpl(), sesDescriptor.getEjbHomeImpl()}, xmlFileName, sesStatelessRemoteXsls, tempDir, generatedJavaFiles);
                    }
                }
                if (hasLocal) {
                    if (isStateful) {
                        this.processXSLT(new String[]{sesDescriptor.getEjbLocalObjectImpl(), sesDescriptor.getEjbLocalHomeImpl()}, xmlFileName, sesStatefulLocalXsls, tempDir, generatedJavaFiles);
                    } else {
                        this.processXSLT(new String[]{sesDescriptor.getEjbLocalObjectImpl(), sesDescriptor.getEjbLocalHomeImpl()}, xmlFileName, sesStatelessLocalXsls, tempDir, generatedJavaFiles);
                    }
                }
            } else if (descriptors[i2] instanceof MessageDrivenDescriptor) {
                MessageDrivenDescriptor mdbDescr = (MessageDrivenDescriptor)descriptors[i2];
                XMLMessageGenerator.generateXml(mdbDescr, loader, xmlFileName, useIndex);
                if (mdbDescr.getMessagingType() != null && !mdbDescr.getMessagingType().equals("")) {
                    this.processXSLT(new String[]{descriptors[i2].getRuntimeClassName(), descriptors[i2].getBootClassName() + "FP"}, xmlFileName, JCAMessageXsls, tempDir, generatedJavaFiles);
                } else {
                    this.processXSLT(new String[]{descriptors[i2].getRuntimeClassName(), descriptors[i2].getBootClassName() + "FP"}, xmlFileName, messageXsls, tempDir, generatedJavaFiles);
                }
            } else {
                EntityDescriptor entDescriptor = (EntityDescriptor)descriptors[i2];
                XMLEntityGenerator.generateXml(entDescriptor, loader, xmlFileName, useIndex);
                if (entDescriptor instanceof CMPEntityDescriptor) {
                    CMPEntityDescriptor cmpDescr = (CMPEntityDescriptor)entDescriptor;
                    String pmXmlFileName = xmlFileName.substring(0, xmlFileName.length() - 4) + "PM.xml";
                    XMLPmGenerator.generateXml(cmpDescr, jarDescr.getAbstractSchema(), pmXmlFileName, loader, useIndex[4]);
                    if (cmpDescr.isReadOnly()) {
                        this.processXSLT(new String[]{cmpDescr.getPersistentClassName(), cmpDescr.getRuntimeClassName()}, pmXmlFileName, new String[]{pmXsls[2], pmXsls[3]}, tempDir, generatedJavaFiles);
                    } else {
                        this.processXSLT(new String[]{cmpDescr.getPersistentClassName(), cmpDescr.getRuntimeClassName()}, pmXmlFileName, new String[]{pmXsls[0], pmXsls[1]}, tempDir, generatedJavaFiles);
                    }
                    if (((CMPEntityDescriptor)entDescriptor).getCmpVersion() != 2) {
                        cmp11Descr.add(entDescriptor);
                    }
                }
                if (hasRemote) {
                    this.processXSLT(new String[]{entDescriptor.getEjbObjectImpl(), entDescriptor.getEjbHomeImpl()}, xmlFileName, entityRemoteXsls, tempDir, generatedJavaFiles);
                }
                if (hasLocal) {
                    this.processXSLT(new String[]{entDescriptor.getEjbLocalObjectImpl(), entDescriptor.getEjbLocalHomeImpl()}, xmlFileName, entityLocalXsls, tempDir, generatedJavaFiles);
                }
            }
            ++i2;
        }
        if (!jarDescr.getAbstractSchema().isEmpty()) {
            RelationDescriptor[] relDescr = jarDescr.getAbstractSchema().getM2MRelationDescriptors();
            int rd = 0;
            while (rd < relDescr.length) {
                String xmlM2MFileName = tempDir.getPath() + sepChar + "tempM2M" + relDescr[rd].getM2MMap().getM2MRelId() + "PM.xml";
                new File(tempDir.getPath() + sepChar + "many2many" + jarDescr.getJarIndex()).mkdirs();
                this.processXSLT(new String[]{"many2many" + jarDescr.getJarIndex() + sepChar + "PersistentM2M" + relDescr[rd].getM2MMap().getM2MRelId()}, xmlM2MFileName, new String[]{pmXsls[4]}, tempDir, generatedJavaFiles);
                ++rd;
            }
        }
        this.ejbLocation.infoT("Compiling...");
        AdminUtils.compile((String)appMainClassPath, (String)tempDir.getPath(), (String[])generatedJavaFiles.toArray(new String[generatedJavaFiles.size()]));
        this.ejbLocation.infoT("Compiled.");
        HashSet clientJarComponents = new HashSet();
        this.deploySupport(tempDir.getPath(), jarDescr, loader, appCrossClassPath, clientJarComponents, remSupp);
        this.makeAppJar(jar, loader, appDir, cmp11Descr);
        try {
            File genJarsDir = new File(appDir, "jars");
            genJarsDir.mkdirs();
            AdminUtils.makeJar((File)tempDir, (String)(genJarsDir.getPath() + sepChar + GEN_JAR_PREFIX + jarDescr.getJarName()));
            File clientJarsDir = new File(appDir, "clientjars");
            clientJarsDir.mkdirs();
            AdminUtils.makeClientJar((File)tempDir, clientJarComponents, (String)(clientJarsDir.getPath() + sepChar + jarDescr.getClientJarName()));
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2160", new Object[]{jarDescr.getClientJarName()}, ioe);
        }
    }

    protected void deploySingleBean(EJBJarDescriptor jarDescr, DeploymentDescriptor oldDescr, DeploymentDescriptor newDescr, ClassLoader earLoader, String appMainClassPath, String appCrossClassPath, File appDir, File tempDir, String[] remSupp, SecurityContext jarSecurityContext, boolean deploySupport) throws DeploymentException {
        RelationDescriptor[] relDescr;
        int index0;
        String beanClassName;
        String locHomeClassName;
        String locClassName;
        String homeClassName;
        DynamicClassLoader loader = new DynamicClassLoader(tempDir.getPath(), earLoader);
        appMainClassPath = appMainClassPath + tempDir.getPath() + pathSep;
        appCrossClassPath = appCrossClassPath + tempDir.getPath() + pathSep;
        int jarIndex = jarDescr.getJarIndex() * 10;
        int[] useIndex = null;
        if (oldDescr != null) {
            useIndex = oldDescr.getUseIndex();
        } else {
            useIndex = new int[5];
            int i = 0;
            while (i < useIndex.length) {
                useIndex[i] = useIndex[i] + jarIndex;
                ++i;
            }
        }
        String remClassName = newDescr.getRemoteInterface();
        if (remClassName != null) {
            newDescr.setEjbObjectImpl(remClassName + "ObjectImpl" + useIndex[0]);
            int index02 = remClassName.lastIndexOf(".");
            if (index02 > -1) {
                new File(tempDir, remClassName.substring(0, index02).replace('.', sepChar)).mkdirs();
            }
        }
        if ((homeClassName = newDescr.getRemoteHomeInterface()) != null) {
            newDescr.setEjbHomeImpl(homeClassName + "Impl" + useIndex[1]);
            int index03 = homeClassName.lastIndexOf(".");
            if (index03 > -1) {
                new File(tempDir, homeClassName.substring(0, index03).replace('.', sepChar)).mkdirs();
            }
        }
        if ((locClassName = newDescr.getLocalInterface()) != null) {
            newDescr.setEjbLocalObjectImpl(locClassName + "LocalObjectImpl" + useIndex[2]);
            int index04 = locClassName.lastIndexOf(".");
            if (index04 > -1) {
                new File(tempDir, locClassName.substring(0, index04).replace('.', sepChar)).mkdirs();
            }
        }
        if ((locHomeClassName = newDescr.getLocalHomeInterface()) != null) {
            newDescr.setEjbLocalHomeImpl(locHomeClassName + "Impl" + useIndex[3]);
            int index05 = locHomeClassName.lastIndexOf(".");
            if (index05 > -1) {
                new File(tempDir, locHomeClassName.substring(0, index05).replace('.', sepChar)).mkdirs();
            }
        }
        if ((beanClassName = newDescr.getClassName()) != null && (index0 = beanClassName.lastIndexOf(".")) > -1) {
            new File(tempDir, beanClassName.substring(0, index0).replace('.', sepChar)).mkdirs();
        }
        newDescr.setUseIndex(useIndex);
        this.mapSecurity(newDescr, jarSecurityContext, loader);
        Vector generatedJavaFiles = new Vector();
        String xmlFileName = tempDir.getPath() + sepChar + "temp" + this.tempIndex++ + ".xml";
        boolean hasRemote = newDescr.hasRemoteInterfaces();
        boolean hasLocal = newDescr.hasLocalInterfaces();
        if (newDescr instanceof SessionDescriptor) {
            boolean isStateful;
            SessionDescriptor sesDescriptor = (SessionDescriptor)newDescr;
            XMLSessionGenerator.generateXml(sesDescriptor, loader, xmlFileName, useIndex);
            boolean bl = isStateful = sesDescriptor.getSessionType() == 1;
            if (hasRemote) {
                if (isStateful) {
                    this.processXSLT(new String[]{sesDescriptor.getEjbObjectImpl(), sesDescriptor.getEjbHomeImpl()}, xmlFileName, sesStatefulRemoteXsls, tempDir, generatedJavaFiles);
                } else {
                    this.processXSLT(new String[]{sesDescriptor.getEjbObjectImpl(), sesDescriptor.getEjbHomeImpl()}, xmlFileName, sesStatelessRemoteXsls, tempDir, generatedJavaFiles);
                }
            }
            if (hasLocal) {
                if (isStateful) {
                    this.processXSLT(new String[]{sesDescriptor.getEjbLocalObjectImpl(), sesDescriptor.getEjbLocalHomeImpl()}, xmlFileName, sesStatefulLocalXsls, tempDir, generatedJavaFiles);
                } else {
                    this.processXSLT(new String[]{sesDescriptor.getEjbLocalObjectImpl(), sesDescriptor.getEjbLocalHomeImpl()}, xmlFileName, sesStatelessLocalXsls, tempDir, generatedJavaFiles);
                }
            }
        } else if (newDescr instanceof MessageDrivenDescriptor) {
            MessageDrivenDescriptor mdbDescr = (MessageDrivenDescriptor)newDescr;
            XMLMessageGenerator.generateXml(mdbDescr, loader, xmlFileName, useIndex);
            if (mdbDescr.getMessagingType() != null && !mdbDescr.getMessagingType().equals("")) {
                this.processXSLT(new String[]{newDescr.getRuntimeClassName(), newDescr.getBootClassName() + "FP"}, xmlFileName, JCAMessageXsls, tempDir, generatedJavaFiles);
            } else {
                this.processXSLT(new String[]{newDescr.getRuntimeClassName(), newDescr.getBootClassName() + "FP"}, xmlFileName, messageXsls, tempDir, generatedJavaFiles);
            }
        } else {
            EntityDescriptor entDescriptor = (EntityDescriptor)newDescr;
            XMLEntityGenerator.generateXml(entDescriptor, loader, xmlFileName, useIndex);
            if (entDescriptor instanceof CMPEntityDescriptor) {
                CMPEntityDescriptor cmpDescr = (CMPEntityDescriptor)entDescriptor;
                String pmXmlFileName = xmlFileName.substring(0, xmlFileName.length() - 4) + "PM.xml";
                XMLPmGenerator.generateXml(cmpDescr, jarDescr.getAbstractSchema(), pmXmlFileName, loader, useIndex[4]);
                if (cmpDescr.isReadOnly()) {
                    this.processXSLT(new String[]{cmpDescr.getPersistentClassName(), cmpDescr.getRuntimeClassName()}, pmXmlFileName, new String[]{pmXsls[2], pmXsls[3]}, tempDir, generatedJavaFiles);
                } else {
                    this.processXSLT(new String[]{cmpDescr.getPersistentClassName(), cmpDescr.getRuntimeClassName()}, pmXmlFileName, new String[]{pmXsls[0], pmXsls[1]}, tempDir, generatedJavaFiles);
                }
            }
            if (hasRemote) {
                this.processXSLT(new String[]{entDescriptor.getEjbObjectImpl(), entDescriptor.getEjbHomeImpl()}, xmlFileName, entityRemoteXsls, tempDir, generatedJavaFiles);
            }
            if (hasLocal) {
                this.processXSLT(new String[]{entDescriptor.getEjbLocalObjectImpl(), entDescriptor.getEjbLocalHomeImpl()}, xmlFileName, entityLocalXsls, tempDir, generatedJavaFiles);
            }
        }
        if (!jarDescr.getAbstractSchema().isEmpty() && (relDescr = jarDescr.getAbstractSchema().getM2MRelationDescriptors()) != null) {
            int rd = 0;
            while (rd < relDescr.length) {
                String xmlM2MFileName = tempDir.getPath() + sepChar + "tempM2M" + relDescr[rd].getM2MMap().getM2MRelId() + "PM.xml";
                new File(tempDir.getPath() + sepChar + "many2many" + jarDescr.getJarIndex()).mkdirs();
                this.processXSLT(new String[]{"many2many" + jarDescr.getJarIndex() + sepChar + "PersistentM2M" + relDescr[rd].getM2MMap().getM2MRelId()}, xmlM2MFileName, new String[]{pmXsls[4]}, tempDir, generatedJavaFiles);
                ++rd;
            }
        }
        this.ejbLocation.infoT("Compiling...");
        AdminUtils.compile((String)appMainClassPath, (String)tempDir.getPath(), (String[])generatedJavaFiles.toArray(new String[generatedJavaFiles.size()]));
        this.ejbLocation.infoT("Compiled.");
        String[] forRemove = null;
        if (oldDescr != null) {
            if (oldDescr.hasRemoteInterfaces() && !newDescr.hasRemoteInterfaces()) {
                forRemove = new String[]{oldDescr.getRemoteInterface().replace('.', '/') + "_Stub.class", oldDescr.getRemoteHomeInterface().replace('.', '/') + "_Stub.class"};
            } else if (oldDescr.hasLocalInterfaces() && !newDescr.hasLocalInterfaces()) {
                forRemove = new String[]{oldDescr.getEjbLocalHomeImpl().replace('.', '/') + ".class", oldDescr.getEjbLocalObjectImpl().replace('.', '/') + ".class"};
            }
        }
        File[] clientFiles = null;
        if (deploySupport) {
            HashSet clientJarComponents = new HashSet();
            this.deploySupportOnly(tempDir.getPath(), newDescr, loader, appCrossClassPath, remSupp, jarDescr.getJarName(), clientJarComponents, false);
            clientFiles = new File[clientJarComponents.size()];
            int cf = 0;
            Iterator it = clientJarComponents.iterator();
            while (it.hasNext()) {
                String fileName = (String)it.next();
                clientFiles[cf++] = new File(tempDir, fileName);
            }
            String clientJarName = appDir.getPath() + sepChar + "clientjars" + sepChar + jarDescr.getClientJarName();
            try {
                this.updateJar(clientJarName, clientFiles, forRemove, tempDir.getPath());
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_2161", new Object[]{"clientjars/" + jarDescr.getClientJarName()}, ioe);
            }
        }
        Vector vClassFiles = new Vector();
        this.getClassFiles(tempDir, vClassFiles);
        File[] classFiles = vClassFiles.toArray(new File[vClassFiles.size()]);
        String genJarName = appDir.getPath() + sepChar + "jars" + sepChar + GEN_JAR_PREFIX + jarDescr.getJarName();
        String[] filesToDelete = null;
        if (forRemove != null) {
            filesToDelete = oldDescr.hasRemoteInterfaces() ? new String[]{oldDescr.getEjbHomeImpl().replace('.', '/') + ".class", oldDescr.getEjbObjectImpl().replace('.', '/') + ".class", oldDescr.getEjbHomeImpl().replace('.', '/') + "p4_Skel.class", oldDescr.getEjbObjectImpl().replace('.', '/') + "p4_Skel.class", forRemove[0], forRemove[1]} : new String[]{forRemove[0], forRemove[1]};
        }
        try {
            this.updateJar(genJarName, classFiles, filesToDelete, tempDir.getPath());
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2161", new Object[]{"jars/" + jarDescr.getJarName()}, ioe);
        }
    }

    private void processXSLT(String[] fileNames, String xmlFileName, String[] xsls, File tempDir, Vector readyJavaFiles) throws DeploymentException {
        StreamSource inXML = new StreamSource(xmlFileName);
        FileOutputStream fos = null;
        String fileName = null;
        try {
            int j = 0;
            while (j < fileNames.length) {
                fileName = fileNames[j].replace('.', sepChar) + ".java";
                readyJavaFiles.add(fileName);
                InputStream xslStream = this.ejbServiceLoader.getResourceAsStream(xsls[j]);
                Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(xslStream));
                transformer.setOutputProperties(this.transformerProps);
                fos = new FileOutputStream(new File(tempDir, fileName));
                transformer.transform(inXML, new StreamResult(fos));
                fos.close();
                ++j;
            }
        }
        catch (TransformerConfigurationException tce) {
            throw new EJBFileGenerationException("ejb_2162", (Throwable)tce);
        }
        catch (TransformerException te) {
            throw new EJBFileGenerationException("ejb_2162", (Throwable)te);
        }
        catch (IOException ioe) {
            throw new EJBFileGenerationException("ejb_2162", (Throwable)ioe);
        }
        catch (NullPointerException npe) {
            throw new EJBFileGenerationException("ejb_2162", (Throwable)npe);
        }
    }

    public void deploySupport(String tempDir, EJBJarDescriptor jarDescr, ClassLoader loader, String appCrossClassPath, HashSet clientJarComponents, String[] remSupp) throws DeploymentException {
        HashSet<String> readyFiles = new HashSet<String>();
        DeploymentDescriptor[] depDescriptors = jarDescr.getDDescriptors();
        int j = 0;
        while (j < depDescriptors.length) {
            if (depDescriptors[j].hasRemoteInterfaces()) {
                Class<?> ejbHomeClass = null;
                Class<?> ejbObjectClass = null;
                try {
                    ejbHomeClass = loader.loadClass(depDescriptors[j].getEjbHomeImpl());
                    ejbObjectClass = loader.loadClass(depDescriptors[j].getEjbObjectImpl());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new EJBDeploymentException("ejb_2163", new Object[]{depDescriptors[j].getEjbName()}, cnfe);
                }
                try {
                    CrossInterface crossInterface = this.environment.getCrossInterface();
                    if (crossInterface == null) {
                        throw new EJBDeploymentException("ejb_2164");
                    }
                    CrossGenerationData crossGenData = crossInterface.generate(new Class[]{ejbHomeClass, ejbObjectClass}, null, remSupp);
                    String crossDir = crossGenData.getDestinationDirectory();
                    String[] remoteSupp = crossGenData.getSupport();
                    int i = 0;
                    while (i < remoteSupp.length) {
                        int index0 = remoteSupp[i].lastIndexOf(sepChar);
                        if (index0 > -1) {
                            new File(tempDir + sepChar + remoteSupp[i].substring(0, index0)).mkdirs();
                        }
                        AdminUtils.copyFile((File)new File(crossDir + sepChar + remoteSupp[i] + ".java"), (File)new File(tempDir + sepChar + remoteSupp[i] + ".java"));
                        String remoteSuppName = remoteSupp[i] + ".java";
                        readyFiles.add(remoteSuppName);
                        ++i;
                    }
                    String[] clientSupp = crossGenData.getClientSupport();
                    int i2 = 0;
                    while (i2 < clientSupp.length) {
                        String clientSuppName = clientSupp[i2] + ".class";
                        clientJarComponents.add(clientSuppName);
                        ++i2;
                    }
                    AdminUtils.delFolder((File)new File(crossDir));
                }
                catch (IOException ioe) {
                    throw new EJBFileGenerationException("ejb_2165", new Object[]{jarDescr.getJarName()}, ioe);
                }
            }
            ++j;
        }
        if (readyFiles.size() > 0) {
            this.ejbLocation.infoT("Compiling communication...");
            String[] readyFilesNames = ((AbstractCollection)readyFiles).toArray(new String[readyFiles.size()]);
            AdminUtils.compile((String)appCrossClassPath, (String)tempDir, (String[])readyFilesNames);
            this.ejbLocation.infoT("Communication compiled.");
        }
    }

    protected void deploySupportOnly(String dirr, DeploymentDescriptor descr, ClassLoader loader, String appCrossClassPath, String[] remSupp, String jarName, HashSet clientJarComponents, boolean updateJar) throws DeploymentException {
        String dir = dirr;
        File currDir = null;
        if (updateJar) {
            dir = dirr + sepChar + "temp" + sepChar + "temp" + System.currentTimeMillis();
            currDir = new File(dir);
            currDir.mkdir();
        } else {
            currDir = new File(dir);
        }
        appCrossClassPath = appCrossClassPath + dir + pathSep;
        HashSet<String> readyFiles = new HashSet<String>();
        if (!descr.hasRemoteInterfaces()) {
            return;
        }
        Class<?> ejbHomeClass = null;
        Class<?> ejbObjectClass = null;
        try {
            ejbHomeClass = loader.loadClass(descr.getEjbHomeImpl());
            ejbObjectClass = loader.loadClass(descr.getEjbObjectImpl());
        }
        catch (ClassNotFoundException cnfe) {
            throw new EJBDeploymentException("ejb_2163", new Object[]{descr.getEjbName()}, cnfe);
        }
        try {
            CrossInterface crossInterface = this.environment.getCrossInterface();
            if (crossInterface == null) {
                throw new EJBDeploymentException("ejb_2164");
            }
            CrossGenerationData crossGenData = crossInterface.generate(new Class[]{ejbHomeClass, ejbObjectClass}, null, remSupp);
            String crossDir = crossGenData.getDestinationDirectory();
            String[] remoteSupp = crossGenData.getSupport();
            int i = 0;
            while (i < remoteSupp.length) {
                int index0 = remoteSupp[i].lastIndexOf(sepChar);
                if (index0 > -1) {
                    new File(dir + sepChar + remoteSupp[i].substring(0, index0)).mkdirs();
                }
                AdminUtils.copyFile((File)new File(crossDir + sepChar + remoteSupp[i] + ".java"), (File)new File(dir + sepChar + remoteSupp[i] + ".java"));
                String remoteSuppName = remoteSupp[i] + ".java";
                readyFiles.add(remoteSuppName);
                ++i;
            }
            String[] clientSupp = crossGenData.getClientSupport();
            int i2 = 0;
            while (i2 < clientSupp.length) {
                String clientSuppName = clientSupp[i2] + ".class";
                if (clientJarComponents != null) {
                    clientJarComponents.add(clientSuppName);
                }
                ++i2;
            }
            AdminUtils.delFolder((File)new File(crossDir));
        }
        catch (IOException ioe) {
            throw new EJBFileGenerationException("ejb_2165", new Object[]{jarName}, ioe);
        }
        String[] fileNames = ((AbstractCollection)readyFiles).toArray(new String[readyFiles.size()]);
        if (fileNames.length > 0) {
            this.ejbLocation.infoT("Compiling communication... ");
            AdminUtils.compile((String)appCrossClassPath, (String)dir, (String[])fileNames);
            this.ejbLocation.infoT("Communication compiled.");
        }
        if (updateJar) {
            File[] files = new File[fileNames.length];
            int i = 0;
            while (i < fileNames.length) {
                files[i] = new File(currDir, fileNames[i].substring(0, fileNames[i].length() - 5) + ".class");
                ++i;
            }
            String genJarName = dirr + sepChar + "jars" + sepChar + GEN_JAR_PREFIX + jarName;
            try {
                this.updateJar(genJarName, files, null, dir);
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_2161", new Object[]{"jars/gen_" + jarName}, ioe);
            }
        }
    }

    protected void mapSecurity(DeploymentDescriptor descr, SecurityContext jarSecurityContext, ClassLoader earLoader) throws DeploymentException {
        boolean hasLocal = descr.hasLocalInterfaces();
        boolean hasRemote = descr.hasRemoteInterfaces();
        if (hasLocal) {
            try {
                Class<?> localHomeIntfClass = earLoader.loadClass(descr.getLocalHomeInterface());
                Class<?> localIntfClass = earLoader.loadClass(descr.getLocalInterface());
                this.map("LocalHome", localHomeIntfClass, descr, jarSecurityContext);
                this.map("Local", localIntfClass, descr, jarSecurityContext);
            }
            catch (ClassNotFoundException cnfe) {
                throw new EJBDeploymentException("ejb_2155", new Object[]{descr.getEjbName()}, cnfe);
            }
        }
        if (hasRemote) {
            try {
                Class<?> remoteHomeIntfClass = earLoader.loadClass(descr.getRemoteHomeInterface());
                Class<?> remoteIntfClass = earLoader.loadClass(descr.getRemoteInterface());
                this.map("Home", remoteHomeIntfClass, descr, jarSecurityContext);
                this.map("Remote", remoteIntfClass, descr, jarSecurityContext);
            }
            catch (ClassNotFoundException cnfe) {
                throw new EJBDeploymentException("ejb_2156", new Object[]{descr.getEjbName()}, cnfe);
            }
        }
    }

    private void map(String intferfaceType, Class intfClass, DeploymentDescriptor descr, SecurityContext jarSecurityContext) throws DeploymentException {
        ResourceContext resContext = jarSecurityContext.getAuthorizationContext().getSecurityResourceContext();
        String resourceId = descr.getEjbName().replace('/', '|') + "*" + intferfaceType;
        ResourceHandle resHandle = null;
        try {
            resContext.destroyResource(resourceId);
        }
        catch (SecurityException se) {
            EJBResourceAccessor.location.traceThrowableT(300, "SecurityException in DeployAdmin.map(...): Cannot destroy resource " + resourceId + ".", (Throwable)se);
        }
        try {
            resContext.createResource(resourceId);
            resHandle = resContext.getResourceHandle(resourceId);
        }
        catch (SecurityException se) {
            throw new EJBDeploymentException("ejb_2166", new Object[]{descr.getEjbName()}, se);
        }
        ResourceAccessControlHandle resAccessHandle = resContext.getResourceAccessControlHandle(resourceId);
        Method[] methods = intfClass.getMethods();
        Vector<Method> filteredMethods = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers()) && !methods[i].getDeclaringClass().getName().equals("java.lang.Object")) {
                filteredMethods.add(methods[i]);
            }
            ++i;
        }
        methods = filteredMethods.toArray(new Method[filteredMethods.size()]);
        AccessControls[] access = descr.getAccessControlEntries();
        MethodEntry[] uncalableMethods = descr.getUncalableMethods();
        Hashtable<Method, String> methodAliases = new Hashtable<Method, String>();
        descr.setMethodAliases(intferfaceType, methodAliases);
        int i2 = 0;
        while (i2 < methods.length) {
            int j;
            String actionId = this.getMethodAlias(intferfaceType, methods[i2]);
            if (actionId == null) {
                actionId = Integer.toString(i2);
                methodAliases.put(methods[i2], actionId);
            }
            String[] securityRoleNames = null;
            boolean isUncalable = false;
            if (uncalableMethods != null) {
                j = 0;
                while (j < uncalableMethods.length) {
                    if (uncalableMethods[j].isCompatible(methods[i2], intferfaceType, descr.getEjbName())) {
                        try {
                            resHandle.removeAction(actionId);
                        }
                        catch (Exception e) {
                            EJBResourceAccessor.location.infoT("Exception in DeployAdmin.map(...): Cannot remove action " + actionId + ". Reason: " + e.toString());
                        }
                        isUncalable = true;
                        break;
                    }
                    ++j;
                }
            }
            if (isUncalable) {
                this.ejbLocation.infoT("UNCALABLE method:" + methods[i2].getName());
            } else {
                if (access != null) {
                    j = 0;
                    while (j < access.length) {
                        if (access[j].isCompatible(methods[i2], intferfaceType)) {
                            securityRoleNames = access[j].getSecurityRoleNames();
                            break;
                        }
                        ++j;
                    }
                }
                if (securityRoleNames != null) {
                    int k = 0;
                    while (k < securityRoleNames.length) {
                        resAccessHandle.grantSecurityRole((String)securityRoleNames[k], actionId, "ALL");
                        ++k;
                    }
                }
            }
            ++i2;
        }
    }

    private String getMethodAlias(String intferfaceType, Method method) {
        String methodName = method.toString();
        methodName = methodName.substring(methodName.indexOf(40), methodName.lastIndexOf(41) + 1);
        methodName = method.getName() + methodName;
        if (intferfaceType.equals("LocalHome") ? this.isLocalHome(methodName) : (intferfaceType.equals("Home") ? this.isRemoteHome(methodName) : (intferfaceType.equals("Local") ? this.isLocalIntf(methodName) : intferfaceType.equals("Remote") && this.isRemoteIntf(methodName)))) {
            return methodName;
        }
        return null;
    }

    private boolean isRemoteHome(String method) {
        return method.equals("getEJBMetaData()") || method.equals("getHomeHandle()") || method.equals("remove(java.lang.Object)") || method.equals("remove(javax.ejb.Handle)");
    }

    private boolean isLocalHome(String method) {
        return method.equals("remove(java.lang.Object)");
    }

    private boolean isLocalIntf(String method) {
        return method.equals("getEJBLocalHome()") || method.equals("getPrimaryKey()") || method.equals("isIdentical(javax.ejb.EJBLocalObject)") || method.equals("remove()");
    }

    private boolean isRemoteIntf(String method) {
        return method.equals("getEJBHome()") || method.equals("getPrimaryKey()") || method.equals("getHandle()") || method.equals("isIdentical(javax.ejb.EJBObject)") || method.equals("remove()");
    }

    public void getClassFiles(File dir, Vector v) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.getClassFiles(files[i], v);
            } else if (files[i].getName().endsWith(".class")) {
                v.add(files[i]);
            }
            ++i;
        }
    }

    public String[] makeCompilerClassPaths(String appName, ClassLoader earLoader, Vector warnings) {
        HashSet appMainCP = (HashSet)this.mainClassPath.clone();
        HashSet appCrossCP = (HashSet)this.crossClassPath.clone();
        ReferencedLoader refLoader = (ReferencedLoader)earLoader;
        String[] resources = refLoader.getResourceNames();
        AdminUtils.addJarsForClasspath((HashSet)appMainCP, (String[])resources);
        AdminUtils.addJarsForClasspath((HashSet)appCrossCP, (String[])resources);
        String[] refs = refLoader.getReferencesTo();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                ReferencedLoader rl = (ReferencedLoader)this.loadContext.getClassLoader(refs[i]);
                if (rl != null) {
                    String[] jarRefs = rl.getResourceNames();
                    AdminUtils.addJarsForClasspath((HashSet)appMainCP, (String[])jarRefs);
                    AdminUtils.addJarsForClasspath((HashSet)appCrossCP, (String[])jarRefs);
                } else {
                    warnings.add("Loader for reference: " + refs[i] + " of application: " + appName + " not found!");
                }
                ++i;
            }
        }
        StringBuffer appMainClassPath = new StringBuffer();
        Iterator i = appMainCP.iterator();
        while (i.hasNext()) {
            appMainClassPath.append(i.next()).append(pathSep);
        }
        StringBuffer appCrossClassPath = new StringBuffer();
        i = appCrossCP.iterator();
        while (i.hasNext()) {
            appCrossClassPath.append(i.next()).append(pathSep);
        }
        return new String[]{appMainClassPath.toString(), appCrossClassPath.toString()};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void makeAppJar(File jar, ClassLoader earLoader, File appRootDir, Vector cmp11Descr) throws DeploymentException {
        try {
            File appJar = new File(appRootDir.getPath() + sepChar + "applicationjars", jar.getName());
            if (cmp11Descr.size() == 0) {
                AdminUtils.copyFile((File)jar, (File)appJar);
                return;
            }
            ZipFile oldJar = null;
            ZipOutputStream newJar = null;
            try {
                try {
                    oldJar = new ZipFile(jar);
                    newJar = new ZipOutputStream(new FileOutputStream(appJar));
                    Enumeration e = cmp11Descr.elements();
                    while (e.hasMoreElements()) {
                        EntityEnhancer.generate((CMPEntityDescriptor)e.nextElement(), earLoader, oldJar, newJar);
                    }
                    Enumeration<? extends ZipEntry> e2 = oldJar.entries();
                    while (e2.hasMoreElements()) {
                        ZipEntry entry = e2.nextElement();
                        try {
                            newJar.putNextEntry(new ZipEntry(entry.getName()));
                        }
                        catch (ZipException zipe) {
                            EJBResourceAccessor.location.infoT("Exception in DeployAdmin.makeAppJar(...): Cannot write new jar entry " + entry.getName() + ". Reason: " + zipe.toString());
                            continue;
                        }
                        InputStream in = oldJar.getInputStream(entry);
                        newJar.write(AdminUtils.read((InputStream)in));
                        newJar.closeEntry();
                    }
                }
                catch (Exception e) {
                    throw new EJBFileOperationException("ejb_2158", (Throwable)e);
                }
                Object var13_15 = null;
                if (newJar != null) {
                    newJar.close();
                }
                if (oldJar == null) return;
                oldJar.close();
                return;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (newJar != null) {
                    newJar.close();
                }
                if (oldJar == null) throw throwable;
                oldJar.close();
                throw throwable;
            }
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2159", (Throwable)ioe);
        }
    }

    public void updateJar(String jarName, File[] filess, String[] filesForRemove, String rootDir) throws IOException {
        File newFile;
        File[] files = new File[filess.length];
        System.arraycopy(filess, 0, files, 0, filess.length);
        int i = 0;
        while (i < files.length) {
            if (files[i].getPath().indexOf(rootDir) == -1) {
                files[i] = new File(rootDir, files[i].getPath());
            }
            ++i;
        }
        ZipFile oldJar = new ZipFile(jarName);
        String tempName = jarName + "_";
        ZipOutputStream newJar = new ZipOutputStream(new FileOutputStream(tempName));
        Enumeration<? extends ZipEntry> enumeration = oldJar.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            String entryName = entry.getName();
            if (AdminUtils.stringInArray((String[])filesForRemove, (String)entryName)) continue;
            File updatedFile = null;
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2] != null && files[i2].getPath().substring(rootDir.length() + 1).replace(sepChar, '/').equals(entryName)) {
                    updatedFile = files[i2];
                    files[i2] = null;
                    break;
                }
                ++i2;
            }
            try {
                newJar.putNextEntry(new ZipEntry(entryName));
            }
            catch (ZipException zipe) {
                EJBResourceAccessor.location.infoT("Exception in DeployAdmin.updateJar(...): Cannot write new jar entry " + entryName + ". Reason: " + zipe.toString());
                continue;
            }
            InputStream in = null;
            in = updatedFile == null ? oldJar.getInputStream(entry) : new FileInputStream(updatedFile);
            newJar.write(AdminUtils.read((InputStream)in));
            newJar.closeEntry();
        }
        int i3 = 0;
        while (i3 < files.length) {
            block11: {
                if (files[i3] != null) {
                    newFile = files[i3];
                    String entryName = newFile.getPath().substring(rootDir.length() + 1).replace(sepChar, '/');
                    try {
                        newJar.putNextEntry(new ZipEntry(entryName));
                    }
                    catch (ZipException zipe) {
                        EJBResourceAccessor.location.infoT("Exception in DeployAdmin.updateJar(...): Cannot write new jar entry " + entryName + ". Reason: " + zipe.toString());
                        break block11;
                    }
                    FileInputStream in = new FileInputStream(newFile);
                    newJar.write(AdminUtils.read((InputStream)in));
                    newJar.closeEntry();
                }
            }
            ++i3;
        }
        newJar.close();
        oldJar.close();
        newFile = new File(tempName);
        File oldFile = new File(jarName);
        oldFile.delete();
        newFile.renameTo(oldFile);
    }

    private TransformerFactory getTransformerFactory() {
        if (this.factory == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.factory = TransformerFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
        }
        return this.factory;
    }

    protected void translateQL(String applicationName, EJBJarDescriptor[] ejbJars, ClassLoader loader, Vector warnings) throws DeploymentException {
        int i = 0;
        while (i < ejbJars.length) {
            if (!ejbJars[i].getAbstractSchema().isEmpty()) {
                QLTranslator translator = new QLTranslator(applicationName, ejbJars[i], loader, warnings);
                translator.translateAllQueries();
            }
            ++i;
        }
    }
}

