/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.container.registry.ObjectRegistry;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.locking.LockingContext;
import com.sap.engine.frame.core.locking.ServerInternalLocking;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.csiv2.EJBIORGeneratorInterface;
import com.sap.engine.interfaces.endpoint.EndpointActivation;
import com.sap.engine.interfaces.resourcecontext.ResourceContextFactory;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.applocking.TableLocking;
import com.sap.engine.services.deploy.container.ContainerManagement;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.ejb.EJBAdmin;
import com.sap.engine.services.ejb.EJBContainerEventListener;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.command.ContainerInfo;
import com.sap.engine.services.ejb.command.ContainerList;
import com.sap.engine.services.ejb.command.CreateTables;
import com.sap.engine.services.ejb.command.DropTables;
import com.sap.engine.services.ejb.command.GeneratePersistentXML;
import com.sap.engine.services.ejb.command.StartMDB;
import com.sap.engine.services.ejb.command.StopMDB;
import com.sap.engine.services.ejb.entity.SynchronizationList;
import com.sap.engine.services.ejb.entity.pm.lock.LocalLockSystem;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystem;
import com.sap.engine.services.ejb.entity.pm.lock.LockSystemImpl;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import com.sap.engine.services.ejb.runtime.RuntimeControls;
import com.sap.engine.services.ejb.util.AdminUtils;
import com.sap.engine.services.failover.storage.PersistentStorage;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class Environment
extends ContainerEventListenerAdapter {
    public static final String EJB_CATEGORY_SERVER = "/System/Server";
    public static final String EJB_LOCATION = "com.sap.engine.services.ejb";
    public static final String EJB_LOCKING_NAMESPACE = "$service.ejb";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$Environment == null ? (class$com$sap$engine$services$ejb$Environment = Environment.class$("com.sap.engine.services.ejb.Environment")) : class$com$sap$engine$services$ejb$Environment));
    private static Environment environment = null;
    private ApplicationServiceContext serviceContext = null;
    private CoreContext coreContext = null;
    private Properties serviceProperties = null;
    private SecurityContext secCtx = null;
    private Command[] commands = null;
    private int commandsId = -1;
    private ShellInterface shell = null;
    private Vector timeoutServiceListeners = null;
    private Object timeoutInterface = null;
    private CrossInterface cross = null;
    private Hashtable synchTable = null;
    private TransactionManager tManager = null;
    private EJBIORGeneratorInterface iorGenerator = null;
    private boolean iiopServiceStarted = false;
    private ContainerManagement deployService = null;
    private DeployCommunicator deployCommunicator = null;
    private ObjectRegistry objRegistry = null;
    private ThreadSystem threadSystem = null;
    private int securityContextObjectId = -1;
    private ConfigurationHandlerFactory configurationFactory = null;
    private SystemMonitor systemMonitor = null;
    private ComponentExecutionContext executionCtx = null;
    private EJBAdmin ejbAdmin = null;
    private RuntimeControls managementInterface = null;
    private EndpointActivation endpointActivation = null;
    private ResourceContextFactory resourceContextFactory = null;
    private PersistentStorage failoverPersistentStorage = null;
    private LockingContext lockCtx = null;
    private ServerInternalLocking internalLock = null;
    private LockSystem lockSystem = null;
    private TableLocking tableLocking = null;
    private LocalLockSystem localLockSystem = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$Environment;

    public Environment(ApplicationServiceContext _serviceContext) throws ServiceException {
        environment = this;
        this.serviceContext = _serviceContext;
        this.initLog();
        ApplicationContainerContext containerCtx = this.serviceContext.getContainerContext();
        this.coreContext = this.serviceContext.getCoreContext();
        this.serviceProperties = this.serviceContext.getServiceState().getProperties();
        this.systemMonitor = containerCtx.getSystemMonitor();
        this.objRegistry = containerCtx.getObjectRegistry();
        this.tManager = (TransactionManager)this.objRegistry.getServiceInterface("ts");
        this.secCtx = (SecurityContext)this.objRegistry.getServiceInterface("security");
        this.lockCtx = this.coreContext.getLockingContext();
        try {
            this.internalLock = this.lockCtx.createServerInternalLocking(EJB_LOCKING_NAMESPACE, "Synchronization For Registering Topic Listeners In Message-Driven Beans.");
        }
        catch (TechnicalLockException tle) {
            ServiceException toThrow = new ServiceException("ejb_9062", (Throwable)((Object)tle));
            LOCATION.traceThrowableT(500, null, (Throwable)((Object)toThrow));
            throw toThrow;
        }
        AdminUtils.poolContext = this.coreContext.getPoolContext();
        this.configurationFactory = this.coreContext.getConfigurationHandlerFactory();
        this.threadSystem = this.coreContext.getThreadSystem();
        this.securityContextObjectId = this.threadSystem.getContextObjectId("security");
        if (this.securityContextObjectId == -1) {
            ServiceException toThrow = new ServiceException("ejb_9057");
            LOCATION.traceThrowableT(500, null, (Throwable)((Object)toThrow));
            throw toThrow;
        }
        this.synchTable = new Hashtable();
        this.lockSystem = new LockSystemImpl(this.lockCtx);
        this.timeoutServiceListeners = new Vector();
        this.commands = new Command[]{new ContainerList(), new ContainerInfo(), new CreateTables(), new DropTables(), new GeneratePersistentXML(), new StopMDB(), new StartMDB()};
    }

    private void initLog() {
        Category category = Category.getCategory((String)EJB_CATEGORY_SERVER);
        Location location = Location.getLocation((String)EJB_LOCATION);
        EJBResourceAccessor.init(category, location);
    }

    public void unregister() {
        if (this.deployService != null) {
            this.deployService.unregisterContainer(this.ejbAdmin.getContainerInfo().getName());
        }
        if (this.commandsId != -1) {
            this.shell.unregisterCommands(this.commandsId);
            this.commandsId = -1;
        }
        this.serviceContext.getServiceState().unregisterContainerEventListener();
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public ApplicationServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public EJBAdmin getEJBAdmin() {
        return this.ejbAdmin;
    }

    public CoreContext getCoreContext() {
        return this.coreContext;
    }

    public Properties getServiceProperties() {
        return this.serviceProperties;
    }

    public RuntimeControls getManagementInterface() {
        return this.managementInterface;
    }

    public void setManagementInterface(RuntimeControls managementInterface) {
        this.managementInterface = managementInterface;
    }

    public void setEJBAdmin(EJBAdmin ejbAdmin) {
        this.ejbAdmin = ejbAdmin;
    }

    public TransactionManager getTransactionManager() {
        return this.tManager;
    }

    public PersistentStorage getFailoverPersistentStorage() {
        return this.failoverPersistentStorage;
    }

    public Context getNewNamingContext() throws NamingException {
        Properties p = new Properties();
        ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)p).put("domain", "true");
        return new InitialDirContext(p);
    }

    public SystemMonitor getSystemMonitor() {
        return this.systemMonitor;
    }

    public SynchronizationList getSynchronizationList(Transaction t) {
        SynchronizationList list = (SynchronizationList)this.synchTable.get(t);
        if (list == null) {
            list = new SynchronizationList(t, this);
            this.synchTable.put(t, list);
            try {
                t.registerSynchronization((Synchronization)list);
            }
            catch (Exception e) {
                BaseEJBException toThrow = new BaseEJBException("ejb_9056", e);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        return list;
    }

    public Hashtable getSynchronizationTable() {
        return this.synchTable;
    }

    public CrossInterface getCrossInterface() {
        return this.cross;
    }

    public EJBIORGeneratorInterface getIORGenerator() {
        if (this.iorGenerator == null) {
            BaseEJBException toThrow = new BaseEJBException("ejb_9054");
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return this.iorGenerator;
    }

    public boolean isIIOPServiceStarted() {
        return this.iiopServiceStarted;
    }

    public DeployCommunicator getDeployCommunicator() {
        if (this.deployCommunicator == null) {
            BaseEJBException toThrow = new BaseEJBException("ejb_9055");
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        return this.deployCommunicator;
    }

    public SecurityContext getSecurityContext() {
        return this.secCtx;
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objRegistry;
    }

    public ThreadSystem getThreadSystem() {
        return this.threadSystem;
    }

    public int getSecurityContextObjectId() {
        return this.securityContextObjectId;
    }

    public ComponentExecutionContext getExecutionContext() {
        return this.executionCtx;
    }

    public ConfigurationHandlerFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public LockingContext getLockingContext() {
        return this.lockCtx;
    }

    public ServerInternalLocking getInternalLock() {
        return this.internalLock;
    }

    public LockSystem getLockSystem() {
        return this.lockSystem;
    }

    public LocalLockSystem getLocalLockingSystem() {
        if (this.localLockSystem == null) {
            this.localLockSystem = new LocalLockSystem();
        }
        return this.localLockSystem;
    }

    public TableLocking getTableLocking() {
        if (this.tableLocking == null) {
            try {
                this.tableLocking = (TableLocking)this.getNewNamingContext().lookup("TableLocking");
            }
            catch (NamingException ne) {
                BaseEJBException toThrow = new BaseEJBException("ejb_9059", ne);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        return this.tableLocking;
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            this.commandsId = this.shell.registerCommands(this.commands);
        } else if (interfaceName.equals("cross")) {
            this.cross = (CrossInterface)interfaceImpl;
        } else if (interfaceName.equals("appcontext")) {
            this.executionCtx = (ComponentExecutionContext)interfaceImpl;
        } else if (interfaceName.equals("csiv2")) {
            this.iorGenerator = (EJBIORGeneratorInterface)interfaceImpl;
        } else if (interfaceName.equals("container")) {
            this.deployService = (ContainerManagement)interfaceImpl;
            this.deployCommunicator = this.deployService.registerContainer(this.ejbAdmin.getContainerInfo().getName(), this.ejbAdmin);
            try {
                this.deployCommunicator.startMyApplications(this.deployCommunicator.getMyApplications());
            }
            catch (RemoteException rex) {
                new ExceptionWrapperException(500, (Throwable)rex).log();
            }
        } else if (interfaceName.equals("endpoint_api")) {
            this.endpointActivation = (EndpointActivation)interfaceImpl;
        } else if (interfaceName.equals("resourcecontext_api")) {
            this.resourceContextFactory = (ResourceContextFactory)interfaceImpl;
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            if (this.commandsId != -1) {
                this.shell.unregisterCommands(this.commandsId);
                this.commandsId = -1;
            }
            this.shell = null;
        } else if (interfaceName.equals("cross")) {
            this.cross = null;
        } else if (interfaceName.equals("csiv2")) {
            this.iorGenerator = null;
        } else if (interfaceName.equals("container")) {
            this.deployService.unregisterContainer(this.ejbAdmin.getContainerInfo().getName());
            this.deployCommunicator = null;
            this.deployService = null;
        } else if (interfaceName.equals("endpoint_api")) {
            this.endpointActivation = null;
        } else if (interfaceName.equals("resourcecontext_api")) {
            this.resourceContextFactory = null;
        }
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals("timeout")) {
            this.timeoutInterface = serviceInterface;
            int i = 0;
            while (i < this.timeoutServiceListeners.size()) {
                ((EJBContainerEventListener)this.timeoutServiceListeners.elementAt(i)).startFunctionalityRelatedToService(this.timeoutInterface);
                ++i;
            }
        } else if (serviceName.equals("failover")) {
            this.failoverPersistentStorage = (PersistentStorage)serviceInterface;
        } else if (serviceName.equals("iiop")) {
            this.iiopServiceStarted = true;
        }
    }

    public void serviceStopped(String serviceName) {
        if (serviceName.equals("timeout")) {
            int i = 0;
            while (i < this.timeoutServiceListeners.size()) {
                ((EJBContainerEventListener)this.timeoutServiceListeners.elementAt(i)).stopFunctionalityRelatedToService("timeout");
                ++i;
            }
            this.timeoutInterface = null;
        } else if (serviceName.equals("failover")) {
            this.failoverPersistentStorage = null;
        } else if (serviceName.equals("iiop")) {
            this.iiopServiceStarted = false;
        }
    }

    public boolean setServiceProperty(String key, String value) {
        return true;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return true;
    }

    public void registerContainerListener(EJBContainerEventListener container, String serviceName) {
        if (serviceName.equals("timeout")) {
            this.timeoutServiceListeners.addElement(container);
            if (this.timeoutInterface != null) {
                container.startFunctionalityRelatedToService(this.timeoutInterface);
            }
        }
    }

    public void unregisterContainerListener(EJBContainerEventListener container, String serviceName) {
        if (serviceName.equals("timeout")) {
            this.timeoutServiceListeners.remove(container);
        }
    }

    public EndpointActivation getEndpointActivation() {
        return this.endpointActivation;
    }

    public ResourceContextFactory getResourceContextFactory() {
        return this.resourceContextFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

