/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.security.domain.ProtectionDomainFactory;
import com.sap.engine.services.applocking.TableLocking;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.ApplicationThreadDestroyer;
import com.sap.engine.services.ejb.ApplicationThreadInitializer;
import com.sap.engine.services.ejb.ContainerBoot;
import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.EJBHomeFactory;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.DeltaDeployAdmin;
import com.sap.engine.services.ejb.deploy.DeployAdmin;
import com.sap.engine.services.ejb.deploy.EJBLoader;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.orMappingVerifier.AbstractSchemaVerifier;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGeneratorsHolder;
import com.sap.engine.services.ejb.entity.pm.PersistenceManager;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.lock.EJBLockingImpl;
import com.sap.engine.services.ejb.exceptions.BaseEJBException;
import com.sap.engine.services.ejb.exceptions.BaseRemoteException;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBConfigurationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDescriptorException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBWarningException;
import com.sap.engine.services.ejb.handle.ServerHandleDelegate;
import com.sap.engine.services.ejb.runtime.ContainerRuntime;
import com.sap.engine.services.ejb.runtime.EJBAdminCallback;
import com.sap.engine.services.ejb.session.stateless_sp5.StatelessContainerFP;
import com.sap.engine.services.ejb.util.AdminJNDIUtils;
import com.sap.engine.services.ejb.util.AdminUtils;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.omg.CORBA.ORB;

public class EJBAdmin
implements ContainerInterface {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$EJBAdmin == null ? (class$com$sap$engine$services$ejb$EJBAdmin = EJBAdmin.class$("com.sap.engine.services.ejb.EJBAdmin")) : class$com$sap$engine$services$ejb$EJBAdmin));
    private static final Category CATEGORY = EJBResourceAccessor.category;
    private static final String CONTAINER_NAME = "EJBContainer";
    private static final String[] FILE_EXTENSIONS = new String[]{".jar"};
    private static final int APP_PRIORITY = 80;
    public static final String LOCAL_EJBS_CONTEXT = "localejbs/";
    public static final String RFC_ACCESS_EJB_CONTEXT = "rfcaccessejb/";
    public static final String EJB_COS_NAMING_CONTEXT = "ejbCosNaming/";
    private static final String EJBLOADER_PREFIX = "ejbGen";
    public static final String SERVICE_EJB_LOADER = "service:ejb";
    private static final String SERVICE_CONNECTOR_LOADER = "service:connector";
    private static final String INTERFACE_RESOURCECONTEXT_LOADER = "interface:resourcecontext_api";
    private static final String INTERFACE_RESOURCESET_LOADER = "interface:resourceset_api";
    private static final String INTERFACE_TRANSACTIONEXT_LOADER = "interface:transactionext";
    private static final String INTERFACE_SECURITY_LOADER = "interface:security";
    private static final String INTERFACE_CROSS_LOADER = "interface:cross";
    private static final String LIBRARY_OPENSQL_LOADER = "library:opensql";
    public static final String LIBRARY_ADD_EJB_LOADER = "library:add_ejb";
    public static final String UPDATE_APPLICATION_DEPLOYED = "app_deployed";
    public static final String UPDATE_CHANGED_JARS = "changed_jars";
    public static final String UPDATE_REMOVED_JARS = "removed_jars";
    public static final String UPDATE_ADDED_JARS = "added_jars";
    private static final String METHOD_NEED_UPDATE = "needUpdate(...)";
    private static final String METHOD_MAKE_UPDATE = "makeUpdate(...)";
    private static final String METHOD_NOTIFY_RUNTIME_CHANGES = "notifyRuntimeChanges(...)";
    private static final String METHOD_INIT_APPLICATION = "initApplication(...)";
    private static final String METHOD_FIND_EJB_REF_LINK = "findEjbRefLink(...)";
    private static final String METHOD_GET_APPLICATION_JARS = "getApplicationJars(...)";
    private static final String METHOD_GET_APPLICATION_JARS_LOCAL = "getApplicationJarsLocal(...)";
    private static final String METHOD_DEPLOY = "deploy(...)";
    private static final String METHOD_DOWNLOAD_APPLICATION_FILES = "downloadApplicationFiles(...)";
    private static final String METHOD_PREPARE_START = "prepareStart(...)";
    private static final String METHOD_PREPARE_STOP = "prepareStop(...)";
    private static final String METHOD_COMMIT_STOP = "commitStop(...)";
    private static final String METHOD_REMOVE = "remove(...)";
    private static final String METHOD_GET_RESOURCES_FOR_TEMP_LOADER = "getResourcesForTempLoader(...)";
    private static final String METHOD_MAKE_SINGLE_FILE_UPDATE = "makeSingleFileUpdate(...)";
    private static final String METHOD_COMMIT_SINGLE_FILE_UPDATE = "commitSingleFileUpdate(...)";
    private static final char sepChar = File.separatorChar;
    private Environment environment = null;
    private DeployAdmin deployAdmin = null;
    private DeltaDeployAdmin deltaDeployAdmin = null;
    private ContainerInfo containerInfo = null;
    private LoadContext classLoaderContext = null;
    private Hashtable allApplications = null;
    private Hashtable backupDescriptors = null;
    private Hashtable notLinkedEjbRefs = null;
    private Hashtable notLinkedEjbLocalRefs = null;
    private Vector ejbCallbacks = null;
    private ManagementListener managementListener = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$EJBAdmin;

    public EJBAdmin(Environment _environment) {
        this.environment = _environment;
        ServiceState serviceState = this.environment.getServiceContext().getServiceState();
        this.classLoaderContext = this.environment.getCoreContext().getLoadContext();
        ClassLoader add_ejb_loader = this.classLoaderContext.getClassLoader(LIBRARY_ADD_EJB_LOADER);
        AdminUtils.initMFKSources((ClassLoader)add_ejb_loader);
        this.deployAdmin = new DeployAdmin(this.environment);
        this.deltaDeployAdmin = new DeltaDeployAdmin(this.environment, this.deployAdmin);
        this.containerInfo = new ContainerInfo();
        this.containerInfo.setName(CONTAINER_NAME);
        this.containerInfo.setFileExtensions(FILE_EXTENSIONS);
        this.containerInfo.setPriority(80);
        this.containerInfo.setJ2EEContainer(true);
        this.containerInfo.setJ2EEModuleName("ejb");
        this.containerInfo.setServiceName(serviceState.getServiceName());
        this.containerInfo.setModuleName(null);
        this.containerInfo.setSupportingSingleFileUpdate(true);
        this.allApplications = new Hashtable();
        this.backupDescriptors = new Hashtable();
        this.notLinkedEjbRefs = new Hashtable();
        this.notLinkedEjbLocalRefs = new Hashtable();
        this.ejbCallbacks = new Vector();
    }

    public ManagementListener getManagementListener() {
        return this.managementListener;
    }

    public void setManagementListener(ManagementListener managementListener) {
        this.managementListener = managementListener;
    }

    public void addEJBAdminCallback(EJBAdminCallback callback) {
        this.ejbCallbacks.add(callback);
    }

    public void removeEJBAdminCallback(EJBAdminCallback callback) {
        this.ejbCallbacks.remove(callback);
    }

    public ApplicationDescriptor[] getAllApplications() {
        return this.allApplications.values().toArray(new ApplicationDescriptor[this.allApplications.size()]);
    }

    public ApplicationDescriptor getApplicationDescriptor(String appName) {
        return (ApplicationDescriptor)this.allApplications.get(appName);
    }

    public ApplicationDescriptor getRandomApplicationDescriptor() {
        Enumeration en = this.allApplications.elements();
        if (!en.hasMoreElements()) {
            return null;
        }
        return (ApplicationDescriptor)en.nextElement();
    }

    public ContainerRuntime getBeanContainer(String appName, String jarName, String beanName) {
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(appName);
        if (appDescr != null) {
            EJBJarDescriptor[] ejbJarDescrs = appDescr.getEJBJarDescriptors();
            int j = 0;
            while (j < ejbJarDescrs.length) {
                if (ejbJarDescrs[j].getJarName().equals(jarName)) {
                    DeploymentDescriptor[] descriptors = ejbJarDescrs[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (descriptors[i].getEjbName().equals(beanName)) {
                            return (ContainerRuntime)((Object)descriptors[i].getContainerBoot());
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    public DeploymentDescriptor getDeploymentDescriptor(String appName, String jarName, String beanName) {
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(appName);
        if (appDescr != null) {
            EJBJarDescriptor[] ejbJarDescrs = appDescr.getEJBJarDescriptors();
            int j = 0;
            while (j < ejbJarDescrs.length) {
                if (ejbJarDescrs[j].getJarName().equals(jarName)) {
                    DeploymentDescriptor[] descriptors = ejbJarDescrs[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (descriptors[i].getEjbName().equals(beanName)) {
                            return descriptors[i];
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    public DeploymentDescriptor getDeploymentDescriptor(String jndiName) {
        Enumeration enumeration = this.allApplications.elements();
        while (enumeration.hasMoreElements()) {
            ApplicationDescriptor appDescr = (ApplicationDescriptor)enumeration.nextElement();
            EJBJarDescriptor[] ejbJars = appDescr.getEJBJarDescriptors();
            int i = 0;
            while (i < ejbJars.length) {
                DeploymentDescriptor[] dd = ejbJars[i].getDDescriptors();
                int j = 0;
                while (j < dd.length) {
                    if (dd[j].getJndiName().equals(jndiName)) {
                        return dd[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public PersistentCache getPersistentCache(String appName, String jarName, String beanName) throws RemoteException {
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(appName);
        if (appDescr != null) {
            EJBJarDescriptor[] ejbJarDescrs = appDescr.getEJBJarDescriptors();
            int j = 0;
            while (j < ejbJarDescrs.length) {
                if (ejbJarDescrs[j].getJarName().equals(jarName)) {
                    PersistenceManager pm = ejbJarDescrs[j].getAbstractSchema().getPersistenceManager();
                    DeploymentDescriptor[] descriptors = ejbJarDescrs[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (descriptors[i].getEjbName().equals(beanName)) {
                            return pm.getPersistentCache(((CMPEntityDescriptor)descriptors[i]).getId());
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException, WarningException {
        String applicationName = deployInfo.getApplicationName();
        LOCATION.pathT("Need Update Begin... " + applicationName);
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_NEED_UPDATE}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        File backupDir = new File(appRootDir, "backup");
        File[] backupJars = null;
        int oldJarsLength = -1;
        ApplicationDescriptor oldAppDescr = (ApplicationDescriptor)this.allApplications.get(applicationName);
        if (oldAppDescr == null) {
            if (!backupDir.exists()) {
                LOCATION.infoT("Request for update of application " + applicationName + " which is not deployed in EJB Container. The update operation will deploy it.");
                return true;
            }
            backupJars = backupDir.listFiles();
            oldJarsLength = backupJars.length;
            InputStream[] altDDStreams = EJBAdmin.getAltDDStreams(appRootDir, backupJars);
            this.buildAppDescriptorBeforeUpdate(deployInfo, backupJars, altDDStreams);
        } else {
            backupJars = backupDir.listFiles();
            oldJarsLength = backupJars.length;
        }
        int newJarsLength = archiveFiles.length;
        StringBuffer removedJars = new StringBuffer();
        StringBuffer changedJars = new StringBuffer();
        StringBuffer addedJars = new StringBuffer();
        int i = 0;
        while (i < newJarsLength) {
            String jarName = archiveFiles[i].getName();
            File jarFile = new File(backupDir, jarName);
            if (jarFile.exists()) {
                changedJars.append(jarName).append(";");
            } else {
                addedJars.append(jarName).append(";");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < oldJarsLength) {
            String jarName = backupJars[i2].getName();
            boolean found = false;
            int j = 0;
            while (j < newJarsLength) {
                if (jarName.equals(archiveFiles[j].getName())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                removedJars.append(jarName).append(";");
            }
            ++i2;
        }
        boolean result = false;
        if (removedJars.length() > 0) {
            ((Hashtable)props).put(UPDATE_REMOVED_JARS, removedJars.toString());
            result = true;
        }
        if (changedJars.length() > 0) {
            ((Hashtable)props).put(UPDATE_CHANGED_JARS, changedJars.toString());
            result = true;
        }
        if (addedJars.length() <= 0) return result;
        ((Hashtable)props).put(UPDATE_ADDED_JARS, addedJars.toString());
        return true;
    }

    private void buildAppDescriptorBeforeUpdate(ContainerDeploymentInfo deployInfo, File[] backupJars, InputStream[] altDDStreams) throws DeploymentException {
        String applicationName = deployInfo.getApplicationName();
        Configuration appConfig = deployInfo.getConfiguration();
        int oldJarsLength = backupJars.length;
        Vector warnings = new Vector();
        ClassLoader oldAppLoader = this.classLoaderContext.getClassLoader(applicationName);
        ApplicationDescriptor appDescr = new ApplicationDescriptor(applicationName);
        EJBJarDescriptor[] ejbjarDescriptors = new EJBJarDescriptor[oldJarsLength];
        int j = 0;
        while (j < oldJarsLength) {
            ejbjarDescriptors[j] = this.deployAdmin.parseSingleJar(backupJars[j], altDDStreams[j], warnings, oldAppLoader, applicationName, false, null, false, null);
            ++j;
        }
        Configuration ejbConfig = null;
        Configuration jarIndexesConfig = null;
        try {
            ejbConfig = appConfig.getSubConfiguration("ejb");
            jarIndexesConfig = ejbConfig.getSubConfiguration("jarindexes");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2104", new Object[]{METHOD_NEED_UPDATE, applicationName}, (Throwable)((Object)ce));
        }
        int j2 = 0;
        while (j2 < oldJarsLength) {
            Integer jarIndex = null;
            try {
                jarIndex = (Integer)jarIndexesConfig.getConfigEntry(ejbjarDescriptors[j2].getJarName());
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2131", new Object[]{ejbjarDescriptors[j2].getJarName(), applicationName}, (Throwable)((Object)ce));
            }
            ejbjarDescriptors[j2].setJarIndex(jarIndex);
            ++j2;
        }
        appDescr.setEJBJarDescriptors(ejbjarDescriptors);
        this.allApplications.put(applicationName, appDescr);
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException {
        String applicationName = deployInfo.getApplicationName();
        LOCATION.pathT("Make Update Begin... " + applicationName);
        Configuration appConfig = deployInfo.getConfiguration();
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_MAKE_UPDATE}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        ApplicationDescriptor oldAppDescr = (ApplicationDescriptor)this.allApplications.get(applicationName);
        if (oldAppDescr == null) {
            try {
                appConfig.getSubConfiguration("ejb").deleteConfiguration();
            }
            catch (ConfigurationException ce) {
                LOCATION.infoT("Unable to delete configurations for application " + applicationName + ". Database problem has occurred. Reason: " + ((Throwable)((Object)ce)).toString());
            }
            if (appRootDir.exists()) {
                AdminUtils.delFolder((File)appRootDir);
            }
            if (archiveFiles.length == 0) {
                return null;
            }
            return this.deploy(archiveFiles, deployInfo, props);
        }
        EJBJarDescriptor[] oldJarDescriptors = oldAppDescr.getEJBJarDescriptors();
        File backupDir = new File(appRootDir, "backup");
        File appJarsDir = new File(appRootDir, "applicationjars");
        File clientJarsDir = new File(appRootDir, "clientjars");
        File genJarsDir = new File(appRootDir, "jars");
        File altDDsDir = new File(appRootDir, "altdds");
        File oldAltDDsDir = new File(appRootDir, "_oldAltdds");
        oldAltDDsDir.mkdirs();
        File[] altDDXmls = altDDsDir.listFiles();
        try {
            int i = 0;
            while (i < altDDXmls.length) {
                AdminUtils.copyFileToDir((File)altDDXmls[i], (File)oldAltDDsDir);
                ++i;
            }
        }
        catch (Exception e) {
            throw new EJBFileOperationException("ejb_2103", new Object[]{applicationName}, e);
        }
        String[] addedJars = AdminUtils.getValues((Properties)props, (String)UPDATE_ADDED_JARS);
        String[] changedJars = AdminUtils.getValues((Properties)props, (String)UPDATE_CHANGED_JARS);
        String[] removedJars = AdminUtils.getValues((Properties)props, (String)UPDATE_REMOVED_JARS);
        int i = 0;
        while (i < removedJars.length) {
            new File(backupDir, removedJars[i]).delete();
            new File(altDDsDir, removedJars[i] + ".xml").delete();
            ++i;
        }
        AdminUtils.emptyFolder((File)appJarsDir);
        AdminUtils.emptyFolder((File)clientJarsDir);
        AdminUtils.emptyFolder((File)genJarsDir);
        int addedAndChangedJarsLength = addedJars.length + changedJars.length;
        File[] addedAndChangedJars = new File[addedAndChangedJarsLength];
        int i2 = 0;
        while (i2 < addedJars.length) {
            int j = 0;
            while (j < archiveFiles.length) {
                if (addedJars[i2].equals(archiveFiles[j].getName())) {
                    addedAndChangedJars[i2] = archiveFiles[j];
                    break;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < changedJars.length) {
            int j = 0;
            while (j < archiveFiles.length) {
                if (changedJars[i3].equals(archiveFiles[j].getName())) {
                    addedAndChangedJars[addedJars.length + i3] = archiveFiles[j];
                    break;
                }
                ++j;
            }
            ++i3;
        }
        ClassLoader earLoader = deployInfo.getLoader();
        InputStream[] altDDStreams = this.getAltDDStreams(addedAndChangedJars, altDDsDir, deployInfo, earLoader);
        Configuration ejbConfig = null;
        Configuration securityConfig = null;
        try {
            ejbConfig = appConfig.getSubConfiguration("ejb");
            securityConfig = ejbConfig.getSubConfiguration("security");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2104", new Object[]{METHOD_MAKE_UPDATE, applicationName}, (Throwable)((Object)ce));
        }
        String[] remoteSupportGenerators = deployInfo.getRemoteSupportGenerators();
        Vector warnings = new Vector();
        ApplicationDescriptor newAppDescr = this.deltaDeployAdmin.makeUpdate(oldAppDescr, addedAndChangedJars, altDDStreams, addedJars.length, removedJars, earLoader, remoteSupportGenerators, securityConfig, props, warnings);
        EJBJarDescriptor[] newJarDescriptors = newAppDescr.getEJBJarDescriptors();
        int jarsLength = archiveFiles.length;
        if (newJarDescriptors.length != jarsLength) {
            throw new EJBDeploymentException("ejb_2105");
        }
        try {
            int i4 = 0;
            while (i4 < addedAndChangedJarsLength) {
                AdminUtils.copyFileToDir((File)addedAndChangedJars[i4], (File)backupDir);
                ++i4;
            }
        }
        catch (Exception e) {
            throw new EJBFileOperationException("ejb_2103", new Object[]{applicationName}, e);
        }
        SimpleEarDescriptor earDescr = deployInfo.getEarDescriptor();
        if (earDescr != null && earDescr.isFailOverEnable()) {
            this.checkFailoverAndPassivation(applicationName, newJarDescriptors, warnings);
        }
        this.backupDescriptors.put(applicationName, oldAppDescr);
        this.allApplications.put(applicationName, newAppDescr);
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        this.fillDeployedComponents(result, newJarDescriptors, true);
        this.fillDeployedComponents(result, oldJarDescriptors, false);
        if (warnings.size() != 0) {
            result.setWarnings(warnings);
        }
        File[] appJars = appJarsDir.listFiles();
        File[] clientJars = clientJarsDir.listFiles();
        String[] componentArchives = new String[appJars.length + clientJars.length];
        int i5 = 0;
        while (i5 < appJars.length) {
            componentArchives[i5] = appJars[i5].getPath();
            ++i5;
        }
        int i6 = 0;
        while (i6 < clientJars.length) {
            componentArchives[appJars.length + i6] = clientJars[i6].getPath();
            ++i6;
        }
        result.setFilesForClassloader(componentArchives);
        Configuration appJarsConfig = null;
        Configuration clientJarsConfig = null;
        Configuration genJarsConfig = null;
        Configuration backupConfig = null;
        Configuration altDDsConfig = null;
        Configuration jarIndexesConfig = null;
        Configuration unknownPKConfig = null;
        try {
            appJarsConfig = ejbConfig.getSubConfiguration("applicationjars");
            clientJarsConfig = ejbConfig.getSubConfiguration("clientjars");
            genJarsConfig = ejbConfig.getSubConfiguration("jars");
            backupConfig = ejbConfig.getSubConfiguration("backup");
            altDDsConfig = ejbConfig.getSubConfiguration("altdds");
            jarIndexesConfig = ejbConfig.getSubConfiguration("jarindexes");
            unknownPKConfig = ejbConfig.getSubConfiguration("unknownpk");
            int i7 = 0;
            while (i7 < oldJarDescriptors.length) {
                if (!oldJarDescriptors[i7].getAbstractSchema().isEmpty() && AdminUtils.stringInArray((String[])removedJars, (String)oldJarDescriptors[i7].getJarName())) {
                    unknownPKConfig.deleteConfiguration(String.valueOf(oldJarDescriptors[i7].getJarIndex()));
                }
                ++i7;
            }
            int i8 = 0;
            while (i8 < newJarDescriptors.length) {
                if (!newJarDescriptors[i8].getAbstractSchema().isEmpty() && AdminUtils.stringInArray((String[])addedJars, (String)newJarDescriptors[i8].getJarName())) {
                    unknownPKConfig.createSubConfiguration(String.valueOf(newJarDescriptors[i8].getJarIndex()));
                }
                ++i8;
            }
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2106", new Object[]{METHOD_MAKE_UPDATE, applicationName}, (Throwable)((Object)ce));
        }
        File[] genJars = genJarsDir.listFiles();
        File[] backupJars = backupDir.listFiles();
        altDDXmls = altDDsDir.listFiles();
        if (appJars.length != jarsLength || clientJars.length != jarsLength || genJars.length != jarsLength) {
            throw new EJBDeploymentException("ejb_2105");
        }
        try {
            this.updateFileEntries(appJars, appJarsConfig);
            this.updateFileEntries(clientJars, clientJarsConfig);
            this.updateFileEntries(genJars, genJarsConfig);
            this.updateFileEntries(backupJars, backupConfig);
            this.updateFileEntries(altDDXmls, altDDsConfig);
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2107", new Object[]{METHOD_MAKE_UPDATE, applicationName}, (Throwable)((Object)ce));
        }
        try {
            AdminUtils.updateCRCIndexForFolder((File)appJarsDir, (String)"applicationjars.crc", (String)"applicationjars.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.updateCRCIndexForFolder((File)clientJarsDir, (String)"clientjars.crc", (String)"clientjars.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.updateCRCIndexForFolder((File)genJarsDir, (String)"jars.crc", (String)"jars.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.updateCRCIndexForFolder((File)backupDir, (String)"backup.crc", (String)"backup.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.updateCRCIndexForFolder((File)altDDsDir, (String)"altdds.crc", (String)"altdds.idx", (File)appRootDir, (Configuration)ejbConfig);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2108", new Object[]{applicationName}, ioe);
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2109", new Object[]{applicationName}, (Throwable)((Object)ce));
        }
        int i9 = 0;
        while (i9 < oldJarDescriptors.length) {
            String jarName = oldJarDescriptors[i9].getJarName();
            if (AdminUtils.stringInArray((String[])removedJars, (String)jarName)) {
                try {
                    jarIndexesConfig.deleteConfigEntry(jarName);
                }
                catch (ConfigurationException ce) {
                    throw new EJBConfigurationException("ejb_2110", new Object[]{jarName, applicationName}, (Throwable)((Object)ce));
                }
            }
            ++i9;
        }
        int i10 = 0;
        while (i10 < newJarDescriptors.length) {
            String jarName = newJarDescriptors[i10].getJarName();
            if (AdminUtils.stringInArray((String[])addedJars, (String)jarName)) {
                try {
                    jarIndexesConfig.addConfigEntry(jarName, new Integer(newJarDescriptors[i10].getJarIndex()));
                }
                catch (ConfigurationException ce) {
                    throw new EJBConfigurationException("ejb_2111", new Object[]{jarName, applicationName}, (Throwable)((Object)ce));
                }
            }
            ++i10;
        }
        try {
            ejbConfig.modifyConfigEntry("FP", "SP5", true);
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2199", new Object[]{applicationName}, (Throwable)((Object)ce));
        }
        return result;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration appConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) {
        this.backupDescriptors.remove(applicationName);
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration appConfig, Properties props) throws WarningException {
        ApplicationDescriptor oldAppDescr = (ApplicationDescriptor)this.backupDescriptors.remove(applicationName);
        if (oldAppDescr != null) {
            this.allApplications.put(applicationName, oldAppDescr);
        }
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
        Vector<String> warnings = new Vector<String>();
        try {
            String appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
            File appDir = new File(appRootDir);
            File backupDir = new File(appDir, "backup");
            File clientJarsDir = new File(appDir, "clientjars");
            File genJarsDir = new File(appDir, "jars");
            Configuration ejbConfig = appConfig.getSubConfiguration("ejb");
            Configuration backupConfig = ejbConfig.getSubConfiguration("backup");
            Configuration clientJarsConfig = ejbConfig.getSubConfiguration("clientjars");
            Configuration genJarsConfig = ejbConfig.getSubConfiguration("jars");
            AdminUtils.makeConsistent((File)backupDir, (Configuration)backupConfig, (Configuration)ejbConfig, (String)"backup.crc", (String)"backup.idx", warnings);
            AdminUtils.makeConsistent((File)clientJarsDir, (Configuration)clientJarsConfig, (Configuration)ejbConfig, (String)"clientjars.crc", (String)"clientjars.idx", warnings);
            AdminUtils.makeConsistent((File)genJarsDir, (Configuration)genJarsConfig, (Configuration)ejbConfig, (String)"jars.crc", (String)"jars.idx", warnings);
        }
        catch (Exception exc) {
            CATEGORY.logThrowableT(400, LOCATION, null, (Throwable)exc);
            warnings.add(exc.toString());
        }
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_2112", new Object[]{METHOD_NOTIFY_RUNTIME_CHANGES});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
    }

    public boolean deployIiopSupport(String appName) throws RemoteException {
        if (!this.environment.isIIOPServiceStarted()) {
            return false;
        }
        DeployCommunicator deployCommunicator = this.environment.getDeployCommunicator();
        File clientJarsDir = null;
        File genJarsDir = null;
        Configuration ejbConfig = null;
        Configuration clientJarsConfig = null;
        Configuration genJarsConfig = null;
        Vector warnings = new Vector();
        try {
            String appRootDir = deployCommunicator.getMyWorkDirectory(appName);
            File appDir = new File(appRootDir);
            clientJarsDir = new File(appDir, "clientjars");
            genJarsDir = new File(appDir, "jars");
            File[] genJars = genJarsDir.listFiles();
            int i = 0;
            while (i < genJars.length) {
                if (this.containsIiopSupport(genJars[i])) {
                    return true;
                }
                ++i;
            }
            Configuration appConfig = deployCommunicator.startRuntimeChanges(appName);
            ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(appName);
            ClassLoader appLoader = this.classLoaderContext.getClassLoader(appName);
            ClassLoader ejbLoader = this.classLoaderContext.getClassLoader(EJBLOADER_PREFIX + appName);
            if (appDescr == null || appLoader == null || ejbLoader == null) {
                throw new EJBDeploymentException("ejb_2198", new Object[]{appName});
            }
            String[] appClassPaths = this.deployAdmin.makeCompilerClassPaths(appName, appLoader, warnings);
            String[] ejbLoaderResources = ((ReferencedLoader)ejbLoader).getResourceNames();
            StringBuffer appCrossCP = new StringBuffer(appClassPaths[1]);
            int i2 = 0;
            while (i2 < ejbLoaderResources.length) {
                appCrossCP.append(ejbLoaderResources[i2]).append(File.pathSeparator);
                ++i2;
            }
            String appCrossClassPath = appCrossCP.toString();
            EJBJarDescriptor[] jarDescrs = appDescr.getEJBJarDescriptors();
            int i3 = 0;
            while (i3 < jarDescrs.length) {
                EJBJarDescriptor jarDescr = jarDescrs[i3];
                File tempDir = new File(appDir, "temp" + sepChar + "temp" + System.currentTimeMillis());
                HashSet clientJarComponents = new HashSet();
                this.deployAdmin.deploySupport(tempDir.getPath(), jarDescr, ejbLoader, appCrossClassPath, clientJarComponents, new String[]{"iiop"});
                File[] clientFiles = new File[clientJarComponents.size()];
                int cf = 0;
                Iterator it = clientJarComponents.iterator();
                while (it.hasNext()) {
                    String fileName = (String)it.next();
                    clientFiles[cf++] = new File(tempDir, fileName);
                }
                String clientJarName = clientJarsDir.getPath() + sepChar + jarDescr.getClientJarName();
                try {
                    this.deployAdmin.updateJar(clientJarName, clientFiles, null, tempDir.getPath());
                }
                catch (IOException ioe) {
                    throw new EJBFileOperationException("ejb_2161", new Object[]{"clientjars/" + jarDescr.getClientJarName()}, ioe);
                }
                Vector vClassFiles = new Vector();
                this.deployAdmin.getClassFiles(tempDir, vClassFiles);
                File[] classFiles = vClassFiles.toArray(new File[vClassFiles.size()]);
                String genJarName = genJarsDir.getPath() + sepChar + "gen_" + jarDescr.getJarName();
                try {
                    this.deployAdmin.updateJar(genJarName, classFiles, null, tempDir.getPath());
                }
                catch (IOException ioe) {
                    throw new EJBFileOperationException("ejb_2161", new Object[]{"jars/" + jarDescr.getJarName()}, ioe);
                }
                ++i3;
            }
            File[] clientJars = clientJarsDir.listFiles();
            ejbConfig = appConfig.getSubConfiguration("ejb");
            clientJarsConfig = ejbConfig.getSubConfiguration("clientjars");
            genJarsConfig = ejbConfig.getSubConfiguration("jars");
            this.updateFileEntries(clientJars, clientJarsConfig);
            this.updateFileEntries(genJars, genJarsConfig);
            AdminUtils.updateCRCIndexForFolder((File)clientJarsDir, (String)"clientjars.crc", (String)"clientjars.idx", (File)appDir, (Configuration)ejbConfig);
            AdminUtils.updateCRCIndexForFolder((File)genJarsDir, (String)"jars.crc", (String)"jars.idx", (File)appDir, (Configuration)ejbConfig);
            deployCommunicator.makeRuntimeChanges(appName, true);
        }
        catch (Exception ex) {
            if (clientJarsDir != null && clientJarsConfig != null) {
                try {
                    AdminUtils.makeConsistent(clientJarsDir, clientJarsConfig, ejbConfig, (String)"clientjars.crc", (String)"clientjars.idx", warnings);
                }
                catch (DeploymentException dex) {
                    throw new BaseRemoteException("ejb_9008", new Object[]{clientJarsConfig.getPath(), ejbConfig.getPath()}, (Throwable)((Object)dex));
                }
            }
            if (genJarsDir != null && genJarsConfig != null) {
                try {
                    AdminUtils.makeConsistent(genJarsDir, genJarsConfig, ejbConfig, (String)"jars.crc", (String)"jars.idx", warnings);
                }
                catch (DeploymentException dex) {
                    throw new BaseRemoteException("ejb_9008", new Object[]{genJarsConfig.getPath(), ejbConfig.getPath()}, (Throwable)((Object)dex));
                }
            }
            try {
                deployCommunicator.rollbackRuntimeChanges(appName);
            }
            catch (Exception e) {
                new ExceptionWrapperException(500, (Throwable)e).log();
            }
            throw new BaseRemoteException("ejb_2168", new Object[]{appName}, ex);
        }
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_2197", new Object[]{appName});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
        return true;
    }

    private boolean containsIiopSupport(File genJar) throws IOException {
        ZipFile jar = new ZipFile(genJar);
        Enumeration<? extends ZipEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("_Tie.class")) continue;
            return true;
        }
        return false;
    }

    private void initApplication(ApplicationDescriptor appDescr, Vector warnings) throws DeploymentException {
        String applicationName = appDescr.getName();
        if (appDescr.isLoaded) {
            LOCATION.infoT("Trying to init loaded application " + applicationName);
            return;
        }
        File jarsDir = null;
        CodeSource code = null;
        String appRootDir = null;
        try {
            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_INIT_APPLICATION}, ioe);
        }
        try {
            jarsDir = new File(appRootDir + sepChar + "jars");
            URL url = new URL("file", "", jarsDir.getCanonicalPath() + "/-");
            code = new CodeSource(url, null);
        }
        catch (MalformedURLException malfe) {
            throw new EJBDeploymentException("ejb_2113", new Object[]{applicationName}, malfe);
        }
        catch (IOException ioe) {
            throw new EJBDeploymentException("ejb_2114", new Object[]{applicationName}, ioe);
        }
        ReferencedLoader refLoader = (ReferencedLoader)appDescr.getEjbLoader();
        if (refLoader != null) {
            warnings.add("EJBLoader for application " + applicationName + " is not null in initApplication!");
            try {
                this.classLoaderContext.unregister(refLoader);
            }
            catch (Exception e) {
                throw new EJBDeploymentException("ejb_2115", new Object[]{applicationName}, e);
            }
        }
        String ejbLoaderName = EJBLOADER_PREFIX + applicationName;
        ClassLoader appLoader = appDescr.getAppLoader();
        ProtectionDomain protDomain = ProtectionDomainFactory.getFactory().registerApplicationProtectionDomain(ejbLoaderName + ":" + ejbLoaderName, code);
        EJBLoader ejbLoader = new EJBLoader(jarsDir.listFiles(), ejbLoaderName, appLoader, protDomain);
        String[] addJars = appDescr.getOthersJars();
        if (addJars != null && addJars.length != 0) {
            JarsResource jars = new JarsResource(addJars);
            ((ResourceLoader)appLoader).addResource(jars);
        }
        try {
            this.classLoaderContext.register(ejbLoader);
            this.classLoaderContext.registerReference(ejbLoaderName, SERVICE_EJB_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, SERVICE_CONNECTOR_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, INTERFACE_RESOURCECONTEXT_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, INTERFACE_RESOURCESET_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, INTERFACE_TRANSACTIONEXT_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, INTERFACE_SECURITY_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, INTERFACE_CROSS_LOADER);
            this.classLoaderContext.registerReference(ejbLoaderName, LIBRARY_OPENSQL_LOADER);
        }
        catch (Exception e) {
            throw new EJBDeploymentException("ejb_2116", new Object[]{applicationName}, e);
        }
        appDescr.setEjbLoader(ejbLoader);
    }

    private void prepareLoad(ApplicationDescriptor appDescr, String fpDeploy) throws DeploymentException {
        ClassLoader loader = appDescr.getEjbLoader();
        String applicationName = appDescr.getName();
        EJBJarDescriptor[] ejbjarDescriptors = appDescr.getEJBJarDescriptors();
        if (ejbjarDescriptors == null) {
            throw new EJBDescriptorException("ejb_2117", new Object[]{applicationName}, null);
        }
        int j = 0;
        while (j < ejbjarDescriptors.length) {
            DeploymentDescriptor[] descriptors = ejbjarDescriptors[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                String bootClassName = null;
                try {
                    String ejbName = descriptors[i].getEjbName();
                    LOCATION.pathT("Loading Bean: " + ejbName);
                    bootClassName = descriptors[i].getBootClassName();
                    if (fpDeploy != null) {
                        bootClassName = bootClassName + "FP";
                        if (descriptors[i] instanceof SessionDescriptor && ((SessionDescriptor)descriptors[i]).getSessionType() == 0 && fpDeploy.equals("SP5")) {
                            bootClassName = "com.sap.engine.services.ejb.session.stateless_sp5.StatelessContainerFP";
                        }
                    }
                    Class<?> bootClass = loader.loadClass(bootClassName);
                    ContainerBoot containerBoot = (ContainerBoot)bootClass.newInstance();
                    descriptors[i].setContainerBoot(containerBoot);
                    containerBoot.init(this.environment, applicationName, descriptors[i], loader);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new EJBDeploymentException("ejb_2118", new Object[]{bootClassName}, ncdfe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new EJBDeploymentException("ejb_2118", new Object[]{bootClassName}, cnfe);
                }
                catch (ContainerInitializationException cie) {
                    throw new EJBDeploymentException("ejb_2119", new Object[]{bootClassName}, cie);
                }
                catch (InstantiationException ie) {
                    throw new EJBDeploymentException("ejb_2120", new Object[]{bootClassName}, ie);
                }
                catch (IllegalAccessException iae) {
                    throw new EJBDeploymentException("ejb_2121", new Object[]{bootClassName}, iae);
                }
                ++i;
            }
            ++j;
        }
    }

    private void commitLoad(ApplicationDescriptor appDescr, String fpDeploy, Vector warnings) throws DeploymentException {
        ClassLoader loader = appDescr.getEjbLoader();
        String applicationName = appDescr.getName();
        EJBJarDescriptor[] ejbjarDescriptors = appDescr.getEJBJarDescriptors();
        if (ejbjarDescriptors == null) {
            warnings.add("Cannot commitLoad for application " + applicationName + ", because ApplicationDescriptor is wrong.");
            return;
        }
        Context naming = null;
        try {
            naming = this.environment.getNewNamingContext();
        }
        catch (NamingException ne) {
            LOCATION.traceThrowableT(500, null, (Throwable)ne);
            warnings.add("EJB Service cannot commit load of application " + applicationName + ", because of JNDI problems.");
            return;
        }
        int j = 0;
        while (j < ejbjarDescriptors.length) {
            DeploymentDescriptor[] descriptors = ejbjarDescriptors[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                ContainerBoot containerBoot = descriptors[i].getContainerBoot();
                String ejbName = descriptors[i].getEjbName();
                try {
                    String trimmedJndiName;
                    Reference r;
                    SessionDescriptor sessDescr;
                    EJBHome ejbHome = containerBoot.getEJBHome();
                    EJBLocalHome ejbLocalHome = containerBoot.getEJBLocalHome();
                    String jndiName = descriptors[i].getJndiName();
                    boolean stateless = false;
                    if (descriptors[i] instanceof SessionDescriptor && (sessDescr = (SessionDescriptor)descriptors[i]).getSessionType() == 0) {
                        stateless = true;
                    }
                    boolean boundLocal = false;
                    if (ejbLocalHome != null) {
                        LOCATION.pathT("Binding: " + ejbName + " >>> LOCAL JNDI name: " + jndiName);
                        AdminJNDIUtils.bind((Context)naming, (String)(LOCAL_EJBS_CONTEXT + jndiName), (Object)ejbLocalHome);
                        if (stateless) {
                            r = new Reference(LOCAL_EJBS_CONTEXT + jndiName, "com.sap.engine.services.ejb.EJBHomeFactory", "");
                            AdminJNDIUtils.bind((Context)naming, (String)(RFC_ACCESS_EJB_CONTEXT + jndiName), (Object)r);
                            trimmedJndiName = AdminUtils.trimLeadingChars((String)jndiName, (char)'/');
                            EJBHomeFactory.registerHome(RFC_ACCESS_EJB_CONTEXT + trimmedJndiName, ejbLocalHome);
                            boundLocal = true;
                        }
                    }
                    if (ejbHome != null) {
                        LOCATION.pathT("Binding: " + ejbName + " >>> JNDI name: " + jndiName);
                        AdminJNDIUtils.bind((Context)naming, (String)jndiName, (Object)ejbHome);
                        if (stateless && fpDeploy != null && fpDeploy.equals("SP5")) {
                            EJBHome serverEjbHome = ((StatelessContainerFP)containerBoot).getServerEJBHome();
                            LOCATION.pathT("Binding: " + ejbName + " >>> ejbCosNaming JNDI name: " + jndiName);
                            AdminJNDIUtils.bind((Context)naming, (String)(EJB_COS_NAMING_CONTEXT + jndiName), (Object)serverEjbHome);
                        }
                        if (stateless && !boundLocal) {
                            r = new Reference(jndiName, "com.sap.engine.services.ejb.EJBHomeFactory", "");
                            AdminJNDIUtils.bind((Context)naming, (String)(RFC_ACCESS_EJB_CONTEXT + jndiName), (Object)r);
                            trimmedJndiName = AdminUtils.trimLeadingChars((String)jndiName, (char)'/');
                            EJBHomeFactory.registerHome(RFC_ACCESS_EJB_CONTEXT + trimmedJndiName, ejbHome);
                        }
                    }
                }
                catch (NamingException ne) {
                    LOCATION.traceThrowableT(500, null, (Throwable)ne);
                    warnings.add("Cannot bind EJBHome and/or EJBLocalHome for bean: " + ejbName + ".");
                }
                catch (Exception e) {
                    LOCATION.traceThrowableT(500, null, (Throwable)e);
                    warnings.add("Cannot bind EJBHome and/or EJBLocalHome for bean: " + ejbName + ". Probably its jndi-name is not correct.");
                }
                ++i;
            }
            AbstractSchema absSchema = ejbjarDescriptors[j].getAbstractSchema();
            if (!absSchema.isEmpty()) {
                PersistenceManager pm = null;
                try {
                    pm = new PersistenceManager(this.environment, absSchema, loader, applicationName);
                }
                catch (BaseEJBException ejbEx) {
                    ejbEx.trace(LOCATION);
                    warnings.add(((Throwable)((Object)ejbEx)).toString());
                }
                if (pm != null) {
                    absSchema.setPersistenceManager(pm);
                    pm.initDataSource(absSchema.useSelectForUpdate());
                }
            }
            ++j;
        }
    }

    private void initPools(ApplicationDescriptor appDescr, Vector warnings) {
        Object synch = new Object();
        ApplicationThreadInitializer initializer = new ApplicationThreadInitializer(synch, appDescr, warnings);
        try {
            Object object = synch;
            synchronized (object) {
                this.environment.getThreadSystem().startThread(initializer, false);
                synch.wait();
            }
        }
        catch (InterruptedException iex) {
            CATEGORY.logThrowableT(400, LOCATION, "Initialization of container pool interrupted. Pool may be not initialized.", (Throwable)iex);
            warnings.add("Initialization of container pool interrupted. Pool may be not initialized.");
        }
    }

    private void destroyContainers(ApplicationDescriptor appDescr, Vector warnings) {
        Object synch = new Object();
        ApplicationThreadDestroyer destroyer = new ApplicationThreadDestroyer(synch, appDescr, warnings);
        try {
            Object object = synch;
            synchronized (object) {
                this.environment.getThreadSystem().startThread(destroyer, false);
                synch.wait();
            }
        }
        catch (InterruptedException iex) {
            CATEGORY.logThrowableT(400, LOCATION, "Destroy containers operation interrupted. Maybe not all application data is consistent.", (Throwable)iex);
            warnings.add("Destroy containers operation interrupted. Maybe not all application data is consistent.");
        }
    }

    private void createBeanContexts(ApplicationDescriptor appDescr, Vector warnings) throws DeploymentException {
        String refEjbHome;
        String ejbLinkName;
        String jndiLinkName;
        String refName;
        EJBJarDescriptor[] ejbJarDescriptors = appDescr.getEJBJarDescriptors();
        String appName = appDescr.getName();
        String factoryName = "com.sap.engine.services.jndi.ComponentObjectFactory";
        Context naming = null;
        try {
            naming = this.environment.getNewNamingContext();
        }
        catch (NamingException ne) {
            throw new EJBDeploymentException("ejb_2122", new Object[]{appName}, ne);
        }
        try {
            AdminJNDIUtils.emptyContext((Context)((Context)naming.lookup("ejbContexts/" + appName)));
        }
        catch (NameNotFoundException nex) {
            LOCATION.infoT("The old version of ejbContexts/" + appName + " was not found in the JNDI. A new conext will be created.");
        }
        catch (Exception ex) {
            LOCATION.infoT("Cannot empty context ejbContexts/" + appName + ". Reason: " + ex.toString());
        }
        Context ejbContexts = null;
        try {
            ejbContexts = AdminJNDIUtils.getContext((Context)naming, (String)"ejbContexts");
        }
        catch (NamingException ne) {
            throw new EJBDeploymentException("ejb_2122", new Object[]{appName}, ne);
        }
        Context appContext = null;
        try {
            appContext = AdminJNDIUtils.createSubcontext((Context)ejbContexts, (String)appName);
        }
        catch (NamingException ne) {
            throw new EJBDeploymentException("ejb_2123", new Object[]{appName}, ne);
        }
        int j = 0;
        while (j < ejbJarDescriptors.length) {
            String jarName = ejbJarDescriptors[j].getJarName();
            AbstractSchema abstractSchema = ejbJarDescriptors[j].getAbstractSchema();
            if (!abstractSchema.isEmpty()) {
                String dsName = abstractSchema.getDBProperties().getDataSourceName();
                Reference dsTxRef = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", SERVICE_CONNECTOR_LOADER);
                dsTxRef.add(new StringRefAddr("res-type", "javax.sql.DataSource"));
                dsTxRef.add(new StringRefAddr("res-auth", "Application"));
                dsTxRef.add(new StringRefAddr("sharing-scope", "Shareable"));
                dsTxRef.add(new StringRefAddr("res-name", dsName));
                dsTxRef.add(new StringRefAddr("tx-support", "true"));
                Reference dsNoTxRef = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", SERVICE_CONNECTOR_LOADER);
                dsNoTxRef.add(new StringRefAddr("res-type", "javax.sql.DataSource"));
                dsNoTxRef.add(new StringRefAddr("res-auth", "Application"));
                dsNoTxRef.add(new StringRefAddr("sharing-scope", "Shareable"));
                dsNoTxRef.add(new StringRefAddr("res-name", dsName));
                dsNoTxRef.add(new StringRefAddr("tx-support", "false"));
                try {
                    AdminJNDIUtils.bind((Context)naming, (String)("ejbContainer/cmp/tx/" + appName + "/" + dsName), (Object)dsTxRef);
                    AdminJNDIUtils.bind((Context)naming, (String)("ejbContainer/cmp/notx/" + appName + "/" + dsName), (Object)dsNoTxRef);
                }
                catch (NamingException ne) {
                    throw new EJBDeploymentException("ejb_2124", new Object[]{jarName, appName}, ne);
                }
                if (abstractSchema.getLockingType() == 2) {
                    TableLocking tableLocking = null;
                    try {
                        tableLocking = this.environment.getTableLocking();
                    }
                    catch (EJBException e) {
                        warnings.add("Cannot obtain TableLocking from the JNDI. Probably applocking service is not started. EJBLocking will not be available for CMP beans in ejb-jar " + jarName + ".");
                    }
                    if (tableLocking != null) {
                        CMPEntityDescriptor[] cmpDescrs = abstractSchema.getDescriptors();
                        int k = 0;
                        while (k < cmpDescrs.length) {
                            String beanName = cmpDescrs[k].getJndiName();
                            String tableName = cmpDescrs[k].getTableName();
                            EJBLockingImpl ejbLocking = new EJBLockingImpl(tableLocking, tableName);
                            try {
                                AdminJNDIUtils.bind((Context)appContext, (String)(beanName + "/java:comp/" + "EJBLocking"), (Object)ejbLocking);
                            }
                            catch (NamingException er) {
                                new ExceptionWrapperException(400, (Throwable)er).log();
                                warnings.add("EJBLocking is not bound in the JNDI name space for CMP Bean " + beanName + ". It is impossible to use it.");
                            }
                            ++k;
                        }
                    }
                }
            }
            DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                String ejbName = descriptors[i].getEjbName();
                if (descriptors[i] instanceof MessageDrivenDescriptor) {
                    MessageDrivenDescriptor mdbDescr = (MessageDrivenDescriptor)descriptors[i];
                    Properties messageBeanProps = mdbDescr.getBeanProperties();
                    String jmsFactoryName = messageBeanProps.getProperty("ConnectionFactoryName");
                    if (mdbDescr.getMessagingType() == null || mdbDescr.getMessagingType().equals("")) {
                        Reference jmsRef;
                        if (mdbDescr.getDestinationType().equals("javax.jms.Queue")) {
                            jmsRef = new Reference("com.sap.engine.services.jmsconnector.cci.QueueConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", SERVICE_CONNECTOR_LOADER);
                            jmsRef.add(new StringRefAddr("res-type", "javax.jms.QueueConnectionFactory"));
                        } else {
                            jmsRef = new Reference("com.sap.engine.services.jmsconnector.cci.TopicConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", SERVICE_CONNECTOR_LOADER);
                            jmsRef.add(new StringRefAddr("res-type", "javax.jms.TopicConnectionFactory"));
                        }
                        jmsRef.add(new StringRefAddr("res-auth", "Application"));
                        jmsRef.add(new StringRefAddr("sharing-scope", "Shareable"));
                        jmsRef.add(new StringRefAddr("res-name", jmsFactoryName));
                        try {
                            AdminJNDIUtils.bind((Context)naming, (String)("ejbContainer/mdb/" + appName + "/" + jmsFactoryName), (Object)jmsRef);
                        }
                        catch (NamingException ne) {
                            throw new EJBDeploymentException("ejb_2125", new Object[]{ejbName, jarName, appName}, ne);
                        }
                    }
                }
                String beanName = descriptors[i].getJndiName();
                String javaCompBeanName = beanName + "/java:comp/env/";
                try {
                    ComponentReference[] compRefs;
                    EnvironmentEntry[] envEntries;
                    ResourceEnvReference[] resourcesEnv;
                    ResourceReference[] resources;
                    EJBeanLocalReference[] beanLocalRefs;
                    EJBeanReference[] beanRefs = descriptors[i].getEJBeanReferences();
                    if (beanRefs != null) {
                        int k = 0;
                        while (k < beanRefs.length) {
                            refName = beanRefs[k].getReferenceName();
                            jndiLinkName = beanRefs[k].getReferenceJndiLink();
                            if (jndiLinkName != null && EJBAdmin.isSpecialJndiLinkName(jndiLinkName)) {
                                LOCATION.infoT("ejb-ref-name " + refName + "<<< SPECIAL LINK JNDI >>>" + jndiLinkName);
                                try {
                                    AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + refName), (Object)new Reference(jndiLinkName, factoryName, ""));
                                }
                                catch (NamingException er) {
                                    new ExceptionWrapperException(400, (Throwable)er).log();
                                    warnings.add("EJBReference " + refName + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                }
                            } else {
                                String refEjbObject;
                                ejbLinkName = beanRefs[k].getReferenceEjbLink();
                                String realBeanName = this.findEjbRefLink(appDescr, warnings, jndiLinkName, ejbLinkName, refEjbHome = beanRefs[k].getHomeInterfaceName(), refEjbObject = beanRefs[k].getRemoteInterfaceName(), refName, jarName, ejbName);
                                if (realBeanName != null) {
                                    LOCATION.infoT("ejb-ref-name " + refName + "<<< LINK >>>" + realBeanName);
                                    try {
                                        AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + refName), (Object)new Reference(realBeanName, factoryName, ""));
                                    }
                                    catch (NamingException er) {
                                        new ExceptionWrapperException(400, (Throwable)er).log();
                                        warnings.add("EJBReference " + refName + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                    }
                                } else {
                                    LOCATION.infoT("ejb-ref-name " + refName + "<<< NOT LINKED >>>");
                                    if (jndiLinkName != null) {
                                        LOCATION.infoT("ejb-ref-name " + refName + "<<< LINK JNDI >>>" + jndiLinkName);
                                        try {
                                            AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + refName), (Object)new Reference(jndiLinkName, factoryName, ""));
                                        }
                                        catch (NamingException er) {
                                            new ExceptionWrapperException(400, (Throwable)er).log();
                                            warnings.add("EJBReference " + refName + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                        }
                                    }
                                    String beanRefKey = appName + "*" + jarName + "*" + ejbName + "*" + appContext.getNameInNamespace() + "/" + javaCompBeanName;
                                    this.notLinkedEjbRefs.put(beanRefKey, beanRefs[k]);
                                }
                            }
                            ++k;
                        }
                    }
                    if ((beanLocalRefs = descriptors[i].getEJBeanLocalReferences()) != null) {
                        int k = 0;
                        while (k < beanLocalRefs.length) {
                            String refName2 = beanLocalRefs[k].getReferenceName();
                            String jndiLinkName2 = beanLocalRefs[k].getReferenceJndiLink();
                            if (jndiLinkName2 != null && EJBAdmin.isSpecialJndiLinkName(jndiLinkName2)) {
                                LOCATION.infoT("ejb-ref-name " + refName2 + "<<< SPECIAL LINK LOCAL JNDI >>>" + jndiLinkName2);
                                try {
                                    AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + refName2), (Object)new Reference(jndiLinkName2, factoryName, ""));
                                }
                                catch (NamingException er) {
                                    new ExceptionWrapperException(400, (Throwable)er).log();
                                    warnings.add("EJBLocalReference " + refName2 + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                }
                            } else {
                                String refEjbLocalObject;
                                String refEjbLocalHome;
                                String ejbLinkName2 = beanLocalRefs[k].getReferenceEjbLink();
                                String realBeanName = this.findEjbLocalRefLink(appDescr, warnings, jndiLinkName2, ejbLinkName2, refEjbLocalHome = beanLocalRefs[k].getLocalHomeInterfaceName(), refEjbLocalObject = beanLocalRefs[k].getLocalInterfaceName(), refName2, jarName, ejbName);
                                if (realBeanName != null) {
                                    LOCATION.infoT("ejb-ref-name " + refName2 + "<<< LINK LOCAL >>>" + realBeanName);
                                    try {
                                        AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + refName2), (Object)new Reference(realBeanName, factoryName, ""));
                                    }
                                    catch (NamingException er) {
                                        new ExceptionWrapperException(400, (Throwable)er).log();
                                        warnings.add("EJBLocalReference " + refName2 + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                    }
                                } else {
                                    LOCATION.infoT("ejb-ref-name " + refName2 + " <<< NOT LINKED LOCAL >>>");
                                    if (jndiLinkName2 != null) {
                                        LOCATION.infoT("ejb-ref-name " + refName2 + "<<< LINK LOCAL JNDI >>>" + jndiLinkName2);
                                        try {
                                            AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + refName2), (Object)new Reference(jndiLinkName2, factoryName, ""));
                                        }
                                        catch (NamingException er) {
                                            new ExceptionWrapperException(400, (Throwable)er).log();
                                            warnings.add("EJBLocalReference " + refName2 + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                        }
                                    }
                                    String beanLocalRefKey = appName + "*" + jarName + "*" + ejbName + "*" + appContext.getNameInNamespace() + "/" + javaCompBeanName;
                                    this.notLinkedEjbLocalRefs.put(beanLocalRefKey, beanLocalRefs[k]);
                                }
                            }
                            ++k;
                        }
                    }
                    if ((resources = descriptors[i].getResourceReferences()) != null) {
                        String resourceType = null;
                        String resourceName = null;
                        int k = 0;
                        while (k < resources.length) {
                            resourceType = resources[k].getResourceType();
                            resourceName = resources[k].getResourceLink();
                            if (resourceName == null) {
                                resourceName = resources[k].getResourceName();
                            }
                            if (resourceType.equals("javax.sql.DataSource") || resourceType.equals("javax.jms.QueueConnectionFactory") || resourceType.equals("javax.jms.TopicConnectionFactory") || resourceType.equals("javax.resource.cci.ConnectionFactory")) {
                                Reference ref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", SERVICE_CONNECTOR_LOADER);
                                ref.add(new StringRefAddr("res-type", resourceType));
                                ref.add(new StringRefAddr("res-name", resourceName));
                                if (resources[k].getResourceAuthorization() == 2) {
                                    ref.add(new StringRefAddr("res-auth", "Container"));
                                } else {
                                    ref.add(new StringRefAddr("res-auth", "Application"));
                                }
                                if (resources[k].getResourceSharingScope() == 1) {
                                    ref.add(new StringRefAddr("sharing-scope", "Unshareable"));
                                } else {
                                    ref.add(new StringRefAddr("sharing-scope", "Shareable"));
                                }
                                if (!resources[k].isTransactional()) {
                                    ref.add(new StringRefAddr("tx-support", "false"));
                                }
                                try {
                                    AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + resources[k].getResourceName()), (Object)ref);
                                }
                                catch (NamingException er) {
                                    new ExceptionWrapperException(400, (Throwable)er).log();
                                    warnings.add("ResourceReference " + resources[k].getResourceName() + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                }
                            } else if (resourceType.equals("javax.mail.Session")) {
                                try {
                                    AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + resources[k].getResourceName()), (Object)new Reference("java:comp/env/mail/MailSession", factoryName, ""));
                                }
                                catch (NamingException er) {
                                    new ExceptionWrapperException(400, (Throwable)er).log();
                                    warnings.add("ResourceReference " + resources[k].getResourceName() + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                }
                            } else if (resourceType.equals("java.net.URL")) {
                                try {
                                    AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + resources[k].getResourceName()), (Object)new URL(resourceName));
                                }
                                catch (MalformedURLException muex) {
                                    new ExceptionWrapperException(400, (Throwable)muex).log();
                                    warnings.add("Resource " + resources[k].getResourceName() + " will not be used. Cannot create URL object for " + resourceName + ".");
                                }
                                catch (NamingException er) {
                                    new ExceptionWrapperException(400, (Throwable)er).log();
                                    warnings.add("ResourceReference " + resources[k].getResourceName() + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                                }
                            } else {
                                warnings.add("Unrecognized resource-type: " + resourceType + ". Ignored!");
                            }
                            ++k;
                        }
                    }
                    if ((resourcesEnv = descriptors[i].getResourceEnvReferences()) != null) {
                        String resourceEnvType = null;
                        String jndiName = null;
                        int k = 0;
                        while (k < resourcesEnv.length) {
                            resourceEnvType = resourcesEnv[k].getType();
                            jndiName = resourcesEnv[k].getJndiName();
                            if (jndiName == null) {
                                jndiName = resourcesEnv[k].getName();
                            }
                            if (resourceEnvType.equals("javax.jms.Queue")) {
                                jndiName = "jmsQueues/" + jndiName;
                            } else if (resourceEnvType.equals("javax.jms.Topic")) {
                                jndiName = "jmsTopics/" + jndiName;
                            } else {
                                warnings.add("Unrecognized resource-env-type: " + resourceEnvType + ". Ignored!");
                            }
                            try {
                                AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + resourcesEnv[k].getName()), (Object)new Reference(jndiName, factoryName, ""));
                            }
                            catch (NamingException er) {
                                new ExceptionWrapperException(400, (Throwable)er).log();
                                warnings.add("ResourceEnvReference " + resourcesEnv[k].getName() + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                            }
                            ++k;
                        }
                    }
                    if ((envEntries = descriptors[i].getEnvironmentEntries()) != null) {
                        int k = 0;
                        while (k < envEntries.length) {
                            try {
                                AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + envEntries[k].getEntryName()), (Object)envEntries[k].getEntryValue());
                            }
                            catch (NamingException er) {
                                new ExceptionWrapperException(400, (Throwable)er).log();
                                warnings.add("Environment variable " + envEntries[k].getEntryName() + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                            }
                            ++k;
                        }
                    }
                    if ((compRefs = descriptors[i].getServerComponentReferences()) != null) {
                        int k = 0;
                        while (k < compRefs.length) {
                            try {
                                AdminJNDIUtils.bind((Context)appContext, (String)(javaCompBeanName + compRefs[k].getName()), (Object)new Reference(compRefs[k].getJndiName(), factoryName, ""));
                            }
                            catch (NamingException er) {
                                new ExceptionWrapperException(400, (Throwable)er).log();
                                warnings.add("ComponentReference " + compRefs[k].getName() + " is not bound in JNDI. It is impossible to lookup it from EJBean " + beanName + ".");
                            }
                            ++k;
                        }
                    }
                    if (descriptors[i] instanceof SessionDescriptor && ((SessionDescriptor)descriptors[i]).getTransactionType() == 0) {
                        try {
                            AdminJNDIUtils.bind((Context)appContext, (String)(beanName + "/java:comp/UserTransaction"), (Object)new Reference("UserTransaction", factoryName, ""));
                        }
                        catch (NamingException er) {
                            new ExceptionWrapperException(400, (Throwable)er).log();
                            warnings.add("UserTransaction is not bound in the JNDI name space for EJBean " + beanName + ".");
                        }
                    }
                    if (descriptors[i] instanceof MessageDrivenDescriptor && ((MessageDrivenDescriptor)descriptors[i]).getTransactionType() == 0) {
                        try {
                            AdminJNDIUtils.bind((Context)appContext, (String)(beanName + "/java:comp/UserTransaction"), (Object)new Reference("UserTransaction", factoryName, ""));
                        }
                        catch (NamingException er) {
                            new ExceptionWrapperException(400, (Throwable)er).log();
                            warnings.add("UserTransaction is not bound in the JNDI name space for EJBean " + beanName + ".");
                        }
                    }
                    if (descriptors[i].hasRemoteInterfaces()) {
                        ServerHandleDelegate hd = new ServerHandleDelegate(beanName);
                        try {
                            AdminJNDIUtils.bind((Context)appContext, (String)(beanName + "/java:comp/HandleDelegate"), (Object)hd);
                        }
                        catch (NamingException er) {
                            new ExceptionWrapperException(400, (Throwable)er).log();
                            warnings.add("HandleDelegate is not bound in the JNDI name space for EJBean " + beanName + ".");
                        }
                    }
                    try {
                        AdminJNDIUtils.bind((Context)appContext, (String)(beanName + "/java:comp/ORB"), (Object)ORB.init((String[])new String[0], null));
                    }
                    catch (Exception ex) {
                        new ExceptionWrapperException(400, (Throwable)ex).log();
                        warnings.add("ORB is not bound in JNDI. It is impossible to lookup org.omg.CORBA.ORB from EJBean " + beanName + ".");
                    }
                }
                catch (NamingException ne) {
                    new ExceptionWrapperException(400, (Throwable)ne).log();
                    warnings.add("JNDI Environment is not created. It is impossible to lookup some context or environment variables from EJBean " + beanName + ".");
                }
                ++i;
            }
            ++j;
        }
        if (!this.notLinkedEjbRefs.isEmpty()) {
            LOCATION.infoT("There are not linked ejb-ref(s).");
            Enumeration keys = this.notLinkedEjbRefs.keys();
            while (keys.hasMoreElements()) {
                String beanRefKey = (String)keys.nextElement();
                StringTokenizer tokenizer = new StringTokenizer(beanRefKey, "*");
                try {
                    String refEjbObject;
                    String app_name = tokenizer.nextToken();
                    String jar_name = tokenizer.nextToken();
                    String ejb_name = tokenizer.nextToken();
                    String context_name = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        CATEGORY.warningT(LOCATION, "Error in EJBContainer: Please do not use '*' in bean or application names!");
                    }
                    ApplicationDescriptor app_descr = (ApplicationDescriptor)this.allApplications.get(app_name);
                    EJBeanReference ejb_ref = (EJBeanReference)this.notLinkedEjbRefs.get(beanRefKey);
                    if (app_descr == null) continue;
                    refName = ejb_ref.getReferenceName();
                    jndiLinkName = ejb_ref.getReferenceJndiLink();
                    String realName = this.findEjbRefLink(app_descr, warnings, jndiLinkName, ejbLinkName = ejb_ref.getReferenceEjbLink(), refEjbHome = ejb_ref.getHomeInterfaceName(), refEjbObject = ejb_ref.getRemoteInterfaceName(), refName, jar_name, ejb_name);
                    if (realName == null) continue;
                    LOCATION.infoT("not linked ejb-ref-name " + refName + "<<< LINK >>>" + realName);
                    AdminJNDIUtils.bind((Context)naming, (String)(context_name + "/" + refName), (Object)new Reference(realName, factoryName, ""));
                    this.notLinkedEjbRefs.remove(beanRefKey);
                }
                catch (NamingException ne) {
                    throw new EJBDeploymentException("ejb_2127", (Throwable)ne);
                }
            }
        }
        if (!this.notLinkedEjbLocalRefs.isEmpty()) {
            LOCATION.infoT("There are not linked ejb-local-ref(s).");
        }
    }

    private static boolean isSpecialJndiLinkName(String jndiLinkName) {
        return jndiLinkName.startsWith("corbaname:");
    }

    public String findEjbRefLink(ApplicationDescriptor appDescr, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbHome, String refEjbObject, String refName, String jarName, String ejbName) throws DeploymentException {
        EJBJarDescriptor[] ejbJarDescriptors = appDescr.getEJBJarDescriptors();
        if (jndiLinkName != null && ejbLinkName == null) {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                        if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                            warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                        }
                        return jndiLinkName;
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j2 = 0;
                while (j2 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j2].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                            if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                                warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                            }
                            String tmpAppRootDir = null;
                            try {
                                tmpAppRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(tmpAppDescr.getName());
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{tmpAppDescr.getName(), METHOD_FIND_EJB_REF_LINK}, ioe);
                            }
                            String[] jNames = new String[]{tmpAppRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j2].getClientJarName(), tmpAppRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j2].getJarName()};
                            appDescr.addOthersJars(jNames);
                            return jndiLinkName;
                        }
                        ++i;
                    }
                    ++j2;
                }
            }
        } else if (ejbLinkName != null) {
            String linkBeanName = null;
            String linkJarName = null;
            int diezIndex = ejbLinkName.indexOf("#");
            if (diezIndex == -1) {
                linkBeanName = ejbLinkName;
                linkJarName = jarName;
            } else {
                linkBeanName = ejbLinkName.substring(diezIndex + 1);
                linkJarName = ejbLinkName.substring(0, diezIndex);
            }
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                if (ejbJarDescriptors[j].getJarName().equals(linkJarName)) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (linkBeanName.equals(descriptors[i].getEjbName())) {
                            if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                                warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                            }
                            return descriptors[i].getJndiName();
                        }
                        ++i;
                    }
                }
                ++j;
            }
            int j3 = 0;
            while (j3 < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j3].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (linkBeanName.equals(descriptors[i].getEjbName())) {
                        if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                            warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                        }
                        return descriptors[i].getJndiName();
                    }
                    ++i;
                }
                ++j3;
            }
        } else {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) && refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                        return descriptors[i].getJndiName();
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j4 = 0;
                while (j4 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j4].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) && refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                            String tmpAppRootDir = null;
                            try {
                                tmpAppRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(tmpAppDescr.getName());
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{tmpAppDescr.getName(), METHOD_FIND_EJB_REF_LINK}, ioe);
                            }
                            String[] jNames = new String[]{tmpAppRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j4].getClientJarName(), tmpAppRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j4].getJarName()};
                            appDescr.addOthersJars(jNames);
                            return descriptors[i].getJndiName();
                        }
                        ++i;
                    }
                    ++j4;
                }
            }
        }
        CATEGORY.warningT(LOCATION, "ejb-ref with ejb-ref-name " + refName + " cannot be linked. Please check values of tags!");
        return null;
    }

    public String findEjbLocalRefLink(ApplicationDescriptor appDescr, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbLocalHome, String refEjbLocalObject, String refName, String jarName, String ejbName) throws DeploymentException {
        String appName = appDescr.getName();
        EJBJarDescriptor[] ejbJarDescriptors = appDescr.getEJBJarDescriptors();
        if (jndiLinkName != null && ejbLinkName == null) {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                        if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                            warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                        }
                        return LOCAL_EJBS_CONTEXT + jndiLinkName;
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j2 = 0;
                while (j2 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j2].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                            if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                                warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                            }
                            this.classLoaderContext.registerReference(appName, EJBLOADER_PREFIX + tmpAppDescr.getName());
                            return LOCAL_EJBS_CONTEXT + jndiLinkName;
                        }
                        ++i;
                    }
                    ++j2;
                }
            }
        } else if (ejbLinkName != null) {
            String linkBeanName = null;
            String linkJarName = null;
            int diezIndex = ejbLinkName.indexOf("#");
            if (diezIndex == -1) {
                linkBeanName = ejbLinkName;
                linkJarName = jarName;
            } else {
                linkBeanName = ejbLinkName.substring(diezIndex + 1);
                linkJarName = ejbLinkName.substring(0, diezIndex);
            }
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                if (ejbJarDescriptors[j].getJarName().equals(linkJarName)) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (linkBeanName.equals(descriptors[i].getEjbName())) {
                            if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                                warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                            }
                            return LOCAL_EJBS_CONTEXT + descriptors[i].getJndiName();
                        }
                        ++i;
                    }
                }
                ++j;
            }
            int j3 = 0;
            while (j3 < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j3].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (linkBeanName.equals(descriptors[i].getEjbName())) {
                        if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                            warnings.add("Jar: " + jarName + ", bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                        }
                        return LOCAL_EJBS_CONTEXT + descriptors[i].getJndiName();
                    }
                    ++i;
                }
                ++j3;
            }
        } else {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) && refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                        return LOCAL_EJBS_CONTEXT + descriptors[i].getJndiName();
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j4 = 0;
                while (j4 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j4].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) && refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                            this.classLoaderContext.registerReference(appName, EJBLOADER_PREFIX + tmpAppDescr.getName());
                            return LOCAL_EJBS_CONTEXT + descriptors[i].getJndiName();
                        }
                        ++i;
                    }
                    ++j4;
                }
            }
        }
        CATEGORY.warningT(LOCATION, "ejb-local-ref with ejb-ref-name " + refName + " cannot be linked. Please check values of tags!");
        return null;
    }

    public String[] getApplicationJars(ApplicationDescriptor appDescr, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbHome, String refEjbObject, String refName, String ejbName) throws DeploymentException {
        String appName = appDescr.getName();
        EJBJarDescriptor[] ejbJarDescriptors = appDescr.getEJBJarDescriptors();
        if (jndiLinkName != null && ejbLinkName == null) {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                        if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                            warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                        }
                        String appRootDir = null;
                        try {
                            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS}, ioe);
                        }
                        return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j].getJarName()};
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j2 = 0;
                while (j2 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j2].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                            if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                                warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                            }
                            String tmpAppRootDir = null;
                            try {
                                tmpAppRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(tmpAppDescr.getName());
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{tmpAppDescr.getName(), METHOD_GET_APPLICATION_JARS}, ioe);
                            }
                            return new String[]{tmpAppRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j2].getClientJarName(), tmpAppRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j2].getJarName()};
                        }
                        ++i;
                    }
                    ++j2;
                }
            }
        } else if (ejbLinkName != null) {
            String linkBeanName = null;
            String linkJarName = null;
            int diezIndex = ejbLinkName.indexOf("#");
            if (diezIndex == -1) {
                linkBeanName = ejbLinkName;
                linkJarName = null;
            } else {
                linkBeanName = ejbLinkName.substring(diezIndex + 1);
                linkJarName = ejbLinkName.substring(0, diezIndex);
            }
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                if (ejbJarDescriptors[j].getJarName().equals(linkJarName)) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (linkBeanName.equals(descriptors[i].getEjbName())) {
                            if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                                warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                            }
                            String appRootDir = null;
                            try {
                                appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS}, ioe);
                            }
                            return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j].getJarName()};
                        }
                        ++i;
                    }
                }
                ++j;
            }
            int j3 = 0;
            while (j3 < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j3].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (linkBeanName.equals(descriptors[i].getEjbName())) {
                        if (!refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) || !refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                            warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": RemoteHome or Remote interface name is different from the one defined in the reference.");
                        }
                        String appRootDir = null;
                        try {
                            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS}, ioe);
                        }
                        return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j3].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j3].getJarName()};
                    }
                    ++i;
                }
                ++j3;
            }
        } else {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) && refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                        String appRootDir = null;
                        try {
                            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS}, ioe);
                        }
                        return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j].getJarName()};
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j4 = 0;
                while (j4 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j4].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (refEjbHome.equals(descriptors[i].getRemoteHomeInterface()) && refEjbObject.equals(descriptors[i].getRemoteInterface())) {
                            String tmpAppRootDir = null;
                            try {
                                tmpAppRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(tmpAppDescr.getName());
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{tmpAppDescr.getName(), METHOD_GET_APPLICATION_JARS}, ioe);
                            }
                            return new String[]{tmpAppRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j4].getClientJarName(), tmpAppRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j4].getJarName()};
                        }
                        ++i;
                    }
                    ++j4;
                }
            }
        }
        CATEGORY.warningT(LOCATION, "ejb-ref with ejb-ref-name " + refName + " not found. Please check values of tags!");
        return null;
    }

    public String[] getApplicationJarsLocal(ApplicationDescriptor appDescr, Vector warnings, String jndiLinkName, String ejbLinkName, String refEjbLocalHome, String refEjbLocalObject, String refName, String ejbName) throws DeploymentException {
        String appName = appDescr.getName();
        EJBJarDescriptor[] ejbJarDescriptors = appDescr.getEJBJarDescriptors();
        if (jndiLinkName != null && ejbLinkName == null) {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                        if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                            warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                        }
                        String appRootDir = null;
                        try {
                            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS_LOCAL}, ioe);
                        }
                        return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j].getJarName()};
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j2 = 0;
                while (j2 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j2].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (jndiLinkName.equals(descriptors[i].getJndiName())) {
                            if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                                warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                            }
                            String tmpAppRootDir = null;
                            try {
                                tmpAppRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(tmpAppDescr.getName());
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{tmpAppDescr.getName(), METHOD_GET_APPLICATION_JARS_LOCAL}, ioe);
                            }
                            this.classLoaderContext.registerReference(appName, EJBLOADER_PREFIX + tmpAppDescr.getName());
                            return new String[]{tmpAppRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j2].getClientJarName(), tmpAppRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j2].getJarName()};
                        }
                        ++i;
                    }
                    ++j2;
                }
            }
        } else if (ejbLinkName != null) {
            String linkBeanName = null;
            String linkJarName = null;
            int diezIndex = ejbLinkName.indexOf("#");
            if (diezIndex == -1) {
                linkBeanName = ejbLinkName;
                linkJarName = null;
            } else {
                linkBeanName = ejbLinkName.substring(diezIndex + 1);
                linkJarName = ejbLinkName.substring(0, diezIndex);
            }
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                if (ejbJarDescriptors[j].getJarName().equals(linkJarName)) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (linkBeanName.equals(descriptors[i].getEjbName())) {
                            if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                                warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                            }
                            String appRootDir = null;
                            try {
                                appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS_LOCAL}, ioe);
                            }
                            return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j].getJarName()};
                        }
                        ++i;
                    }
                }
                ++j;
            }
            int j3 = 0;
            while (j3 < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j3].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (linkBeanName.equals(descriptors[i].getEjbName())) {
                        if (!refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) || !refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                            warnings.add("Bean: " + ejbName + ", ejb-ref-name: " + refName + ": LocalHome or Local interface name is different from the one defined in the reference.");
                        }
                        String appRootDir = null;
                        try {
                            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS_LOCAL}, ioe);
                        }
                        return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j3].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j3].getJarName()};
                    }
                    ++i;
                }
                ++j3;
            }
        } else {
            int j = 0;
            while (j < ejbJarDescriptors.length) {
                DeploymentDescriptor[] descriptors = ejbJarDescriptors[j].getDDescriptors();
                int i = 0;
                while (i < descriptors.length) {
                    if (refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) && refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                        String appRootDir = null;
                        try {
                            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_GET_APPLICATION_JARS_LOCAL}, ioe);
                        }
                        return new String[]{appRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j].getClientJarName(), appRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j].getJarName()};
                    }
                    ++i;
                }
                ++j;
            }
            Enumeration e = this.allApplications.elements();
            while (e.hasMoreElements()) {
                ApplicationDescriptor tmpAppDescr = (ApplicationDescriptor)e.nextElement();
                ejbJarDescriptors = tmpAppDescr.getEJBJarDescriptors();
                int j4 = 0;
                while (j4 < ejbJarDescriptors.length) {
                    DeploymentDescriptor[] descriptors = ejbJarDescriptors[j4].getDDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        if (refEjbLocalHome.equals(descriptors[i].getLocalHomeInterface()) && refEjbLocalObject.equals(descriptors[i].getLocalInterface())) {
                            String tmpAppRootDir = null;
                            try {
                                tmpAppRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(tmpAppDescr.getName());
                            }
                            catch (IOException ioe) {
                                throw new EJBFileOperationException("ejb_2100", new Object[]{tmpAppDescr.getName(), METHOD_GET_APPLICATION_JARS_LOCAL}, ioe);
                            }
                            this.classLoaderContext.registerReference(appName, EJBLOADER_PREFIX + tmpAppDescr.getName());
                            return new String[]{tmpAppRootDir + sepChar + "clientjars" + sepChar + ejbJarDescriptors[j4].getClientJarName(), tmpAppRootDir + sepChar + "applicationjars" + sepChar + ejbJarDescriptors[j4].getJarName()};
                        }
                        ++i;
                    }
                    ++j4;
                }
            }
        }
        CATEGORY.warningT(LOCATION, "ejb-local-ref with ejb-ref-name " + refName + " not found. Please check values of tags!");
        return null;
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException {
        String applicationName = deployInfo.getApplicationName();
        LOCATION.pathT("Deploy Begin... " + applicationName);
        ClassLoader earLoader = deployInfo.getLoader();
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_DEPLOY}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        File altDDsDir = new File(appRootDir, "altdds");
        altDDsDir.mkdirs();
        InputStream[] altDDStreams = this.getAltDDStreams(archiveFiles, altDDsDir, deployInfo, earLoader);
        Configuration appConfig = deployInfo.getConfiguration();
        Configuration ejbConfig = null;
        Configuration securityConfig = null;
        try {
            ejbConfig = appConfig.createSubConfiguration("ejb");
            securityConfig = ejbConfig.createSubConfiguration("security");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2128", new Object[]{METHOD_DEPLOY, applicationName}, (Throwable)((Object)ce));
        }
        String[] remoteSupportGenerators = deployInfo.getRemoteSupportGenerators();
        Vector warnings = new Vector();
        ApplicationDescriptor appDescr = new ApplicationDescriptor(applicationName);
        this.allApplications.put(applicationName, appDescr);
        this.deployAdmin.generate(archiveFiles, altDDStreams, appDescr, earLoader, remoteSupportGenerators, securityConfig, warnings);
        EJBJarDescriptor[] ejbJars = appDescr.getEJBJarDescriptors();
        int jarsLength = archiveFiles.length;
        if (ejbJars.length != jarsLength) {
            throw new EJBDeploymentException("ejb_2105");
        }
        SimpleEarDescriptor earDescr = deployInfo.getEarDescriptor();
        if (earDescr != null && earDescr.isFailOverEnable()) {
            this.checkFailoverAndPassivation(applicationName, ejbJars, warnings);
        }
        File backupDir = new File(appRootDir, "backup");
        backupDir.mkdirs();
        try {
            int i = 0;
            while (i < jarsLength) {
                AdminUtils.copyFileToDir((File)archiveFiles[i], (File)backupDir);
                ++i;
            }
        }
        catch (Exception e) {
            throw new EJBFileOperationException("ejb_2103", new Object[]{applicationName}, e);
        }
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        this.fillDeployedComponents(result, ejbJars, true);
        if (warnings.size() != 0) {
            result.setWarnings(warnings);
        }
        File appJarsDir = new File(appRootDir, "applicationjars");
        File clientJarsDir = new File(appRootDir, "clientjars");
        File genJarsDir = new File(appRootDir, "jars");
        File classesDir = new File(appRootDir, "classes");
        classesDir.mkdirs();
        File[] appJars = appJarsDir.listFiles();
        File[] clientJars = clientJarsDir.listFiles();
        String[] componentArchives = new String[appJars.length + clientJars.length];
        int i = 0;
        while (i < appJars.length) {
            componentArchives[i] = appJars[i].getPath();
            ++i;
        }
        int i2 = 0;
        while (i2 < clientJars.length) {
            componentArchives[appJars.length + i2] = clientJars[i2].getPath();
            ++i2;
        }
        result.setFilesForClassloader(componentArchives);
        Configuration appJarsConfig = null;
        Configuration clientJarsConfig = null;
        Configuration genJarsConfig = null;
        Configuration backupConfig = null;
        Configuration altDDsConfig = null;
        Configuration jarIndexesConfig = null;
        Configuration unknownPKConfig = null;
        try {
            appJarsConfig = ejbConfig.createSubConfiguration("applicationjars");
            clientJarsConfig = ejbConfig.createSubConfiguration("clientjars");
            genJarsConfig = ejbConfig.createSubConfiguration("jars");
            backupConfig = ejbConfig.createSubConfiguration("backup");
            altDDsConfig = ejbConfig.createSubConfiguration("altdds");
            ejbConfig.createSubConfiguration("classes");
            jarIndexesConfig = ejbConfig.createSubConfiguration("jarindexes");
            unknownPKConfig = ejbConfig.createSubConfiguration("unknownpk");
            int i3 = 0;
            while (i3 < ejbJars.length) {
                if (!ejbJars[i3].getAbstractSchema().isEmpty()) {
                    unknownPKConfig.createSubConfiguration(String.valueOf(ejbJars[i3].getJarIndex()));
                }
                ++i3;
            }
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2128", new Object[]{METHOD_DEPLOY, applicationName}, (Throwable)((Object)ce));
        }
        File[] genJars = genJarsDir.listFiles();
        File[] backupJars = backupDir.listFiles();
        File[] altDDXmls = altDDsDir.listFiles();
        if (appJars.length != jarsLength || clientJars.length != jarsLength || genJars.length != jarsLength) {
            throw new EJBDeploymentException("ejb_2105");
        }
        try {
            appJarsConfig.addFileEntries(appJars);
            clientJarsConfig.addFileEntries(clientJars);
            genJarsConfig.addFileEntries(genJars);
            backupConfig.addFileEntries(backupJars);
            altDDsConfig.addFileEntries(altDDXmls);
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2129", new Object[]{METHOD_DEPLOY, applicationName}, (Throwable)((Object)ce));
        }
        try {
            AdminUtils.writeCRCIndexForFolder((File)appJarsDir, (String)"applicationjars.crc", (String)"applicationjars.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.writeCRCIndexForFolder((File)clientJarsDir, (String)"clientjars.crc", (String)"clientjars.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.writeCRCIndexForFolder((File)genJarsDir, (String)"jars.crc", (String)"jars.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.writeCRCIndexForFolder((File)backupDir, (String)"backup.crc", (String)"backup.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.writeCRCIndexForFolder((File)altDDsDir, (String)"altdds.crc", (String)"altdds.idx", (File)appRootDir, (Configuration)ejbConfig);
            AdminUtils.writeCRCIndexForFolder((File)classesDir, (String)"classes.crc", (String)"classes.idx", (File)appRootDir, (Configuration)ejbConfig);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2108", new Object[]{applicationName}, ioe);
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2109", new Object[]{applicationName}, (Throwable)((Object)ce));
        }
        int i4 = 0;
        while (i4 < ejbJars.length) {
            try {
                jarIndexesConfig.addConfigEntry(ejbJars[i4].getJarName(), new Integer(ejbJars[i4].getJarIndex()));
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2111", new Object[]{ejbJars[i4].getJarName(), applicationName}, (Throwable)((Object)ce));
            }
            ++i4;
        }
        try {
            ejbConfig.addConfigEntry("FP", "SP5");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2199", new Object[]{applicationName}, (Throwable)((Object)ce));
        }
        return result;
    }

    public void notifyDeployedComponents(String applicationName, Properties notifyProperties) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
        ApplicationDescriptor app = (ApplicationDescriptor)this.allApplications.get(applicationName);
        int size = this.ejbCallbacks.size();
        int i = 0;
        while (i < size) {
            try {
                ((EJBAdminCallback)this.ejbCallbacks.elementAt(i)).deployedApplication(app);
            }
            catch (RemoteException re) {
                LOCATION.infoT("RemoteException while notifying EJBAdminCallback.deployedApplication(" + applicationName + "). Reason: " + re.toString());
            }
            catch (Exception e) {
                LOCATION.infoT("Exception while notifying EJBAdminCallback.deployedApplication(" + applicationName + "). Reason: " + e.toString());
                this.ejbCallbacks.remove(i);
            }
            ++i;
        }
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        this.remove(applicationName);
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        LOCATION.pathT("Download Application Files Begin... " + applicationName);
        Vector warnings = new Vector();
        Configuration ejbConfig = null;
        Configuration appJarsConfig = null;
        Configuration clientJarsConfig = null;
        Configuration genJarsConfig = null;
        Configuration backupConfig = null;
        Configuration classesConfig = null;
        Configuration altDDsConfig = null;
        try {
            ejbConfig = appConfig.getSubConfiguration("ejb");
            appJarsConfig = ejbConfig.getSubConfiguration("applicationjars");
            clientJarsConfig = ejbConfig.getSubConfiguration("clientjars");
            genJarsConfig = ejbConfig.getSubConfiguration("jars");
            backupConfig = ejbConfig.getSubConfiguration("backup");
            classesConfig = ejbConfig.getSubConfiguration("classes");
            altDDsConfig = ejbConfig.getSubConfiguration("altdds");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2104", new Object[]{METHOD_DOWNLOAD_APPLICATION_FILES, applicationName}, (Throwable)((Object)ce));
        }
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_DOWNLOAD_APPLICATION_FILES}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        File appJarsDir = new File(appRootDir, "applicationjars");
        File clientJarsDir = new File(appRootDir, "clientjars");
        File genJarsDir = new File(appRootDir, "jars");
        File backupDir = new File(appRootDir, "backup");
        File classesDir = new File(appRootDir, "classes");
        File altDDsDir = new File(appRootDir, "altdds");
        AdminUtils.makeConsistent((File)appJarsDir, (Configuration)appJarsConfig, (Configuration)ejbConfig, (String)"applicationjars.crc", (String)"applicationjars.idx", warnings);
        AdminUtils.makeConsistent((File)clientJarsDir, (Configuration)clientJarsConfig, (Configuration)ejbConfig, (String)"clientjars.crc", (String)"clientjars.idx", warnings);
        AdminUtils.makeConsistent((File)genJarsDir, (Configuration)genJarsConfig, (Configuration)ejbConfig, (String)"jars.crc", (String)"jars.idx", warnings);
        AdminUtils.makeConsistent((File)backupDir, (Configuration)backupConfig, (Configuration)ejbConfig, (String)"backup.crc", (String)"backup.idx", warnings);
        AdminUtils.makeConsistent((File)classesDir, (Configuration)classesConfig, (Configuration)ejbConfig, (String)"classes.crc", (String)"classes.idx", warnings);
        AdminUtils.makeConsistent((File)altDDsDir, (Configuration)altDDsConfig, (Configuration)ejbConfig, (String)"altdds.crc", (String)"altdds.idx", warnings);
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_2112", new Object[]{METHOD_DOWNLOAD_APPLICATION_FILES});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
    }

    public void prepareStart(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        LOCATION.pathT("Prepare Start Begin... " + applicationName);
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_PREPARE_START}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        File backupDir = new File(appRootDir, "backup");
        File[] backupJars = backupDir.listFiles();
        int jarsLength = backupJars.length;
        InputStream[] altDDStreams = EJBAdmin.getAltDDStreams(appRootDir, backupJars);
        Vector warnings = new Vector();
        ClassLoader appLoader = this.classLoaderContext.getClassLoader(applicationName);
        ApplicationDescriptor appDescr = new ApplicationDescriptor(applicationName);
        EJBJarDescriptor[] ejbjarDescriptors = new EJBJarDescriptor[jarsLength];
        int j = 0;
        while (j < jarsLength) {
            ejbjarDescriptors[j] = this.deployAdmin.parseSingleJar(backupJars[j], altDDStreams[j], warnings, appLoader, applicationName, false, null, false, null);
            ++j;
        }
        Configuration ejbConfig = null;
        Configuration jarIndexesConfig = null;
        try {
            ejbConfig = appConfig.getSubConfiguration("ejb");
            jarIndexesConfig = ejbConfig.getSubConfiguration("jarindexes");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2104", new Object[]{METHOD_PREPARE_START, applicationName}, (Throwable)((Object)ce));
        }
        int j2 = 0;
        while (j2 < jarsLength) {
            Integer jarIndex = null;
            try {
                jarIndex = (Integer)jarIndexesConfig.getConfigEntry(ejbjarDescriptors[j2].getJarName());
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2131", new Object[]{ejbjarDescriptors[j2].getJarName(), applicationName}, (Throwable)((Object)ce));
            }
            ejbjarDescriptors[j2].setJarIndex(jarIndex);
            this.deployAdmin.fixSingleJarOnStartup(ejbjarDescriptors[j2]);
            ++j2;
        }
        appDescr.setEJBJarDescriptors(ejbjarDescriptors);
        appDescr.setAppLoader(appLoader);
        this.allApplications.put(applicationName, appDescr);
        this.createBeanContexts(appDescr, warnings);
        int j3 = 0;
        while (j3 < jarsLength) {
            AbstractSchema schema = ejbjarDescriptors[j3].getAbstractSchema();
            if (!schema.isEmpty()) {
                if (schema.haveToCreateTables()) {
                    StatementGeneratorsHolder holder = new StatementGeneratorsHolder(schema);
                    holder.createTablesAtDeploy(this.environment, warnings);
                }
                if (!schema.isVerificationSwitchedOff()) {
                    AbstractSchemaVerifier.check(applicationName, schema, this.environment, warnings);
                }
            }
            ++j3;
        }
        String fpDeploy = null;
        try {
            fpDeploy = (String)ejbConfig.getConfigEntry("FP");
        }
        catch (ConfigurationException ce) {
            fpDeploy = null;
        }
        this.initApplication(appDescr, warnings);
        this.prepareLoad(appDescr, fpDeploy);
        this.commitLoad(appDescr, fpDeploy, warnings);
        this.initPools(appDescr, warnings);
        appDescr.isLoaded = true;
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_2112", new Object[]{METHOD_PREPARE_START});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
    }

    private static InputStream[] getAltDDStreams(File appRootDir, File[] backupJars) throws EJBFileOperationException {
        int jarsLength = backupJars.length;
        File altDDsDir = new File(appRootDir, "altdds");
        File[] altDDXmls = altDDsDir.listFiles();
        InputStream[] altDDStreams = new InputStream[jarsLength];
        int i = 0;
        while (i < altDDXmls.length) {
            String xmlFileName = altDDXmls[i].getName();
            int j = 0;
            while (j < jarsLength) {
                if (backupJars[j].getName().equals(xmlFileName.substring(0, xmlFileName.length() - 4))) {
                    try {
                        altDDStreams[j] = new FileInputStream(altDDXmls[i]);
                        break;
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new EJBFileOperationException("ejb_2130", new Object[]{xmlFileName}, fnfe);
                    }
                }
                ++j;
            }
            ++i;
        }
        return altDDStreams;
    }

    public void commitStart(String applicationName) throws WarningException {
        LOCATION.pathT("Commit Start Begin... " + applicationName);
    }

    public void rollbackStart(String applicationName) throws WarningException {
        LOCATION.pathT("Rollback Start Begin... " + applicationName);
        this.commitStop(applicationName);
    }

    public void prepareStop(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        LOCATION.pathT("Prepare Stop Begin... " + applicationName);
    }

    public void commitStop(String applicationName) throws WarningException {
        LOCATION.pathT("Commit Stop Begin... " + applicationName);
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(applicationName);
        Vector<String> warnings = new Vector<String>();
        Context naming = null;
        try {
            naming = this.environment.getNewNamingContext();
        }
        catch (NamingException ne) {
            new EJBDeploymentException("ejb_2134", new Object[]{applicationName}, ne).log();
        }
        if (appDescr != null) {
            EJBJarDescriptor[] ejbJarDescrs = appDescr.getEJBJarDescriptors();
            int j = 0;
            while (j < ejbJarDescrs.length) {
                PersistenceManager pm;
                AbstractSchema schema = ejbJarDescrs[j].getAbstractSchema();
                if (!schema.isEmpty() && (pm = schema.getPersistenceManager()) != null) {
                    pm.applicationIsStopped();
                }
                ++j;
            }
            if (naming != null) {
                this.unbindBeanHomes(naming, appDescr);
                try {
                    AdminJNDIUtils.destroyContexts((Context)naming, (String)("ejbContexts/" + applicationName));
                }
                catch (Exception e) {
                    new ExceptionWrapperException(400, (Throwable)e, "ejb_2133", new Object[]{METHOD_PREPARE_STOP, applicationName}).log();
                }
                try {
                    AdminJNDIUtils.destroyContexts((Context)naming, (String)("ejbContainer/cmp/tx/" + applicationName));
                    AdminJNDIUtils.destroyContexts((Context)naming, (String)("ejbContainer/cmp/notx/" + applicationName));
                }
                catch (NamingException ne) {
                    LOCATION.debugT("Cannot destroy context with DataSources for CMP entity beans in application " + applicationName + ". Reason: " + ne.toString());
                }
                try {
                    AdminJNDIUtils.destroyContexts((Context)naming, (String)("ejbContainer/mdb/" + applicationName));
                }
                catch (NamingException ne) {
                    LOCATION.debugT("Cannot destroy context with JMS factories for message-driven beans in application " + applicationName + ". Reason: " + ne.toString());
                }
            }
            this.destroyContainers(appDescr, warnings);
            this.unregisterLoaders(appDescr, warnings);
        } else {
            warnings.add("Application " + applicationName + " has been removed or is not deployed. This application cannot be stopped!");
        }
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_2112", new Object[]{METHOD_COMMIT_STOP});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
        LOCATION.pathT("Rollback Stop Begin... " + applicationName);
    }

    private void unbindBeanHomes(Context naming, ApplicationDescriptor appDescr) {
        EJBJarDescriptor[] ejbJarDescrs = appDescr.getEJBJarDescriptors();
        int j = 0;
        while (j < ejbJarDescrs.length) {
            DeploymentDescriptor[] descriptors = ejbJarDescrs[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                String jndiName = descriptors[i].getJndiName();
                if (jndiName != null) {
                    SessionDescriptor sessDescr;
                    try {
                        AdminJNDIUtils.unbind((Context)naming, (String)jndiName);
                    }
                    catch (Exception e) {
                        LOCATION.infoT("Cannot unbind EJBHome for bean " + jndiName + ". Reason: " + e.toString());
                    }
                    if (descriptors[i] instanceof SessionDescriptor && (sessDescr = (SessionDescriptor)descriptors[i]).getSessionType() == 0) {
                        try {
                            String trimmedJndiName = AdminUtils.trimLeadingChars((String)jndiName, (char)'/');
                            EJBHomeFactory.unregisterHome(RFC_ACCESS_EJB_CONTEXT + trimmedJndiName);
                            AdminJNDIUtils.unbind((Context)naming, (String)(RFC_ACCESS_EJB_CONTEXT + jndiName));
                        }
                        catch (Exception e) {
                            LOCATION.infoT("Cannot unbind EJBLocalHome/EJBHome for bean " + jndiName + " from context " + RFC_ACCESS_EJB_CONTEXT + ". Reason: " + e.toString());
                        }
                        try {
                            AdminJNDIUtils.unbind((Context)naming, (String)(EJB_COS_NAMING_CONTEXT + jndiName));
                        }
                        catch (NamingException e) {
                            LOCATION.infoT("Cannot unbind EJBHome for bean " + jndiName + " from context " + EJB_COS_NAMING_CONTEXT + ". Reason: " + e.toString());
                        }
                    }
                    try {
                        AdminJNDIUtils.unbind((Context)naming, (String)(LOCAL_EJBS_CONTEXT + jndiName));
                    }
                    catch (Exception e) {
                        LOCATION.infoT("Cannot unbind EJBLocalHome for bean " + jndiName + ". Reason: " + e.toString());
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    private void unregisterLoaders(ApplicationDescriptor appDescr, Vector warnings) {
        String applicationName = appDescr.getName();
        ReferencedLoader refLoader = (ReferencedLoader)appDescr.getEjbLoader();
        if (refLoader == null) {
            warnings.add("EJBLoader for application " + applicationName + " is null in commitStop!");
        } else {
            try {
                this.classLoaderContext.unregister(refLoader);
            }
            catch (Exception e) {
                warnings.add("Cannot unregister EJBLoader for application " + applicationName + ". Reason: " + e.toString());
            }
        }
        appDescr.setEjbLoader(null);
        appDescr.setAppLoader(null);
        appDescr.isLoaded = false;
    }

    public void remove(String applicationName) throws WarningException {
        EJBJarDescriptor[] ejbJarDescrs;
        LOCATION.pathT("Remove Application Begin... " + applicationName);
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.remove(applicationName);
        Vector<String> warnings = new Vector<String>();
        if (appDescr == null) {
            LOCATION.infoT("Cannot remove application " + applicationName + ", because it is already removed or its deployment in EJBContainer has not begun.");
            return;
        }
        if (appDescr.isLoaded) {
            warnings.add("Attempt to remove application " + applicationName + " which is not stopped.");
        }
        if ((ejbJarDescrs = appDescr.getEJBJarDescriptors()) != null) {
            SecurityContext securityContext = this.environment.getSecurityContext();
            int j = 0;
            while (j < ejbJarDescrs.length) {
                String policyConfigurationName = applicationName + "*" + ejbJarDescrs[j].getJarName();
                securityContext.unregisterPolicyConfiguration(policyConfigurationName);
                ++j;
            }
        }
        int size = this.ejbCallbacks.size();
        int i = 0;
        while (i < size) {
            try {
                ((EJBAdminCallback)this.ejbCallbacks.elementAt(i)).undeployedApplication(applicationName);
            }
            catch (RemoteException re) {
                LOCATION.infoT("RemoteException while notifying EJBAdminCallback.undeployedApplication(" + applicationName + "). Reason: " + re.toString());
            }
            catch (Exception e) {
                LOCATION.infoT("Exception while notifying EJBAdminCallback.undeployedApplication(" + applicationName + ").Reason: " + e.toString());
                this.ejbCallbacks.remove(i);
            }
            ++i;
        }
        if (warnings.size() != 0) {
            EJBWarningException toThrow = new EJBWarningException("ejb_2112", new Object[]{METHOD_REMOVE});
            toThrow.setWarnings(warnings);
            throw toThrow;
        }
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        LOCATION.pathT("Get Resources For TempLoader Begin... " + applicationName);
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_GET_RESOURCES_FOR_TEMP_LOADER}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        Vector<String> result = new Vector<String>();
        File classesDir = new File(appRootDir, "classes");
        File[] classesFiles = classesDir.listFiles();
        if (classesFiles.length > 0) {
            result.add(classesDir.getPath());
        }
        File backupDir = new File(appRootDir, "backup");
        File[] backupJars = backupDir.listFiles();
        int i = 0;
        while (i < backupJars.length) {
            result.add(backupJars[i].getPath());
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException, WarningException {
        return true;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] fileInfos, ContainerDeploymentInfo deployInfo, Properties props) throws DeploymentException {
        String applicationName = deployInfo.getApplicationName();
        Configuration appConfig = deployInfo.getConfiguration();
        LOCATION.pathT("SingleFileUpdate Begin... " + applicationName);
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(applicationName);
        if (appDescr == null) {
            throw new EJBDeploymentException("ejb_2139", new Object[]{applicationName});
        }
        EJBJarDescriptor[] ejbJarDescrs = appDescr.getEJBJarDescriptors();
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{applicationName, METHOD_MAKE_SINGLE_FILE_UPDATE}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        Configuration ejbConfig = null;
        Configuration classesConfig = null;
        try {
            ejbConfig = appConfig.getSubConfiguration("ejb");
            classesConfig = ejbConfig.getSubConfiguration("classes");
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2104", new Object[]{METHOD_MAKE_SINGLE_FILE_UPDATE, applicationName}, (Throwable)((Object)ce));
        }
        File classesDir = new File(appRootDir, "classes");
        String classesDirPath = classesDir.getPath();
        ClassLoader loader = deployInfo.getLoader();
        Class<?> ejbHomeClass = null;
        Class<?> ejbObjectClass = null;
        Class<?> ejbLocalHomeClass = null;
        Class<?> ejbLocalObjectClass = null;
        try {
            ejbHomeClass = loader.loadClass("javax.ejb.EJBHome");
            ejbObjectClass = loader.loadClass("javax.ejb.EJBObject");
            ejbLocalHomeClass = loader.loadClass("javax.ejb.EJBLocalHome");
            ejbLocalObjectClass = loader.loadClass("javax.ejb.EJBLocalObject");
        }
        catch (ClassNotFoundException cnfe) {
            throw new EJBDeploymentException("ejb_2140", (Throwable)cnfe);
        }
        int i = 0;
        while (i < fileInfos.length) {
            if (fileInfos[i].getContainerName().equals(CONTAINER_NAME)) {
                File file = new File(fileInfos[i].getFileName());
                String fileName = fileInfos[i].getFileEntryName();
                String jarName = fileInfos[i].getArchiveName();
                LOCATION.pathT("SingleFileUpdate file: " + fileName + ", jar: " + jarName);
                String className = null;
                try {
                    className = fileName.replace('/', '.').substring(0, fileName.length() - 6);
                }
                catch (IndexOutOfBoundsException iobe) {
                    throw new EJBDeploymentException("ejb_2141", new Object[]{fileName}, iobe);
                }
                EJBJarDescriptor jarDescr = null;
                int j = 0;
                while (j < ejbJarDescrs.length) {
                    if (jarName.equals(ejbJarDescrs[j].getJarName())) {
                        jarDescr = ejbJarDescrs[j];
                    }
                    ++j;
                }
                if (jarDescr == null) {
                    throw new EJBDeploymentException("ejb_2142", new Object[]{fileName, jarName, applicationName});
                }
                DeploymentDescriptor[] descriptors = jarDescr.getDDescriptors();
                int j2 = 0;
                while (j2 < descriptors.length) {
                    if (className.equals(descriptors[j2].getClassName()) && descriptors[j2] instanceof CMPEntityDescriptor && ((CMPEntityDescriptor)descriptors[j2]).getCmpVersion() == 1) {
                        throw new EJBDeploymentException("ejb_2143", new Object[]{className, descriptors[j2].getEjbName()});
                    }
                    ++j2;
                }
                Class<?> clas = null;
                try {
                    clas = loader.loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new EJBDeploymentException("ejb_2140", (Throwable)cnfe);
                }
                if (ejbHomeClass.isAssignableFrom(clas)) {
                    throw new EJBDeploymentException("ejb_2144", new Object[]{className, "javax.ejb.EJBHome"});
                }
                if (ejbObjectClass.isAssignableFrom(clas)) {
                    throw new EJBDeploymentException("ejb_2144", new Object[]{className, "javax.ejb.EJBObject"});
                }
                if (ejbLocalHomeClass.isAssignableFrom(clas)) {
                    throw new EJBDeploymentException("ejb_2144", new Object[]{className, "javax.ejb.EJBLocalHome"});
                }
                if (ejbLocalObjectClass.isAssignableFrom(clas)) {
                    throw new EJBDeploymentException("ejb_2144", new Object[]{className, "javax.ejb.EJBLocalObject"});
                }
                File newFile = new File(classesDir, fileName);
                try {
                    AdminUtils.copyFile((File)file, (File)newFile);
                }
                catch (IOException ioe) {
                    throw new EJBFileOperationException("ejb_2145", new Object[]{fileName, classesDirPath}, ioe);
                }
                try {
                    classesConfig.updateFileByKey(fileName, newFile, true);
                }
                catch (ConfigurationException ce) {
                    throw new EJBConfigurationException("ejb_2146", new Object[]{METHOD_MAKE_SINGLE_FILE_UPDATE, applicationName, fileName}, (Throwable)((Object)ce));
                }
            }
            ++i;
        }
        try {
            AdminUtils.updateCRCIndexForFolder((File)classesDir, (String)"classes.crc", (String)"classes.idx", (File)appRootDir, (Configuration)ejbConfig);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2108", new Object[]{applicationName}, ioe);
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_2109", new Object[]{applicationName}, (Throwable)((Object)ce));
        }
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        LOCATION.pathT("Commit SingleFileUpdate Begin... " + applicationName);
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            throw new EJBWarningException("ejb_2100", new Object[]{applicationName, METHOD_COMMIT_SINGLE_FILE_UPDATE}, (Throwable)ioe);
        }
        File classesDir = new File(appWorkDir, "classes");
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        result.setFilesForClassloader(new String[]{classesDir.getPath()});
        return result;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return true;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(appName);
        if (appDescr != null && addAppInfo.isFailOverEnable()) {
            EJBJarDescriptor[] ejbJars = appDescr.getEJBJarDescriptors();
            Vector warnings = new Vector();
            this.checkFailoverAndPassivation(appName, ejbJars, warnings);
            if (warnings.size() != 0) {
                EJBWarningException toThrow = new EJBWarningException("ejb_2196", new Object[]{appName});
                toThrow.setWarnings(warnings);
                throw toThrow;
            }
        }
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public String[] listApplications() {
        LOCATION.pathT("List Applications Begin...");
        ApplicationDescriptor[] allDescrs = new ApplicationDescriptor[this.allApplications.size()];
        allDescrs = this.allApplications.values().toArray(allDescrs);
        String[] result = new String[allDescrs.length];
        int i = 0;
        while (i < allDescrs.length) {
            result[i] = allDescrs[i].getName();
            ++i;
        }
        return result;
    }

    public File[] getClientJar(String applicationName) {
        LOCATION.pathT("Get ClientJar Begin... " + applicationName);
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(applicationName);
        if (appDescr == null) {
            LOCATION.infoT("The client jar for the application " + applicationName + " was not found!");
            return null;
        }
        EJBJarDescriptor[] descrs = appDescr.getEJBJarDescriptors();
        File[] result = new File[descrs.length];
        String appRootDir = null;
        try {
            appRootDir = this.environment.getDeployCommunicator().getMyWorkDirectory(applicationName);
        }
        catch (IOException ioe) {
            new ExceptionWrapperException(400, (Throwable)ioe, "ejb_2101", new Object[]{applicationName}).log();
            return null;
        }
        int i = 0;
        while (i < descrs.length) {
            result[i] = new File(appRootDir + sepChar + "clientjars" + sepChar + descrs[i].getClientJarName());
            ++i;
        }
        return result;
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        if (applicationName == null || applicationName.equals("")) {
            return null;
        }
        ApplicationDescriptor descr = this.getApplicationDescriptor(applicationName);
        if (descr == null) {
            return null;
        }
        ExportInfo[] infos = null;
        ExportInfo[] temp = null;
        EJBJarDescriptor[] jars = descr.getEJBJarDescriptors();
        String jarName = null;
        SecurityRoles[] roles = null;
        DeploymentDescriptor[] beans = null;
        DeploymentDescriptor bean = null;
        if (jars == null || jars.length == 0) {
            return null;
        }
        int i = 0;
        while (i < jars.length) {
            if (jars[i] != null && (beans = jars[i].getDDescriptors()) != null && beans.length != 0) {
                jarName = jars[i].getJarName();
                roles = jars[i].getSecurityRoles();
                int j = 0;
                while (j < beans.length) {
                    bean = beans[j];
                    if (bean != null) {
                        if (infos == null || infos.length == 0) {
                            infos = new ExportInfo[1];
                        } else {
                            temp = new ExportInfo[infos.length + 1];
                            System.arraycopy(infos, 0, temp, 0, infos.length);
                            infos = temp;
                        }
                        infos[infos.length - 1] = new ExportInfo();
                        infos[infos.length - 1].setComponentName(jarName + "#" + bean.getEjbName());
                        infos[infos.length - 1].setType((byte)1);
                        infos[infos.length - 1].setSecurityRoles(roles);
                        infos[infos.length - 1].setEJBeanReferences(bean.getEJBeanReferences());
                        infos[infos.length - 1].setEnvironmentEntries(bean.getEnvironmentEntries());
                        infos[infos.length - 1].setResourceReferences(bean.getResourceReferences());
                        if (bean instanceof CMPEntityDescriptor && jars[i].getAbstractSchema() != null && jars[i].getAbstractSchema().getDBProperties() != null) {
                            infos[infos.length - 1].setDBPoolName(jars[i].getAbstractSchema().getDBProperties().getDataSourceName());
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return infos;
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        throw new EJBDeploymentException("ejb_2147");
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public void stopMyApplications() throws RemoteException {
        Collection appDescriptors = this.allApplications.values();
        Iterator it = appDescriptors.iterator();
        Vector<String> notStoppedApps = new Vector<String>();
        while (it.hasNext()) {
            String appName = ((ApplicationDescriptor)it.next()).getName();
            if (this.environment.getDeployCommunicator().getStatus(appName) == 0) continue;
            notStoppedApps.add(appName);
        }
        this.environment.getDeployCommunicator().stopMyApplications(notStoppedApps.toArray(new String[notStoppedApps.size()]));
    }

    public String[] getJNDINames(String appName, String jarName) {
        ApplicationDescriptor appDescr = (ApplicationDescriptor)this.allApplications.get(appName);
        if (appDescr != null) {
            EJBJarDescriptor[] ejbJars = appDescr.getEJBJarDescriptors();
            int i = 0;
            while (i < ejbJars.length) {
                if (ejbJars[i].getJarName().equals(jarName)) {
                    DeploymentDescriptor[] dd = ejbJars[i].getDDescriptors();
                    String[] jndiNames = new String[dd.length];
                    int j = 0;
                    while (j < dd.length) {
                        jndiNames[j] = dd[j].getJndiName();
                        ++j;
                    }
                    return jndiNames;
                }
                ++i;
            }
        }
        return null;
    }

    public void addReferencedObject(String appName, String beanJNDIName, String jndiLinkName, Object referencedObject) throws NamingException {
        Context naming = this.environment.getNewNamingContext();
        Context appContext = AdminJNDIUtils.getContext((Context)naming, (String)("ejbContexts/" + appName));
        AdminJNDIUtils.bind((Context)appContext, (String)(beanJNDIName + "/java:comp/env/" + jndiLinkName), (Object)referencedObject);
    }

    private InputStream[] getAltDDStreams(File[] archiveFiles, File altDDsDir, ContainerDeploymentInfo deployInfo, ClassLoader loader) throws DeploymentException {
        int jarsLength = archiveFiles.length;
        InputStream[] altDDStreams = new InputStream[jarsLength];
        SimpleEarDescriptor earDescr = deployInfo.getEarDescriptor();
        if (earDescr != null) {
            J2EEModule[] modules = earDescr.getEJBs();
            Hashtable fileMappings = deployInfo.getFileMappings();
            int i = 0;
            while (i < jarsLength) {
                String jarEntry = (String)fileMappings.get(archiveFiles[i].getAbsolutePath());
                int k = 0;
                while (k < modules.length) {
                    if (jarEntry.equals(modules[k].getUri())) {
                        String altDD = modules[k].getAlt_dd();
                        if (altDD == null || altDD.trim().equals("")) break;
                        altDDStreams[i] = loader.getResourceAsStream(altDD);
                        if (altDDStreams[i] == null) {
                            throw new EJBDeploymentException("ejb_2148", new Object[]{jarEntry});
                        }
                        try {
                            AdminUtils.writeToFile((InputStream)altDDStreams[i], (File)altDDsDir, (String)(archiveFiles[i].getName() + ".xml"));
                        }
                        catch (IOException ioe) {
                            throw new EJBFileOperationException("ejb_2149", new Object[]{archiveFiles[i].getName() + ".xml"}, ioe);
                        }
                        altDDStreams[i] = loader.getResourceAsStream(altDD);
                        if (altDDStreams[i] != null) break;
                        throw new EJBDeploymentException("ejb_2148", new Object[]{jarEntry});
                    }
                    ++k;
                }
                ++i;
            }
        }
        return altDDStreams;
    }

    private void checkFailoverAndPassivation(String applicationName, EJBJarDescriptor[] ejbJars, Vector warnings) {
        int k = 0;
        while (k < ejbJars.length) {
            DeploymentDescriptor[] dd = ejbJars[k].getDDescriptors();
            int m = 0;
            while (m < dd.length) {
                SessionDescriptor descr;
                if (dd[m] instanceof SessionDescriptor && (descr = (SessionDescriptor)dd[m]).usePassivation()) {
                    warnings.add("Session bean " + descr.getEjbName() + " from application " + applicationName + " uses passivation when in the same time the failover for the application is switched on. This is not an error but sometimes it may cause some runtime problems.");
                }
                ++m;
            }
            ++k;
        }
    }

    private void fillDeployedComponents(ApplicationDeployInfo adInfo, EJBJarDescriptor[] ejbJars, boolean newDescr) {
        Vector<String> deployedComponentNames = new Vector<String>();
        int i = 0;
        while (i < ejbJars.length) {
            AbstractSchema abstractSchema = ejbJars[i].getAbstractSchema();
            if (!abstractSchema.isEmpty()) {
                String dsName = abstractSchema.getDBProperties().getDataSourceName();
                if (newDescr) {
                    adInfo.addResourceReference(dsName, "javax.sql.DataSource", "hard");
                } else {
                    adInfo.addRemovedResourceReference(dsName, "javax.sql.DataSource");
                }
            }
            DeploymentDescriptor[] dDescriptors = ejbJars[i].getDDescriptors();
            int j = 0;
            while (j < dDescriptors.length) {
                MessageDrivenDescriptor mdbDescr;
                ResourceReference[] resRefs;
                DeploymentDescriptor dd = dDescriptors[j];
                if (newDescr) {
                    deployedComponentNames.add(dd.getEjbName());
                }
                if ((resRefs = dd.getResourceReferences()) != null) {
                    int k = 0;
                    while (k < resRefs.length) {
                        String resType = resRefs[k].getResourceType();
                        if (!resType.equals("javax.mail.Session") && !resType.equals("java.net.URL")) {
                            String resName = resRefs[k].getResourceLink();
                            if (resName == null) {
                                resName = resRefs[k].getResourceName();
                            }
                            if (newDescr) {
                                adInfo.addResourceReference(resName, resType);
                            } else {
                                adInfo.addRemovedResourceReference(resName, resType);
                            }
                        }
                        ++k;
                    }
                }
                if (dd instanceof MessageDrivenDescriptor && ((mdbDescr = (MessageDrivenDescriptor)dd).getMessagingType() == null || mdbDescr.getMessagingType().equals(""))) {
                    Properties messageBeanProps = mdbDescr.getBeanProperties();
                    String jmsFactoryName = messageBeanProps.getProperty("ConnectionFactoryName");
                    if (mdbDescr.getDestinationType().equals("javax.jms.Queue")) {
                        if (newDescr) {
                            adInfo.addResourceReference(jmsFactoryName, "javax.jms.QueueConnectionFactory", "hard");
                        } else {
                            adInfo.addRemovedResourceReference(jmsFactoryName, "javax.jms.QueueConnectionFactory");
                        }
                    } else if (newDescr) {
                        adInfo.addResourceReference(jmsFactoryName, "javax.jms.TopicConnectionFactory", "hard");
                    } else {
                        adInfo.addRemovedResourceReference(jmsFactoryName, "javax.jms.TopicConnectionFactory");
                    }
                }
                ++j;
            }
            ++i;
        }
        if (newDescr) {
            adInfo.setDeployedComponentNames(deployedComponentNames.toArray(new String[deployedComponentNames.size()]));
        }
    }

    private void updateFileEntries(File[] files, Configuration config) throws ConfigurationException {
        int i = 0;
        while (i < files.length) {
            config.updateFile(files[i], true);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

