/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb;

import com.sap.engine.services.ejb.ContainerInitializationException;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import java.util.Vector;

public class ApplicationThreadInitializer
implements Runnable {
    private Object synch = null;
    private ApplicationDescriptor appDescr = null;
    private Vector warnings = null;

    public ApplicationThreadInitializer(Object synch, ApplicationDescriptor appDescr, Vector warnings) {
        this.synch = synch;
        this.appDescr = appDescr;
        this.warnings = warnings;
    }

    public void run() {
        Object object = this.synch;
        synchronized (object) {
            try {
                this.initPools();
                Object var3_2 = null;
                this.synch.notify();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.synch.notify();
                throw throwable;
            }
        }
    }

    private void initPools() {
        String applicationName = this.appDescr.getName();
        EJBJarDescriptor[] ejbjarDescriptors = this.appDescr.getEJBJarDescriptors();
        if (ejbjarDescriptors == null) {
            this.warnings.add("Cannot init pools for application " + applicationName + ", because ApplicationDescriptor is wrong.");
        }
        int j = 0;
        while (j < ejbjarDescriptors.length) {
            DeploymentDescriptor[] descriptors = ejbjarDescriptors[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                String ejbName = descriptors[i].getEjbName();
                EJBResourceAccessor.location.pathT("Initializing pools for bean: " + ejbName);
                try {
                    descriptors[i].getContainerBoot().initPools();
                }
                catch (ContainerInitializationException cie) {
                    new ExceptionWrapperException(400, (Throwable)cie).log();
                    this.warnings.add("Cannot initialize pools for bean: " + ejbName + ". Reason: " + cie.toString());
                }
                ++i;
            }
            ++j;
        }
    }
}

