/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.sfilechooser;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.sfilechooser.DefaultFileSystem;
import com.sap.engine.services.deploy.gui.sfilechooser.DriveObject;
import com.sap.engine.services.deploy.gui.sfilechooser.ExplorerFilter;
import com.sap.engine.services.deploy.gui.sfilechooser.FavouritesDialog;
import com.sap.engine.services.deploy.gui.sfilechooser.FavouritesPopupListener;
import com.sap.engine.services.deploy.gui.sfilechooser.FileObject;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.DriveTreeNode;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.ExplorerTreeModel;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.FileListRenderer;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.FolderTreeNode;
import com.sap.engine.services.deploy.gui.sfilechooser.tree.SChooserTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ExplorerPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener,
TreeExpansionListener,
KeyListener,
MouseListener {
    private SFileChooser chooserDialog;
    private DriveTreeNode rootNode = new DriveTreeNode();
    private ExplorerTreeModel dirTreeModel = new ExplorerTreeModel(this.rootNode);
    private JTree dirTree = new JTree(this.dirTreeModel);
    private JList fileList = new JList();
    private JComboBox adressBar = new JComboBox();
    private JSplitPane jSplit;
    private JTextField addressBar = new JTextField("");
    private TreePath lastSelectedTreeElementPath;
    private DefaultMutableTreeNode lastSelectedTreeNode;
    private DefaultMutableTreeNode beforeLastSelectedTreeNode;
    private JPopupMenu popup = new JPopupMenu();
    private String lastDirectory = null;
    private DriveObject[] systemDrives;
    private DefaultFileSystem fs;
    private File projectDir = new File(".");
    private FavouritesDialog dialog;
    public static final int CREATE_BUTTON = 0;
    public static final int HOME_DIR_BUTTON = 1;
    public static final int USER_DIR_BUTTON = 2;
    public static final int PROJECT_DIR_BUTTON = 3;
    public static final int LAST_DIR_BUTTON = 4;
    public static final int BACK_BUTTON = 5;
    public static final int FORWARD_BUTTON = 6;
    public static final int UP_BUTTON = 7;
    public static final int FAVOURITES_BUTTON = 8;
    public static final int FAVOURITES_MANGAMENT_BUTTON = 9;
    public static final String CREATE_CMD = "CREATE_CMD";
    public static final String ADDRESS_BAR = "ADDRESS_BAR";
    public static final String HOME_CMD = "HOME_CMD";
    public static final String USER_DIR_CMD = "USER_DIR_CMD";
    public static final String PROJECT_CMD = "PROJECT_CMD";
    public static final String LAST_CMD = "LAST_CMD";
    public static final String BACK_CMD = "BACK_CMD";
    public static final String FORWARD_CMD = "FORWARD_CMD";
    public static final String UP_ONE_LEVEL_CMD = "UP_ONE_LEVEL_CMD";
    public static final String FAVOURITE_MANAGMENT_CMD = "FAVOURITE_MANAGMENT_CMD";
    public static final String FAVOURITES_CMD = "FAVOURITES_CMD";
    private boolean hasBack = false;
    private boolean hasForward = false;
    private String[] backBuffer = new String[10];
    private String[] forwardBuffer = new String[10];
    private boolean fromBackBuffer = false;
    private boolean fromBackButton = false;
    private boolean hasFavourites = false;
    private boolean inWhile = false;
    private boolean addsDrive = false;
    private String[] filters = null;
    private boolean onlyDirs = false;
    private boolean isWindowsOS = false;
    private boolean isNewFile = false;
    private boolean isClassPathPanel = false;
    private File userDir = new File(System.getProperty("user.dir"));
    private File homeDir = new File(System.getProperty("user.home"));
    private JLabel locationStatus = new JLabel();
    private JComboBox filterBox = new JComboBox();
    protected JButton[] explorerButtons = new JButton[10];

    public ExplorerPanel(SFileChooser chooserDialog) {
        this.chooserDialog = chooserDialog;
        this.init();
    }

    private void init() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            this.isWindowsOS = true;
        }
        this.dialog = new FavouritesDialog((JDialog)((Object)this.chooserDialog), this);
        this.filterBox.addActionListener(this);
        this.filterBox.setActionCommand("filter_box");
        FileListRenderer listRenderer = new FileListRenderer();
        this.fileList.setCellRenderer(listRenderer);
        SChooserTreeRenderer srenderer = new SChooserTreeRenderer();
        this.dirTree.setCellRenderer(srenderer);
        this.dirTree.getSelectionModel().setSelectionMode(1);
        this.jSplit = new JSplitPane();
        JPanel mainPanel = new JPanel();
        JPanel adressPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        adressPanel.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.dirTree.addMouseListener(this);
        this.dirTree.addKeyListener(this);
        this.dirTree.addTreeSelectionListener(this);
        this.dirTree.addTreeExpansionListener(this);
        this.fileList.addListSelectionListener(this);
        this.addressBar.setActionCommand(ADDRESS_BAR);
        this.addressBar.addActionListener(this);
        ((JTextField)this.adressBar.getEditor().getEditorComponent()).addActionListener(this);
        this.fileList.addKeyListener(this);
        this.fileList.addMouseListener(this);
        this.dirTree.setRootVisible(true);
        JScrollPane dirTreeScroll = new JScrollPane(this.dirTree);
        JScrollPane fileListScroll = new JScrollPane(this.fileList);
        JPanel directoryPanel1 = new JPanel(new BorderLayout());
        JPanel locationPanel = new JPanel(new BorderLayout());
        locationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Current Directory"));
        locationPanel.add((Component)this.locationStatus, "Center");
        directoryPanel1.add((Component)dirTreeScroll, "Center");
        directoryPanel1.add((Component)this.loadSpeedButtons(), "East");
        directoryPanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Directories"));
        JPanel filePanel1 = new JPanel(new BorderLayout());
        filePanel1.add((Component)fileListScroll, "Center");
        this.filterBox.setPreferredSize(new Dimension(fileListScroll.getWidth(), 22));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Filters"));
        filterPanel.add((Component)this.filterBox, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        filePanel1.add((Component)filterPanel, "South");
        filePanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Files"));
        this.jSplit.setLeftComponent(directoryPanel1);
        this.jSplit.setRightComponent(filePanel1);
        this.jSplit.setDividerLocation(200);
        JLabel adressLabel = new JLabel("Address");
        adressPanel.add((Component)adressLabel, new GridBagConstraints(0, 0, 1, 0, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        adressPanel.add((Component)this.addressBar, new GridBagConstraints(1, 0, 1, 0, 0.1, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)this.jSplit, new GridBagConstraints(0, 1, 3, 5, 0.1, 0.1, 15, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)locationPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)mainPanel, new GridBagConstraints(1, 1, 5, 5, 0.1, 0.1, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)adressPanel, new GridBagConstraints(0, 8, 6, 1, 0.1, 0.0, 15, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.explorerButtons[4].setEnabled(this.lastSelectedTreeNode != null);
        this.explorerButtons[5].setEnabled(this.hasElementsInBuffer(this.backBuffer));
        this.explorerButtons[6].setEnabled(this.hasElementsInBuffer(this.forwardBuffer));
        this.explorerButtons[8].setEnabled(this.dialog.getFavouritesVector().size() != 0);
        this.initTree();
    }

    private void initTree() {
        this.fs = new DefaultFileSystem();
        this.systemDrives = this.fs.getSystemDrives();
        this.dirTreeModel.setIsLoadingDrives(true);
        int i = 0;
        while (i < this.systemDrives.length) {
            DriveTreeNode tempAddNode = new DriveTreeNode(this.systemDrives[i]);
            this.dirTreeModel.insertNodeInto(tempAddNode, this.rootNode, i);
            ++i;
        }
        this.dirTreeModel.reload();
        this.dirTreeModel.setIsLoadingDrives(false);
        this.goTo(this.userDir);
    }

    private JPanel loadSpeedButtons() {
        this.explorerButtons[0] = new JButton();
        this.explorerButtons[1] = new JButton();
        this.explorerButtons[2] = new JButton();
        this.explorerButtons[3] = new JButton();
        this.explorerButtons[4] = new JButton();
        this.explorerButtons[5] = new JButton();
        this.explorerButtons[6] = new JButton();
        this.explorerButtons[7] = new JButton();
        this.explorerButtons[8] = new JButton();
        this.explorerButtons[9] = new JButton();
        this.explorerButtons[0].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[1].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[2].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[3].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[4].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[5].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[6].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[7].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[8].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[9].setPreferredSize(new Dimension(24, 24));
        this.explorerButtons[0].setActionCommand(CREATE_CMD);
        this.explorerButtons[1].setActionCommand(HOME_CMD);
        this.explorerButtons[2].setActionCommand(USER_DIR_CMD);
        this.explorerButtons[3].setActionCommand(PROJECT_CMD);
        this.explorerButtons[4].setActionCommand(LAST_CMD);
        this.explorerButtons[5].setActionCommand(BACK_CMD);
        this.explorerButtons[6].setActionCommand(FORWARD_CMD);
        this.explorerButtons[7].setActionCommand(UP_ONE_LEVEL_CMD);
        this.explorerButtons[8].setActionCommand(FAVOURITES_CMD);
        this.explorerButtons[9].setActionCommand(FAVOURITE_MANAGMENT_CMD);
        this.explorerButtons[0].addActionListener(this);
        this.explorerButtons[1].addActionListener(this);
        this.explorerButtons[2].addActionListener(this);
        this.explorerButtons[3].addActionListener(this);
        this.explorerButtons[4].addActionListener(this);
        this.explorerButtons[5].addActionListener(this);
        this.explorerButtons[6].addActionListener(this);
        this.explorerButtons[7].addActionListener(this);
        this.explorerButtons[8].addActionListener(this);
        this.explorerButtons[9].addActionListener(this);
        this.explorerButtons[0].setToolTipText("Create New Directory");
        this.explorerButtons[1].setToolTipText("Home Directory");
        this.explorerButtons[2].setToolTipText("User Directory");
        this.explorerButtons[3].setToolTipText("Project Directory");
        this.explorerButtons[4].setToolTipText("Last selected directory");
        this.explorerButtons[5].setToolTipText("Back");
        this.explorerButtons[6].setToolTipText("Forward");
        this.explorerButtons[7].setToolTipText("Up One Directory");
        this.explorerButtons[8].setToolTipText("Favorites");
        this.explorerButtons[9].setToolTipText("Favorites Management");
        this.explorerButtons[0].setIcon(ImageHolder.newFolderIcon);
        this.explorerButtons[1].setIcon(ImageHolder.homeIcon);
        this.explorerButtons[2].setIcon(ImageHolder.userDirIcon);
        this.explorerButtons[3].setIcon(ImageHolder.projectIcon);
        this.explorerButtons[4].setIcon(ImageHolder.lastIcon);
        this.explorerButtons[5].setIcon(ImageHolder.leftArrowIcon);
        this.explorerButtons[6].setIcon(ImageHolder.rightArrowIcon);
        this.explorerButtons[7].setIcon(ImageHolder.upFolderIcon);
        this.explorerButtons[8].setIcon(ImageHolder.favourites);
        this.explorerButtons[9].setIcon(ImageHolder.favouritesManagment);
        FavouritesPopupListener listener = new FavouritesPopupListener(this.popup);
        this.explorerButtons[8].addMouseListener(listener);
        JPanel speedButtons = new JPanel();
        speedButtons.setLayout(new GridBagLayout());
        int i = 0;
        while (i < this.explorerButtons.length) {
            speedButtons.add((Component)this.explorerButtons[i], new GridBagConstraints(0, i, 1, 1, 0.0, 0.1, 11, 0, new Insets(1, 1, 1, 1), 0, 0));
            ++i;
        }
        this.explorerButtons[5].setEnabled(false);
        this.explorerButtons[6].setEnabled(false);
        speedButtons.setMinimumSize(new Dimension(28, 400));
        speedButtons.setMaximumSize(new Dimension(32, 400));
        speedButtons.setPreferredSize(new Dimension(30, 400));
        return speedButtons;
    }

    private int countDirectories(File f) {
        File[] list = f.listFiles();
        int result = 0;
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].isDirectory()) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    private int needUpdateInfo(DefaultMutableTreeNode givenNode) {
        boolean isFolder = givenNode instanceof FolderTreeNode;
        File fileForCheck = !isFolder ? new File(((DriveTreeNode)givenNode).getDriveObject().getName()) : new File(((FolderTreeNode)givenNode).getAbsolutePath());
        return this.countDirectories(fileForCheck) - givenNode.getChildCount();
    }

    private DefaultMutableTreeNode containsInChilds(DefaultMutableTreeNode parentNode, DefaultMutableTreeNode givenNode) {
        int count = parentNode.getChildCount();
        int i = 0;
        while (i < count) {
            if (parentNode.getChildAt(i).equals(givenNode)) {
                return (DefaultMutableTreeNode)parentNode.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    private void removeDeadDirectories(DefaultMutableTreeNode givenNode) {
        int countChilds;
        boolean isFolder = givenNode instanceof FolderTreeNode;
        int i = countChilds = givenNode.getChildCount();
        while (0 < i) {
            File fileForCheck;
            if (isFolder && !(fileForCheck = new File(((FolderTreeNode)givenNode.getChildAt(i - 1)).getAbsolutePath())).exists()) {
                this.dirTreeModel.removeNodeFromParent((DefaultMutableTreeNode)givenNode.getChildAt(i - 1));
            }
            --i;
        }
    }

    private File[] getDirectories(File[] f) {
        Vector<File> vec = new Vector<File>();
        if (f == null) {
            return null;
        }
        int i = 0;
        while (i < f.length) {
            if (f[i] != null && f[i].isDirectory()) {
                vec.add(f[i]);
            }
            ++i;
        }
        if (vec.size() == 0) {
            return null;
        }
        Object[] result = new File[vec.size()];
        vec.copyInto(result);
        return result;
    }

    private int findIndex(DefaultMutableTreeNode given, File f1) {
        File[] tempListOfFiles = this.getDirectories(new File(given.toString()).listFiles());
        if (tempListOfFiles == null) {
            return given.getChildCount();
        }
        int i = 0;
        while (i < tempListOfFiles.length) {
            if (tempListOfFiles[i].getAbsolutePath().equals(f1.getAbsolutePath())) {
                return i;
            }
            ++i;
        }
        return given.getChildCount();
    }

    private boolean containsValue(DriveObject value, DriveObject[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].getName().equals(value.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findIndexToInsertDrive(DriveObject drvO) {
        int i = 0;
        while (i < this.rootNode.getChildCount()) {
            if (((DriveTreeNode)this.rootNode.getChildAt(i)).getDriveObject().getName().compareTo(drvO.getName()) > 0) {
                return i;
            }
            ++i;
        }
        return this.rootNode.getChildCount() - 1;
    }

    private DriveTreeNode findDriveNode(DriveObject drvO) {
        int i = 0;
        while (i < this.rootNode.getChildCount()) {
            if (((DriveTreeNode)this.rootNode.getChildAt(i)).getDriveObject().getName().equals(drvO.getName())) {
                return (DriveTreeNode)this.rootNode.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    private void checkDrives() {
        DriveObject[] drvObjcts = this.fs.getSystemDrives();
        Vector<DriveObject> sysDrivesTemp = new Vector<DriveObject>();
        int i = 0;
        while (i < this.systemDrives.length) {
            if (this.containsValue(this.systemDrives[i], drvObjcts)) {
                sysDrivesTemp.add(this.systemDrives[i]);
            } else {
                DriveTreeNode tempAddNode = this.findDriveNode(this.systemDrives[i]);
                if (tempAddNode != null) {
                    this.dirTreeModel.removeNodeFromParent(tempAddNode);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < drvObjcts.length) {
            if (!sysDrivesTemp.contains(drvObjcts[i2])) {
                DriveTreeNode tempAddNode = new DriveTreeNode(drvObjcts[i2]);
                this.dirTreeModel.insertNodeInto(tempAddNode, this.rootNode, this.findIndexToInsertDrive(drvObjcts[i2]));
            }
            ++i2;
        }
        this.systemDrives = drvObjcts;
    }

    private void importTwoLevels(DefaultMutableTreeNode givenNode) {
        File[] fileList;
        File fileForCheck;
        boolean isFolder;
        this.removeDeadDirectories(givenNode);
        if (!this.addsDrive) {
            this.checkDrives();
        }
        if (!(isFolder = givenNode instanceof FolderTreeNode)) {
            fileForCheck = new File(((DriveTreeNode)givenNode).getDriveObject().getName());
            if (((DriveTreeNode)givenNode).getDriveObject().getName().equals("System")) {
                // empty if block
            }
        } else {
            fileForCheck = new File(((FolderTreeNode)givenNode).getAbsolutePath());
        }
        if ((fileList = fileForCheck.listFiles()) == null) {
            return;
        }
        int i = 0;
        while (i < fileList.length) {
            if (fileList[i].isDirectory()) {
                FolderTreeNode childOfGivenNode = new FolderTreeNode(fileList[i]);
                FolderTreeNode temp = (FolderTreeNode)this.containsInChilds(givenNode, childOfGivenNode);
                if (temp == null) {
                    this.dirTreeModel.insertNodeInto(childOfGivenNode, givenNode, this.findIndex(givenNode, fileList[i]));
                } else {
                    childOfGivenNode = temp;
                }
                fileForCheck = new File(childOfGivenNode.getAbsolutePath());
                File[] childFileList = fileForCheck.listFiles();
                if (childFileList != null) {
                    int j = 0;
                    while (j < childFileList.length) {
                        if (childFileList[j].isDirectory()) {
                            FolderTreeNode childOfChildOfGivenNode = new FolderTreeNode(childFileList[j]);
                            temp = (FolderTreeNode)this.containsInChilds(childOfGivenNode, childOfChildOfGivenNode);
                            if (temp != null) break;
                            this.dirTreeModel.insertNodeInto(childOfChildOfGivenNode, childOfGivenNode, this.findIndex(childOfGivenNode, childFileList[j]));
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private String[] convertToSegmentsArray(String convertFilePath) {
        StringTokenizer st = new StringTokenizer(convertFilePath, File.separator);
        Vector<String> resultVector = new Vector<String>();
        if (convertFilePath.startsWith(File.separator)) {
            resultVector.add(File.separator);
        }
        while (st.hasMoreTokens()) {
            resultVector.add(st.nextToken());
        }
        Object[] result = new String[resultVector.size()];
        resultVector.copyInto(result);
        return result;
    }

    public void goTo(File gotoFile) {
        String[] filePartsArray = this.convertToSegmentsArray(gotoFile.getAbsolutePath());
        TreePath goPath = null;
        Object[] treeGoPath = null;
        Vector<DefaultMutableTreeNode> treeVector = new Vector<DefaultMutableTreeNode>();
        String path = "";
        DefaultMutableTreeNode tempFindNode = this.rootNode;
        treeVector.add(tempFindNode);
        int i = 0;
        while (i < filePartsArray.length) {
            path = i == 0 && filePartsArray[i].equals(File.separator) ? filePartsArray[i] : (i == 0 && !filePartsArray[i].equals(File.separator) ? filePartsArray[i] : path + File.separator + filePartsArray[i]);
            int indexChildCount = tempFindNode.getChildCount();
            int j = 0;
            while (j < indexChildCount) {
                if (tempFindNode.getChildAt(j) instanceof DriveTreeNode) {
                    if (this.equalsStringsOSDependant(((DriveTreeNode)tempFindNode.getChildAt(j)).getDriveObject().getName(), path) || this.equalsStringsOSDependant(((DriveTreeNode)tempFindNode.getChildAt(j)).getDriveObject().getName(), path + File.separator)) {
                        tempFindNode = (DefaultMutableTreeNode)tempFindNode.getChildAt(j);
                        treeVector.add(tempFindNode);
                        break;
                    }
                } else if (tempFindNode.getChildAt(j) instanceof FolderTreeNode && (this.equalsStringsOSDependant(((FolderTreeNode)tempFindNode.getChildAt(j)).getAbsolutePath(), path) || this.equalsStringsOSDependant(((FolderTreeNode)tempFindNode.getChildAt(j)).getAbsolutePath(), path + File.separator))) {
                    tempFindNode = (DefaultMutableTreeNode)tempFindNode.getChildAt(j);
                    treeVector.add(tempFindNode);
                    break;
                }
                ++j;
            }
            if (treeVector.size() > 0) {
                treeGoPath = new Object[treeVector.size()];
                treeVector.copyInto(treeGoPath);
                goPath = new TreePath(treeGoPath);
                this.importTwoLevels((DefaultMutableTreeNode)treeGoPath[treeGoPath.length - 1]);
                if (i == filePartsArray.length - 1) {
                    this.dirTree.setSelectionPath(goPath);
                }
            }
            ++i;
        }
    }

    private void createAction() {
        if (this.dirTree.isSelectionEmpty()) {
            return;
        }
        String name = null;
        boolean test2 = true;
        do {
            if ((name = JOptionPane.showInputDialog((Component)((Object)this.chooserDialog), "Please input the name of the new directory", "Create Directory", 1)) != null && FileUtils.isCorrectFileName(name)) {
                test2 = false;
                continue;
            }
            if (name == null) {
                return;
            }
            JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "A file name cannot contain the following characters: *, ?, \\, /, <, >, |, \" .", "Warning", 0);
        } while (test2);
        DefaultMutableTreeNode creater = (DefaultMutableTreeNode)this.lastSelectedTreeElementPath.getLastPathComponent();
        String parent = null;
        if (creater instanceof DriveTreeNode && !((DriveTreeNode)this.lastSelectedTreeNode).getDriveObject().getName().equals("System")) {
            parent = ((DriveTreeNode)this.lastSelectedTreeNode).getDriveObject().getName();
        } else if (creater instanceof FolderTreeNode) {
            parent = ((FolderTreeNode)this.lastSelectedTreeNode).getAbsolutePath();
        }
        File f = new File(parent);
        File tempFile = new File(f, name);
        if (tempFile.exists()) {
            JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "Such name already exists!", "Warning", 0);
        } else {
            tempFile.mkdirs();
        }
        this.importTwoLevels(creater);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ADDRESS_BAR)) {
            File existFile;
            if (!this.addressBar.getText().equals("") && (existFile = new File(this.addressBar.getText())).exists() && existFile.isDirectory()) {
                this.goTo(existFile);
            }
        } else if (actionEvent.getActionCommand().equals(CREATE_CMD)) {
            this.createAction();
        } else if (actionEvent.getActionCommand().equals(HOME_CMD)) {
            this.goTo(this.homeDir);
        } else if (actionEvent.getActionCommand().equals(USER_DIR_CMD)) {
            this.goTo(this.userDir);
        } else if (actionEvent.getActionCommand().equals(PROJECT_CMD)) {
            this.goTo(this.projectDir);
        } else if (actionEvent.getActionCommand().equals(LAST_CMD)) {
            if (this.beforeLastSelectedTreeNode != null) {
                if (this.beforeLastSelectedTreeNode instanceof DriveTreeNode) {
                    this.lastDirectory = ((DriveTreeNode)this.beforeLastSelectedTreeNode).getDriveObject().getName();
                } else if (this.beforeLastSelectedTreeNode instanceof FolderTreeNode) {
                    this.lastDirectory = ((FolderTreeNode)this.beforeLastSelectedTreeNode).getAbsolutePath();
                }
                if (this.lastDirectory != null) {
                    this.goTo(new File(this.lastDirectory));
                }
            }
        } else if (actionEvent.getActionCommand().equals(BACK_CMD)) {
            this.goToNodeWithoutTreeCompletion(this.backBuffer);
        } else if (actionEvent.getActionCommand().equals(FORWARD_CMD)) {
            this.goToNodeWithoutTreeCompletion(this.forwardBuffer);
        } else if (actionEvent.getActionCommand().equals(UP_ONE_LEVEL_CMD)) {
            if (this.lastSelectedTreeNode != null && this.lastSelectedTreeNode.getParent() != null) {
                this.dirTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)this.lastSelectedTreeNode.getParent()).getPath()));
            }
        } else if (actionEvent.getActionCommand().equals(FAVOURITE_MANAGMENT_CMD)) {
            this.dialog.favouritesPanelAddRemove(!this.hasFavourites);
            this.hasFavourites = !this.hasFavourites;
        } else if (!actionEvent.getActionCommand().equals(FAVOURITES_CMD) && actionEvent.getActionCommand().equals("filter_box")) {
            this.refreshAction();
        }
    }

    private boolean hasElementsInBuffer(String[] buffer) {
        return this.findLastEntry(buffer) > 0;
    }

    private void treeListEvent(DefaultMutableTreeNode node) {
        ExplorerFilter fil = new ExplorerFilter(this.returnFilter((String)this.filterBox.getSelectedItem()), this.onlyDirs);
        this.importTwoLevels(node);
        FileObject[] list = new FileObject[]{};
        if (node instanceof DriveTreeNode) {
            if (((DriveTreeNode)node).getDriveObject().getName().equals("System")) {
                this.locationStatus.setText("System");
                this.fileList.removeAll();
                list = new FileObject[this.systemDrives.length];
                int t = 0;
                while (t < this.systemDrives.length) {
                    list[t] = new FileObject(this.systemDrives[t].getName());
                    ++t;
                }
                this.fileList.setListData(list);
                this.fileList.repaint();
                this.repaint();
                this.lastSelectedTreeNode = node;
                this.explorerButtons[4].setEnabled(this.lastSelectedTreeNode != null);
                this.explorerButtons[5].setEnabled(this.hasElementsInBuffer(this.backBuffer));
                this.explorerButtons[6].setEnabled(this.hasElementsInBuffer(this.forwardBuffer));
                return;
            }
            File[] temporaryList = new FileObject(((DriveTreeNode)node).getDriveObject().getName()).listFiles(fil);
            this.locationStatus.setText(((DriveTreeNode)node).getDriveObject().getName());
            if (temporaryList == null) {
                this.fileList.removeAll();
                JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "Drive not ready.", "Error", 0);
                this.dirTree.clearSelection();
                this.lastSelectedTreeNode = node;
                this.explorerButtons[4].setEnabled(this.lastSelectedTreeNode != null);
                this.explorerButtons[5].setEnabled(this.hasElementsInBuffer(this.backBuffer));
                this.explorerButtons[6].setEnabled(this.hasElementsInBuffer(this.forwardBuffer));
                return;
            }
            list = new FileObject[temporaryList.length];
            int i = 0;
            while (i < temporaryList.length) {
                list[i] = new FileObject(temporaryList[i].getAbsolutePath());
                ++i;
            }
            if (list == null) {
                this.fileList.removeAll();
                JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "Drive not ready.", "Error", 0);
                this.dirTree.clearSelection();
                this.lastSelectedTreeNode = node;
                this.explorerButtons[4].setEnabled(this.lastSelectedTreeNode != null);
                this.explorerButtons[5].setEnabled(this.hasElementsInBuffer(this.backBuffer));
                this.explorerButtons[6].setEnabled(this.hasElementsInBuffer(this.forwardBuffer));
                return;
            }
        } else if (node instanceof FolderTreeNode) {
            this.importTwoLevels(node);
            this.locationStatus.setText(((FolderTreeNode)node).getAbsolutePath());
            File[] temporaryList = ((FolderTreeNode)node).getFile().listFiles(fil);
            DefaultMutableTreeNode tempNode1 = node;
            if (!((FolderTreeNode)tempNode1).getFile().exists()) {
                node = null;
                while (tempNode1 != null && tempNode1 instanceof FolderTreeNode && !((FolderTreeNode)tempNode1).getFile().exists()) {
                    if (((FolderTreeNode)tempNode1).getFile().exists()) continue;
                    tempNode1 = (DefaultMutableTreeNode)tempNode1.getParent();
                    this.inWhile = true;
                }
                if (this.inWhile && tempNode1 != null) {
                    int i = tempNode1.getChildCount() - 1;
                    while (i > -1) {
                        this.dirTreeModel.removeNodeFromParent((DefaultMutableTreeNode)tempNode1.getChildAt(i));
                        --i;
                    }
                }
                this.inWhile = false;
                this.fileList.setListData(new Vector());
                this.lastSelectedTreeNode = node;
                JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "Drive not ready.", "Error", 0);
                this.explorerButtons[4].setEnabled(this.lastSelectedTreeNode != null);
                this.explorerButtons[5].setEnabled(this.hasElementsInBuffer(this.backBuffer));
                this.explorerButtons[6].setEnabled(this.hasElementsInBuffer(this.forwardBuffer));
                return;
            }
            if (temporaryList != null) {
                list = new FileObject[temporaryList.length];
                int i = 0;
                while (i < temporaryList.length) {
                    list[i] = new FileObject(temporaryList[i].getAbsolutePath());
                    ++i;
                }
            }
        }
        this.fileList.setListData(this.preShowData(list));
        if (this.lastSelectedTreeNode == null || !this.lastSelectedTreeNode.equals(node)) {
            this.getBeforeLastSelectedNode(node);
        }
        this.lastSelectedTreeNode = node;
    }

    public void valueChanged(TreeSelectionEvent treeEvent) {
        if (this.inWhile) {
            return;
        }
        if (!this.dirTree.isSelectionEmpty()) {
            this.fileList.removeAll();
            this.lastSelectedTreeElementPath = treeEvent.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.lastSelectedTreeElementPath.getLastPathComponent();
            this.treeListEvent(node);
        } else {
            this.locationStatus.setText("");
        }
        this.explorerButtons[4].setEnabled(this.lastSelectedTreeNode != null);
        this.explorerButtons[5].setEnabled(this.hasElementsInBuffer(this.backBuffer));
        this.explorerButtons[6].setEnabled(this.hasElementsInBuffer(this.forwardBuffer));
    }

    private FileObject[] preShowData(FileObject[] list) {
        FileObject[] result = new FileObject[list.length];
        int countDir = 0;
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirectory()) {
                result[countDir] = list[i];
                ++countDir;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2].isFile()) {
                result[countDir] = list[i2];
                ++countDir;
            }
            ++i2;
        }
        return result;
    }

    public void valueChanged(ListSelectionEvent listEvent) {
        if (listEvent.getSource() == this.fileList) {
            this.fileListEvent();
        }
    }

    private void fileListEvent() {
        if (this.fileList.isSelectionEmpty()) {
            this.addressBar.setText("");
            return;
        }
        Object[] tempFO = this.fileList.getSelectedValues();
        String result = "";
        boolean noFirst = false;
        int i = 0;
        while (i < tempFO.length) {
            if (i == 0) {
                if (this.onlyDirs || this.isClassPathPanel) {
                    if (((FileObject)tempFO[i]).isDirectory()) {
                        result = ((FileObject)tempFO[i]).getAbsolutePath();
                    } else {
                        noFirst = true;
                    }
                } else if (((FileObject)tempFO[i]).isFile()) {
                    result = ((FileObject)tempFO[i]).getAbsolutePath();
                }
            } else {
                if (noFirst) {
                    if (this.onlyDirs || this.isClassPathPanel) {
                        if (((FileObject)tempFO[i]).isDirectory()) {
                            result = ((FileObject)tempFO[i]).getAbsolutePath();
                        } else {
                            noFirst = true;
                        }
                    } else if (((FileObject)tempFO[i]).isFile()) {
                        result = ((FileObject)tempFO[i]).getAbsolutePath();
                    }
                }
                if (this.onlyDirs || this.isClassPathPanel) {
                    if (((FileObject)tempFO[i]).isDirectory()) {
                        result = result + ";" + ((FileObject)tempFO[i]).getAbsolutePath();
                    }
                } else if (((FileObject)tempFO[i]).isFile()) {
                    result = result + ";" + ((FileObject)tempFO[i]).getAbsolutePath();
                }
            }
            ++i;
        }
        this.addressBar.setText(result);
    }

    public boolean isCorrectSelection() {
        if (this.isClassPathPanel) {
            return true;
        }
        if (this.isNewFile && !this.addressBar.getText().trim().equals("")) {
            File fTemp;
            FileObject foObj;
            if (this.dirTree.isSelectionEmpty() || this.dirTree.getSelectionPath().getLastPathComponent() == this.rootNode) {
                return false;
            }
            if (!this.fileList.isSelectionEmpty() && this.isNewFile && !(foObj = (FileObject)this.fileList.getSelectedValue()).getAbsolutePath().equals(this.addressBar.getText()) && (fTemp = new File(this.addressBar.getText())).getParentFile() != null && !fTemp.getParentFile().exists() && this.addressBar.getText().indexOf(File.separator) >= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "The parent path is not valid!", "Error", 0);
                return false;
            }
            if (this.addressBar.getText().indexOf("*") == -1 && this.addressBar.getText().indexOf("?") == -1 && this.addressBar.getText().indexOf("<") == -1 && this.addressBar.getText().indexOf(">") == -1 && this.addressBar.getText().indexOf("|") == -1) {
                return true;
            }
            JOptionPane.showMessageDialog((Component)((Object)this.chooserDialog), "The file name contains forbiden symbols: *, ?, <, >, |", "Error", 0);
            return false;
        }
        if (this.isNewFile) {
            return false;
        }
        if (!this.fileList.isSelectionEmpty()) {
            Object[] tempSelectedItems = this.fileList.getSelectedValues();
            if (tempSelectedItems == null) {
                return false;
            }
            boolean hasDirs = false;
            boolean hasFiles = false;
            int i = 0;
            while (i < tempSelectedItems.length) {
                if (((File)tempSelectedItems[i]).isDirectory()) {
                    hasDirs = true;
                } else if (((File)tempSelectedItems[i]).isFile()) {
                    hasFiles = true;
                }
                ++i;
            }
            if (this.onlyDirs && hasDirs) {
                return true;
            }
            if (!this.onlyDirs && hasFiles) {
                return true;
            }
        } else if (!this.dirTree.isSelectionEmpty() && this.onlyDirs) {
            return true;
        }
        return false;
    }

    public void treeExpanded(TreeExpansionEvent trEx) {
        DefaultMutableTreeNode t1 = (DefaultMutableTreeNode)trEx.getPath().getLastPathComponent();
        this.importTwoLevels(t1);
    }

    public void treeCollapsed(TreeExpansionEvent trEx) {
        DefaultMutableTreeNode t1 = (DefaultMutableTreeNode)trEx.getPath().getLastPathComponent();
        this.importTwoLevels(t1);
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getSource() == this.dirTree) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getSource() == this.fileList) {
            FileObject fo = (FileObject)this.fileList.getSelectedValue();
            if (fo == null) {
                return;
            }
            if (me.getClickCount() > 1) {
                if (fo.isDirectory()) {
                    int indexChilds = this.lastSelectedTreeNode.getChildCount();
                    if (indexChilds > 0) {
                        int i = 0;
                        while (i < indexChilds) {
                            if (this.lastSelectedTreeNode.getChildAt(i) instanceof DriveTreeNode) {
                                if (fo.getAbsolutePath().equals(((DriveTreeNode)this.lastSelectedTreeNode.getChildAt(i)).getDriveObject().getName())) {
                                    TreePath treePath = new TreePath(((DriveTreeNode)this.lastSelectedTreeNode.getChildAt(i)).getPath());
                                    this.dirTree.setSelectionPath(treePath);
                                    return;
                                }
                            } else if (this.lastSelectedTreeNode.getChildAt(i) instanceof FolderTreeNode && fo.getAbsolutePath().equals(((FolderTreeNode)this.lastSelectedTreeNode.getChildAt(i)).getFile().getAbsolutePath())) {
                                TreePath treePath = new TreePath(((FolderTreeNode)this.lastSelectedTreeNode.getChildAt(i)).getPath());
                                this.dirTree.setSelectionPath(treePath);
                                return;
                            }
                            ++i;
                        }
                    }
                } else if (!fo.exists()) {
                    TreePath treePath = new TreePath(this.lastSelectedTreeNode.getPath());
                    this.dirTree.setSelectionPath(treePath);
                } else {
                    this.chooserDialog.okAction();
                }
            }
            if (fo != null && !fo.exists()) {
                TreePath treePath = new TreePath(this.lastSelectedTreeNode.getPath());
                this.dirTree.clearSelection();
                this.dirTree.setSelectionPath(treePath);
            }
        } else if (me.getSource() == this.dirTree) {
            // empty if block
        }
    }

    private void getBeforeLastSelectedNode(DefaultMutableTreeNode node) {
        if (!this.dirTree.isSelectionEmpty() && node != this.lastSelectedTreeNode) {
            this.beforeLastSelectedTreeNode = this.lastSelectedTreeNode;
            if (this.beforeLastSelectedTreeNode != null && !this.fromBackButton) {
                String[] buffer = null;
                boolean fromBack = false;
                if (this.fromBackBuffer) {
                    buffer = this.forwardBuffer;
                    fromBack = false;
                    this.fromBackBuffer = false;
                } else {
                    buffer = this.backBuffer;
                    fromBack = true;
                    this.nullBuffer(this.forwardBuffer);
                }
                String path = null;
                if (this.beforeLastSelectedTreeNode instanceof DriveTreeNode) {
                    path = ((DriveTreeNode)this.beforeLastSelectedTreeNode).getDriveObject().getName();
                    this.addToBuffer(path, buffer, fromBack);
                } else if (this.beforeLastSelectedTreeNode instanceof FolderTreeNode) {
                    path = ((FolderTreeNode)this.beforeLastSelectedTreeNode).getAbsolutePath();
                    this.addToBuffer(path, buffer, fromBack);
                }
            }
            this.fromBackButton = false;
            this.beforeLastSelectedTreeNode = this.lastSelectedTreeNode;
        }
    }

    private int findLastEntry(String[] strArray) {
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i] == null) {
                return --i;
            }
            ++i;
        }
        return strArray.length - 1;
    }

    private boolean equalsStringsOSDependant(String s1, String s2) {
        if (this.isWindowsOS) {
            if (s1 != null) {
                return s1.equalsIgnoreCase(s2);
            }
            return s2 == null;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2 == null;
    }

    private void goToNodeWithoutTreeCompletion(String[] buffer) {
        if (buffer.length > 0) {
            int index1 = this.findLastEntry(buffer);
            if (index1 < 0) {
                return;
            }
            if (buffer == this.backBuffer) {
                this.addToBuffer(buffer[index1], this.forwardBuffer, false);
                this.fromBackButton = true;
                this.fromBackBuffer = true;
                this.goTo(new File(buffer[index1]));
                buffer[index1] = null;
            } else {
                this.fromBackButton = true;
                this.addToBuffer(buffer[index1], this.backBuffer, true);
                this.goTo(new File(buffer[index1]));
                buffer[index1] = null;
            }
        }
    }

    private void nullBuffer(String[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = null;
            ++i;
        }
    }

    private void addToBuffer(String s, String[] buffer, boolean fromBack) {
        int index = this.findLastEntry(buffer);
        if (index != buffer.length - 1) {
            buffer[++index] = s;
        } else {
            String[] tempArray = new String[10];
            System.arraycopy(buffer, 1, tempArray, 0, buffer.length - 1);
            buffer = tempArray;
            buffer[buffer.length - 1] = s;
        }
        if (fromBack) {
            this.backBuffer = buffer;
            this.printBuffer(this.backBuffer);
        } else {
            this.forwardBuffer = buffer;
        }
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void setProjectDirectory(String project) {
        if (project == null) {
            project = ".";
        }
        this.projectDir = new File(project);
        if (!this.projectDir.exists() || !this.projectDir.isDirectory()) {
            this.projectDir = new File(System.getProperty("user.dir"));
        }
    }

    private void printBuffer(String[] buffer) {
    }

    public Object[] getSeleectedItems() {
        Vector<FileObject> resultV = new Vector<FileObject>();
        if (!this.fileList.isSelectionEmpty()) {
            return this.fileList.getSelectedValues();
        }
        if (this.addressBar.getText().trim().equals("")) {
            if (this.onlyDirs && !this.dirTree.isSelectionEmpty()) {
                TreePath path = this.dirTree.getSelectionPath();
                DefaultMutableTreeNode ttNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (ttNode instanceof DriveTreeNode) {
                    return new Object[]{((DriveTreeNode)ttNode).getDriveObject().getName()};
                }
                if (ttNode instanceof FolderTreeNode) {
                    return new Object[]{((FolderTreeNode)ttNode).getAbsolutePath()};
                }
                return null;
            }
            if (this.isClassPathPanel && !this.dirTree.isSelectionEmpty()) {
                TreePath path = this.dirTree.getSelectionPath();
                DefaultMutableTreeNode ttNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (ttNode instanceof DriveTreeNode) {
                    return new Object[]{((DriveTreeNode)ttNode).getDriveObject().getName()};
                }
                if (ttNode instanceof FolderTreeNode) {
                    return new Object[]{((FolderTreeNode)ttNode).getAbsolutePath()};
                }
                return null;
            }
            return null;
        }
        String[] tempor = this.tokenizertoArray(this.addressBar.getText());
        int i = 0;
        while (i < tempor.length) {
            FileObject fo;
            String var = ApplicationInformationProvider.getVariableUsed(tempor[i]);
            if (var != null) {
                fo = new FileObject(tempor[i]);
                resultV.add(fo);
            } else {
                fo = new FileObject(tempor[i]);
                if (fo.exists()) {
                    resultV.add(fo);
                }
            }
            ++i;
        }
        Object[] result = new Object[resultV.size()];
        resultV.copyInto(result);
        return result;
    }

    public String[] getSeleectedPaths() {
        if (this.isNewFile) {
            String[] result = new String[1];
            String path = null;
            if (!this.dirTree.isSelectionEmpty()) {
                DefaultMutableTreeNode givenNode = (DefaultMutableTreeNode)this.dirTree.getSelectionPath().getLastPathComponent();
                if (!this.fileList.isSelectionEmpty()) {
                    FileObject foTemp = (FileObject)this.fileList.getSelectedValue();
                    if (this.addressBar.getText().equals(foTemp.getAbsolutePath())) {
                        result[0] = this.addressBar.getText();
                        return result;
                    }
                }
                if (new File(this.addressBar.getText()).getParentFile() != null) {
                    result[0] = this.addressBar.getText();
                    return result;
                }
                boolean isFolder = givenNode instanceof FolderTreeNode;
                path = isFolder ? ((FolderTreeNode)givenNode).getAbsolutePath() : ((DriveTreeNode)givenNode).getDriveObject().getName();
                result[0] = path.endsWith(File.separator) ? path + this.addressBar.getText() : path + File.separator + this.addressBar.getText();
            } else {
                return null;
            }
            return result;
        }
        Vector<String> resultV = new Vector<String>();
        if (!this.fileList.isSelectionEmpty()) {
            Object[] tempFO = this.fileList.getSelectedValues();
            String[] result = new String[tempFO.length];
            int i = 0;
            while (i < tempFO.length) {
                if (this.onlyDirs || this.isClassPathPanel) {
                    if (((File)tempFO[i]).isDirectory()) {
                        result[i] = ((File)tempFO[i]).getAbsolutePath();
                    }
                } else if (!this.onlyDirs) {
                    if (this.filters != null && this.filters.length > 0) {
                        if (((File)tempFO[i]).isFile()) {
                            result[i] = ((File)tempFO[i]).getAbsolutePath();
                        }
                    } else {
                        result[i] = ((File)tempFO[i]).getAbsolutePath();
                    }
                }
                ++i;
            }
            if (result.length == 0) {
                return null;
            }
            return result;
        }
        if (this.addressBar.getText().trim().equals("")) {
            TreePath path = this.dirTree.getSelectionPath();
            DefaultMutableTreeNode ttNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (ttNode instanceof DriveTreeNode) {
                return new String[]{((DriveTreeNode)ttNode).getDriveObject().getName()};
            }
            if (ttNode instanceof FolderTreeNode) {
                return new String[]{((FolderTreeNode)ttNode).getAbsolutePath()};
            }
            return null;
        }
        String[] tempor = this.tokenizertoArray(this.addressBar.getText());
        int i = 0;
        while (i < tempor.length) {
            FileObject fo = new FileObject(tempor[i]);
            if (this.onlyDirs || this.isClassPathPanel) {
                if (fo.isDirectory() && fo.exists()) {
                    resultV.add(fo.getAbsolutePath());
                }
            } else if (!this.onlyDirs) {
                if (this.filters != null && this.filters.length > 0) {
                    if (fo.isFile() && fo.exists()) {
                        resultV.add(fo.getAbsolutePath());
                    }
                } else if (fo.exists()) {
                    resultV.add(fo.getAbsolutePath());
                }
            }
            ++i;
        }
        Object[] result = new String[resultV.size()];
        resultV.copyInto(result);
        if (result.length == 0) {
            return null;
        }
        return result;
    }

    private String[] tokenizertoArray(String filesTemp) {
        Object[] result = null;
        Vector<String> resultV = new Vector<String>();
        StringTokenizer st = new StringTokenizer(filesTemp, ";");
        while (st.hasMoreTokens()) {
            resultV.add(st.nextToken());
        }
        result = new String[resultV.size()];
        resultV.copyInto(result);
        return result;
    }

    public boolean isAddressFieldEmpty() {
        return this.addressBar.getText().trim().equals("");
    }

    public String getAddressField() {
        return this.addressBar.getText();
    }

    public String[] getFilters() {
        return this.filters;
    }

    public void setFilters(String[] fiters) {
        if (fiters == null) {
            this.filters = fiters;
            return;
        }
        boolean contains = false;
        boolean containsMultiplyer = false;
        this.filterBox.removeAllItems();
        int i = 0;
        while (i < fiters.length) {
            if (this.filterBox.getItemCount() > 0) {
                int j = 0;
                while (j < this.filterBox.getItemCount()) {
                    if (((String)this.filterBox.getItemAt(j)).equals(this.putFilterDescription(fiters[i]))) {
                        contains = true;
                    }
                    if (((String)this.filterBox.getItemAt(j)).equals(this.putFilterDescription(".*"))) {
                        containsMultiplyer = true;
                    }
                    ++j;
                }
                if (!contains) {
                    this.filterBox.addItem(this.putFilterDescription(fiters[i]));
                }
                if (!containsMultiplyer) {
                    this.filterBox.addItem(this.putFilterDescription(".*"));
                }
            } else if (!this.putFilterDescription(fiters[i]).equals(this.putFilterDescription(".*"))) {
                this.filterBox.addItem(this.putFilterDescription(fiters[i]));
                this.filterBox.addItem(this.putFilterDescription(".*"));
            } else {
                this.filterBox.addItem(this.putFilterDescription(fiters[i]));
            }
            ++i;
        }
        if (this.filters != null && this.filters.length == 0) {
            this.filterBox.addItem(this.putFilterDescription(".*"));
        }
        this.filters = fiters;
    }

    public boolean isOnlyDirs() {
        return this.onlyDirs;
    }

    public void setOnlyDirs(boolean onlyDirs) {
        if (onlyDirs) {
            this.setFilters(new String[]{"Directories"});
        }
        this.onlyDirs = onlyDirs;
    }

    public void setMultiSelection(boolean multi) {
        if (multi) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
    }

    public void clear() {
        this.addressBar.setText("");
    }

    public boolean isNewFile() {
        return this.isNewFile;
    }

    public void setIsNewFile(boolean isNewFile) {
        this.isNewFile = isNewFile;
    }

    public void gotoUserDir() {
        this.goTo(this.userDir);
    }

    public void gotoWorkDir() {
        this.goTo(this.projectDir);
    }

    public String getFavourites() {
        return this.dialog.getFavourites();
    }

    public void setFavourites(String fav) {
        this.dialog.setFavourites(fav);
    }

    public void removeFavourites() {
        this.dialog.favouritesPanelAddRemove(false);
    }

    public JList getFileList() {
        return this.fileList;
    }

    public DefaultMutableTreeNode getLastSelectedTreeNode() {
        return this.lastSelectedTreeNode;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public JButton[] getExplorerButtons() {
        return this.explorerButtons;
    }

    public JTree getDirTree() {
        return this.dirTree;
    }

    public SFileChooser getChooserDialog() {
        return this.chooserDialog;
    }

    public void setChooserDialog(SFileChooser chooserDialog) {
        this.chooserDialog = chooserDialog;
    }

    public boolean isHasFavourites() {
        return this.hasFavourites;
    }

    public void setHasFavourites(boolean hasFavourites) {
        this.hasFavourites = hasFavourites;
    }

    public void refreshAction() {
        if (!this.dirTree.isSelectionEmpty()) {
            this.treeListEvent((DefaultMutableTreeNode)this.dirTree.getSelectionPath().getLastPathComponent());
        }
    }

    private String putFilterDescription(String s) {
        if (s != null && s.equals("Directories")) {
            return "Directories";
        }
        if (s.equals("*.*") || s.equals(".*")) {
            return "All Files. (.*)";
        }
        if (s.toLowerCase().equals("*.dlp") || s.toLowerCase().equals(".dlp")) {
            return "Project Files. (.dlp)";
        }
        if (s.toLowerCase().equals("*.xml") || s.toLowerCase().equals(".xml")) {
            return "XML Files. (.xml)";
        }
        if (s.toLowerCase().indexOf("*.gif") != -1 || s.toLowerCase().indexOf(".gif") != -1 || s.toLowerCase().indexOf("*.jpg") != -1 || s.toLowerCase().indexOf(".jpg") != -1) {
            return "Image Files. (" + s + ")";
        }
        if (s.toLowerCase().indexOf("*.jar") != -1 || s.toLowerCase().indexOf(".jar") != -1 || s.toLowerCase().indexOf("*.war") != -1 || s.toLowerCase().indexOf(".war") != -1 || s.toLowerCase().indexOf("*.rar") != -1 || s.toLowerCase().indexOf(".rar") != -1 || s.toLowerCase().indexOf("*.ear") != -1 || s.toLowerCase().indexOf(".ear") != -1 || s.toLowerCase().indexOf("*.zip") != -1 || s.toLowerCase().indexOf(".zip") != -1 || s.toLowerCase().indexOf("*.ace") != -1 || s.toLowerCase().indexOf(".ace") != -1 || s.toLowerCase().indexOf("*.sar") != -1 || s.toLowerCase().indexOf(".sar") != -1) {
            return "Archive Files (" + s + ")";
        }
        return "Files. (" + s + ")";
    }

    private String returnFilter(String s) {
        if (s == null || s.equals("Directories")) {
            return null;
        }
        int index1 = s.lastIndexOf("(");
        int index2 = s.lastIndexOf(")");
        String result = s.substring(index1 + 1, index2);
        return result;
    }

    public boolean isClassPathPanel() {
        return this.isClassPathPanel;
    }

    public void setIsClassPathPanel(boolean isClassPathPanel) {
        this.isClassPathPanel = isClassPathPanel;
    }

    public boolean isWindowsOS() {
        return this.isWindowsOS;
    }
}

