/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping.tree;

import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.services.deploy.gui.mapping.tree.ClassFileMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.DirMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.FileMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.ManifestTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.SelectableCellComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class MappingTreeCellRenderer
extends SelectableCellComponent
implements TreeCellRenderer {
    private Icon dirMapIcon;
    private Icon fileMapDeselectIcon2;
    private Icon filesMapIcon;
    private Icon fileMapIcon;
    private Icon manifestFile;
    private Icon classFileDeselectIcon;
    private Icon classFileIcon;
    private Object treeNode;
    private Font boldFont = new Font("Dialog", 1, 12);
    private Font plainFont = new Font("Dialog", 0, 12);
    private Color fgColor = new Color(36, 74, 204);

    public MappingTreeCellRenderer() {
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.label.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        this.treeNode = value;
        this.setFont(this.plainFont);
        this.setBackground(tree.getBackground());
        if (value instanceof DirMappingTreeNode) {
            this.setToolTipText(((DirMappingTreeNode)value).getMapObjValue().getFilePath());
            if (((DirMappingTreeNode)value).getMapObjValue().getFilePath().equals("Directories")) {
                this.setSelectable(false);
                this.setIcon(this.dirMapIcon);
                this.setText(value.toString());
                this.repaint();
            } else {
                if (((DirMappingTreeNode)value).getMapObjValue().isIncluded()) {
                    this.setSelectable(true);
                    this.setIcon(this.dirMapIcon);
                    this.setSelected(true);
                } else {
                    this.setSelectable(true);
                    this.setIcon(this.fileMapDeselectIcon2);
                    this.setSelected(false);
                }
                this.setText(value.toString());
            }
        }
        if (value instanceof FileMappingTreeNode) {
            this.setSelectable(false);
            this.setToolTipText(((FileMappingTreeNode)value).getFileMapObjValue().getFilePath());
            if (((FileMappingTreeNode)value).getFileMapObjValue().getFilePath().equals("Files")) {
                this.setIcon(this.filesMapIcon);
            } else {
                this.setIcon(this.fileMapIcon);
            }
            this.setText(value.toString());
        }
        if (value instanceof ClassFileMappingTreeNode) {
            this.setSelectable(false);
            this.setToolTipText(((ClassFileMappingTreeNode)value).getFileMapObjValue().getFilePath());
            if (((ClassFileMappingTreeNode)value).getFileMapObjValue().getFilePath().equals("Bean classes")) {
                this.setIcon(this.filesMapIcon);
                if (((ClassFileMappingTreeNode)value).getChildCount() == 0) {
                    this.setIcon(this.classFileDeselectIcon);
                } else {
                    this.setIcon(this.classFileIcon);
                }
                this.setText(((ClassFileMappingTreeNode)value).getFileMapObjValue().getFilePath());
            } else {
                this.setIcon(this.fileMapIcon);
                this.setText(value.toString());
            }
        }
        if (value instanceof ManifestTreeNode) {
            this.setIcon(this.manifestFile);
            this.setText(value.toString());
        }
        if (selected) {
            this.setForeground(this.fgColor);
        } else {
            this.setForeground(Color.black);
        }
        return this;
    }

    private void initImages() {
        this.dirMapIcon = (ImageIcon)ImageHolder.dirMapIcon;
        this.filesMapIcon = (ImageIcon)ImageHolder.fileMapIcon;
        this.fileMapIcon = (ImageIcon)ImageHolder.fileIcon;
        this.fileMapDeselectIcon2 = (ImageIcon)ImageHolder.fileMapDeselectIcon;
        this.manifestFile = (ImageIcon)ImageHolder.manifestFile;
        this.classFileDeselectIcon = (ImageIcon)ImageHolder.classFileDeselectIcon;
        this.classFileIcon = (ImageIcon)ImageHolder.classFileIcon;
    }
}

