/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.gui.MappingPanel;
import com.sap.engine.services.deploy.gui.SFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FileMappingPanel
extends JPanel
implements ActionListener {
    private SFileChooser fileChooser;
    private JTextField mapNameTextField;
    private JTextField filePathTextField;
    private JButton pathButton;
    private Frame frame;
    private MappingPanel mapPanel;
    private JButton addFile;
    private JButton clear;

    public FileMappingPanel(Frame frame, MappingPanel mapPanel) {
        this.frame = frame;
        this.mapPanel = mapPanel;
        this.init();
        LookAndFeelHandler.add((Component)this);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel textFieldPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JLabel labelPath = new JLabel("File Path:");
        JLabel labelMapName = new JLabel("Map Name:");
        this.filePathTextField = new JTextField();
        this.mapNameTextField = new JTextField();
        this.addFile = new JButton("Add");
        this.clear = new JButton("Clear");
        this.pathButton = new JButton("...");
        this.clear.setActionCommand("Clear");
        this.clear.addActionListener(this);
        this.addFile.setActionCommand("Add_File");
        this.addFile.addActionListener(this);
        this.pathButton.setActionCommand("path");
        this.pathButton.addActionListener(this);
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)this.addFile, null);
        buttonPanel.add((Component)this.clear, null);
        textFieldPanel.setLayout(new GridBagLayout());
        textFieldPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Files Panel"));
        textFieldPanel.add((Component)labelPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)labelMapName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.filePathTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.pathButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.mapNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)textFieldPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.initFileChooser();
    }

    public void initFileChooser() {
        this.fileChooser = SFileChooser.getInstance((JFrame)this.frame);
        this.fileChooser.setFilters(new String[]{".*", ".html", ".gif;.jpg"});
    }

    public void setData(InfoObject info) {
        this.mapNameTextField.setText(info.getEntryName());
        this.filePathTextField.setText(info.getFilePath());
    }

    public InfoObject getData() {
        InfoObject infoTemp = new InfoObject(this.mapNameTextField.getText(), this.filePathTextField.getText());
        return infoTemp;
    }

    public String[] getTextFromFields() {
        String[] result = new String[]{this.mapNameTextField.getText(), this.filePathTextField.getText()};
        return result;
    }

    public void resetTextFields() {
        this.filePathTextField.setText("");
        this.mapNameTextField.setText("");
    }

    public boolean isEmptyTextFields() {
        boolean result = false;
        if (!this.filePathTextField.getText().trim().equals("") && this.filePathTextField.getText() != null) {
            result = true;
        }
        return result;
    }

    public void clear() {
        this.mapNameTextField.setText("");
        this.filePathTextField.setText("");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("path")) {
            this.initFileChooser();
            String[] path = this.fileChooser.showFileDialog("Select File", false, false, false);
            if (path != null) {
                this.filePathTextField.setText(path[0]);
                if (this.mapPanel.madeFrom() == MappingPanel.WEB) {
                    int indexTemp = this.filePathTextField.getText().lastIndexOf(46);
                    if (indexTemp != -1) {
                        if (this.filePathTextField.getText().substring(indexTemp).equalsIgnoreCase(".class")) {
                            int tempIndexFS = this.filePathTextField.getText().lastIndexOf(File.separator);
                            String tEntry = "";
                            if (tempIndexFS != -1) {
                                tEntry = "WEB-INF/classes/" + this.filePathTextField.getText().substring(tempIndexFS + 1);
                                tEntry = tEntry.replace(File.separatorChar, '/');
                            }
                            this.mapNameTextField.setText(tEntry);
                        } else if (this.filePathTextField.getText().substring(indexTemp).equalsIgnoreCase(".jar")) {
                            int tempIndexFS = this.filePathTextField.getText().lastIndexOf(File.separator);
                            String tEntry = "";
                            if (tempIndexFS != -1) {
                                tEntry = "WEB-INF/lib/" + this.filePathTextField.getText().substring(tempIndexFS + 1);
                                tEntry = tEntry.replace(File.separatorChar, '/');
                            }
                            this.mapNameTextField.setText(tEntry);
                        } else {
                            String tEntry = "";
                            int tempIndexFS = this.filePathTextField.getText().lastIndexOf(File.separator);
                            if (tempIndexFS != -1) {
                                tEntry = this.filePathTextField.getText().substring(tempIndexFS + 1);
                                tEntry = tEntry.replace(File.separatorChar, '/');
                                this.mapNameTextField.setText(tEntry);
                            } else {
                                this.mapNameTextField.setText(this.filePathTextField.getText());
                            }
                        }
                    }
                } else {
                    String tEntry = "";
                    int tempIndexFS = this.filePathTextField.getText().lastIndexOf(File.separator);
                    if (tempIndexFS != -1) {
                        tEntry = this.filePathTextField.getText().substring(tempIndexFS + 1);
                        tEntry = tEntry.replace(File.separatorChar, '/');
                        this.mapNameTextField.setText(tEntry);
                    } else {
                        this.mapNameTextField.setText(this.filePathTextField.getText());
                    }
                }
            }
        } else if (event.getActionCommand().equals("Add_File")) {
            this.mapPanel.addFile();
        } else if (event.getActionCommand().equals("Clear")) {
            this.clear();
        }
    }

    public void setMapNameTextField(String s) {
        this.mapNameTextField.setText(s);
    }

    public void setAllDisable() {
        this.mapNameTextField.setEnabled(false);
        this.filePathTextField.setEnabled(false);
        this.pathButton.setEnabled(false);
        this.addFile.setEnabled(false);
        this.clear.setEnabled(false);
    }

    public void setAllEnable() {
        this.mapNameTextField.setEnabled(true);
        this.filePathTextField.setEnabled(true);
        this.pathButton.setEnabled(true);
        this.addFile.setEnabled(true);
        this.clear.setEnabled(true);
    }
}

