/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping;

import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.gui.MappingPanel;
import com.sap.engine.services.deploy.gui.SFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DirectoryMappingPanel
extends JPanel
implements ActionListener {
    private JTextField mapNameTextField;
    private JTextField dirPathTextField;
    private JButton pathButton;
    private Frame frame;
    private MappingPanel mapPanel;
    private SFileChooser fileChooser;

    public DirectoryMappingPanel(Frame frame, MappingPanel mapPanel) {
        this.frame = frame;
        this.mapPanel = mapPanel;
        this.init();
        LookAndFeelHandler.add((Component)this);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel textFieldPanel = new JPanel();
        JLabel labelPath = new JLabel("Directory Path:");
        JLabel labelMapName = new JLabel("Map Name:");
        this.dirPathTextField = new JTextField();
        this.mapNameTextField = new JTextField();
        JButton addFile = new JButton("Add");
        JButton clear = new JButton("Clear");
        this.pathButton = new JButton("...");
        clear.setActionCommand("Clear");
        clear.addActionListener(this);
        addFile.setActionCommand("Add_Dir");
        addFile.addActionListener(this);
        this.pathButton.setActionCommand("path");
        this.pathButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)addFile, null);
        buttonPanel.add((Component)clear, null);
        textFieldPanel.setLayout(new GridBagLayout());
        textFieldPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Directories Panel"));
        textFieldPanel.add((Component)labelPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)labelMapName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.dirPathTextField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.pathButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        textFieldPanel.add((Component)this.mapNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)textFieldPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void setData(InfoObject info) {
        this.mapNameTextField.setText(info.getEntryName());
        this.dirPathTextField.setText(info.getFilePath());
    }

    public InfoObject getData() {
        InfoObject infoTemp = new InfoObject(this.mapNameTextField.getText(), this.dirPathTextField.getText());
        return infoTemp;
    }

    public String[] getTextFromFields() {
        String[] result = new String[]{this.mapNameTextField.getText(), this.dirPathTextField.getText()};
        return result;
    }

    public void resetTextFields() {
        this.dirPathTextField.setText("");
        this.mapNameTextField.setText("");
    }

    public boolean isEptyTextFields() {
        boolean result = false;
        if (!this.dirPathTextField.getText().trim().equals("") && this.dirPathTextField.getText() != null) {
            result = true;
        }
        return result;
    }

    public void clear() {
        this.mapNameTextField.setText("");
        this.dirPathTextField.setText("");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("path")) {
            this.fileChooser = SFileChooser.getInstance((JFrame)this.frame);
            String[] path = this.fileChooser.showDirDialog("Select Directory", false, false, false);
            if (path != null) {
                this.dirPathTextField.setText(path[0]);
            }
        } else if (event.getActionCommand().equals("Add_Dir")) {
            this.mapPanel.addDirectory();
        } else if (event.getActionCommand().equals("Clear")) {
            this.clear();
        }
    }

    public void setMapNameTextField(String s) {
        this.mapNameTextField.setText(s);
    }

    public void setAllDisable() {
        this.mapNameTextField.setEnabled(false);
        this.dirPathTextField.setEnabled(false);
        this.pathButton.setEnabled(false);
    }

    public void setAllEnable() {
        this.mapNameTextField.setEnabled(true);
        this.dirPathTextField.setEnabled(true);
        this.pathButton.setEnabled(true);
    }
}

