/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.ejb.gui.additional.BeanSettings;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LocaleSettings;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.SecurityRolesPanelLogical;
import com.sap.engine.services.deploy.gui.common.UserMappingPanelLogical;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SecurityViewPanel
extends BasicPanelView
implements ChangeListener,
MadeFromConstants {
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JTabbedPane theTabbedPane = new JTabbedPane();
    protected SecurityRolesPanelLogical first;
    protected UserMappingPanelLogical second;
    private SimpleEarDescriptor descr = null;
    private ClassLoader loader;
    private Frame mainFrame;
    private RemoteSecurity node = null;
    private int madeFrom = 0;
    private ApplicationInformationProvider appInfoProvider;

    public SecurityViewPanel() {
        this.first = new SecurityRolesPanelLogical(this.mainFrame);
        this.second = new UserMappingPanelLogical();
        this.init();
    }

    public SecurityViewPanel(Frame mainFrame, int madeFromConstant) {
        this.mainFrame = mainFrame;
        this.madeFrom = madeFromConstant;
        this.first = new SecurityRolesPanelLogical(mainFrame);
        this.first.init(this.madeFrom);
        this.second = new UserMappingPanelLogical(mainFrame);
        this.init();
        if (this.second != null) {
            this.second.init(this.madeFrom);
        }
    }

    public void setDescriptor(SimpleEarDescriptor _descr) {
        this.descr = _descr;
        if (this.first == null) {
            this.first = new SecurityRolesPanelLogical(this.mainFrame);
            this.first.init(0);
        }
        this.first.setSecurityRoles(this.descr.getRoles());
        if (this.madeFrom != 1 && this.madeFrom != 2) {
            if (this.second != null) {
                this.second.initAvailableList(this.descr.getRoles());
            } else {
                this.second = new UserMappingPanelLogical(this.mainFrame);
                this.second.initAvailableList(this.descr.getRoles());
                this.theTabbedPane.addTab(LocaleSettings.getInstance((String)"EJB").getResourceString("UserMapping", "User Mapping"), this.second);
            }
        } else {
            int index = this.theTabbedPane.indexOfComponent(this.second);
            if (index > -1) {
                this.theTabbedPane.removeTabAt(index);
            }
        }
    }

    private void init() {
        this.setLayout(this.borderLayout1);
        this.theTabbedPane.addTab(LocaleSettings.getInstance((String)"EJB").getResourceString("SecurityRoles", "Security Roles"), this.first);
        if (this.second != null) {
            this.theTabbedPane.addTab(LocaleSettings.getInstance((String)"EJB").getResourceString("UserMapping", "User Mapping"), this.second);
        }
        this.add((Component)this.theTabbedPane, "Center");
        this.theTabbedPane.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        this.tabsChanged();
    }

    private void tabsChanged() {
        if (this.second != null) {
            this.second.initAvailableList(this.first.getSecurityRoles());
        }
        this.first.reset();
        this.repaint();
        this.validate();
    }

    public void commitChange() {
        this.first.commitChange();
        SecurityRoles[] roles = this.first.getSecurityRoles();
        if (this.second != null) {
            this.replaceEqualRoles(this.second.getRoles(), roles);
        }
    }

    public void replaceEqualRoles(SecurityRoles[] allRoles, SecurityRoles[] roles) {
        if (allRoles == null || roles == null) {
            return;
        }
        int i = 0;
        while (i < roles.length) {
            int j = 0;
            while (j < allRoles.length) {
                if (roles[i] != null && allRoles[j] != null && roles[i].getRoleName().trim().equals(allRoles[j].getRoleName().trim())) {
                    roles[i].setUserNames(allRoles[j].getUserNames());
                    roles[i].setUserSIDs(allRoles[j].getUserSIDs());
                    roles[i].setUserGroups(allRoles[j].getUserGroup());
                    roles[i].setGroupSIDs(allRoles[j].getGroupSIDs());
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setContext(RemoteSecurity node) {
        this.node = node;
        if (this.second != null) {
            this.second.initAvailableList(this.first.getSecurityRoles());
            this.second.setContext(node);
        } else {
            this.second = new UserMappingPanelLogical(this.mainFrame);
            this.second.initAvailableList(this.first.getSecurityRoles());
            this.second.setContext(node);
            if (this.madeFrom != 1 && this.madeFrom != 2) {
                this.theTabbedPane.addTab(BeanSettings.getResourceString("UserMapping", "User Mapping"), this.second);
            }
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        int index = this.theTabbedPane.indexOfComponent(this.second);
        if (this.madeFrom != 1 && this.madeFrom != 2) {
            if (index == -1) {
                this.theTabbedPane.addTab(BeanSettings.getResourceString("UserMapping", "User Mapping"), this.second);
            } else {
                this.theTabbedPane.removeTabAt(index);
            }
        }
    }

    public SecurityRoles[] getSecurityRoles() {
        SecurityRoles[] secRoles = this.first.getSecurityRoles();
        return secRoles;
    }

    public int isCorrect() {
        return 0;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider _appProvider) {
        if (this.first != null) {
            this.first.setApplicationInformationProvider(_appProvider);
        }
        if (this.second != null) {
            this.second.setApplicationInformationProvider(_appProvider);
        }
        this.appInfoProvider = _appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appInfoProvider;
    }

    public void setFrame(Frame frame) {
        this.mainFrame = frame;
    }

    public void clear() {
        this.first.clear();
    }

    public void setLoader(ClassLoader loader) {
    }
}

