/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.deploy.gui.ear.PropsEditorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class PropsEditorPanelLogical
extends PropsEditorPanel {
    protected static final String[] ADD_DRIVER_LABELS = new String[]{"DB driver:"};
    protected int madeFrom = 3;
    protected Hashtable datasources;
    protected Hashtable dbInitStatements;
    protected Hashtable drivers;
    protected Hashtable libraries;
    protected Hashtable libNodes;
    protected DataSourceManager dsManager;
    private SFileChooser sfc = null;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private Vector jdbcVector = new Vector();
    protected JDBCDescriptor[] descr;
    private JDBCDescriptor lastJDBCDescr = null;
    private ApplicationInformationProvider appProvider;
    private EARDescriptor earDescr = null;

    public PropsEditorPanelLogical(Frame frame, int madeFromConstant) {
        this.mainFrame = frame;
        this.madeFrom = madeFromConstant;
        this.aliasesPanel.setParentComponent((Component)this.mainFrame);
        this.sfc = SFileChooser.getInstance((JFrame)this.mainFrame);
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        String actionCmd = ae.getActionCommand();
        if (actionCmd.equals(PropsEditorPanel.ADD_POOL_CMD)) {
            this.addPoolAction();
        } else if (actionCmd.equals(PropsEditorPanel.MODIFY_POOL_CMD)) {
            this.addPoolAction();
        } else if (actionCmd.equals(PropsEditorPanel.REMOVE_POOL_CMD)) {
            this.removePoolAction();
        } else if (actionCmd.equals(PropsEditorPanel.CLEAR_POOL_CMD)) {
            this.clearPoolAction();
        } else if (src == this.expCheckBox) {
            this.expAction();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.jdbcVerComboBox) {
            if (this.jdbcVerComboBox.getSelectedIndex() == -1) {
                this.jdbcVerComboBox.setSelectedItem(this.verCBoxLastSel);
            } else {
                this.verCBoxLastSel = this.jdbcVerComboBox.getSelectedItem();
                this.updateJDBCPanels();
            }
        }
        if (ie.getSource() == this.cpdsComboBox) {
            if (this.cpdsComboBox.getSelectedIndex() == -1) {
                this.cpdsComboBox.setSelectedItem(this.cpdsCBoxLastSel);
            } else {
                this.cpdsCBoxLastSel = this.cpdsComboBox.getSelectedItem();
                this.updateCPDSPanel();
            }
        }
    }

    private void expAction() {
        if (this.expCheckBox.isSelected()) {
            this.connLifeField.setEnabled(true);
            this.runThreadField.setEnabled(true);
        } else {
            this.connLifeField.setEnabled(false);
            this.runThreadField.setEnabled(false);
        }
    }

    private void removePoolAction() {
        JDBCDescriptor reference = null;
        if (!this.dsList.isSelectionEmpty()) {
            reference = ((ListValues)this.dsList.getSelectedValue()).getJdbcDescr();
            this.jdbcVector.removeElement(reference);
            this.initList(this.jdbcVector);
        }
    }

    private void clearPoolAction() {
        this.clear();
    }

    private void addPoolAction() {
        JDBCDescriptor newJDBCDescr = this.getJDBCDescriptorFromGui();
        ListModel model = this.dsList.getModel();
        Vector currentValues = new Vector();
        this.jdbcVector = new Vector();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            this.jdbcVector.add(((ListValues)currentValues.elementAt(i)).getJdbcDescr());
            ++i;
        }
        boolean toAdd = true;
        int i2 = 0;
        i2 = 0;
        while (i2 < currentValues.size()) {
            if (newJDBCDescr.getDataSourceName().equals(((ListValues)currentValues.elementAt(i2)).getJdbcDescr().getDataSourceName())) {
                toAdd = false;
                break;
            }
            ++i2;
        }
        if (toAdd) {
            this.jdbcVector.addElement(newJDBCDescr);
            this.initList(this.jdbcVector);
        } else if (!this.dsList.isSelectionEmpty()) {
            JDBCDescriptor tempJDBC = this.getJDBCDescriptorFromGui();
            this.jdbcVector.setElementAt(tempJDBC, i2);
            ((ListValues)this.dsList.getSelectedValue()).setJdbcDescr(tempJDBC);
        }
        this.clear();
    }

    private void initList(Vector jdbc_descr) {
        Vector<ListValues> newJdbc = new Vector<ListValues>();
        if (jdbc_descr != null) {
            int i = 0;
            while (i < jdbc_descr.size()) {
                newJdbc.add(new ListValues((JDBCDescriptor)jdbc_descr.elementAt(i), 20));
                ++i;
            }
        }
        this.dsList.setListData(newJdbc);
    }

    private int getIsoCmd(int value) {
        if (PropsEditorPanel.ISO_CMD != null) {
            int i = 0;
            while (i < PropsEditorPanel.ISO_CMD.length) {
                if (value == PropsEditorPanel.ISO_CMD[i]) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private void initFields(JDBCDescriptor jdbc) {
        if (jdbc == null) {
            return;
        }
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameField.setText(jdbc.getDataSourceName());
            this.setText = false;
        }
        this.aliasesPanel.initList(jdbc.getAliases());
        this.driverTextField.setText(jdbc.getDriverName());
        this.initConnField.setValue(jdbc.getInitConnections());
        this.maxConnField.setValue(jdbc.getMaxConnections());
        this.isolation.setSelectedIndex(this.getIsoCmd(jdbc.getIsolationLevel()));
        this.ttwConnField.setValue(jdbc.getMaxTimeToWaitConn());
        if (jdbc.getConnLifetime() != 0 || jdbc.getRunCleanupThread() != 0) {
            this.expCheckBox.setSelected(true);
            this.connLifeField.setValue(jdbc.getConnLifetime());
            this.runThreadField.setValue(jdbc.getRunCleanupThread());
        } else {
            this.expCheckBox.setSelected(false);
            this.connLifeField.setValue(0);
            this.runThreadField.setValue(0);
        }
        if (PropsEditorPanel.OPEN_SQL_CMD.equals(jdbc.getSQLEngine())) {
            this.openSQLButton.setSelected(true);
            this.nativeSQLButton.setSelected(false);
            this.vendorSQLButton.setSelected(false);
        } else if (PropsEditorPanel.NATIVE_SQL_CMD.equals(jdbc.getSQLEngine())) {
            this.openSQLButton.setSelected(false);
            this.nativeSQLButton.setSelected(true);
            this.vendorSQLButton.setSelected(false);
        } else {
            this.openSQLButton.setSelected(false);
            this.nativeSQLButton.setSelected(false);
            this.vendorSQLButton.setSelected(true);
        }
        if (!jdbc.isNewDriver()) {
            this.jdbcVerComboBox.setSelectedIndex(0);
            this.userField.setText(jdbc.getUsername());
            ((JTextComponent)this.passField).setText(jdbc.getPassword());
            this.urlField.setText(jdbc.getURL());
            this.driverField.setText(jdbc.getDriverClassName());
            this.propertyEditor.initProperties(jdbc.getProps1x());
        } else {
            this.jdbcVerComboBox.setSelectedIndex(1);
            this.factoryField.setText(jdbc.getObjectFactory());
            this.cpdsNameField.setText(jdbc.getCPDSClassName());
            this.xadsNameField.setText(jdbc.getXADSClassName());
            if (jdbc.isXADS()) {
                this.cpdsComboBox.setSelectedItem(PropsEditorPanel.XADataSource);
            } else {
                this.cpdsComboBox.setSelectedItem(PropsEditorPanel.ConnectionPoolDataSource);
            }
            this.propertyEditor.initProperties(jdbc.getProps20());
        }
    }

    private JDBCDescriptor getJDBCDescriptorFromGui() {
        JDBCDescriptor descr = new JDBCDescriptor();
        descr.setDataSourceName(this.nameField.getText());
        String[] aliases = this.aliasesPanel.getListDataArray();
        descr.setAliases(aliases == null ? new String[]{} : aliases);
        descr.setDriverName(this.driverTextField.getText());
        descr.setInitConnections(this.initConnField.getValue());
        descr.setMaxConnections(this.maxConnField.getValue());
        descr.setIsolationLevel(PropsEditorPanel.ISO_CMD[this.isolation.getSelectedIndex()]);
        descr.setMaxTimeToWaitConn(this.ttwConnField.getValue());
        if (this.expCheckBox.isSelected()) {
            descr.setConnLifetime(this.connLifeField.getValue());
            descr.setRunCleanupThread(this.runThreadField.getValue());
        }
        if (this.openSQLButton.isSelected()) {
            descr.setSQLEngine(PropsEditorPanel.OPEN_SQL_CMD);
        } else if (this.nativeSQLButton.isSelected()) {
            descr.setSQLEngine(PropsEditorPanel.NATIVE_SQL_CMD);
        } else {
            descr.setSQLEngine(PropsEditorPanel.VENDOR_SQL_CMD);
        }
        int jdbcIndex = this.jdbcVerComboBox.getSelectedIndex();
        if (jdbcIndex == 0) {
            descr.setNewDriver(false);
            descr.setUsername(this.userField.getText());
            descr.setPassword(new String(this.passField.getPassword()));
            descr.setURL(this.urlField.getText());
            descr.setDriverClassName(this.driverField.getText());
            descr.setProps1x(this.propertyEditor.getProps());
        }
        if (jdbcIndex == 1) {
            descr.setNewDriver(true);
            descr.setObjectFactory(this.factoryField.getText());
            descr.setCPDSClassName(this.cpdsNameField.getText());
            descr.setXADSClassName(this.xadsNameField.getText());
            descr.setXADS(this.cpdsComboBox.getSelectedItem() != null ? this.cpdsComboBox.getSelectedItem().equals(PropsEditorPanel.XADataSource) : true);
            descr.setProps20(this.propertyEditor.getProps());
        }
        return descr;
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    private void checkDisabled() {
        String refName = this.nameField.getText().trim();
        if (refName.equals("")) {
            this.clear();
            return;
        }
        this.selectWithMouse = false;
        Vector currentValues = new Vector();
        ListModel model = this.dsList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (refName.equals(((ListValues)currentValues.elementAt(i2)).getJdbcDescr().getDataSourceName())) {
                toAdd = false;
                this.selectElementByName(i2, currentValues);
                break;
            }
            ++i2;
        }
        if (toAdd && !this.dsList.isSelectionEmpty()) {
            this.dsList.clearSelection();
        }
        this.setButtonsEnabled(toAdd);
        this.selectWithMouse = true;
    }

    private void selectElementByName(int i, Vector currentValues) {
        this.dsList.setSelectedValue(currentValues.elementAt(i), true);
    }

    private void setButtonsEnabled(boolean toAdd) {
        if (this.nameField.getText().trim().length() != 0) {
            if (toAdd) {
                this.addPoolBtn.setEnabled(true);
                this.changePoolBtn.setEnabled(false);
                this.clearPoolBtn.setEnabled(true);
                this.removePoolBtn.setEnabled(false);
            } else {
                this.addPoolBtn.setEnabled(false);
                this.changePoolBtn.setEnabled(true);
                this.clearPoolBtn.setEnabled(true);
                this.removePoolBtn.setEnabled(true);
            }
        } else {
            this.addPoolBtn.setEnabled(false);
            this.changePoolBtn.setEnabled(false);
            this.clearPoolBtn.setEnabled(false);
            this.removePoolBtn.setEnabled(false);
        }
    }

    private void updateJDBCPanels() {
        int index = this.jdbcVerComboBox.getSelectedIndex();
        if (index == 0) {
            this.addJDBCPanel1x();
        } else if (index == 1) {
            this.addJDBCPanel20();
        }
    }

    private void updateCPDSPanel() {
        int index = this.cpdsComboBox.getSelectedIndex();
        if (index == 0) {
            this.addCPDSPanel();
        } else if (index == 1) {
            this.addXADSPanel();
        } else {
            this.addXADSPanel();
        }
    }

    public void valueChanged(ListSelectionEvent tse) {
        this.changePoolBtn.setEnabled(true);
        this.clearPoolBtn.setEnabled(true);
        this.removePoolBtn.setEnabled(true);
        if (!this.selectWithMouse) {
            if (this.dsList.getSelectedValue() != null) {
                this.lastJDBCDescr = ((ListValues)this.dsList.getSelectedValue()).getJdbcDescr();
                this.initFields(this.lastJDBCDescr);
            } else {
                this.clear();
            }
            return;
        }
        if (!this.dsList.isSelectionEmpty()) {
            JDBCDescriptor tempJDBC = new JDBCDescriptor();
            if (this.lastJDBCDescr == null) {
                this.lastJDBCDescr = ((ListValues)this.dsList.getSelectedValue()).getJdbcDescr();
                this.initFields(this.lastJDBCDescr);
            } else if (this.lastJDBCDescr != null && this.lastJDBCDescr.getDataSourceName().equals(this.nameField.getText()) && !this.lastJDBCDescr.equals(tempJDBC = this.getJDBCDescriptorFromGui())) {
                Object[] options = new Object[]{GuiSettings.getResourceString("YesOption", "Yes"), GuiSettings.getResourceString("NoOption", "No")};
                int result = JOptionPane.showOptionDialog(this.mainFrame, GuiSettings.getResourceString("AppDataSourceChangesMsg", "The JDBC descriptor") + " " + this.lastJDBCDescr.getDataSourceName() + " " + GuiSettings.getResourceString("CommitChangesMsg", "has changed. Do you want to commit these changes?"), "Warning", -1, 2, null, options, options[0]);
                if (result == 0) {
                    this.lastJDBCDescr = this.getJDBCDescriptorFromGui();
                    JDBCDescriptor temp = null;
                    int i = 0;
                    while (i < this.jdbcVector.size()) {
                        temp = (JDBCDescriptor)this.jdbcVector.elementAt(i);
                        if (temp.getDataSourceName().equals(this.lastJDBCDescr.getDataSourceName())) {
                            ((ListValues)this.dsList.getModel().getElementAt(i)).setType(20);
                            this.jdbcVector.setElementAt(this.lastJDBCDescr, i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.lastJDBCDescr = ((ListValues)this.dsList.getSelectedValue()).getJdbcDescr();
            this.initFields(this.lastJDBCDescr);
        } else {
            this.clear();
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameField.setText("");
            this.setText = false;
        }
        this.aliasesPanel.initList(new String[0]);
        this.driverTextField.setText(null);
        this.initConnField.setValue(0);
        this.maxConnField.setValue(25);
        this.isolation.setSelectedIndex(0);
        this.ttwConnField.setValue(60);
        this.expCheckBox.setSelected(false);
        this.connLifeField.setValue(0);
        this.connLifeField.setEnabled(false);
        this.runThreadField.setValue(0);
        this.runThreadField.setEnabled(false);
        this.openSQLButton.setSelected(true);
        this.nativeSQLButton.setSelected(false);
        this.vendorSQLButton.setSelected(false);
        this.jdbcVerComboBox.setSelectedIndex(0);
        this.userField.setText(null);
        ((JTextComponent)this.passField).setText(null);
        this.urlField.setText(null);
        this.driverField.setText(null);
        this.propertyEditor.initProperties(null);
        this.factoryField.setText(null);
        this.cpdsNameField.setText(null);
        this.xadsNameField.setText(null);
        this.cpdsComboBox.setSelectedIndex(0);
        this.propertyEditor.initProperties(null);
        this.dsList.clearSelection();
        this.addPoolBtn.setEnabled(false);
        this.changePoolBtn.setEnabled(false);
        this.clearPoolBtn.setEnabled(false);
        this.removePoolBtn.setEnabled(false);
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        if (this.jdbcVector.size() > 0) {
            this.descr = new JDBCDescriptor[this.jdbcVector.size()];
            this.jdbcVector.copyInto(this.descr);
        } else {
            this.descr = null;
        }
        if (this.earDescr != null) {
            this.earDescr.setJdbcDescr(this.descr);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setDescriptor(EARDescriptor earDescr) {
        this.earDescr = earDescr;
        this.clear();
        this.lastJDBCDescr = null;
        this.jdbcVector = new Vector();
        this.descr = earDescr != null ? earDescr.getJdbcDescr() : null;
        if (this.descr != null) {
            int i = 0;
            while (i < this.descr.length) {
                this.jdbcVector.add(this.descr[i]);
                ++i;
            }
        }
        this.initList(this.jdbcVector);
    }
}

