/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.deploy.gui.ear.AppReferencePanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class AppReferencePanelLogical
extends AppReferencePanel
implements Runnable {
    private int lastSelected = -1;
    private SimpleEarDescriptor descriptor = null;
    int constant;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private ApplicationInformationProvider appProvider;

    public AppReferencePanelLogical() {
    }

    public AppReferencePanelLogical(Frame mainFrame, int constant) {
        this.mainFrame = mainFrame;
        this.constant = constant;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("REMOVE_CMD")) {
            this.deleteBtnActionPerformed();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearBtnActionPerformed();
        } else if (cmd.equals("ADD_CMD")) {
            this.setBtnActionPerformed();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyBTNActionPerformed();
        }
        this.clearAll();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.checkEnable();
        this.modifyButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        ReferenceObject oldReference = null;
        if (this.lastSelected >= 0 && this.lastSelected < this.referenceModel.size()) {
            oldReference = ((ListValues)this.referenceModel.elementAt(this.lastSelected)).getReferenceObject();
        }
        ReferenceObject newReference = this.getRefrenceFromFields();
        if (oldReference != null && newReference != null && newReference.getReferenceTarget() != null && !newReference.getReferenceTarget().trim().equals("") && oldReference.getReferenceTarget().equals(newReference.getReferenceTarget()) && !oldReference.equals(newReference)) {
            Object[] options = new Object[]{"Yes", "No"};
            int result = JOptionPane.showOptionDialog(this.mainFrame, "The reference " + oldReference.getReferenceTarget() + " " + "has been changed. Do you want to commit these changes?", "Warning", -1, 2, null, options, options[0]);
            if (result == 0) {
                ((ListValues)this.referenceModel.elementAt(this.lastSelected)).setReferenceObject(newReference);
            }
        }
        if (!this.referenceList.isSelectionEmpty()) {
            this.initFields(((ListValues)this.referenceList.getSelectedValue()).getReferenceObject());
        } else {
            this.clear();
        }
        this.lastSelected = this.referenceList.getSelectedIndex();
    }

    public void deleteBtnActionPerformed() {
        if (!this.referenceList.isSelectionEmpty()) {
            this.lastSelected = -1;
            this.referenceModel.removeElement(this.referenceList.getSelectedValue());
        }
    }

    public void clearBtnActionPerformed() {
        this.clearAll();
    }

    public void modifyBTNActionPerformed() {
        ReferenceObject panelDescr = this.getRefrenceFromFields();
        if (!this.referenceList.isSelectionEmpty() && !((ListValues)this.referenceList.getSelectedValue()).getReferenceObject().equals(panelDescr)) {
            ((ListValues)this.referenceList.getSelectedValue()).setReferenceObject(panelDescr);
        }
    }

    private boolean containsInModel(String logName) {
        int i = 0;
        while (i < this.referenceModel.size()) {
            if (((ListValues)this.referenceModel.getElementAt(i)).getReferenceObject().getReferenceTarget().equalsIgnoreCase(logName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setBtnActionPerformed() {
        if (!this.containsInModel(this.targetTextField.getText())) {
            this.referenceModel.addElement(this.getListValue(this.getRefrenceFromFields()));
        }
    }

    private ReferenceObject getRefrenceFromFields() {
        ReferenceObject refObj = new ReferenceObject();
        if (this.targetTextField.getText() != null && !this.targetTextField.getText().trim().equals("")) {
            refObj.setReferenceTarget(this.targetTextField.getText().trim());
        } else {
            refObj.setReferenceTarget(null);
        }
        if (this.targetProviderName.getText() != null && !this.targetProviderName.getText().trim().equals("")) {
            refObj.setReferenceProviderName(this.targetProviderName.getText());
        } else {
            refObj.setReferenceProviderName(null);
        }
        refObj.setReferenceTargetType((String)this.targetTypeComboBox.getSelectedItem());
        refObj.setReferenceType((String)this.typeComboBox.getSelectedItem());
        return refObj;
    }

    private void initFields(ReferenceObject refObject) {
        if (this.selectWithMouse) {
            this.setText = true;
            this.setSelectedInTargetComboBox(refObject.getReferenceTarget());
            this.setText = false;
        }
        this.targetTypeComboBox.setSelectedItem(refObject.getReferenceTargetType());
        this.typeComboBox.setSelectedItem(refObject.getReferenceType());
        this.targetProviderName.setText(refObject.getReferenceProviderName());
    }

    public void commitChange() {
        if (this.descriptor != null) {
            this.descriptor.setReferences(this.getReferenceObjects());
        }
    }

    private ReferenceObject[] getReferenceObjects() {
        ReferenceObject[] refObjectArray = null;
        if (this.referenceModel.size() > 0) {
            refObjectArray = new ReferenceObject[this.referenceModel.size()];
            int i = 0;
            while (i < this.referenceModel.size()) {
                refObjectArray[i] = ((ListValues)this.referenceModel.elementAt(i)).getReferenceObject();
                ++i;
            }
        } else {
            refObjectArray = null;
        }
        return refObjectArray;
    }

    private void checkEnable() {
        this.targetTextField.setEnabled(true);
        if (this.targetTextField.getText() != null && this.targetTextField.getText().trim().length() != 0) {
            this.targetProviderName.setEnabled(true);
            this.targetTypeComboBox.setEnabled(true);
            this.typeComboBox.setEnabled(true);
        } else {
            this.targetProviderName.setEnabled(false);
            this.targetTypeComboBox.setEnabled(false);
            this.typeComboBox.setEnabled(false);
        }
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
    }

    public int isCorrect() {
        return 0;
    }

    public void setDescriptor(SimpleEarDescriptor descr) {
        Vector compRefs;
        int i;
        ReferenceObjectIntf[] refObjectArray;
        this.clearAll();
        this.referenceModel.removeAllElements();
        this.descriptor = descr;
        ReferenceObjectIntf[] referenceObjectIntfArray = refObjectArray = descr == null ? null : descr.getReferences();
        if (refObjectArray != null) {
            ReferenceObject temp = null;
            i = 0;
            while (i < refObjectArray.length) {
                temp = new ReferenceObject();
                temp.setReferenceProviderName(refObjectArray[i].getReferenceProviderName());
                temp.setReferenceTarget(refObjectArray[i].getReferenceTarget());
                temp.setReferenceTargetType(refObjectArray[i].getReferenceTargetType());
                temp.setReferenceType(refObjectArray[i].getReferenceType());
                this.referenceModel.addElement(this.getListValue(temp));
                ++i;
            }
        }
        if (this.appProvider != null && (compRefs = this.appProvider.getAllReferenceObjects(this.mainFrame)) != null) {
            i = 0;
            while (i < compRefs.size()) {
                if (!this.isExists(this.getReferenceObjects(), (ReferenceObject)compRefs.elementAt(i))) {
                    this.referenceModel.addElement(this.getListValue((ReferenceObject)compRefs.elementAt(i)));
                }
                ++i;
            }
        }
        this.setPosibleTargetItems(null);
    }

    private ListValues getListValue(ReferenceObject ref) {
        return new ListValues(ref, 18);
    }

    private boolean isExists(ReferenceObject[] refObjects, ReferenceObject obj) {
        if (obj == null) {
            return true;
        }
        if (refObjects != null) {
            ReferenceObject existing = null;
            int i = 0;
            while (i < refObjects.length) {
                existing = refObjects[i];
                if (existing != null && existing.getReferenceTarget() != null && existing.getReferenceTarget().equals(obj.getReferenceTarget()) && existing.getReferenceTargetType() != null && existing.getReferenceTargetType().equals(obj.getReferenceTargetType())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void clearAll() {
        if (this.selectWithMouse) {
            this.setText = true;
            this.targetTextField.setText("");
            this.targetProviderName.setText("");
            this.setText = false;
        }
        this.targetTypeComboBox.setSelectedIndex(0);
        this.typeComboBox.setSelectedIndex(0);
        this.referenceList.clearSelection();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.checkEnable();
    }

    private void checkDisabled() {
        String target = this.targetTextField.getText();
        this.checkEnable();
        this.selectWithMouse = false;
        boolean toAdd = true;
        if (!this.referenceList.isSelectionEmpty() && !((ListValues)this.referenceList.getSelectedValue()).getReferenceObject().getReferenceTarget().equals(target)) {
            this.referenceList.clearSelection();
        }
        int i = 0;
        while (i < this.referenceModel.size()) {
            if (target.equals(((ListValues)this.referenceModel.elementAt(i)).getReferenceObject().getReferenceTarget())) {
                toAdd = false;
                if (!this.referenceList.isSelectionEmpty()) break;
                this.referenceList.setSelectedValue(this.referenceModel.elementAt(i), true);
                break;
            }
            ++i;
        }
        if (target.trim().length() != 0) {
            if (toAdd) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.selectWithMouse = true;
    }

    public void changedUpdate(DocumentEvent event) {
        SwingUtilities.invokeLater(this);
    }

    public void insertUpdate(DocumentEvent event) {
        SwingUtilities.invokeLater(this);
    }

    public void removeUpdate(DocumentEvent event) {
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void clear() {
        this.clearAll();
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    private void setSelectedInTargetComboBox(String target) {
        if (target == null) {
            return;
        }
        this.targetTextField.setText(target);
    }

    public void setPosibleTargetItems(String[] arr) {
        this.targetTextField.setText("");
        if (arr != null && arr.length != 0) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != null && !arr[i].trim().equals("")) {
                    this.setSelectedInTargetComboBox(arr[i]);
                }
                ++i;
            }
        }
        if (this.referenceModel.size() != 0) {
            ReferenceObject obj = null;
            int i = 0;
            while (i < this.referenceModel.size()) {
                obj = ((ListValues)this.referenceModel.elementAt(i)).getReferenceObject();
                if (obj != null) {
                    this.setSelectedInTargetComboBox(obj.getReferenceTarget());
                }
                ++i;
            }
        }
        this.clear();
    }

    public static void main(String[] a) {
        AppReferencePanelLogical appReferences = new AppReferencePanelLogical();
        JDialog d = new JDialog();
        d.getContentPane().add(appReferences);
        d.pack();
        d.show();
    }
}

