/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common.additional;

import com.sap.engine.services.deploy.gui.common.ImageHolder;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.deploy.gui.common.additional.SecurityUserObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class SecurityTreeRenderer
extends JLabel
implements TreeCellRenderer {
    public Icon rootIcon;
    private Icon beanIcon;
    private Icon methodRed;
    private Icon methodBlue;
    private Icon beanClass;
    private Icon onMessage;
    private Icon interfaceRed;
    private Icon interfaceBlue;
    private Icon secRoleIcon;
    private Icon secRoleGroup;
    private Icon secRoleReference;
    private Icon userIcon;
    private Icon groupIcon;
    private Icon beanRunAsIcon;
    private Icon webRunAsIcon;
    private Icon applicationIcon;
    private Icon ejbIcon;
    private Icon webIcon;

    public SecurityTreeRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public SecurityTreeRenderer(Icon rootIcon) {
        this.rootIcon = rootIcon;
        this.setOpaque(true);
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof SecurityUserObject) {
            this.setText(userObject.toString());
            this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
            this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
            SecurityUserObject viewInfe = (SecurityUserObject)userObject;
            switch (viewInfe.getType()) {
                case 0: {
                    if (this.rootIcon != null) {
                        this.setIcon(this.rootIcon);
                        break;
                    }
                    this.setIcon(this.groupIcon);
                    break;
                }
                case 15: {
                    this.setIcon(this.beanClass);
                    break;
                }
                case 3: {
                    this.setIcon(this.interfaceRed);
                    break;
                }
                case 4: {
                    this.setIcon(this.interfaceBlue);
                    break;
                }
                case 5: {
                    this.setIcon(this.secRoleIcon);
                    break;
                }
                case 6: {
                    this.setIcon(this.secRoleGroup);
                    break;
                }
                case 11: {
                    this.setIcon(this.secRoleReference);
                    break;
                }
                case 2: {
                    this.setIcon(this.methodBlue);
                    if (((SecurityTreeNode)value).isExcludedNode()) {
                        this.setForeground(Color.lightGray);
                        break;
                    }
                    if (((SecurityTreeNode)value).getAccessControls() == null || !((SecurityTreeNode)value).getAccessControls().getUnchecked()) break;
                    this.setForeground(new Color(30, 180, 110));
                    break;
                }
                case 1: {
                    this.setIcon(this.methodRed);
                    if (((SecurityTreeNode)value).isExcludedNode()) {
                        this.setForeground(Color.lightGray);
                        break;
                    }
                    if (((SecurityTreeNode)value).getAccessControls() == null || !((SecurityTreeNode)value).getAccessControls().getUnchecked()) break;
                    this.setForeground(new Color(30, 180, 110));
                    break;
                }
                case 16: {
                    this.setIcon(this.onMessage);
                    break;
                }
                case 9: {
                    this.setIcon(this.userIcon);
                    break;
                }
                case 10: {
                    this.setIcon(this.groupIcon);
                    break;
                }
                case 12: {
                    this.setIcon(this.beanIcon);
                    break;
                }
                case 13: {
                    this.setIcon(this.beanRunAsIcon);
                    break;
                }
                case 14: {
                    this.setIcon(this.webRunAsIcon);
                    break;
                }
                case 17: {
                    this.setIcon(this.applicationIcon);
                    break;
                }
                case 18: {
                    this.setIcon(this.ejbIcon);
                    break;
                }
                case 19: {
                    this.setIcon(this.webIcon);
                    break;
                }
                default: {
                    this.setIcon(this.methodRed);
                }
            }
        }
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }

    private void initImages() {
        this.beanIcon = ImageHolder.anEJBeanIcon;
        this.methodRed = ImageHolder.aMethodRed;
        this.methodBlue = ImageHolder.aMethodBlue;
        this.interfaceRed = ImageHolder.anInterfaceRed;
        this.interfaceBlue = ImageHolder.anInterfaceBlue;
        this.secRoleIcon = ImageHolder.aSecRoleIcon;
        this.secRoleGroup = ImageHolder.aSecRoleGroup;
        this.secRoleReference = ImageHolder.aSecRoleReference;
        this.userIcon = ImageHolder.aUserIcon;
        this.groupIcon = ImageHolder.aUserGroup;
        this.beanRunAsIcon = ImageHolder.aBeanRunAsIcon;
        this.webRunAsIcon = ImageHolder.aWebRunAsIcon;
        this.beanClass = ImageHolder.aBeanClassIcon;
        this.onMessage = ImageHolder.onMessageIcon;
        this.applicationIcon = ImageHolder.applicationIcon;
        this.ejbIcon = ImageHolder.ejbIcon;
        this.webIcon = ImageHolder.webIcon;
    }
}

