/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.ResourceEnvReferencePanel;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class ResourceEnvReferencePanelLogical
extends ResourceEnvReferencePanel {
    private ResourceEnvReference[] reference = null;
    private int constant;
    private boolean flag;
    private ApplicationInformationProvider appProvider;

    public ResourceEnvReferencePanelLogical(Frame mainFrame, int constant) {
        super(constant);
        this.constant = constant;
        this.clearAll();
        this.mainFrame = mainFrame;
        this.flag = false;
    }

    private void disableFields() {
        if (this.constant == 0) {
            this.nameTextField.setEnabled(true);
            this.typeTextField.setEnabled(true);
            this.jndiTextField.setEnabled(true);
            this.descrPanel.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
        } else if (this.constant == 3) {
            this.nameTextField.setEnabled(false);
            this.typeTextField.setEnabled(false);
            this.jndiTextField.setEnabled(true);
            this.descrPanel.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else if (this.constant == 1 || this.constant == 4 || this.constant == 5 || this.constant == 6) {
            this.nameTextField.setEnabled(true);
            this.typeTextField.setEnabled(true);
            this.jndiTextField.setEnabled(true);
            this.descrPanel.setEnabled(true);
            this.clearButton.setEnabled(true);
        } else if (this.constant == 2) {
            this.nameTextField.setEnabled(false);
            this.typeTextField.setEnabled(false);
            this.jndiTextField.setEnabled(false);
            this.descrPanel.setEnabled(true);
            this.clearButton.setEnabled(true);
        }
        this.removeButton.setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.inCheckDisabled) {
            this.checPanel();
        }
        if (!this.resourceList.isSelectionEmpty()) {
            if (this.constant == 3 || this.constant == 2) {
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
            this.addButton.setEnabled(false);
            if (this.constant == 3) {
                this.typeTextField.setEnabled(false);
            } else {
                this.typeTextField.setEnabled(true);
            }
            this.jndiTextField.setEnabled(true);
            this.descrPanel.setEnabled(true);
            this.show((ListValues)this.resourceList.getSelectedValue());
        } else {
            this.clearAll();
        }
    }

    private void show(ListValues listValue) {
        if (!this.inCheckDisabled || !this.nameTextField.getText().trim().equals(listValue.getResourceEnvReference().getName())) {
            this.setNameText = true;
            this.nameTextField.setText(listValue.getResourceEnvReference().getName());
            this.setNameText = false;
        }
        this.typeTextField.setText(listValue.getResourceEnvReference().getType().trim());
        String jndiName = listValue.getResourceEnvReference().getJndiName();
        if (jndiName == null) {
            this.jndiTextField.setText("");
        } else {
            this.jndiTextField.setText(jndiName.trim());
        }
        String description = listValue.getResourceEnvReference().getDescription();
        if (description == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(description.trim());
        }
    }

    private ResourceEnvReference getValueAt(int index) {
        Vector currentValues = new Vector();
        ResourceEnvReference value = null;
        int size = this.model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(this.model.getElementAt(i));
            ++i;
        }
        if (currentValues.size() != 0 && index > -1 && index < currentValues.size()) {
            value = ((ListValues)currentValues.elementAt(index)).getResourceEnvReference();
        }
        return value;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addActionPerformed();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyActionPerformed();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeActionPerformed();
        } else {
            this.clearActionPerformed();
        }
    }

    private void initList(Vector resEnvReference1) {
        if (resEnvReference1 != null && resEnvReference1.size() != 0) {
            int i = 0;
            while (i < resEnvReference1.size()) {
                this.model.addElement(new ListValues((ResourceEnvReference)resEnvReference1.elementAt(i), 15));
                ++i;
            }
        }
    }

    private void initList(ResourceEnvReference[] resEnvReference1) {
    }

    private void modifyActionPerformed() {
        ListValues value = this.findResEnvRef(this.nameTextField.getText().trim());
        if (!this.typeTextField.getText().trim().equals("")) {
            ResourceEnvReference ref = value.getResourceEnvReference();
            this.modifyActionPerformed(ref, this.typeTextField.getText().trim(), this.jndiTextField.getText().trim(), this.descrPanel.getText().trim());
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, "The Resource Environment Reference type is missing.", "Error", 0);
        }
    }

    private void modifyActionPerformed(ResourceEnvReference ref, String type, String jndi, String descr) {
        ref.setType(type);
        if (!descr.equals("")) {
            ref.setDescription(descr);
        } else {
            ref.setDescription(null);
        }
        if (!jndi.equals("")) {
            ref.setJndiName(jndi);
        } else {
            ref.setJndiName(null);
        }
        this.modifyAction = true;
        this.clearActionPerformed();
        this.modifyAction = false;
    }

    private void addActionPerformed() {
        if (this.typeTextField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this.mainFrame, "The Resource Environment Reference type is missing.", "Error", 0);
        } else {
            ResourceEnvReference ref = new ResourceEnvReference();
            ref.setName(this.nameTextField.getText().trim());
            ref.setType(this.typeTextField.getText().trim());
            ref.setJndiName(this.jndiTextField.getText().trim().equals("") ? null : this.jndiTextField.getText().trim());
            ref.setDescription(this.descrPanel.getText().equals("") ? null : this.descrPanel.getText());
            this.model.addElement(new ListValues(ref, 15));
            this.clearActionPerformed();
        }
    }

    public void removeActionPerformed() {
        ListValues value = this.findResEnvRef(this.nameTextField.getText().trim());
        this.clearActionPerformed();
        this.model.removeElement(value);
    }

    public void clearActionPerformed() {
        if (!this.resourceList.isSelectionEmpty()) {
            this.resourceList.clearSelection();
        }
        this.clearAll();
    }

    private ListValues findResEnvRef(String name) {
        int size = this.model.size();
        int i = 0;
        while (i < size) {
            if (name.equals(((ListValues)this.model.get(i)).getName().trim())) {
                return (ListValues)this.model.get(i);
            }
            ++i;
        }
        return null;
    }

    private void checPanel() {
        String name = this.nameTextField.getText().trim();
        String type = this.typeTextField.getText().trim();
        if (!name.equals("") && !type.equals("")) {
            String description = this.descrPanel.getText().trim();
            String jndi = this.jndiTextField.getText().trim();
            ListValues ref = this.findResEnvRef(name);
            int answer = 1;
            if (ref != null) {
                ResourceEnvReference resEnvRef = ref.getResourceEnvReference();
                if (!(description.equals(resEnvRef.getDescription() == null ? "" : resEnvRef.getDescription()) && type.equals(resEnvRef.getType() == null ? "" : resEnvRef.getType()) && jndi.equals(resEnvRef.getJndiName() == null ? "" : resEnvRef.getJndiName()))) {
                    answer = JOptionPane.showConfirmDialog(this.mainFrame, "The ResourceEnvReference <" + name + "> has changed description.\n Would you like to modify it?", "Warning", 0, 2);
                    if (answer == 0) {
                        this.modifyActionPerformed(ref.getResourceEnvReference(), type, jndi, description);
                    } else {
                        this.clearAll();
                    }
                }
            } else {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "There is new ResourceEnvReference <" + name + "> described.\n Would you like to add it?", "Warning", 0, 2);
                if (answer == 0) {
                    this.addActionPerformed();
                } else {
                    this.clearAll();
                }
            }
        }
    }

    private void checkDisabled() {
        String refName;
        this.inCheckDisabled = true;
        if (!this.resourceList.isSelectionEmpty()) {
            this.resourceList.clearSelection();
        }
        if ((refName = this.nameTextField.getText().trim()).equals("")) {
            this.clearAll();
            return;
        }
        ListValues value = this.findResEnvRef(refName);
        this.init(this.constant);
        this.clearButton.setEnabled(true);
        if (this.constant == 1 || this.constant == 4 || this.constant == 5 || this.constant == 6) {
            if (value == null) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.descrPanel.setEnabled(true);
            } else {
                this.resourceList.setSelectedValue(value, true);
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                if (this.constant != 3 && this.constant != 2) {
                    this.removeButton.setEnabled(true);
                }
            }
        } else {
            this.disableFields();
        }
        this.inCheckDisabled = false;
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setNameText) {
            this.checkDisabled();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setNameText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setNameText) {
            this.checkDisabled();
        }
    }

    public void setDescriptor(ResourceEnvReference[] rReference) {
        this.clear();
        this.flag = false;
        this.disableFields();
        this.clearAll();
        this.reference = rReference;
        int size = -1;
        if (this.reference != null && (size = this.reference.length) != 0) {
            int i = 0;
            while (i < size) {
                this.model.addElement(new ListValues(this.reference[i], 15));
                ++i;
            }
        }
    }

    public void commitChange() {
        this.reference = new ResourceEnvReference[this.model.getSize()];
        Enumeration enumeration = this.model.elements();
        if (enumeration != null) {
            int size = 0;
            while (enumeration.hasMoreElements()) {
                this.reference[size] = ((ListValues)enumeration.nextElement()).getResourceEnvReference();
                ++size;
            }
        } else {
            this.reference = null;
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
        if (this.constant == 0 || this.constant == 1 || this.constant == 4 || this.constant == 5 || this.constant == 6) {
            this.nameTextField.setEnabled(true);
            this.typeTextField.setEnabled(true);
            this.jndiTextField.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else if (this.constant == 3 || this.constant == 2) {
            this.nameTextField.setEnabled(false);
            this.typeTextField.setEnabled(false);
            this.jndiTextField.setEnabled(false);
            this.addButton.setEnabled(false);
            this.descrPanel.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(false);
        }
    }

    public void clear() {
        this.clearAll();
        this.model.removeAllElements();
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
        this.descrPanel.updateLook_Feel();
    }

    public void setLoader(ClassLoader loader) {
    }

    public ResourceEnvReference[] getEnvReference() {
        return this.reference != null && this.reference.length == 0 ? null : this.reference;
    }

    public void setEnvReference(ResourceEnvReference[] reference) {
        this.reference = reference;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    protected void clearAll() {
        if (!this.inCheckDisabled || this.modifyAction) {
            this.setNameText = true;
            this.nameTextField.setText("");
            this.setNameText = false;
        }
        this.typeTextField.setText("");
        this.jndiTextField.setText("");
        this.descrPanel.setText("");
        if (this.constant == 0 || this.constant == 1 || this.constant == 4 || this.constant == 5 || this.constant == 6) {
            this.nameTextField.setEnabled(true);
        } else if (this.constant == 3 || this.constant == 2) {
            this.nameTextField.setEnabled(false);
        }
        this.typeTextField.setEnabled(false);
        this.jndiTextField.setEnabled(false);
        this.descrPanel.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }
}

