/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.MainTabPanel;
import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.LogViewerDialog;
import com.sap.engine.services.deploy.gui.common.ErrorObject;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ErrorReportLocatorDialog
extends CEscapeDialog
implements ActionListener,
ListSelectionListener {
    private JList errorList = new JList();
    private DefaultListModel listModel = new DefaultListModel();
    private JTextArea message = new JTextArea();
    private JTextArea helpMessage = new JTextArea();
    private ErrorReportObject[] errorObj;
    private LogViewerDialog logDialog;
    private Frame frame;
    private JButton exceptionButton;
    private JButton goToButton;
    private Vector mainTabPanel = new Vector();

    public ErrorReportLocatorDialog(Frame frame, ErrorReportObject[] errorObj) {
        super(frame, "Error Reporting...", false);
        this.errorObj = errorObj;
        this.frame = frame;
        this.init();
        ((Window)((Object)this)).pack();
    }

    public ErrorReportLocatorDialog(Frame frame) {
        this(frame, null);
    }

    void init() {
        this.logDialog = new LogViewerDialog(this.frame, "Exception");
        this.logDialog.setSize(new Dimension(150, 300));
        this.errorList.setModel(this.listModel);
        this.errorList.setPreferredSize(new Dimension(150, 300));
        this.errorList.addListSelectionListener(this);
        JScrollPane errorListScroll = new JScrollPane(this.errorList);
        this.message.setWrapStyleWord(true);
        JScrollPane messageScroll = new JScrollPane(this.message);
        JScrollPane helpMessageScroll = new JScrollPane(this.helpMessage);
        this.helpMessage.setWrapStyleWord(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel closeButtonPanel = new JPanel();
        closeButtonPanel.setLayout(new FlowLayout());
        JPanel goToButtonPanel = new JPanel();
        goToButtonPanel.setLayout(new FlowLayout());
        JPanel errorPanel = new JPanel();
        errorPanel.setLayout(new BorderLayout());
        errorPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Error ID"));
        errorPanel.add((Component)errorListScroll, "Center");
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        messagePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Short Message"));
        messagePanel.add((Component)messageScroll, "Center");
        JPanel helpMessagePanel = new JPanel();
        helpMessagePanel.setLayout(new BorderLayout());
        helpMessagePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Help Message"));
        helpMessagePanel.add((Component)helpMessageScroll, "Center");
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        this.goToButton = new JButton("Go To");
        this.goToButton.setActionCommand("goto");
        this.goToButton.addActionListener(this);
        this.exceptionButton = new JButton("Exception");
        this.exceptionButton.setActionCommand("exception");
        this.exceptionButton.addActionListener(this);
        closeButtonPanel.add((Component)closeButton, null);
        goToButtonPanel.add((Component)this.goToButton, null);
        goToButtonPanel.add((Component)this.exceptionButton, null);
        mainPanel.add((Component)errorPanel, new GridBagConstraints(0, 0, 5, 10, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)messagePanel, new GridBagConstraints(5, 0, 4, 4, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)helpMessagePanel, new GridBagConstraints(5, 4, 4, 4, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)goToButtonPanel, new GridBagConstraints(7, 8, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        ((JDialog)((Object)this)).getContentPane().setLayout(new BorderLayout());
        ((JDialog)((Object)this)).getContentPane().add((Component)mainPanel, "Center");
        ((JDialog)((Object)this)).getContentPane().add((Component)closeButtonPanel, "South");
        this.goToButton.setEnabled(false);
        this.exceptionButton.setEnabled(false);
        this.initList();
        ((Component)((Object)this)).setSize(new Dimension(640, 480));
    }

    private void initList() {
        this.listModel.removeAllElements();
        if (this.errorObj != null) {
            int i = 0;
            while (i < this.errorObj.length) {
                if (this.errorObj[i] != null && this.errorObj[i].getErrors() != null) {
                    int j = 0;
                    while (j < this.errorObj[i].getErrors().length) {
                        this.listModel.addElement(this.errorObj[i].getErrors()[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        ((Component)((Object)this)).setSize(new Dimension(640, 480));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("close")) {
            ((Component)((Object)this)).setVisible(false);
        } else if (e.getActionCommand().equalsIgnoreCase("goto")) {
            this.gotoAction();
        } else if (e.getActionCommand().equalsIgnoreCase("exception")) {
            this.exceptionAction();
        }
    }

    public void valueChanged(ListSelectionEvent ev) {
        if (!this.errorList.isSelectionEmpty()) {
            this.goToButton.setEnabled(true);
            this.clearFields();
            this.message.setText(((ErrorObject)this.errorList.getSelectedValue()).getMessage());
            this.helpMessage.setText(((ErrorObject)this.errorList.getSelectedValue()).getHelpMessage());
            this.exceptionButton.setEnabled(((ErrorObject)this.errorList.getSelectedValue()).getExceptionStacktrace() != null && !((ErrorObject)this.errorList.getSelectedValue()).getExceptionStacktrace().trim().equals(""));
        } else {
            this.goToButton.setEnabled(false);
            this.clearFields();
        }
    }

    public void clearFields() {
        this.message.setText("");
        this.helpMessage.setText("");
    }

    public void clear() {
        this.errorObj = null;
        this.initList();
        this.message.setText("");
        this.helpMessage.setText("");
    }

    private void gotoAction() {
        if (this.mainTabPanel != null && !this.errorList.isSelectionEmpty()) {
            ErrorReportObject tempReport = this.getErrorObjectParent((ErrorObject)this.errorList.getSelectedValue());
            int i = 0;
            while (i < this.mainTabPanel.size()) {
                if (tempReport.getTabPane() == ((MainTabPanel)this.mainTabPanel.elementAt(i)).getMadeFromConstant()) {
                    ((MainTabPanel)this.mainTabPanel.elementAt(i)).selectNode(tempReport, (ErrorObject)this.errorList.getSelectedValue());
                }
                ++i;
            }
        }
    }

    private ErrorReportObject getErrorObjectParent(ErrorObject eObj) {
        if (this.errorObj == null) {
            return null;
        }
        int i = 0;
        while (i < this.errorObj.length) {
            ErrorObject[] errorArray = this.errorObj[i].getErrors();
            if (errorArray != null) {
                int j = 0;
                while (j < errorArray.length) {
                    if (errorArray[j] == eObj) {
                        return this.errorObj[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private void exceptionAction() {
        if (!this.errorList.isSelectionEmpty()) {
            if (((ErrorObject)this.errorList.getSelectedValue()).getExceptionStacktrace() != null && !((ErrorObject)this.errorList.getSelectedValue()).getExceptionStacktrace().trim().equals("")) {
                this.logDialog.show((Dialog)((Object)this), ((ErrorObject)this.errorList.getSelectedValue()).getExceptionStacktrace());
            } else {
                JOptionPane.showMessageDialog(this.frame, "Error", "No stacktrace available", 2);
            }
        }
    }

    public void setValues(ErrorReportObject[] er) {
        this.clear();
        this.errorObj = er;
        this.initList();
    }

    protected void performEnterAction(KeyEvent e) {
        this.gotoAction();
    }

    public ErrorReportObject[] getErrorObjects() {
        return this.errorObj;
    }

    public void setErrorObjects(ErrorReportObject[] errorObj) {
        this.errorObj = errorObj;
        this.initList();
    }

    public void addMainTabPanel(MainTabPanel mainTabPanel1) {
        if (!this.mainTabPanel.contains(mainTabPanel1)) {
            this.mainTabPanel.add(mainTabPanel1);
        }
    }
}

