/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.MadeFromConstants;
import com.sap.engine.services.deploy.gui.MappingPanel;
import com.sap.engine.services.deploy.gui.SFileChooser;
import com.sap.engine.services.deploy.gui.common.AdditionalPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AdditionalPanelLogical
extends AdditionalPanel
implements MadeFromConstants {
    public static final String GIF = ".gif";
    public static final String JPG = ".jpg";
    protected SFileChooser chooser = null;
    protected int madeFrom;
    protected ClassLoader classLoader = null;
    private SerializableFile[] defaultIcons = null;
    private SerializableFile[] images = new SerializableFile[2];
    private String archiveFile = null;
    private ApplicationInformationProvider appProvider;
    private MappingPanel mapping = null;
    private boolean isForEar = false;
    private boolean doLoad = true;
    private boolean acceptBrowse = false;

    public AdditionalPanelLogical(Frame _mainFrame, int _madeFrom) {
        this.mainFrame = _mainFrame;
        this.madeFrom = _madeFrom;
        this.setButtonsEnabled();
    }

    public AdditionalPanelLogical(Frame mainFrame1, SerializableFile[] defaultIcons, String borderName, boolean smoller, boolean isAppClient, int made) {
        super(smoller, isAppClient);
        this.init(mainFrame1, defaultIcons, borderName, made);
        this.setButtonsEnabled();
        if (!isAppClient) {
            this.remove(this.callbackHandlerLabel);
            this.remove(this.callbackHandlerField);
            this.repaint();
        }
    }

    private void init(Frame _mainFrame1, SerializableFile[] _defaultIcons, String _borderName, int _madeFrom) {
        this.defaultIcons = _defaultIcons;
        this.mainFrame = _mainFrame1;
        this.madeFrom = _madeFrom;
        if (_borderName != null) {
            this.descriptionPanel.setNewBorder(GuiSettings.getResourceString("DescriptionForMsg", "Description for") + " " + _borderName);
        } else {
            this.descriptionPanel.setNewBorder(GuiSettings.getResourceString("DescriptionForMsg", "Description for") + " ");
        }
        this.chooser = SFileChooser.getInstance((JFrame)this.mainFrame);
        this.chooser.setFilters(new String[]{JPG + File.pathSeparator + GIF});
        LookAndFeelHandler.add((Component)((Object)this.chooser));
        if (this.madeFrom == 3) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setIconFiles() {
        if (this.archiveFile == null) return;
        if (this.madeFrom != 2) {
            return;
        }
        this.smallComboBox.removeAllItems();
        this.largeComboBox.removeAllItems();
        try {
            try {
                ZipFile zip = null;
                zip = new ZipFile(this.archiveFile);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                ZipEntry entry = null;
                while (enumeration != null && enumeration.hasMoreElements()) {
                    entry = enumeration.nextElement();
                    if (entry == null || entry.getName() == null || !entry.getName().endsWith(GIF) && !entry.getName().endsWith(JPG)) continue;
                    this.evaluate(this.smallComboBox, entry.getName());
                    this.evaluate(this.largeComboBox, entry.getName());
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.mainFrame, "An I/O error had occured.\n" + ioe.toString(), "Error", 0);
                Object var5_6 = null;
                this.smallComboBox.setSelectedIndex(-1);
                this.smallComboBox.addItem("");
                this.largeComboBox.setSelectedIndex(-1);
                this.largeComboBox.addItem("");
                return;
            }
            Object var5_5 = null;
            this.smallComboBox.setSelectedIndex(-1);
            this.smallComboBox.addItem("");
            this.largeComboBox.setSelectedIndex(-1);
            this.largeComboBox.addItem("");
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.smallComboBox.setSelectedIndex(-1);
            this.smallComboBox.addItem("");
            this.largeComboBox.setSelectedIndex(-1);
            this.largeComboBox.addItem("");
            throw throwable;
        }
    }

    public void setDescriptor(SerializableFile[] icons, String description, String displayName, String borderName, String jarName) {
        this.smallImageLabel.setIcon(null);
        this.largeImageLabel.setIcon(null);
        this.setArchiveFileName(jarName);
        this.initIcons(icons);
        this.descriptionPanel.setText(description);
        this.displayTextField.setText(displayName);
        if (borderName != null) {
            this.descriptionPanel.setNewBorder(GuiSettings.getResourceString("DescriptionForMsg", "Description for") + " " + borderName + " ");
        } else {
            this.descriptionPanel.setNewBorder(GuiSettings.getResourceString("DescriptionForMsg", "Description for") + " ");
        }
        this.setButtonsEnabled();
    }

    public void setDescriptor(SerializableFile[] icons, String description, String displayName, String borderName, String jarName, String callbackHandler) {
        this.setDescriptor(icons, description, displayName, borderName, jarName);
        this.callbackHandlerField.setText(callbackHandler);
    }

    private void initIcons(SerializableFile[] icons) {
        this.checkIcons(icons);
        if (icons == null || icons.length < 2 || icons[0] == null && icons[1] == null) {
            this.defaultAction();
            return;
        }
        if (icons[0] != null) {
            if (icons[0].getBytes() != null) {
                this.smallImageLabel.setIcon(new ImageIcon(icons[0].getBytes()));
                this.images[0] = icons[0];
            } else if (icons[0].getAbsoluteFilePath() != null && !icons[0].getAbsoluteFilePath().trim().equals("")) {
                this.smallImageLabel.setIcon(this.loadImage(this.nameChooser(icons[0]), 16));
            }
            if (icons[0].getFileName() == null) {
                this.evaluate(this.smallComboBox, "");
            } else {
                this.evaluate(this.smallComboBox, this.nameChooser(icons[0]));
            }
        } else if (this.defaultIcons != null && this.defaultIcons.length > 0 && this.defaultIcons[0] != null) {
            this.smallImageLabel.setIcon(new ImageIcon(this.defaultIcons[0].getBytes()));
        } else {
            this.smallImageLabel.setIcon(null);
        }
        if (icons[1] != null) {
            if (icons[1].getBytes() != null) {
                this.largeImageLabel.setIcon(new ImageIcon(icons[1].getBytes()));
                this.images[1] = icons[1];
            } else if (icons[1].getAbsoluteFilePath() != null && !icons[1].getAbsoluteFilePath().trim().equals("")) {
                this.largeImageLabel.setIcon(this.loadImage(this.nameChooser(icons[1]), 32));
            }
            if (icons[1].getFileName() == null) {
                this.evaluate(this.largeComboBox, "");
            } else {
                this.evaluate(this.largeComboBox, this.nameChooser(icons[1]));
            }
        } else if (this.defaultIcons != null && this.defaultIcons.length > 1 && this.defaultIcons[1] != null) {
            this.largeImageLabel.setIcon(new ImageIcon(this.defaultIcons[1].getBytes()));
        } else {
            this.largeImageLabel.setIcon(null);
        }
    }

    private String nameChooser(SerializableFile icon) {
        if (this.madeFrom == 1 || this.acceptBrowse) {
            return icon.getAbsoluteFilePath();
        }
        return icon.getFileName();
    }

    private void setButtonsEnabled() {
        boolean flag = false;
        if (this.madeFrom == 1 || this.acceptBrowse) {
            flag = true;
        }
        this.browseButton1.setEnabled(flag);
        this.browseButton2.setEnabled(flag);
        this.setDefaultBtn.setEnabled(flag);
    }

    public void setButtonsEnabled(boolean flag) {
        this.acceptBrowse = this.madeFrom == 2 ? flag : false;
        this.browseButton1.setEnabled(this.acceptBrowse);
        this.browseButton2.setEnabled(this.acceptBrowse);
        this.setDefaultBtn.setEnabled(this.acceptBrowse);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("BROWSE_1")) {
            this.browse1Action();
        } else if (cmd.equals("BROWSE_2")) {
            this.browse2Action();
        } else if (cmd.equals("DEFAULT")) {
            this.defaultAction();
        }
    }

    public void browse1Action() {
        String fileName = null;
        ImageIcon icon = null;
        fileName = this.getSelectedFile();
        if (fileName != null && (icon = this.loadImage(fileName, 16)) != null) {
            this.evaluate(this.smallComboBox, fileName);
            this.smallImageLabel.setIcon(icon);
        }
    }

    public void browse2Action() {
        String fileName = null;
        ImageIcon icon = null;
        fileName = this.getSelectedFile();
        if (fileName != null && (icon = this.loadImage(fileName, 32)) != null) {
            this.evaluate(this.largeComboBox, fileName);
            this.largeImageLabel.setIcon(icon);
        }
    }

    public ImageIcon loadImage(String fileName, int imageSize) {
        if (fileName.endsWith(JPG) || fileName.endsWith(GIF)) {
            ImageIcon ic;
            SerializableFile icon;
            block10: {
                icon = null;
                if (this.archiveFile != null && this.madeFrom != 1) {
                    try {
                        ZipFile zip = null;
                        zip = new ZipFile(this.archiveFile);
                        ZipEntry entry = null;
                        entry = zip.getEntry(fileName.replace(File.separatorChar, '/'));
                        if (entry != null) {
                            BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
                            byte[] bytes = new byte[(int)entry.getSize()];
                            in.read(bytes);
                            icon = new SerializableFile();
                            icon.setFileName(fileName);
                            icon.setBytes(bytes);
                            break block10;
                        }
                        icon = new SerializableFile(fileName);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this.mainFrame, "An I/O error had occured.\n" + ioe.toString(), "Error", 0);
                    }
                } else {
                    icon = new SerializableFile(fileName);
                }
            }
            if (icon != null && icon.getBytes() != null && ((ic = new ImageIcon(icon.getBytes())).getIconHeight() > imageSize || ic.getIconWidth() > imageSize)) {
                JOptionPane.showMessageDialog(this.mainFrame, "The image in the selected file is larger then expected.\nPlease select image with size " + imageSize + "x" + imageSize + " pixels.", "Error", 0);
                return null;
            }
            if (imageSize <= 16) {
                this.images[0] = icon;
            } else {
                this.images[1] = icon;
            }
            if (icon != null && icon.getBytes() != null) {
                return new ImageIcon(icon.getBytes());
            }
            return null;
        }
        JOptionPane.showMessageDialog(this.mainFrame, "This file " + fileName + "  " + "does not contain an image.\nPlease select image file " + "with extension .jpg or .gif.", "Error", 0);
        return null;
    }

    public void defaultAction() {
        if (this.defaultIcons != null && this.defaultIcons.length >= 2) {
            if (this.defaultIcons[0] != null) {
                this.smallImageLabel.setIcon(new ImageIcon(this.defaultIcons[0].getBytes()));
            } else {
                this.smallImageLabel.setIcon(null);
            }
            if (this.defaultIcons[1] != null) {
                this.largeImageLabel.setIcon(new ImageIcon(this.defaultIcons[1].getBytes()));
            } else {
                this.largeImageLabel.setIcon(null);
            }
        } else {
            this.smallImageLabel.setIcon(null);
            this.largeImageLabel.setIcon(null);
        }
        this.evaluate(this.smallComboBox, "");
        this.evaluate(this.largeComboBox, "");
        this.images[0] = null;
        this.images[1] = null;
    }

    protected String getSelectedFile() {
        String[] files = null;
        files = this.chooser.showFileDialog(GuiSettings.getResourceString("SelectApropriateImageMsg", "Select File"), false, false, false);
        if (files != null && files[0] != null) {
            return files[0];
        }
        return null;
    }

    public SerializableFile[] commitChanges() {
        this.checkIcons(this.images);
        return this.images;
    }

    private void checkIcons(SerializableFile[] icons) {
        if (icons != null) {
            int i = 0;
            while (i < icons.length) {
                if (icons[i] != null && icons[i].getAbsoluteFilePath() == null) {
                    try {
                        icons[i].setAbsoluteFilePath(new File(".").getCanonicalPath() + File.separator + icons[i].getFileName());
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this.mainFrame, "An I/O error had occured.\n" + ioe.toString(), "Error", 0);
                    }
                }
                if (icons[i] != null && icons[i].getFileName() != null && icons[i].getFileName().trim().equals("")) {
                    icons[i] = null;
                }
                if (icons[i] != null && icons[i].getFileName() != null && !icons[i].getFileName().endsWith(GIF) && !icons[i].getFileName().endsWith(JPG)) {
                    icons[i] = null;
                }
                ++i;
            }
        }
    }

    public String getDisplayName() {
        if (!this.displayTextField.getText().trim().equals("")) {
            return this.displayTextField.getText().trim();
        }
        return null;
    }

    public String getCallbackHandler() {
        if (!this.callbackHandlerField.getText().trim().equals("")) {
            return this.callbackHandlerField.getText().trim();
        }
        return null;
    }

    public String getDescription() {
        if (!this.descriptionPanel.getText().trim().equals("")) {
            return this.descriptionPanel.getText().trim();
        }
        return null;
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public int isCorrect() {
        String callback;
        if (this.isAppClient && !(callback = this.callbackHandlerField.getText().trim()).equals("") && this.madeFrom != 1) {
            try {
                if (this.classLoader != null) {
                    this.classLoader.loadClass(callback);
                    return 0;
                }
                Class.forName(callback);
                return 0;
            }
            catch (ClassNotFoundException classNotFound) {
                JOptionPane.showMessageDialog(this.mainFrame, "Callback class " + callback + " not found." + classNotFound.toString(), "Warning", 2);
                return 1;
            }
            catch (NoClassDefFoundError noClassDefFound) {
                JOptionPane.showMessageDialog(this.mainFrame, "Callback class " + callback + " could not be loaded." + noClassDefFound.toString(), "Warning", 2);
                return 1;
            }
        }
        return 0;
    }

    public void clear() {
        this.displayTextField.setText("");
        this.callbackHandlerField.setText("");
        this.smallComboBox.removeAllItems();
        this.largeComboBox.removeAllItems();
        this.evaluate(this.smallComboBox, "");
        this.evaluate(this.largeComboBox, "");
        this.initIcons(null);
        this.descriptionPanel.setText("");
    }

    public void setLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public void commitChange() {
    }

    public void setEnabled(boolean flag) {
        if (this.madeFrom == 2 && !this.isForEar) {
            this.displayTextField.setEnabled(false);
        } else if ((this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) && this.isForEar) {
            this.displayTextField.setEnabled(true);
        } else {
            this.displayTextField.setEnabled(flag);
        }
        this.callbackHandlerField.setEnabled(flag);
        this.smallComboBox.setEnabled(flag);
        this.largeComboBox.setEnabled(flag);
        this.browseButton1.setEnabled(flag);
        this.browseButton2.setEnabled(flag);
        this.setDefaultBtn.setEnabled(flag);
        this.imagesPanel.setEnabled(flag);
        this.smallPanel.setEnabled(flag);
        this.largePanel.setEnabled(flag);
        this.descriptionPanel.setEnabled(flag);
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setDescriptionBorderName(String borderName) {
        if (borderName != null) {
            this.descriptionPanel.setNewBorder(GuiSettings.getResourceString("DescriptionForMsg", "Description for") + " " + borderName + " ");
        } else {
            this.descriptionPanel.setNewBorder(GuiSettings.getResourceString("DescriptionForMsg", "Description for") + " ");
        }
    }

    public boolean addAdditionalFile() {
        if (this.mapping != null) {
            if (this.images != null) {
                if (this.images[0] != null && this.images[0].getFileName() != null && this.images[0].getAbsoluteFilePath() != null) {
                    this.mapping.addFile(this.images[0].getFileName(), this.images[0].getAbsoluteFilePath());
                }
                if (this.images[1] != null && this.images[1].getFileName() != null && this.images[1].getAbsoluteFilePath() != null) {
                    this.mapping.addFile(this.images[1].getFileName(), this.images[1].getAbsoluteFilePath());
                }
                this.mapping.repaint();
                this.mapping.validate();
            }
            return true;
        }
        return false;
    }

    public void enableAddingAdditionalFiles(MappingPanel _mapping) {
        this.mapping = _mapping;
    }

    private void setArchiveFileName(String jarName) {
        if (jarName == null) {
            return;
        }
        this.archiveFile = jarName;
        this.setIconFiles();
    }

    public void setArchiveName(String jarName) {
        this.setArchiveFileName(jarName);
        try {
            String point = new File(".").getCanonicalPath() + File.separator;
            String icon = null;
            if (this.images != null) {
                if (this.images[0] != null) {
                    icon = this.images[0].getAbsoluteFilePath();
                    if (icon != null) {
                        if (icon.startsWith(point) && this.madeFrom != 1) {
                            icon = icon.substring(point.length());
                        }
                    } else {
                        icon = this.images[0].getFileName();
                    }
                    this.evaluate(this.smallComboBox, this.madeFrom == 1 ? this.images[0].getAbsoluteFilePath() : (icon == null ? this.images[0].getFileName() : icon));
                    this.smallImageLabel.setIcon(this.loadImage(icon, 16));
                }
                if (this.images[1] != null) {
                    icon = this.images[1].getAbsoluteFilePath();
                    if (icon != null) {
                        if (icon.startsWith(point) && this.madeFrom != 1) {
                            icon = icon.substring(point.length());
                        }
                    } else {
                        icon = this.images[1].getFileName();
                    }
                    this.evaluate(this.largeComboBox, this.madeFrom == 1 ? this.images[1].getAbsoluteFilePath() : (icon == null ? this.images[1].getFileName() : icon));
                    this.largeImageLabel.setIcon(this.loadImage(icon, 32));
                }
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.mainFrame, "An I/O error had occured.\n" + ex.toString(), "Error", 0);
        }
    }

    public void setCallbackHandler(String callback) {
        this.callbackHandlerField.setText(callback);
    }

    public void setForEar(boolean forEar) {
        this.isForEar = forEar;
    }

    private void evaluate(JComboBox comboBox, String add) {
        if (add == null || comboBox == null) {
            return;
        }
        this.doLoad = false;
        comboBox.removeItem(add);
        comboBox.addItem(add);
        comboBox.setSelectedItem(add);
        this.doLoad = true;
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.doLoad) {
            return;
        }
        Object source = e.getSource();
        int size = 16;
        JLabel current = this.smallImageLabel;
        if (source != null && source instanceof JComboBox) {
            if ((JComboBox)source == this.smallComboBox) {
                size = 16;
                current = this.smallImageLabel;
            } else if ((JComboBox)source == this.largeComboBox) {
                size = 32;
                current = this.largeImageLabel;
            } else {
                return;
            }
            String value = (String)((JComboBox)source).getSelectedItem();
            if (value != null && !value.trim().equals("")) {
                ImageIcon icon = this.loadImage(value, size);
                current.setIcon(icon);
            } else if (value != null && value.trim().equals("") && this.defaultIcons != null && this.defaultIcons.length == 2 && this.defaultIcons[0] != null && this.defaultIcons[1] != null) {
                current.setIcon(new ImageIcon(this.defaultIcons[size == 16 ? 0 : 1].getBytes()));
            }
        }
    }
}

