/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.services.deploy.gui.DeployUserObject;
import com.sap.engine.services.deploy.gui.ImageHolder;
import com.sap.engine.services.deploy.gui.SecurityUserObject;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class TreeRenderer
extends JLabel
implements TreeCellRenderer {
    private Icon serverIcon;
    private Icon containerIcon;
    private Icon applicationIcon;
    private Icon componentIcon;
    private Icon startingIcon;
    private Icon startedIcon;
    private Icon stoppedIcon;
    private Icon implicit_stoppedIcon;
    private Icon stoppingIcon;
    private Icon upgradingIcon;
    private Icon methodRed;
    private Icon methodBlue;
    private Icon methodGroup;
    private Icon secRoleIcon;
    private Icon secRoleGroup;
    private Icon aUserGroup;

    public TreeRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof DeployUserObject) {
            DeployUserObject viewInfe = (DeployUserObject)userObject;
            switch (viewInfe.getType()) {
                case 1: {
                    this.setIcon(this.serverIcon);
                    break;
                }
                case 2: {
                    this.setIcon(this.containerIcon);
                    break;
                }
                case 5: {
                    this.setIcon(this.startedIcon);
                    break;
                }
                case 3: {
                    this.setIcon(this.stoppedIcon);
                    break;
                }
                case 9: {
                    this.setIcon(this.implicit_stoppedIcon);
                    break;
                }
                case 7: {
                    this.setIcon(this.stoppingIcon);
                    break;
                }
                case 6: {
                    this.setIcon(this.startingIcon);
                    break;
                }
                case 8: {
                    this.setIcon(this.upgradingIcon);
                    break;
                }
                case 4: {
                    this.setIcon(this.componentIcon);
                    break;
                }
                default: {
                    this.setIcon(this.serverIcon);
                    break;
                }
            }
        } else if (userObject instanceof SecurityUserObject) {
            SecurityUserObject viewInfe = (SecurityUserObject)userObject;
            switch (viewInfe.getType()) {
                case 3: {
                    this.setIcon(this.methodGroup);
                    break;
                }
                case 4: {
                    this.setIcon(this.secRoleIcon);
                    break;
                }
                case 5: {
                    this.setIcon(this.secRoleGroup);
                    break;
                }
                case 2: {
                    this.setIcon(this.methodBlue);
                    break;
                }
                case 1: {
                    this.setIcon(this.methodRed);
                    break;
                }
                case 10: {
                    this.setIcon(this.aUserGroup);
                    break;
                }
                default: {
                    this.setIcon(this.methodRed);
                }
            }
        }
        this.setText(userObject != null ? userObject.toString() : "No Name");
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }

    private void initImages() {
        this.serverIcon = ImageHolder.serverIcon;
        this.containerIcon = ImageHolder.containerIcon;
        this.applicationIcon = ImageHolder.applicationIcon;
        this.componentIcon = ImageHolder.componentIcon;
        this.startedIcon = ImageHolder.startedIcon;
        this.startingIcon = ImageHolder.startingIcon;
        this.stoppedIcon = ImageHolder.stoppedIcon;
        this.implicit_stoppedIcon = ImageHolder.implicit_stoppedIcon;
        this.stoppingIcon = ImageHolder.stoppingIcon;
        this.upgradingIcon = ImageHolder.upgradingIcon;
        this.methodRed = ImageHolder.aMethodRed;
        this.methodBlue = ImageHolder.aMethodBlue;
        this.methodGroup = ImageHolder.aMethodGroup;
        this.secRoleIcon = ImageHolder.aSecRoleIcon;
        this.secRoleGroup = ImageHolder.aSecRoleGroup;
        this.aUserGroup = ImageHolder.aUserGroup;
    }
}

