/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.gui.MappingInterface;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.event.AnalyzeProgressListener;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.mapping.DirMappingPanel;
import com.sap.engine.services.deploy.gui.mapping.DirectoryMappingPanel;
import com.sap.engine.services.deploy.gui.mapping.FileMappingPanel;
import com.sap.engine.services.deploy.gui.mapping.ManifestPanel;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import com.sap.engine.services.deploy.gui.mapping.dependancy.DependancyDialog;
import com.sap.engine.services.deploy.gui.mapping.dependancy.DependencyAnalyzer;
import com.sap.engine.services.deploy.gui.mapping.tree.ClassFileMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.DirMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.FileMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.ManifestTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.MappingTree;
import com.sap.engine.services.deploy.gui.mapping.tree.MappingTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class MappingPanel
extends BasicPanelView
implements MappingInterface,
TreeSelectionListener,
ActionListener,
AnalyzeProgressListener {
    public static int EJB = 0;
    public static int WEB = 1;
    public static int CLIENT = 2;
    public static int CONNECTOR = 3;
    public static int EAR = 4;
    protected Frame frame;
    private JSplitPane spliter;
    protected MappingTree tree;
    protected DefaultTreeModel defTree;
    protected FileMappingTreeNode fileNode;
    protected DirMappingTreeNode root = new DirMappingTreeNode();
    protected DirMappingTreeNode directorysMainNode = new DirMappingTreeNode("Directories");
    protected FileMappingTreeNode filesMainNode = new FileMappingTreeNode("Files");
    private ClassFileMappingTreeNode beanClassesMainNode = null;
    private ManifestTreeNode manifestNode = new ManifestTreeNode("", "Manifest");
    protected FileMappingPanel fileMapPanel;
    protected DirectoryMappingPanel directoryMapPanel;
    protected DirMappingPanel dirMapPanel;
    private ManifestPanel manifestPanel;
    private JPanel lastSelectedPanel;
    protected TreePath lastSelectedTreeElementPath;
    private JButton removeButton;
    private JButton dependenciesButton;
    protected Vector listOfDirs;
    protected DirMappingTreeNode dirFindNode;
    private static boolean resultOfSearch = false;
    private Vector classNames;
    private String[] classPaths;
    private JPanel emptyPanel = new JPanel();
    private String archiveName = "default";
    private String lastManifestFile = "";
    private int madeFrom;
    protected static final int ENTRY_NAME = 0;
    protected static final int FILE_PATH = 1;
    private ApplicationInformationProvider appProvider;
    private String[] classPath = null;
    private Vector classPathVector = null;
    private DependencyAnalyzer dependencies = new DependencyAnalyzer();
    private Vector depFiles = new Vector();
    private Vector startDepFiles = new Vector();
    private boolean isSettingData;
    private Vector newFiles;

    public MappingPanel(Vector listOfDirs, Frame frame, String archiveName, int madeFrom) {
        this.frame = frame;
        this.madeFrom = madeFrom;
        this.listOfDirs = listOfDirs;
        this.archiveName = archiveName;
        this.setPreferredSize(new Dimension(700, 480));
        this.init();
    }

    public MappingPanel(Frame frame, int madeFrom) {
        this.madeFrom = madeFrom;
        this.frame = frame;
        this.setPreferredSize(new Dimension(700, 480));
        this.init();
    }

    protected void init() {
        this.dependencies.addProgressListener(this);
        this.setLayout(new BorderLayout());
        this.fileMapPanel = new FileMappingPanel(this.frame, this);
        this.fileMapPanel.setMinimumSize(new Dimension(400, 350));
        this.directoryMapPanel = new DirectoryMappingPanel(this.frame, this);
        this.directoryMapPanel.setMinimumSize(new Dimension(400, 350));
        this.dirMapPanel = new DirMappingPanel(this.directorysMainNode);
        this.dirMapPanel.setMinimumSize(new Dimension(400, 350));
        this.manifestPanel = new ManifestPanel(this.frame);
        this.tree = new MappingTree(this.root);
        this.dirMapPanel.setTree(this.tree);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        this.defTree = (DefaultTreeModel)this.tree.getModel();
        this.tree.addTreeSelectionListener(this);
        this.tree.setRootVisible(false);
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)treeScrollPane, "Center");
        treePanel.setPreferredSize(new Dimension(230, 200));
        treePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Archive Content Tree"));
        this.spliter = new JSplitPane(1, treePanel, this.fileMapPanel);
        this.spliter.setDividerLocation(230);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.spliter, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.dependenciesButton = new JButton("Dependencies");
        this.dependenciesButton.setActionCommand("dependencies");
        this.dependenciesButton.addActionListener(this);
        this.removeButton = new JButton("Remove");
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        buttonPanel.add((Component)this.removeButton, null);
        if (this.madeFrom != EAR) {
            buttonPanel.add((Component)this.dependenciesButton, null);
        }
        treePanel.add((Component)buttonPanel, "South");
        this.add((Component)mainPanel, "Center");
        this.defTree.insertNodeInto(this.directorysMainNode, this.root, 0);
        this.defTree.insertNodeInto(this.filesMainNode, this.root, 1);
        this.defTree.insertNodeInto(this.manifestNode, this.root, 2);
        MappingTreeCellRenderer renderer = new MappingTreeCellRenderer();
        this.tree.setCellRenderer(renderer);
        if (this.listOfDirs != null) {
            if (this.listOfDirs.size() > 0) {
                this.insertNodes(this.sort(this.listOfDirs));
            }
        } else {
            this.listOfDirs = new Vector();
        }
        this.tree.setDirMapPanel(this.dirMapPanel);
        this.defTree.reload();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
    }

    protected void rekursiveDirectoryLoading(File file, DirMappingTreeNode parentNode, boolean newFile) {
        if (!file.isFile()) {
            File[] filesList = file.listFiles();
            int i = 0;
            while (i < filesList.length) {
                if (filesList[i].isDirectory()) {
                    MappingObject map = new MappingObject(filesList[i].getAbsolutePath(), new Properties());
                    DirMappingTreeNode childNode = this.findChildNode(parentNode, filesList[i].getAbsolutePath());
                    if (!this.checkExistence(filesList[i].getAbsolutePath(), false)) {
                        childNode = new DirMappingTreeNode(map);
                        this.defTree.insertNodeInto(childNode, parentNode, 0);
                        if (newFile && childNode.getParent() instanceof DirMappingTreeNode) {
                            childNode.getMapObjValue().setMappings(((DirMappingTreeNode)childNode.getParent()).getMapObjValue().getMappings());
                            this.newFiles.add(childNode.getMapObjValue().getFilePath());
                        }
                    }
                    this.rekursiveDirectoryLoading(filesList[i], childNode, newFile);
                }
                ++i;
            }
        }
    }

    private DirMappingTreeNode findChildNode(DirMappingTreeNode parent, String filePathT) {
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            if (((DirMappingTreeNode)parent.getChildAt(i)).getMapObjValue().getFilePath().equals(filePathT)) {
                return (DirMappingTreeNode)parent.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    public boolean addDirectory() {
        String pathString;
        String[] fileAndEntry = this.directoryMapPanel.getTextFromFields();
        String newMapping = fileAndEntry[0];
        String path = fileAndEntry[1];
        if (path == null || path.trim().equals("")) {
            return true;
        }
        if (newMapping == null) {
            return true;
        }
        this.directoryMapPanel.resetTextFields();
        DirMappingTreeNode newNode = null;
        if (path != null && !this.checkExistence(pathString = path, false)) {
            File file = new File(pathString);
            newNode = new DirMappingTreeNode(pathString);
            this.defTree.insertNodeInto(newNode, this.directorysMainNode, 0);
            this.rekursiveDirectoryLoading(file, newNode, false);
        }
        if (newNode != null) {
            Properties forPass = new Properties();
            if (newMapping != null && !newMapping.trim().equals("")) {
                newMapping = newMapping.replace('\\', '/');
                while (newMapping.startsWith("/")) {
                    newMapping = newMapping.substring(1);
                }
                String mappingUpperCase = newMapping.toUpperCase();
                int index1 = 0;
                int index2 = 0;
                while (index1 != -1) {
                    index1 = mappingUpperCase.indexOf("WEB-INF/", index2);
                    if (index1 > -1) {
                        newMapping = newMapping.substring(0, index1) + "WEB-INF/" + newMapping.substring(index1 + 8);
                    }
                    index2 = index1 + 1;
                }
                newNode.getMapObjValue().getMappings().setProperty(".*", newMapping);
                forPass.setProperty(".*", newMapping);
                Properties one = (Properties)((Hashtable)forPass).clone();
                this.dirMapPanel.passToChildren(one, forPass, newNode);
            } else if (this.madeFrom == WEB) {
                newNode.getMapObjValue().getMappings().setProperty(".class", "WEB-INF/classes");
                newNode.getMapObjValue().getMappings().setProperty(".jar", "WEB-INF/lib");
                forPass.setProperty(".class", "WEB-INF/classes");
                Properties one = (Properties)((Hashtable)forPass).clone();
                this.dirMapPanel.passToChildren(one, forPass, newNode);
                forPass = new Properties();
                forPass.setProperty(".jar", "WEB-INF/lib");
                Properties two = (Properties)((Hashtable)forPass).clone();
                this.dirMapPanel.passToChildren(two, forPass, newNode);
            }
        }
        this.dirMapPanel.ultimateCheckForCyclicDirectories();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
        return true;
    }

    protected void replaceMapping(String fileNameLoc, String entryNameChange) {
        int count = this.filesMainNode.getChildCount();
        int i = 0;
        while (i < count) {
            if (((FileMappingTreeNode)this.filesMainNode.getChildAt(i)).getFileMapObjValue().getFilePath().equals(fileNameLoc)) {
                ((FileMappingTreeNode)this.filesMainNode.getChildAt((int)i)).getFileMapObjValue().entryName = entryNameChange;
                break;
            }
            ++i;
        }
    }

    protected String replaceFS(String forReplace) {
        String result = forReplace.replace(File.separatorChar, '/');
        int index = 0;
        String temp = null;
        while (result.indexOf("//") != -1) {
            index = result.indexOf("//");
            temp = result.substring(0, index);
            result = temp + result.substring(index + 1);
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public boolean addFile() {
        boolean replaced = false;
        if (this.fileMapPanel.isEmptyTextFields()) {
            String[] fileAndEntry = this.fileMapPanel.getTextFromFields();
            if (fileAndEntry[0].trim().equals("")) {
                fileAndEntry[0] = fileAndEntry[0].trim();
            }
            String filePathTemp = fileAndEntry[1];
            String entryPathTemp = fileAndEntry[0];
            int intempFilePath = filePathTemp.lastIndexOf(File.separator);
            int intempEntryPath = entryPathTemp.lastIndexOf(File.separator);
            if (intempFilePath != -1) {
                filePathTemp = filePathTemp.substring(filePathTemp.lastIndexOf(File.separator) + 1);
            }
            if (intempEntryPath != -1) {
                entryPathTemp = entryPathTemp.substring(entryPathTemp.lastIndexOf(File.separator) + 1);
            }
            fileAndEntry[0] = fileAndEntry[0].replace('/', File.separatorChar);
            int margin1 = filePathTemp.lastIndexOf(".");
            int margin2 = entryPathTemp.lastIndexOf(".");
            if (margin1 != -1 && margin2 != -1) {
                if (!fileAndEntry[1].substring(margin1).equals(fileAndEntry[0].substring(margin2))) {
                    int option2;
                    if (fileAndEntry[0].endsWith(File.separator)) {
                        fileAndEntry[0] = fileAndEntry[1].lastIndexOf(File.separator) != -1 ? fileAndEntry[0] + fileAndEntry[1].substring(fileAndEntry[1].lastIndexOf(File.separator) + 1) : fileAndEntry[0] + fileAndEntry[1];
                    } else if (!filePathTemp.substring(margin1).equals(entryPathTemp.substring(margin2)) && (option2 = JOptionPane.showConfirmDialog(this, "Your mapping has diferent extention. Replace with old one?", "Replace extention", 0)) == 0) {
                        fileAndEntry[0] = fileAndEntry[0].substring(0, fileAndEntry[0].lastIndexOf("."));
                        fileAndEntry[0] = fileAndEntry[0] + fileAndEntry[1].substring(fileAndEntry[1].lastIndexOf("."));
                    }
                }
                this.fileMapPanel.setMapNameTextField(fileAndEntry[0]);
            } else if (fileAndEntry[0].trim().equals("")) {
                fileAndEntry[0] = fileAndEntry[1].substring(fileAndEntry[1].lastIndexOf(File.separator));
            } else {
                if (fileAndEntry[0].endsWith(File.separator)) {
                    fileAndEntry[0] = fileAndEntry[1].lastIndexOf(File.separator) != -1 ? fileAndEntry[0] + fileAndEntry[1].substring(fileAndEntry[1].lastIndexOf(File.separator) + 1) : fileAndEntry[0] + fileAndEntry[1];
                } else if (margin1 != -1 && margin2 == -1) {
                    fileAndEntry[0] = fileAndEntry[0] + filePathTemp.substring(margin1);
                } else if (fileAndEntry[1].lastIndexOf(File.separator) != -1) {
                    fileAndEntry[0] = fileAndEntry[0] + File.separator + fileAndEntry[1].substring(fileAndEntry[1].lastIndexOf(File.separator) + 1);
                }
                fileAndEntry[0] = this.replaceFS(fileAndEntry[0]);
                this.fileMapPanel.setMapNameTextField(fileAndEntry[0]);
            }
            this.fileMapPanel.repaint();
            InfoObject ttempInfo = new InfoObject(fileAndEntry[0], fileAndEntry[1]);
            if (!this.checkExistence(ttempInfo, true)) {
                this.fileNode = new FileMappingTreeNode(ttempInfo);
                File f = new File(fileAndEntry[1]);
                if (f.exists()) {
                    this.defTree.insertNodeInto(this.fileNode, this.filesMainNode, 0);
                } else {
                    JOptionPane.showMessageDialog(this.frame, "There is no such file");
                }
            } else {
                int option = JOptionPane.showConfirmDialog(this, "File Already Exists. Replace Mapping?", "Replace Mapping", 0);
                if (option == 0) {
                    fileAndEntry[0] = this.replaceFS(fileAndEntry[0]);
                    this.replaceMapping(fileAndEntry[1], fileAndEntry[0]);
                    this.fileMapPanel.setMapNameTextField(fileAndEntry[0]);
                    replaced = true;
                }
            }
            if (!replaced) {
                this.fileMapPanel.resetTextFields();
            }
        }
        TreeUtils.expandTree((JTree)this.tree, (int)2);
        return true;
    }

    public void addFile(String entry, String path) {
        String[] fileAndEntry = new String[]{entry, path};
        if (fileAndEntry[0].trim().equals("")) {
            fileAndEntry[0] = fileAndEntry[0].trim();
        }
        this.fileMapPanel.repaint();
        InfoObject ttempInfo = new InfoObject(fileAndEntry[0], fileAndEntry[1]);
        if (!this.checkExistence(ttempInfo, true)) {
            this.fileNode = new FileMappingTreeNode(ttempInfo);
            File f = new File(fileAndEntry[1]);
            if (f.exists()) {
                this.defTree.insertNodeInto(this.fileNode, this.filesMainNode, 0);
            }
        }
        TreeUtils.expandTree((JTree)this.tree, (int)2);
    }

    public void updateDirPanel(DefaultMutableTreeNode node) {
        if (!((DirMappingTreeNode)node).getMapObjValue().getFilePath().equals("Directories") && ((DirMappingTreeNode)node).getMapObjValue().isIncluded()) {
            this.dirMapPanel.setAllEnable();
            this.dirMapPanel.setData((DirMappingTreeNode)node);
        } else {
            this.dirMapPanel.clear();
            this.dirMapPanel.setAllDisable();
        }
    }

    private void updateFilePanel(DefaultMutableTreeNode node) {
        if (node != this.filesMainNode && node != this.beanClassesMainNode) {
            if (node instanceof FileMappingTreeNode) {
                this.fileMapPanel.setData(((FileMappingTreeNode)node).getFileMapObjValue());
                if (((FileMappingTreeNode)node).getFileMapObjValue().getEntryName().equalsIgnoreCase("META-INF/Manifest.mf")) {
                    this.fileMapPanel.setAllDisable();
                } else {
                    this.fileMapPanel.setAllEnable();
                }
            } else if (node instanceof ClassFileMappingTreeNode) {
                this.fileMapPanel.setData(((ClassFileMappingTreeNode)node).getFileMapObjValue());
                this.fileMapPanel.setAllDisable();
            }
        } else {
            this.fileMapPanel.setAllEnable();
            this.fileMapPanel.resetTextFields();
        }
    }

    private void removeAnyElement() {
        DefaultMutableTreeNode node;
        if (!this.tree.isSelectionEmpty() && (node = (DefaultMutableTreeNode)this.lastSelectedTreeElementPath.getLastPathComponent()) != this.directorysMainNode && node != this.filesMainNode && !(node instanceof ManifestTreeNode)) {
            Object[] selpath = ((DefaultMutableTreeNode)node.getParent()).getPath();
            this.defTree.removeNodeFromParent(node);
            this.fileMapPanel.resetTextFields();
            this.dirMapPanel.resetFields();
            this.tree.setSelectionPath(new TreePath(selpath));
        }
        this.removeButton.setEnabled(false);
    }

    private Vector sort(Vector forSort) {
        String compareI = null;
        String compareJ = null;
        int index = 0;
        int length = 0;
        int i = 0;
        while (i < forSort.size()) {
            int j = i + 1;
            while (j < forSort.size()) {
                if (forSort.elementAt(i) instanceof MappingObject && forSort.elementAt(j) instanceof MappingObject) {
                    index = ((MappingObject)forSort.elementAt(i)).getFilePath().indexOf(File.separator);
                    length = ((MappingObject)forSort.elementAt(i)).getFilePath().length();
                    compareI = ((MappingObject)forSort.elementAt(i)).getFilePath().substring(index, length);
                    index = ((MappingObject)forSort.elementAt(j)).getFilePath().indexOf(File.separator);
                    length = ((MappingObject)forSort.elementAt(j)).getFilePath().length();
                    compareJ = ((MappingObject)forSort.elementAt(j)).getFilePath().substring(index, length);
                    if (compareI.compareTo(compareJ) > 0) {
                        forSort.insertElementAt((MappingObject)forSort.elementAt(j), i);
                        forSort.removeElementAt(j + 1);
                    }
                }
                ++j;
            }
            ++i;
        }
        return forSort;
    }

    /*
     * WARNING - void declaration
     */
    public boolean insertNodes(Vector insertNodesVector) {
        int minCountOfTokens = 0;
        Vector<String> vectorRemoved = new Vector<String>();
        int y = 0;
        while (y < insertNodesVector.size()) {
            File checkExistenceFile;
            if (insertNodesVector.elementAt(y) instanceof MappingObject) {
                checkExistenceFile = new File(((MappingObject)insertNodesVector.elementAt(y)).getFilePath());
                if (!checkExistenceFile.exists()) {
                    vectorRemoved.add(checkExistenceFile.getAbsolutePath());
                    insertNodesVector.removeElementAt(y);
                    --y;
                } else {
                    int indexToken = ((MappingObject)insertNodesVector.elementAt(y)).getFilePath().indexOf(File.separator);
                    int lengthToken = ((MappingObject)insertNodesVector.elementAt(y)).getFilePath().length();
                    String subTokenPart = ((MappingObject)insertNodesVector.elementAt(y)).getFilePath().substring(indexToken, lengthToken);
                    StringTokenizer minToken = new StringTokenizer(subTokenPart, File.separator);
                    if (minCountOfTokens == 0) {
                        minCountOfTokens = minToken.countTokens();
                    } else if (minCountOfTokens > minToken.countTokens()) {
                        minCountOfTokens = minToken.countTokens();
                    }
                }
            } else if (insertNodesVector.elementAt(y) instanceof InfoObject && !(checkExistenceFile = new File(((InfoObject)insertNodesVector.elementAt(y)).getFilePath())).exists()) {
                JOptionPane.showMessageDialog(this.frame, "The File " + ((InfoObject)insertNodesVector.elementAt(y)).getFilePath() + " does not exist and it will be removed from project", "Warning", 2);
                insertNodesVector.removeElementAt(y);
                --y;
            }
            ++y;
        }
        if (vectorRemoved.size() > 0) {
            String warning = "";
            int i = 0;
            while (i < vectorRemoved.size()) {
                warning = warning + vectorRemoved.elementAt(i) + "\n";
                ++i;
            }
            LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)this.frame);
            logErrorDialog.showWarningDialogNoLogFile("There are some directories missing from the file system.\nThey will be ignored from additional files panel\n", warning);
        }
        int index = 0;
        int length = 0;
        int i = 0;
        while (i < insertNodesVector.size()) {
            String subPart = null;
            String prePart = "";
            if (insertNodesVector.elementAt(i) instanceof MappingObject) {
                index = ((MappingObject)insertNodesVector.elementAt(i)).getFilePath().indexOf(File.separator);
                length = ((MappingObject)insertNodesVector.elementAt(i)).getFilePath().length();
                if (index > 0) {
                    prePart = ((MappingObject)insertNodesVector.elementAt(i)).getFilePath().substring(0, index);
                }
                subPart = ((MappingObject)insertNodesVector.elementAt(i)).getFilePath().substring(index, length);
                StringTokenizer st = new StringTokenizer(subPart, File.separator);
                String wholePath = "";
                if (st.countTokens() > minCountOfTokens) {
                    String temp = null;
                    while (st.hasMoreTokens()) {
                        if (st.hasMoreTokens()) {
                            temp = st.nextToken();
                            wholePath = wholePath + File.separator + temp;
                            continue;
                        }
                        temp = st.nextToken();
                    }
                    int lastIndexSeparator = wholePath.lastIndexOf(File.separator);
                    wholePath = wholePath.substring(0, lastIndexSeparator);
                    this.dirFindNode = null;
                    DirMappingTreeNode tempDirNode = new DirMappingTreeNode((MappingObject)insertNodesVector.elementAt(i));
                    this.searchForDirNode(prePart + wholePath, this.directorysMainNode);
                    if (this.dirFindNode != null) {
                        DirMappingTreeNode parent = this.dirFindNode;
                        if (!this.checkExistence(((MappingObject)insertNodesVector.elementAt(i)).getFilePath(), false) && parent != null) {
                            this.defTree.insertNodeInto(tempDirNode, parent, 0);
                        }
                    } else {
                        this.defTree.insertNodeInto(tempDirNode, this.directorysMainNode, 0);
                    }
                } else if (!this.checkExistence(((MappingObject)insertNodesVector.elementAt(i)).getFilePath(), false)) {
                    DirMappingTreeNode tempDirNode = new DirMappingTreeNode((MappingObject)insertNodesVector.elementAt(i));
                    this.defTree.insertNodeInto(tempDirNode, this.directorysMainNode, 0);
                }
            } else if (insertNodesVector.elementAt(i) instanceof InfoObject && !this.checkExistence(((InfoObject)insertNodesVector.elementAt(i)).getFilePath(), false)) {
                FileMappingTreeNode tempFileNode = new FileMappingTreeNode((InfoObject)insertNodesVector.elementAt(i));
                this.defTree.insertNodeInto(tempFileNode, this.filesMainNode, 0);
                if (this.archiveName != null) {
                    String manifestName = this.processDots(this.archiveName);
                    if (tempFileNode.getFileMapObjValue().getFilePath().equals(manifestName)) {
                        try {
                            String line;
                            BufferedReader in = new BufferedReader(new FileReader(new File(manifestName)));
                            String text = "";
                            while ((line = in.readLine()) != null) {
                                void lastIndexSeparator;
                                text = text + (String)lastIndexSeparator + "";
                            }
                            this.manifestPanel.setData(text);
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(this.frame, "Error in Manifest File\n" + e.toString(), "Error", 0);
                        }
                    }
                }
            }
            ++i;
        }
        this.updateTree();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
        return true;
    }

    protected void searchForDirNode(String filePath, DirMappingTreeNode treeNodeTemp) {
        int index = treeNodeTemp.getChildCount();
        if (filePath.equals(treeNodeTemp.getMapObjValue().getFilePath())) {
            this.dirFindNode = treeNodeTemp;
        }
        int i = 0;
        while (i < index) {
            if (((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).isLeaf()) {
                if (filePath.equals(((DirMappingTreeNode)treeNodeTemp.getChildAt(i)).getMapObjValue().getFilePath())) {
                    this.dirFindNode = (DirMappingTreeNode)treeNodeTemp.getChildAt(i);
                }
            } else {
                this.searchForDirNode(filePath, (DirMappingTreeNode)treeNodeTemp.getChildAt(i));
            }
            ++i;
        }
    }

    protected boolean checkExistence(Object filePath, boolean isFile) {
        if (isFile) {
            int nodeCount = this.filesMainNode.getChildCount();
            int i = 0;
            while (i < nodeCount) {
                if (((FileMappingTreeNode)this.filesMainNode.getChildAt(i)).getFileMapObjValue().equals(filePath)) {
                    return true;
                }
                ++i;
            }
        } else {
            resultOfSearch = false;
            this.rekursiveSearch((String)filePath, this.directorysMainNode);
            return resultOfSearch;
        }
        return false;
    }

    private void rekursiveSearch(String filePath, DirMappingTreeNode searchedTreeNode) {
        int count = searchedTreeNode.getChildCount();
        int i = 0;
        while (i < count) {
            if (searchedTreeNode.getChildAt(i).isLeaf()) {
                if (filePath.equals(((DirMappingTreeNode)searchedTreeNode.getChildAt(i)).getMapObjValue().getFilePath())) {
                    resultOfSearch = true;
                }
            } else {
                if (((DirMappingTreeNode)searchedTreeNode.getChildAt(i)).getMapObjValue().getFilePath().equals(filePath)) {
                    resultOfSearch = true;
                }
                this.rekursiveSearch(filePath, (DirMappingTreeNode)searchedTreeNode.getChildAt(i));
            }
            ++i;
        }
    }

    protected void updateTree() {
        int i = 0;
        while (i < this.directorysMainNode.getChildCount()) {
            File file = new File(((DirMappingTreeNode)this.directorysMainNode.getChildAt(i)).getMapObjValue().getFilePath());
            this.newFiles = new Vector();
            this.rekursiveDirectoryLoading(file, (DirMappingTreeNode)this.directorysMainNode.getChildAt(i), true);
            if (this.newFiles.size() > 0) {
                String warning = "";
                int j = 0;
                while (j < this.newFiles.size()) {
                    warning = warning + this.newFiles.elementAt(j) + "\n";
                    ++j;
                }
                LogMessageDialog logErrorDialog = LogMessageDialog.getInstance((Frame)this.frame);
                logErrorDialog.showInformDialogNoLogFile("New directories are found.\nThere are some new directories found on the file system.\nThey will be added into additional files panel.\n", warning);
            }
            this.newFiles = new Vector();
            ++i;
        }
    }

    public Vector getDependenciesList() {
        Vector result = new Vector();
        Vector tempDirs = this.dirMapPanel.flattenTree();
        Vector tempFiles = this.getFilesList();
        int i = 0;
        while (i < tempDirs.size()) {
            result.add(tempDirs.elementAt(i));
            ++i;
        }
        int j = 0;
        while (j < tempFiles.size()) {
            result.add(tempFiles.elementAt(j));
            ++j;
        }
        return result;
    }

    private void dependenciesAction() {
        this.depFiles = new Vector();
        this.startDepFiles = this.getClassFiles(this.getDependenciesList());
    }

    private Vector getClassFiles(Vector v) {
        Vector result = new Vector();
        int dirCount = this.directorysMainNode.getChildCount();
        Vector tempClassFiles = new Vector();
        Vector<String> tempClass = new Vector<String>();
        this.startDepFiles = new Vector();
        int i = 0;
        while (i < dirCount) {
            tempClassFiles = this.getAllClassFiles(new Vector(), (DirMappingTreeNode)this.directorysMainNode.getChildAt(i));
            int k = 0;
            while (k < tempClassFiles.size()) {
                tempClass.add(((File)tempClassFiles.elementAt(k)).getAbsolutePath());
                if (!this.startDepFiles.contains(((File)tempClassFiles.elementAt(k)).getAbsolutePath())) {
                    this.startDepFiles.add(((File)tempClassFiles.elementAt(k)).getAbsolutePath());
                }
                ++k;
            }
            if (this.classPathVector == null) {
                this.classPathVector = new Vector();
            }
            Vector tempResult = this.dependencies.findDependancies(tempClass, this.excludedPacks(), false, this.classPathVector);
            int j = 0;
            while (j < tempResult.size()) {
                result.add(tempResult.elementAt(j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Vector excludedPacks() {
        Vector<String> exclude = new Vector<String>();
        exclude.addElement("java/");
        exclude.addElement("javax/");
        exclude.addElement("com/sun/");
        exclude.addElement("com/prosyst/aprj/");
        exclude.addElement("com/prosyst/ide/");
        exclude.addElement("com/prosyst/gui/");
        exclude.addElement("com/prosyst/util/");
        exclude.addElement("com/prosyst/plugin/");
        exclude.addElement("com/prosyst/debugger/");
        exclude.addElement("com/prosyst/setup/");
        exclude.addElement("com/inqmy/boot/");
        exclude.addElement("com/inqmy/core/");
        exclude.addElement("com/inqmy/debug/");
        exclude.addElement("com/inqmy/deploy/");
        exclude.addElement("com/inqmy/frame/");
        exclude.addElement("com/inqmy/gui/");
        exclude.addElement("com/inqmy/lib/");
        exclude.addElement("com/inqmy/services/");
        exclude.addElement("com/inqmy/system/");
        exclude.addElement("com/inqmy/tools/");
        exclude.addElement("com/inqmy/transport/");
        exclude.addElement("com/sap/engine/boot/");
        exclude.addElement("com/sap/engine/core/");
        exclude.addElement("com/sap/engine/debug/");
        exclude.addElement("com/sap/engine/deploy/");
        exclude.addElement("com/sap/engine/frame/");
        exclude.addElement("com/sap/engine/gui/");
        exclude.addElement("com/sap/engine/lib/");
        exclude.addElement("com/sap/engine/services/");
        exclude.addElement("com/sap/engine/system/");
        exclude.addElement("com/sap/engine/tools/");
        exclude.addElement("com/sap/engine/transport/");
        return exclude;
    }

    private void addClassFilesToVector(String directory, Vector v) {
        File f = new File(directory);
        File[] files = f.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile() && files[i].getAbsolutePath().toLowerCase().endsWith(".class")) {
                    v.add(files[i]);
                }
                ++i;
            }
        }
    }

    private Vector getAllClassFiles(Vector passing, DirMappingTreeNode dirNode) {
        int i = 0;
        while (i < dirNode.getChildCount()) {
            if (dirNode.getChildAt(i).isLeaf()) {
                this.addClassFilesToVector(((DirMappingTreeNode)dirNode.getChildAt(i)).getMapObjValue().getFilePath(), passing);
            } else {
                this.addClassFilesToVector(((DirMappingTreeNode)dirNode.getChildAt(i)).getMapObjValue().getFilePath(), passing);
                this.getAllClassFiles(passing, (DirMappingTreeNode)dirNode.getChildAt(i));
            }
            ++i;
        }
        return passing;
    }

    public Vector getDirectoriesList() {
        if (!this.lastManifestFile.equals(this.manifestPanel.getData())) {
            this.saveManifestFile();
            this.lastManifestFile = this.manifestPanel.getData();
        }
        return this.dirMapPanel.flattenTree();
    }

    public Vector getFilesList() {
        Vector<InfoObject> result = new Vector<InfoObject>();
        if (!this.lastManifestFile.equals(this.manifestPanel.getData())) {
            this.saveManifestFile();
            this.lastManifestFile = this.manifestPanel.getData();
        }
        int i = 0;
        while (i < this.filesMainNode.getChildCount()) {
            result.add(((FileMappingTreeNode)this.filesMainNode.getChildAt(i)).getFileMapObjValue());
            ++i;
        }
        return result;
    }

    public void setDependenciesList(Vector allFiles) {
        this.isSettingData = true;
        this.manifestPanel.clear();
        this.directorysMainNode.removeAllChildren();
        this.filesMainNode.removeAllChildren();
        this.defTree.reload();
        this.dirMapPanel.clear();
        this.fileMapPanel.clear();
        this.listOfDirs = allFiles;
        this.insertNodes(this.sort(this.listOfDirs));
        this.isSettingData = false;
    }

    public void setClassFilesPaths(Vector _classNames, String[] _classPaths) {
        if (_classNames == null || _classPaths == null) {
            return;
        }
        if (this.beanClassesMainNode == null) {
            this.beanClassesMainNode = new ClassFileMappingTreeNode("Bean classes");
            this.defTree.insertNodeInto(this.beanClassesMainNode, this.root, 2);
        }
        this.beanClassesMainNode.removeAllChildren();
        this.classPaths = null;
        this.classNames = null;
        this.classNames = new Vector();
        this.classPaths = _classPaths;
        ClassFileMappingTreeNode tempFileNode = null;
        String classPath = null;
        String className = null;
        String className1 = null;
        int i = 0;
        while (i < this.classPaths.length) {
            int j;
            classPath = this.classPaths[i];
            if (classPath.endsWith(".jar")) {
                j = 0;
                while (j < _classNames.size()) {
                    className1 = (String)_classNames.elementAt(j);
                    className = className1.endsWith(".class") ? className1.substring(0, className1.length() - 6).replace('.', '/') + ".class" : className1.replace('.', '/') + ".class";
                    try {
                        ZipFile zFile = new ZipFile(classPath);
                        if (zFile.getEntry(className) != null) {
                            tempFileNode = new ClassFileMappingTreeNode(className, new InfoObject(className, classPath));
                            this.defTree.insertNodeInto(tempFileNode, this.beanClassesMainNode, 0);
                            this.classNames.add(className1);
                            _classNames.removeElement(className1);
                            --j;
                        }
                    }
                    catch (Exception ziex) {
                        boolean fails_T = true;
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < _classNames.size()) {
                    className1 = (String)_classNames.elementAt(j);
                    className = className1.endsWith(".class") ? className1.substring(0, className1.length() - 6).replace('.', File.separatorChar) + ".class" : className1.replace('.', File.separatorChar) + ".class";
                    File f = new File(classPath + File.separator + className);
                    if (f.exists()) {
                        tempFileNode = new ClassFileMappingTreeNode(f.getAbsolutePath(), new InfoObject(className, f.getAbsolutePath()));
                        this.defTree.insertNodeInto(tempFileNode, this.beanClassesMainNode, 0);
                        this.classNames.add(className1);
                        _classNames.removeElement(className1);
                        --j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.defTree.reload();
        TreeUtils.expandTree((JTree)this.tree, (int)2);
    }

    public void clear() {
        this.directorysMainNode.removeAllChildren();
        this.filesMainNode.removeAllChildren();
        this.listOfDirs.clear();
        this.defTree.reload();
        this.dirMapPanel.clear();
        this.fileMapPanel.clear();
        this.manifestPanel.clear();
    }

    public void setArchiveName(String archive) {
        this.archiveName = archive;
    }

    private String processDots(String st) {
        int t1 = st.lastIndexOf(".");
        String t2 = st.substring(0, t1);
        return t2 + "_" + st.substring(t1 + 1) + ".mf";
    }

    private void saveManifestFile() {
        if (this.isSettingData) {
            return;
        }
        String manifestFileName = this.processDots(this.archiveName);
        File manifestFile = new File(manifestFileName);
        File parentFile = manifestFile.getParentFile();
        try {
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(manifestFile));
            out.write(this.manifestPanel.getData());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Unable to save manifest file. Exception is: " + e.toString(), "Warning", 2);
            return;
        }
        InfoObject ttempInfo = new InfoObject("META-INF/Manifest.mf", manifestFile.getAbsolutePath());
        if (!this.checkExistence(ttempInfo, true)) {
            FileMappingTreeNode fileNode = new FileMappingTreeNode(ttempInfo);
            this.defTree.insertNodeInto(fileNode, this.filesMainNode, 0);
            TreeUtils.expandTree((JTree)this.tree, (int)2);
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int madeFromConstant) {
    }

    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("remove")) {
            this.removeAnyElement();
        }
        if (action.getActionCommand().equals("clear")) {
            this.clear();
            this.setClassFilesPaths(this.classNames, this.classPaths);
        }
        if (action.getActionCommand().equals("dependencies")) {
            this.dependenciesAction();
        }
    }

    public void valueChanged(TreeSelectionEvent treeEvent) {
        if (this.tree.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        if (!this.lastManifestFile.equals(this.manifestPanel.getData().trim())) {
            this.saveManifestFile();
            this.lastManifestFile = this.manifestPanel.getData().trim();
        }
        this.lastSelectedTreeElementPath = treeEvent.getPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.lastSelectedTreeElementPath.getLastPathComponent();
        if (node != this.directorysMainNode && node != this.filesMainNode && node != this.manifestNode) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        if (node instanceof DirMappingTreeNode) {
            if (this.lastSelectedPanel instanceof DirMappingPanel) {
                if (node != this.directorysMainNode) {
                    this.updateDirPanel(node);
                } else if (this.lastSelectedPanel instanceof DirMappingPanel) {
                    this.spliter.remove(this.dirMapPanel);
                    this.spliter.setRightComponent(this.directoryMapPanel);
                    this.lastSelectedPanel = this.directoryMapPanel;
                }
            } else {
                if (this.lastSelectedPanel instanceof FileMappingPanel) {
                    this.spliter.remove(this.fileMapPanel);
                } else if (this.lastSelectedPanel instanceof ManifestPanel) {
                    this.spliter.remove(this.manifestPanel);
                } else if (this.lastSelectedPanel instanceof DirectoryMappingPanel) {
                    this.spliter.remove(this.directoryMapPanel);
                }
                if (node != this.directorysMainNode) {
                    this.spliter.setRightComponent(this.dirMapPanel);
                    this.lastSelectedPanel = this.dirMapPanel;
                    this.updateDirPanel(node);
                    this.repaint();
                } else {
                    this.spliter.setRightComponent(this.directoryMapPanel);
                    this.lastSelectedPanel = this.directoryMapPanel;
                    this.repaint();
                }
            }
        } else if (node instanceof FileMappingTreeNode) {
            if (this.lastSelectedPanel instanceof FileMappingPanel) {
                this.updateFilePanel(node);
            } else {
                if (this.lastSelectedPanel instanceof DirMappingPanel) {
                    this.spliter.remove(this.dirMapPanel);
                } else if (this.lastSelectedPanel instanceof ManifestPanel) {
                    this.spliter.remove(this.manifestPanel);
                } else if (this.lastSelectedPanel instanceof DirectoryMappingPanel) {
                    this.spliter.remove(this.directoryMapPanel);
                }
                this.spliter.setRightComponent(this.fileMapPanel);
                this.lastSelectedPanel = this.fileMapPanel;
                this.updateFilePanel(node);
                this.repaint();
            }
        } else if (node instanceof ManifestTreeNode) {
            if (this.lastSelectedPanel instanceof DirMappingPanel) {
                this.spliter.remove(this.dirMapPanel);
            } else if (this.lastSelectedPanel instanceof FileMappingPanel) {
                this.spliter.remove(this.fileMapPanel);
            } else if (this.lastSelectedPanel instanceof DirectoryMappingPanel) {
                this.spliter.remove(this.directoryMapPanel);
            }
            this.spliter.setRightComponent(this.manifestPanel);
            this.lastSelectedPanel = this.manifestPanel;
            this.repaint();
        } else if (node instanceof ClassFileMappingTreeNode) {
            this.removeButton.setEnabled(false);
            if (((ClassFileMappingTreeNode)node).getFileMapObjValue().getFilePath().equals("Bean classes")) {
                if (this.lastSelectedPanel != null) {
                    this.spliter.remove(this.lastSelectedPanel);
                }
                this.spliter.setRightComponent(this.emptyPanel);
                this.lastSelectedPanel = this.emptyPanel;
                this.repaint();
            } else if (this.lastSelectedPanel instanceof FileMappingPanel) {
                this.updateFilePanel(node);
            } else {
                this.spliter.setRightComponent(this.fileMapPanel);
                this.lastSelectedPanel = this.fileMapPanel;
                this.updateFilePanel(node);
                this.repaint();
            }
        }
    }

    public int madeFrom() {
        return this.madeFrom;
    }

    public void setLoader(ClassLoader loader) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void commitChange() {
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String[] classPath) {
        this.classPathVector = new Vector();
        if (classPath == null) {
            return;
        }
        int i = 0;
        while (i < classPath.length) {
            this.classPathVector.add(classPath[i]);
            ++i;
        }
        this.classPath = classPath;
    }

    public void groupStarted(String st) {
    }

    public void fileNotReadProperly(String str) {
    }

    public void processFinished() {
        int i = 0;
        while (i < this.startDepFiles.size()) {
            int j = 0;
            while (j < this.depFiles.size()) {
                if (this.startDepFiles.elementAt(i).equals(((InfoObject)this.depFiles.elementAt(j)).getFilePath())) {
                    this.depFiles.remove(j);
                    --j;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.depFiles.size()) {
            if (!((InfoObject)this.depFiles.elementAt(i2)).getEntryName().toLowerCase().endsWith(".class")) {
                ((InfoObject)this.depFiles.elementAt(i2)).setEntryName(((InfoObject)this.depFiles.elementAt(i2)).getEntryName() + ".class");
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.depFiles.size()) {
            if (this.checkExistence(this.depFiles.elementAt(i3), true)) {
                this.depFiles.remove(i3);
                --i3;
            }
            ++i3;
        }
        if (this.depFiles.size() == 0) {
            JOptionPane.showMessageDialog(this.frame, "Additional dependencies not found.", "Dependencies Not Found", 2);
            return;
        }
        DependancyDialog dDialog = new DependancyDialog(this.frame);
        Object[] strFile = new InfoObject[this.depFiles.size()];
        this.depFiles.copyInto(strFile);
        dDialog.initData((InfoObject[])strFile);
        ((Component)((Object)dDialog)).setVisible(true);
        if (dDialog.isOk()) {
            InfoObject[] filesToAdd = dDialog.getInfoObjects();
            int i4 = 0;
            while (i4 < filesToAdd.length) {
                this.addFile(filesToAdd[i4].getEntryName(), filesToAdd[i4].getFilePath());
                ++i4;
            }
        }
    }

    public void currentFileFinished(String file, String location) {
        InfoObject io;
        if (!(file.trim().equals("") || location.trim().equals("") || this.depFiles.contains(io = new InfoObject(file, location)))) {
            this.depFiles.add(io);
        }
    }

    public void newFilesFound(int d) {
    }

    public void fileNotFound(String d) {
    }

    private String[] tokenizerToArray(String str, String delimeter) {
        if (str == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(str, delimeter);
        int tokCount = tok.countTokens();
        String[] clsPaths = new String[tokCount];
        int i = 0;
        while (i < tokCount) {
            clsPaths[i] = tok.nextToken();
            ++i;
        }
        return clsPaths;
    }

    private String[] getAllLibrariesFromAdditionalFiles(Vector allFilesTemp) {
        File[] tempArray;
        File tempDir;
        Vector<Object> preResult = new Vector<Object>();
        boolean bypassMappingSearch = false;
        boolean getOut = false;
        int i = 0;
        while (i < this.directorysMainNode.getChildCount()) {
            if (((DirMappingTreeNode)this.directorysMainNode.getChildAt(i)).getMapObjValue().getMappings().getProperty(".jar") != null) {
                bypassMappingSearch = true;
                int j = 0;
                while (j < this.directorysMainNode.getChildAt(i).getChildCount()) {
                    if (((DirMappingTreeNode)this.directorysMainNode.getChildAt(i).getChildAt(j)).toString().equals("WEB-INF")) {
                        int h = 0;
                        while (h < this.directorysMainNode.getChildAt(i).getChildAt(j).getChildCount()) {
                            if (((DirMappingTreeNode)this.directorysMainNode.getChildAt(i).getChildAt(j).getChildAt(h)).toString().equals("lib")) {
                                tempDir = new File(((DirMappingTreeNode)this.directorysMainNode.getChildAt(i).getChildAt(j).getChildAt(h)).getMapObjValue().getFilePath());
                                tempArray = tempDir.listFiles();
                                int k = 0;
                                while (k < tempArray.length) {
                                    File tempFile = tempArray[k];
                                    if (tempFile.isFile() && tempFile.getAbsolutePath().toLowerCase().endsWith(".jar")) {
                                        preResult.add(tempFile.getAbsolutePath());
                                    }
                                    getOut = true;
                                    ++k;
                                }
                            }
                            if (getOut) break;
                            ++h;
                        }
                    }
                    if (getOut) break;
                    ++j;
                }
            }
            if (getOut) break;
            ++i;
        }
        int i2 = 0;
        while (i2 < allFilesTemp.size()) {
            if (allFilesTemp.elementAt(i2) instanceof MappingObject) {
                Properties mappings;
                String libMapping;
                if (!bypassMappingSearch && (libMapping = (mappings = ((MappingObject)allFilesTemp.elementAt(i2)).getMappings()).getProperty(".jar")) != null && this.isWebInfLibrary(libMapping)) {
                    tempDir = new File(((MappingObject)allFilesTemp.elementAt(i2)).getFilePath());
                    tempArray = tempDir.listFiles();
                    int j = 0;
                    while (j < tempArray.length) {
                        if (tempArray[j].getAbsolutePath().toLowerCase().endsWith(".jar")) {
                            preResult.add(tempArray[j]);
                        }
                        ++j;
                    }
                }
            } else if (allFilesTemp.elementAt(i2) instanceof InfoObject) {
                String libMapping = ((InfoObject)allFilesTemp.elementAt(i2)).getEntryName();
                if (libMapping != null && this.isWebInfLibrary(libMapping)) {
                    tempDir = new File(((InfoObject)allFilesTemp.elementAt(i2)).getFilePath());
                    tempArray = tempDir.listFiles();
                    if (tempArray == null) {
                        return null;
                    }
                    int j = 0;
                    while (j < tempArray.length) {
                        if (tempArray[j].getAbsolutePath().toLowerCase().endsWith(".jar")) {
                            preResult.add(tempArray[j]);
                        }
                        ++j;
                    }
                }
            } else {
                System.out.println("Some Kind of Problem!!!" + allFilesTemp.elementAt(i2));
            }
            ++i2;
        }
        Object[] result = new String[preResult.size()];
        preResult.copyInto(result);
        return result;
    }

    private boolean isWebInfLibrary(String origin) {
        String[] processing = this.tokenizerToArray(origin = origin.replace('\\', '/'), "/");
        return processing != null && processing.length == 3 && processing[0].equals("WEB-INF") && processing[1].equals("lib") && processing[2].toLowerCase().endsWith(".jar");
    }
}

