/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.extended.ear;

import com.sap.engine.deploy.ejb.descriptors.xml.EJB20DescriptorDocument;
import com.sap.engine.deploy.ejb.descriptors.xml.InqmyEjbGenerator;
import com.sap.engine.deploy.ejb.descriptors.xml.XMLPersistentGenerator;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationAdditionalDocument;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationDocument;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResorceAdapterDescriptorDocument;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.EARClassLoader;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.jar.SimpleEARUpdater;
import com.sap.engine.services.deploy.ear.xml.ApplicationJ2EEEngineDocument;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.extended.ear.ExtendedJar;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.DestinationsDescriptorDocument;
import com.sap.engine.services.jmsconnector.descriptor.XMLParser;
import com.sap.engine.services.log_configurator.admin.LogXMLParser;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.xml.AdditionalWebDescrDocument;
import com.sap.engine.services.servlets_jsp.descriptor.xml.WebDescriptorDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;

public class EarUpdater
extends JarUtils {
    protected File earFile = null;
    protected String tempDir = null;
    protected String alternativeEAR = null;
    protected EARClassLoader loader = null;
    private XMLPersistentGenerator persistentGenerator = null;

    public EarUpdater() {
    }

    public EarUpdater(String earName) {
        this.setFile(earName);
    }

    public void setFile(File file) {
        this.setFile(file.getAbsolutePath());
    }

    public void setFile(String earName) {
        this.earFile = new File(earName);
        this.alternativeEAR = earName;
    }

    public void update(ExtendedJar[] jars, EARDescriptor ear, String newEarName) throws DeploymentException {
        this.alternativeEAR = newEarName;
        this.update(jars, ear);
    }

    public void setTempDir(String temp) {
        this.tempDir = temp;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void update(ExtendedJar[] jars, EARDescriptor earDescr) throws DeploymentException {
        if (jars == null || jars.length == 0) {
            return;
        }
        File tempFilesDir = null;
        if (this.tempDir == null) {
            String name = this.earFile.getName().toLowerCase().endsWith(".ear") ? this.earFile.getName().substring(0, this.earFile.getName().length() - 4) : this.earFile.getName();
            name = name.replace('.', '_');
            this.tempDir = "." + File.separator + name + System.currentTimeMillis();
        }
        if (!(tempFilesDir = new File(this.tempDir)).exists()) {
            tempFilesDir.mkdirs();
        }
        ArchiveDescriptor descr = null;
        String altDDir = null;
        InfoObject[] infoes = null;
        InfoObject info = null;
        Hashtable<String, InfoObject[]> hash = new Hashtable<String, InfoObject[]>();
        DeploymentDescriptor[] dd = null;
        boolean hasCMP = false;
        InfoObject[] tempInfo = null;
        int i = 0;
        while (i < jars.length) {
            descr = jars[i].getDescriptor();
            altDDir = this.tempDir + File.separator + jars[i].getFileName().replace('.', '_');
            infoes = this.saveAltDD(altDDir, descr);
            hasCMP = false;
            if (jars[i].getType() == 1) {
                dd = ((EJBJarDescriptor)descr).getDDescriptors();
                int j = 0;
                while (j < dd.length) {
                    if (dd[j] instanceof CMPEntityDescriptor) {
                        hasCMP = true;
                        break;
                    }
                    ++j;
                }
                if (hasCMP) {
                    info = this.generatePersistent((EJBJarDescriptor)descr, altDDir);
                    tempInfo = new InfoObject[infoes.length + 1];
                    System.arraycopy(infoes, 0, tempInfo, 0, infoes.length);
                    tempInfo[infoes.length] = info;
                    infoes = tempInfo;
                }
            }
            hash.put(jars[i].getFileName(), infoes);
            ++i;
        }
        Vector<InfoObject> addEarXmls = new Vector<InfoObject>();
        try {
            ApplicationJ2EEEngineDocument appDoc = new ApplicationJ2EEEngineDocument();
            DestinationsDescriptorDocument destDoc = new DestinationsDescriptorDocument();
            if (earDescr != null) {
                ReferenceObjectIntf[] refIntfs = earDescr.getReferences();
                if (refIntfs != null) {
                    ReferenceObject[] refs = new ReferenceObject[refIntfs.length];
                    int i2 = 0;
                    while (i2 < refIntfs.length) {
                        refs[i2] = new ReferenceObject();
                        refs[i2].setReferenceProviderName(refIntfs[i2].getReferenceProviderName());
                        refs[i2].setReferenceTarget(refIntfs[i2].getReferenceTarget());
                        refs[i2].setReferenceTargetType(refIntfs[i2].getReferenceTargetType());
                        refs[i2].setReferenceType(refIntfs[i2].getReferenceType());
                        ++i2;
                    }
                    appDoc.setReferences(refs);
                }
                appDoc.setClassPath(earDescr.getClassPath());
                appDoc.setProviderName(earDescr.getProviderName());
                appDoc.setModules(earDescr.getAdditionalModules());
                appDoc.setFailOverValue(earDescr.getFailOverValue());
                String appPath = this.tempDir + File.separator + "application-j2ee-engine.xml";
                StandardDOMWriter writer = new StandardDOMWriter();
                Document doc = null;
                if (appDoc.getReferences() != null && appDoc.getReferences().length != 0 || appDoc.getClassPath() != null && !appDoc.getClassPath().trim().equals("") || appDoc.getProviderName() != null && !appDoc.getProviderName().trim().equals("") && !appDoc.getProviderName().trim().equals(new EARDescriptor().getProviderName()) || appDoc.getModules() != null || appDoc.getFailOverValue() != null) {
                    try {
                        doc = appDoc.loadDocumentFromFields();
                        writer.write(doc, appPath, new ApplicationJ2EEEngineDocument().getDTD(), "UTF-8");
                        addEarXmls.add(new InfoObject("META-INF/application-j2ee-engine.xml", appPath));
                    }
                    catch (Exception loadexc) {
                        throw new DeploymentException("deploy_5093", new String[]{loadexc.toString()}, loadexc);
                    }
                } else if (new File(appPath).exists()) {
                    new File(appPath).delete();
                }
                String destPath = this.tempDir + File.separator + "jms-destinations.xml";
                doc = destDoc.loadDocumentFromDescriptor(earDescr.getJMSConnector());
                if (doc != null && destDoc.needsLoad()) {
                    writer.write(doc, destPath, "<!DOCTYPE jms-destinations SYSTEM 'jms-destinations.dtd'>", "UTF-8");
                    addEarXmls.add(new InfoObject(earDescr.getXmlEntry("jms-destinations.xml"), destPath));
                } else if (new File(destPath).exists()) {
                    new File(destPath).delete();
                }
                String factoriesPath = this.tempDir + File.separator + "jms-factories.xml";
                doc = XMLParser.loadDocumentFromDescriptor(earDescr.getJMSConnector());
                if (doc != null) {
                    writer.write(doc, factoriesPath, "<!DOCTYPE jms-factories SYSTEM 'jms-factories.dtd'>", "UTF-8");
                    addEarXmls.add(new InfoObject(earDescr.getXmlEntry("jms-factories.xml"), factoriesPath));
                } else if (new File(factoriesPath).exists()) {
                    new File(factoriesPath).delete();
                }
                String dataSources = this.tempDir + File.separator + "data-sources.xml";
                JDBCDescriptor[] tempJDBCArr = earDescr.getJdbcDescr();
                if (tempJDBCArr != null && tempJDBCArr.length != 0) {
                    Vector<JDBCDescriptor> tempJDBCVector = new Vector<JDBCDescriptor>();
                    int i3 = 0;
                    while (i3 < tempJDBCArr.length) {
                        tempJDBCVector.add(tempJDBCArr[i3]);
                        ++i3;
                    }
                    XMLUtils.generateAllXML(earDescr.getApplicationID(), tempJDBCVector, dataSources);
                    addEarXmls.add(new InfoObject(earDescr.getXmlEntry("data-sources.xml"), dataSources));
                } else if (new File(dataSources).exists()) {
                    new File(dataSources).delete();
                }
                String logConfiguration = this.tempDir + File.separator + "log-configuration.xml";
                LogConfiguration logConfig = earDescr.getlogConfiguration();
                if (logConfig != null) {
                    doc = LogXMLParser.writeToXml(new FileOutputStream(new File(logConfiguration)), logConfig);
                    addEarXmls.add(new InfoObject(earDescr.getXmlEntry("log-configuration.xml"), logConfiguration));
                } else if (new File(logConfiguration).exists()) {
                    new File(logConfiguration).delete();
                }
                String dataSourceAliases = this.tempDir + File.separator + "data-source-aliases.xml";
                Hashtable aliases = earDescr.getDataSourceAliase();
                if (aliases != null) {
                    XMLUtils.generateAliasesXML(earDescr.getApplicationID(), aliases, dataSourceAliases);
                    addEarXmls.add(new InfoObject(earDescr.getXmlEntry("data-source-aliases.xml"), dataSourceAliases));
                } else if (new File(dataSourceAliases).exists()) {
                    new File(dataSourceAliases).delete();
                }
            }
        }
        catch (IOException sss) {
            throw new DeploymentException("deploy_2008", new String[]{"reading", sss.toString()}, sss);
        }
        Object[] addXmlsInfos = null;
        if (addEarXmls != null && addEarXmls.size() != 0) {
            addXmlsInfos = new InfoObject[addEarXmls.size()];
            addEarXmls.copyInto(addXmlsInfos);
        }
        SimpleEARUpdater simpleUpadater = new SimpleEARUpdater(this.earFile.getAbsolutePath(), hash, (InfoObject[])addXmlsInfos);
        try {
            simpleUpadater.updateEar(this.alternativeEAR);
            Object var29_34 = null;
        }
        catch (Throwable throwable) {
            Object var29_35 = null;
            FileUtils.deleteDirectory(tempFilesDir);
            throw throwable;
        }
        FileUtils.deleteDirectory(tempFilesDir);
    }

    public String getAlternativeEAR() {
        return this.alternativeEAR;
    }

    public void setAlternativeEAR(String alternativeEAR) {
        this.alternativeEAR = alternativeEAR;
    }

    private InfoObject[] saveAltDD(String dir, ArchiveDescriptor ad) throws DeploymentException {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        InfoObject[] res = new InfoObject[2];
        if (ad instanceof EJBJarDescriptor) {
            EJB20DescriptorDocument doc = new EJB20DescriptorDocument();
            Document document = null;
            try {
                document = doc.loadEJBJarDescriptor((EJBJarDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "ejb-jar.xml", "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>", "UTF-8");
                res[0] = new InfoObject("META-INF/ejb-jar.xml", dir + File.separator + "ejb-jar.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"ejb-jar.xml"}, ex);
            }
            try {
                InqmyEjbGenerator j2eeGenerator = new InqmyEjbGenerator();
                j2eeGenerator.generateXML((EJBJarDescriptor)ad, new File(dir, "ejb-j2ee-engine.xml").getAbsolutePath());
                res[1] = new InfoObject("META-INF/ejb-j2ee-engine.xml", dir + File.separator + "ejb-j2ee-engine.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"ejb-j2ee-engine.xml"}, ex);
            }
        }
        if (ad instanceof WebDeploymentDescriptor) {
            WebDescriptorDocument doc = new WebDescriptorDocument();
            Document document = null;
            try {
                document = doc.loadDocumentFromDescriptor((WebDeploymentDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "web.xml", "<!DOCTYPE web-app PUBLIC '-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN' 'http://java.sun.com/dtd/web-app_2_3.dtd'>", "UTF-8");
                res[0] = new InfoObject("WEB-INF/web.xml", dir + File.separator + "web.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"web.xml"}, ex);
            }
            try {
                AdditionalWebDescrDocument doc1 = new AdditionalWebDescrDocument();
                document = doc1.loadDocumentFromDescriptor((WebDeploymentDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "web-j2ee-engine.xml", "<!DOCTYPE web-j2ee-engine SYSTEM 'web-j2ee-engine.dtd'>", "UTF-8");
                res[1] = new InfoObject("WEB-INF/web-j2ee-engine.xml", dir + File.separator + "web-j2ee-engine.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"web-j2ee-engine.xml"}, ex);
            }
        }
        if (ad instanceof ApplicationClientDescriptor) {
            J2EEApplicationDocument doc = new J2EEApplicationDocument();
            Document document = null;
            try {
                document = doc.loadDocument((ApplicationClientDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "application-client.xml", "<!DOCTYPE application-client [\n<!ELEMENT application-client (icon?, display-name, description?, env-entry*, ejb-ref*, resource-ref*, resource-env-ref*, callback-handler?)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-sharing-scope?)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-sharing-scope (#PCDATA)>\n<!ELEMENT resource-env-ref (description?, resource-env-ref-name, resource-env-ref-type)>\n<!ELEMENT resource-env-ref-name (#PCDATA)>\n<!ELEMENT resource-env-ref-type (#PCDATA)>\n<!ELEMENT callback-handler (#PCDATA)>\n<!ATTLIST application-client id ID #IMPLIED>\n<!ATTLIST callback-handler id ID #IMPLIED>\n<!ATTLIST description id ID #IMPLIED>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ATTLIST ejb-link id ID #IMPLIED>\n<!ATTLIST ejb-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref-name id ID #IMPLIED>\n<!ATTLIST ejb-ref-type id ID #IMPLIED>\n<!ATTLIST env-entry id ID #IMPLIED>\n<!ATTLIST env-entry-name id ID #IMPLIED>\n<!ATTLIST env-entry-type id ID #IMPLIED>\n<!ATTLIST env-entry-value id ID #IMPLIED>\n<!ATTLIST home id ID #IMPLIED>\n<!ATTLIST icon id ID #IMPLIED>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ATTLIST remote id ID #IMPLIED>\n<!ATTLIST res-auth id ID #IMPLIED>\n<!ATTLIST res-ref-name id ID #IMPLIED>\n<!ATTLIST res-sharing-scope id ID #IMPLIED>\n<!ATTLIST res-type id ID #IMPLIED>\n<!ATTLIST resource-env-ref id ID #IMPLIED>\n<!ATTLIST resource-env-ref-name id ID #IMPLIED>\n<!ATTLIST resource-env-ref-type id ID #IMPLIED>\n<!ATTLIST resource-ref id ID #IMPLIED>\n<!ATTLIST small-icon id ID #IMPLIED> \n]>", "UTF-8");
                res[0] = new InfoObject("META-INF/application-client.xml", dir + File.separator + "application-client.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"application-client.xml"}, ex);
            }
            try {
                J2EEApplicationAdditionalDocument doc1 = new J2EEApplicationAdditionalDocument();
                document = doc1.loadClientAdditionalElements((ApplicationClientDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "application-client-additional.xml", "<!DOCTYPE appclient-j2ee-engine SYSTEM 'appclient-j2ee-engine.dtd'>", "UTF-8");
                res[1] = new InfoObject("META-INF/application-client-additional.xml", dir + File.separator + "application-client-additional.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"application-client-additional.xml"}, ex);
            }
        }
        if (ad instanceof JCDescriptor) {
            ResorceAdapterDescriptorDocument doc = new ResorceAdapterDescriptorDocument();
            Document document = null;
            try {
                document = doc.loadDocumentFromDescriptor((JCDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "ra.xml", "<!DOCTYPE connector PUBLIC '-//Sun Microsystems, Inc.//DTD Connector 1.0//EN' 'http://java.sun.com/dtd/connector_1_0.dtd'>", "UTF-8");
                res[0] = new InfoObject("META-INF/ra.xml", dir + File.separator + "ra.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"ra.xml"}, ex);
            }
            try {
                document = doc.loadAdditionalDocumentFromDescriptor((JCDescriptor)ad);
                new StandardDOMWriter().write(document, dir + File.separator + "connector-j2ee-engine.xml", "<!DOCTYPE connector-j2ee-engine SYSTEM 'connector-j2ee-engine.dtd'>", "UTF-8");
                res[1] = new InfoObject("META-INF/connector-j2ee-engine.xml", dir + File.separator + "connector-j2ee-engine.xml");
            }
            catch (Exception ex) {
                throw new DeploymentException("deploy_4402", new String[]{"connector-j2ee-engine.xml"}, ex);
            }
        }
        return res;
    }

    private InfoObject generatePersistent(EJBJarDescriptor descr, String altDDdirPath) throws DeploymentException {
        InfoObject res = null;
        if (this.persistentGenerator == null) {
            this.persistentGenerator = new XMLPersistentGenerator();
        }
        File altDDdir = new File(altDDdirPath);
        boolean hasEntity = false;
        DeploymentDescriptor[] dd = descr.getDDescriptors();
        int i = 0;
        while (i < dd.length) {
            if (dd[i] instanceof CMPEntityDescriptor) {
                hasEntity = true;
                break;
            }
            ++i;
        }
        try {
            if (hasEntity) {
                Document doc1 = this.persistentGenerator.generateDocument(descr);
                new StandardDOMWriter().write(doc1, new File(altDDdir, "persistent.xml").getAbsolutePath(), " <!DOCTYPE persistent-ejb-map SYSTEM 'persistent.dtd'>", "UTF-8");
                res = new InfoObject("META-INF/persistent.xml", new File(altDDdir, "persistent.xml").getAbsolutePath());
            }
        }
        catch (IOException ioex) {
            throw new DeploymentException("deploy_4402", new String[]{"persistent.xml"}, ioex);
        }
        return res;
    }

    public void clear() {
        if (this.loader != null) {
            this.loader.clear();
        }
        if (this.tempDir != null) {
            FileUtils.deleteDirectory(new File(this.tempDir));
        }
    }

    public EARClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(EARClassLoader loader) {
        this.loader = loader;
        if (loader != null) {
            this.tempDir = loader.getOutputDir();
        }
    }
}

