/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.extended.ear;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.logging.descriptors.LogConfiguration;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.CloneUtils;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.jmsconnector.descriptor.JMSConnectorDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EARDescriptor
extends SimpleEarDescriptor {
    public static final String JMS_DEST = "jms-destinations.xml";
    public static final String JMS_FACT = "jms-factories.xml";
    public static final String DATA_SOURCES = "data-sources.xml";
    public static final String DATA_ALIASES = "data-source-aliases.xml";
    public static final String LOG_CONFIG = "log-configuration.xml";
    private Hashtable descrTable = null;
    private JMSConnectorDescriptor jmsConnector = null;
    private JDBCDescriptor[] jdbcDescr = null;
    private LogConfiguration logConfiguration = null;
    private Hashtable dataSourceAliase = null;
    private Hashtable xmlEntries = new Hashtable();

    public EARDescriptor() {
    }

    public EARDescriptor(String displayName) {
        this.displayName = displayName;
    }

    public EARDescriptor(SimpleEarDescriptor simple) {
        this.displayName = simple.getDisplayName();
        this.description = simple.getDescription();
        this.smallIcon = simple.getSmallIcon();
        this.largeIcon = simple.getLargeIcon();
        this.roles = simple.getRoles();
        this.modules = simple.getModules();
        this.archiveTable = simple.getArchiveTable();
        this.componentTable = simple.getCompTable();
        this.references = simple.getReferences();
        this.classPath = simple.getClassPath();
        this.providerName = simple.getProviderName();
        this.additionalModules = simple.getAdditionalModules();
        this.failOverValue = simple.getFailOverValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EARDescriptor)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EARDescriptor earD = (EARDescriptor)obj;
        if (!EqualUtils.equalObjects(this.getJMSConnector(), earD.getJMSConnector())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getJdbcDescr(), earD.getJdbcDescr())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getlogConfiguration(), earD.getlogConfiguration())) {
            return false;
        }
        return EqualUtils.equalHashtableObjectToUnOrderedObjectArray(this.getDataSourceAliase(), earD.getDataSourceAliase());
    }

    public Object clone() {
        String key;
        EARDescriptor descr = new EARDescriptor();
        descr.description = this.description;
        descr.displayName = this.displayName;
        if (this.smallIcon != null) {
            descr.smallIcon = (SerializableFile)this.smallIcon.clone();
        }
        if (this.largeIcon != null) {
            descr.largeIcon = (SerializableFile)this.largeIcon.clone();
        }
        if (this.roles != null) {
            descr.roles = new SecurityRoles[this.roles.length];
            System.arraycopy(this.roles, 0, descr.roles, 0, this.roles.length);
        }
        if (this.modules != null) {
            descr.modules = new J2EEModule[this.modules.length];
            System.arraycopy(this.modules, 0, descr.modules, 0, this.modules.length);
        }
        if (this.references != null && this.references.length != 0) {
            descr.setReferences(new ReferenceObject[this.references.length]);
            ReferenceObject temp = null;
            int i = 0;
            while (i < this.references.length) {
                if (this.references[i] != null) {
                    temp = new ReferenceObject();
                    temp.setReferenceProviderName(this.references[i].getReferenceProviderName());
                    temp.setReferenceTarget(this.references[i].getReferenceTarget());
                    temp.setReferenceTargetType(this.references[i].getReferenceTargetType());
                    temp.setReferenceType(this.references[i].getReferenceType());
                    descr.setReference(i, temp);
                }
                ++i;
            }
        }
        descr.setClassPath(this.classPath != null ? new String(this.classPath) : null);
        descr.setProviderName(this.providerName != null ? new String(this.providerName) : null);
        if (this.additionalModules != null) {
            descr.setAdditionalModules(CloneUtils.cloneStrStrHashtable(this.getAdditionalModules()));
        }
        descr.setFailOverValue(this.failOverValue);
        if (this.jmsConnector != null) {
            descr.jmsConnector = (JMSConnectorDescriptor)this.jmsConnector.clone();
        }
        if (this.jdbcDescr != null) {
            descr.setJdbcDescr(new JDBCDescriptor[this.jdbcDescr.length]);
            int i = 0;
            while (i < this.jdbcDescr.length) {
                if (this.jdbcDescr[i] != null) {
                    descr.setJDBCDescriptor(i, (JDBCDescriptor)this.jdbcDescr[i].clone());
                }
                ++i;
            }
        }
        if (this.logConfiguration != null) {
            descr.setlogConfiguration((LogConfiguration)this.logConfiguration.clone());
        }
        Hashtable<String, String[]> newDataSourceAliase = null;
        if (this.dataSourceAliase != null) {
            newDataSourceAliase = new Hashtable<String, String[]>();
            Enumeration enumeration = this.dataSourceAliase.keys();
            key = null;
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                newDataSourceAliase.put(new String(key), CloneUtils.cloneStringArray((String[])this.dataSourceAliase.get(key)));
            }
        }
        descr.setDataSourceAliase(newDataSourceAliase);
        if (this.xmlEntries != null) {
            Enumeration enumeration = this.xmlEntries.keys();
            key = null;
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                descr.addXmlEntry(new String(key), new String((String)this.xmlEntries.get(key)));
            }
        }
        return descr;
    }

    public Hashtable getDescrTable() {
        return this.descrTable;
    }

    public void setDescrTable(Hashtable descTable) {
        this.descrTable = descTable;
    }

    public DeploymentDescriptor getDeplDescr(String archName, String beanName) {
        String temp = null;
        String current = null;
        String value = null;
        ArchiveDescriptor archDescr = null;
        Descriptor descriptor = null;
        if (archName != null) {
            Enumeration en = this.descrTable.keys();
            while (en.hasMoreElements()) {
                temp = (String)en.nextElement();
                if (!archName.equals(temp)) continue;
                value = (String)this.descrTable.get(temp);
                Enumeration enumeration = this.archiveTable.keys();
                while (enumeration.hasMoreElements()) {
                    current = (String)enumeration.nextElement();
                    if (!value.equals(current) || !((archDescr = (ArchiveDescriptor)this.archiveTable.get(current)) instanceof EJBJarDescriptor) || (descriptor = archDescr.getDescriptor(beanName)) == null) continue;
                    return (DeploymentDescriptor)descriptor;
                }
            }
        }
        return null;
    }

    public WebDeploymentDescriptor getWebDescr(String archName) {
        String temp = null;
        String current = null;
        String value = null;
        ArchiveDescriptor archDescr = null;
        if (archName != null) {
            Enumeration en = this.descrTable.keys();
            while (en.hasMoreElements()) {
                temp = (String)en.nextElement();
                if (!archName.equals(temp)) continue;
                value = (String)this.descrTable.get(temp);
                Enumeration enumeration = this.archiveTable.keys();
                while (enumeration.hasMoreElements()) {
                    current = (String)enumeration.nextElement();
                    if (!value.equals(current) || !((archDescr = (ArchiveDescriptor)this.archiveTable.get(current)) instanceof WebDeploymentDescriptor)) continue;
                    return (WebDeploymentDescriptor)archDescr;
                }
            }
        }
        return null;
    }

    public ApplicationClientDescriptor getClientDescr(String archName) {
        String temp = null;
        String current = null;
        String value = null;
        ArchiveDescriptor archDescr = null;
        if (archName != null) {
            Enumeration en = this.descrTable.keys();
            while (en.hasMoreElements()) {
                temp = (String)en.nextElement();
                if (!archName.equals(temp)) continue;
                value = (String)this.descrTable.get(temp);
                Enumeration enumeration = this.archiveTable.keys();
                while (enumeration.hasMoreElements()) {
                    current = (String)enumeration.nextElement();
                    if (!value.equals(current) || !((archDescr = (ArchiveDescriptor)this.archiveTable.get(current)) instanceof ApplicationClientDescriptor)) continue;
                    return (ApplicationClientDescriptor)archDescr;
                }
            }
        }
        return null;
    }

    public JCDescriptor getConnectorDescr(String archName) {
        String temp = null;
        String current = null;
        String value = null;
        ArchiveDescriptor archDescr = null;
        if (archName != null) {
            Enumeration en = this.descrTable.keys();
            while (en.hasMoreElements()) {
                temp = (String)en.nextElement();
                if (!archName.equals(temp)) continue;
                value = (String)this.descrTable.get(temp);
                Enumeration enumeration = this.archiveTable.keys();
                while (enumeration.hasMoreElements()) {
                    current = (String)enumeration.nextElement();
                    if (!value.equals(current) || !((archDescr = (ArchiveDescriptor)this.archiveTable.get(current)) instanceof JCDescriptor)) continue;
                    return (JCDescriptor)archDescr;
                }
            }
        }
        return null;
    }

    public EntityDescriptor[] getEntityDescr() {
        ArchiveDescriptor archiveDescr = null;
        DeploymentDescriptor[] deplDescrs = null;
        Vector<DeploymentDescriptor> entityDesc = new Vector<DeploymentDescriptor>();
        Object[] result = null;
        Enumeration enumeration = this.archiveTable.elements();
        while (enumeration.hasMoreElements()) {
            archiveDescr = (ArchiveDescriptor)enumeration.nextElement();
            if (!(archiveDescr instanceof EJBJarDescriptor) || (deplDescrs = ((EJBJarDescriptor)archiveDescr).getDDescriptors()) == null) continue;
            int i = 0;
            while (i < deplDescrs.length) {
                if (deplDescrs[i] instanceof EntityDescriptor) {
                    entityDesc.add(deplDescrs[i]);
                }
                ++i;
            }
        }
        result = new EntityDescriptor[entityDesc.size()];
        entityDesc.copyInto(result);
        return result;
    }

    public void setJMSConnector(JMSConnectorDescriptor jms) {
        this.jmsConnector = jms;
    }

    public JMSConnectorDescriptor getJMSConnector() {
        return this.jmsConnector;
    }

    public JDBCDescriptor[] getJdbcDescr() {
        return this.jdbcDescr;
    }

    public void setJdbcDescr(JDBCDescriptor[] jdbcDescr) {
        this.jdbcDescr = jdbcDescr;
    }

    public JDBCDescriptor getJdbcDescr(int number) {
        if (this.jdbcDescr != null && number < this.jdbcDescr.length && number > -1) {
            return this.jdbcDescr[number];
        }
        return null;
    }

    public void setJDBCDescriptor(int number, JDBCDescriptor jdbc) {
        if (this.jdbcDescr == null || number >= this.jdbcDescr.length) {
            JDBCDescriptor[] newJDBCDescr = new JDBCDescriptor[number + 1];
            if (this.jdbcDescr != null) {
                int j = 0;
                while (j < this.jdbcDescr.length) {
                    newJDBCDescr[j] = this.jdbcDescr[j];
                    ++j;
                }
            }
            this.jdbcDescr = newJDBCDescr;
        }
        this.jdbcDescr[number] = jdbc;
    }

    public LogConfiguration getlogConfiguration() {
        return this.logConfiguration;
    }

    public void setlogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public Hashtable getDataSourceAliase() {
        return this.dataSourceAliase;
    }

    public void setDataSourceAliase(Hashtable dataSourceAliase) {
        this.dataSourceAliase = dataSourceAliase;
    }

    public void addXmlEntry(String xmlFile, String pathInEar) {
        if (this.xmlEntries == null) {
            this.xmlEntries = new Hashtable();
        }
        if (xmlFile == null || xmlFile.equals("")) {
            return;
        }
        if (pathInEar == null || pathInEar.equals("")) {
            return;
        }
        this.xmlEntries.put(xmlFile, pathInEar);
    }

    private String getOriginalXmlEntry(String xmlFile) {
        return (String)this.xmlEntries.get(xmlFile);
    }

    public String getXmlEntry(String xmlFile) {
        if (this.xmlEntries == null) {
            return null;
        }
        if (xmlFile == null || xmlFile.equals("")) {
            return null;
        }
        String path = this.getOriginalXmlEntry(xmlFile);
        if (path == null || path.equals("")) {
            path = "META-INF/" + xmlFile;
        }
        return path;
    }
}

