/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.xml;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EARDescriptorReader {
    SimpleEarDescriptor descriptor;
    public String dtd = null;
    public String defaultDTD = "<!DOCTYPE application [\n<!ELEMENT application (icon?, display-name, description?, module+, security-role*)>\n<!ATTLIST application id ID #IMPLIED>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ATTLIST icon id ID #IMPLIED>\n<!ELEMENT small-icon (#PCDATA)>\n<!ATTLIST small-icon id ID #IMPLIED>\n<!ELEMENT large-icon (#PCDATA)>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ELEMENT display-name (#PCDATA)>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ELEMENT description (#PCDATA)>\n<!ATTLIST description id ID #IMPLIED>\n<!ELEMENT module ((ejb | java | web), alt-dd?)>\n<!ATTLIST module id ID #IMPLIED>\n<!ELEMENT ejb (#PCDATA)>\n<!ATTLIST ejb id ID #IMPLIED>\n<!ELEMENT java (#PCDATA)>\n<!ATTLIST java id ID #IMPLIED>\n<!ELEMENT web (web-uri, context-root)>\n<!ATTLIST web id ID #IMPLIED>\n<!ELEMENT web-uri (#PCDATA)>\n<!ATTLIST web-uri id ID #IMPLIED>\n<!ELEMENT context-root (#PCDATA)>\n<!ATTLIST context-root id ID #IMPLIED>\n<!ELEMENT alt-dd (#PCDATA)>\n<!ATTLIST alt-dd id ID #IMPLIED>\n<!ELEMENT security-role (description?, role-name)>\n<!ATTLIST security-role id ID #IMPLIED>\n<!ELEMENT role-name (#PCDATA)>\n<!ATTLIST role-name id ID #IMPLIED>\n]>";
    public String sunDTD = "http://java.sun.com/j2ee/dtds/application_1_2.dtd";

    public SimpleEarDescriptor loadSimpleSimpleEarDescriptor(Document doc) throws DeploymentException {
        DocumentType dt = doc.getDoctype();
        this.dtd = dt == null ? this.defaultDTD : dt.getSystemId();
        Element docElement = doc.getDocumentElement();
        Element nameElement = (Element)this.getFirstChild(docElement, "display-name");
        String displayName = this.getElementValue(nameElement);
        if (displayName == null || displayName.equals("")) {
            throw new DeploymentException("deploy_2027");
        }
        if (new File(displayName).isAbsolute()) {
            int index = displayName.lastIndexOf("/");
            if (index == -1) {
                index = displayName.lastIndexOf("\\");
            }
            if (index > -1) {
                displayName = displayName.substring(index);
            }
        }
        displayName = displayName.replace('/', '_');
        displayName = displayName.replace('\\', '_');
        displayName = displayName.replace(':', '_');
        displayName = displayName.replace('*', '_');
        displayName = displayName.replace('?', '_');
        displayName = displayName.replace('\"', '_');
        displayName = displayName.replace('<', '_');
        displayName = displayName.replace('>', '_');
        displayName = displayName.replace('|', '_');
        this.descriptor = new SimpleEarDescriptor(displayName.trim());
        this.loadDescriptor(docElement);
        return this.descriptor;
    }

    public void loadDescriptor(Element docElement) {
        Node descr;
        Node icon = this.getFirstChild(docElement, "icon");
        if (icon != null) {
            this.loadIcons((Element)icon);
        }
        if ((descr = this.getFirstLevelChild(docElement, "description")) != null) {
            this.loadApplicationDescription((Element)descr);
        }
        NodeList moduleList = docElement.getElementsByTagName("module");
        this.loadModules(moduleList);
        NodeList secRolesList = docElement.getElementsByTagName("security-role");
        if (secRolesList != null) {
            this.loadSecurityRoles(secRolesList);
        }
    }

    private void loadIcons(Element icon) {
        String largeIcon;
        Node large;
        String smIcon;
        Node sm = this.getFirstChild(icon, "small-icon");
        if (sm != null && (smIcon = this.getElementValue((Element)sm)) != null && !smIcon.trim().equals("")) {
            this.descriptor.setSmallIcon(new SerializableFile(smIcon));
        }
        if ((large = this.getFirstChild(icon, "large-icon")) != null && (largeIcon = this.getElementValue((Element)large)) != null && !largeIcon.trim().equals("")) {
            this.descriptor.setLargeIcon(new SerializableFile(largeIcon));
        }
    }

    private void loadApplicationDescription(Element descrElement) {
        String descr = this.getElementValue(descrElement);
        if (descr != null) {
            this.descriptor.setDescription(descr);
        }
    }

    private void loadModules(NodeList list) {
        J2EEModule[] modules = new J2EEModule[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Element next = (Element)list.item(i);
            modules[i] = this.loadModule(next);
            ++i;
        }
        this.descriptor.setModules(modules);
    }

    private J2EEModule loadModule(Element modElement) {
        String uri;
        int type = 1;
        J2EEModule mod = null;
        Node child = null;
        child = this.getFirstChild(modElement, "ejb");
        if (child != null) {
            uri = this.getElementValue((Element)child);
            mod = new J2EEModule(type, uri);
        } else {
            child = this.getFirstChild(modElement, "java");
            if (child != null) {
                type = 3;
                uri = this.getElementValue((Element)child);
                mod = new J2EEModule(type, uri);
            } else {
                child = this.getFirstChild(modElement, "web");
                if (child != null) {
                    type = 4;
                    Element weburiElement = (Element)this.getFirstChild((Element)child, "web-uri");
                    String uri2 = this.getElementValue(weburiElement);
                    Element contextElement = (Element)this.getFirstChild((Element)child, "context-root");
                    String context = this.getElementValue(contextElement);
                    if (context == null || context.equals("")) {
                        context = "/";
                    }
                    context = context.replace(':', '_');
                    context = context.replace('*', '_');
                    context = context.replace('?', '_');
                    context = context.replace('\"', '_');
                    context = context.replace('<', '_');
                    context = context.replace('>', '_');
                    context = context.replace('|', '_');
                    if ((context = context.replace('\\', '/')).endsWith(".")) {
                        context = context.substring(0, context.length() - 1) + "_";
                    }
                    while (context.length() > 1 && context.startsWith("/")) {
                        context = context.substring(1, context.length());
                    }
                    StringBuffer temp = new StringBuffer();
                    int i = 0;
                    while (i < context.length()) {
                        if (context.charAt(i) != '/' || context.charAt(i) == '/' && (temp.length() == 0 || temp.charAt(temp.length() - 1) != '/')) {
                            temp.append(context.charAt(i));
                        }
                        ++i;
                    }
                    context = new String(temp);
                    mod = new J2EEModule(uri2, context);
                }
            }
        }
        Node altChild = this.getFirstChild(modElement, "alt-dd");
        if (altChild != null) {
            String altdd = this.getElementValue((Element)altChild);
            mod.setAlt_dd(altdd);
        }
        return mod;
    }

    private void loadSecurityRoles(NodeList secRoles) {
        SecurityRoles[] roles = new SecurityRoles[secRoles.getLength()];
        int i = 0;
        while (i < secRoles.getLength()) {
            Element next = (Element)secRoles.item(i);
            roles[i] = this.loadSecurityRoles(next);
            ++i;
        }
    }

    private SecurityRoles loadSecurityRoles(Element secRoleElement) {
        Node descr = this.getFirstLevelChild(secRoleElement, "description");
        Node roleNode = this.getFirstChild(secRoleElement, "role-name");
        String roleName = this.getElementValue((Element)roleNode);
        if (descr != null) {
            return new SecurityRoles(roleName, this.getElementValue((Element)descr));
        }
        return new SecurityRoles(roleName);
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private Node getFirstLevelChild(Element el, String name) {
        NodeList list = el.getChildNodes();
        if (list == null || list.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeName().equals(name)) {
                return list.item(i);
            }
            ++i;
        }
        return null;
    }

    private String getElementValue(Element el) {
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }
}

